/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.wizard;

import javax.el.MethodExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.wizard.WizardBase;
import org.primefaces.event.FlowEvent;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Wizard
extends WizardBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Wizard";
    public static final String STEP_STATUS_CLASS = "ui-wizard-step-titles ui-helper-reset ui-helper-clearfix";
    public static final String STEP_CLASS = "ui-wizard-step-title ui-state-default ui-corner-all";
    public static final String ACTIVE_STEP_CLASS = "ui-wizard-step-title ui-state-default ui-state-highlight ui-corner-all";
    public static final String BACK_BUTTON_CLASS = "ui-wizard-nav-back";
    public static final String NEXT_BUTTON_CLASS = "ui-wizard-nav-next";
    private Tab current;

    public void processDecodes(FacesContext context) {
        this.decode(context);
        if (!this.isBackRequest(context) || this.isUpdateModelOnPrev() && this.isBackRequest(context)) {
            this.getStepToProcess().processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isBackRequest(context) || this.isUpdateModelOnPrev() && this.isBackRequest(context)) {
            this.current.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isBackRequest(context) || this.isUpdateModelOnPrev() && this.isBackRequest(context)) {
            this.current.processUpdates(context);
        }
    }

    public Tab getStepToProcess() {
        if (this.current == null) {
            String currentStepId = this.getStep();
            for (UIComponent child : this.getChildren()) {
                if (!child.getId().equals(currentStepId)) continue;
                this.current = (Tab)child;
                break;
            }
        }
        return this.current;
    }

    public boolean isWizardRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_wizardRequest");
    }

    public boolean isBackRequest(FacesContext context) {
        return this.isWizardRequest(context) && context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_backRequest");
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof FlowEvent) {
            FlowEvent flowEvent = (FlowEvent)event;
            FacesContext context = this.getFacesContext();
            MethodExpression me = this.getFlowListener();
            if (me != null) {
                String step = (String)me.invoke(context.getELContext(), new Object[]{event});
                this.setStep(step);
            } else {
                this.setStep(flowEvent.getNewStep());
            }
        }
    }
}

