/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.primefaces.cache.CacheProvider;
import org.primefaces.cache.DefaultCacheProvider;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;
import org.primefaces.virusscan.VirusScannerService;

public class PrimeApplicationContext {
    public static final String INSTANCE_KEY = PrimeApplicationContext.class.getName();
    private static final Logger LOGGER = Logger.getLogger(PrimeApplicationContext.class.getName());
    private final PrimeEnvironment environment;
    private final PrimeConfiguration config;
    private final ClassLoader applicationClassLoader;
    private final Map<Class<?>, Map<String, Object>> enumCacheMap;
    private final Map<Class<?>, Map<String, Object>> constantsCacheMap;
    private final Lazy<ValidatorFactory> validatorFactory;
    private final Lazy<Validator> validator;
    private final Lazy<CacheProvider> cacheProvider;
    private final Lazy<VirusScannerService> virusScannerService;

    public PrimeApplicationContext(FacesContext facesContext) {
        this.environment = new PrimeEnvironment(facesContext);
        this.config = new PrimeConfiguration(facesContext, this.environment);
        this.enumCacheMap = new ConcurrentHashMap();
        this.constantsCacheMap = new ConcurrentHashMap();
        ClassLoader classLoader = null;
        Object context = facesContext.getExternalContext().getContext();
        if (context != null) {
            try {
                Method getClassLoaderMethod = context.getClass().getMethod("getClassLoader", new Class[0]);
                if (getClassLoaderMethod != null) {
                    classLoader = (ClassLoader)getClassLoaderMethod.invoke(context, new Object[0]);
                }
            }
            catch (AbstractMethodError | IllegalAccessException | NoSuchMethodError | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException getClassLoaderMethod) {
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "An unexpected Exception or Error was thrown when calling facesContext.getExternalContext().getContext().getClassLoader(). Falling back to Thread.currentThread().getContextClassLoader() instead.", t);
            }
        }
        if (classLoader == null) {
            classLoader = LangUtils.getContextClassLoader();
        }
        this.applicationClassLoader = classLoader;
        if (this.config.isBeanValidationEnabled()) {
            this.validatorFactory = new Lazy<ValidatorFactory>(){

                @Override
                protected ValidatorFactory initialize() {
                    return Validation.buildDefaultValidatorFactory();
                }
            };
            this.validator = new Lazy<Validator>(){

                @Override
                protected Validator initialize() {
                    return ((ValidatorFactory)PrimeApplicationContext.this.validatorFactory.get()).getValidator();
                }
            };
        } else {
            this.validatorFactory = null;
            this.validator = null;
        }
        this.virusScannerService = new Lazy<VirusScannerService>(){

            @Override
            protected VirusScannerService initialize() {
                return new VirusScannerService(PrimeApplicationContext.this.applicationClassLoader);
            }
        };
        this.cacheProvider = new Lazy<CacheProvider>(){

            @Override
            protected CacheProvider initialize() {
                String cacheProviderConfigValue = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("primefaces.CACHE_PROVIDER");
                if (cacheProviderConfigValue == null) {
                    return new DefaultCacheProvider();
                }
                try {
                    return (CacheProvider)LangUtils.loadClassForName(cacheProviderConfigValue).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        };
    }

    public static PrimeApplicationContext getCurrentInstance(FacesContext facesContext) {
        if (facesContext == null || facesContext.getExternalContext() == null) {
            return null;
        }
        PrimeApplicationContext applicationContext = (PrimeApplicationContext)facesContext.getExternalContext().getApplicationMap().get(INSTANCE_KEY);
        if (applicationContext == null) {
            applicationContext = new PrimeApplicationContext(facesContext);
            PrimeApplicationContext.setCurrentInstance(applicationContext, facesContext);
        }
        return applicationContext;
    }

    public static PrimeApplicationContext getCurrentInstance(ServletContext context) {
        return (PrimeApplicationContext)context.getAttribute(INSTANCE_KEY);
    }

    public static void setCurrentInstance(PrimeApplicationContext context, FacesContext facesContext) {
        facesContext.getExternalContext().getApplicationMap().put(INSTANCE_KEY, context);
        if (facesContext.getExternalContext().getContext() instanceof ServletContext) {
            ((ServletContext)facesContext.getExternalContext().getContext()).setAttribute(INSTANCE_KEY, (Object)context);
        }
    }

    public PrimeEnvironment getEnvironment() {
        return this.environment;
    }

    public PrimeConfiguration getConfig() {
        return this.config;
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory == null ? null : this.validatorFactory.get();
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider.get();
    }

    public Map<Class<?>, Map<String, Object>> getEnumCacheMap() {
        return this.enumCacheMap;
    }

    public Map<Class<?>, Map<String, Object>> getConstantsCacheMap() {
        return this.constantsCacheMap;
    }

    public Validator getValidator() {
        return this.validator == null ? null : this.validator.get();
    }

    public VirusScannerService getVirusScannerService() {
        return this.virusScannerService.get();
    }

    public void release() {
        if (this.environment != null && this.environment.isAtLeastBv11() && this.validatorFactory != null && this.validatorFactory.isInitialized() && this.validatorFactory.get() != null) {
            this.validatorFactory.get().close();
        }
    }
}

