/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.component.visit.VisitCallback;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.expression.impl.WidgetVarVisitCallback;

public class Jsf23WidgetVarSearchKeywordResolver
extends SearchKeywordResolver {
    private static final Pattern PATTERN = Pattern.compile("widgetVar\\((\\w+)\\)");

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return keyword != null && keyword.startsWith("widgetVar(");
    }

    public void resolve(SearchKeywordContext context, UIComponent current, String keyword) {
        try {
            Matcher matcher = PATTERN.matcher(keyword);
            if (!matcher.matches()) {
                throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"");
            }
            WidgetVarVisitCallback visitCallback = new WidgetVarVisitCallback(matcher.group(1));
            context.getSearchExpressionContext().getFacesContext().getViewRoot().visitTree(SearchExpressionUtils.createVisitContext(context.getSearchExpressionContext().getFacesContext(), 8), (VisitCallback)visitCallback);
            context.invokeContextCallback(visitCallback.getComponent());
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"", (Throwable)e);
        }
    }
}

