/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.model.UploadedFile;
import org.primefaces.shaded.commons.io.input.BoundedInputStream;
import org.primefaces.util.FileUploadUtils;

public class DefaultUploadedFile
implements UploadedFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private FileItem fileItem;
    private Long sizeLimit;

    public DefaultUploadedFile() {
    }

    public DefaultUploadedFile(FileItem fileItem, FileUpload fileUpload) {
        this.fileItem = fileItem;
        this.sizeLimit = fileUpload.getSizeLimit();
    }

    @Override
    public String getFileName() {
        return FileUploadUtils.getValidFilename(this.fileItem.getName());
    }

    @Override
    public List<String> getFileNames() {
        return null;
    }

    @Override
    public InputStream getInputstream() throws IOException {
        return this.sizeLimit == null ? this.fileItem.getInputStream() : new BoundedInputStream(this.fileItem.getInputStream(), this.sizeLimit);
    }

    @Override
    public long getSize() {
        return this.fileItem.getSize();
    }

    @Override
    public byte[] getContents() {
        return this.fileItem.get();
    }

    @Override
    public String getContentType() {
        return this.fileItem.getContentType();
    }

    @Override
    public void write(String filePath) throws Exception {
        String validFilePath = FileUploadUtils.getValidFilePath(filePath);
        this.fileItem.write(new File(validFilePath));
    }
}

