/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class IterableDataModel<E>
extends DataModel<E> {
    private int index = -1;
    private Iterable<E> wrapped;
    private List<E> wrappedList;

    public IterableDataModel() {
        this(null);
    }

    public IterableDataModel(Iterable<E> iterable) {
        this.setWrappedData(iterable);
    }

    public int getRowCount() {
        if (this.wrappedList == null) {
            return -1;
        }
        return this.wrappedList.size();
    }

    public E getRowData() {
        if (this.wrappedList == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.wrappedList.get(this.index);
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int oldIndex = this.index;
        this.index = rowIndex;
        if (this.wrappedList == null) {
            return;
        }
        DataModelListener[] dataModelListeners = this.getDataModelListeners();
        if (oldIndex != this.index && dataModelListeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            for (DataModelListener listener : dataModelListeners) {
                if (listener == null) continue;
                listener.rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.wrapped;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.wrapped = null;
            this.wrappedList = null;
            this.setRowIndex(-1);
        } else {
            this.wrapped = (Iterable)data;
            if (this.wrapped instanceof List) {
                this.wrappedList = (List)this.wrapped;
            } else if (this.wrapped instanceof Collection) {
                this.wrappedList = new ArrayList((Collection)this.wrapped);
            } else {
                this.wrappedList = new ArrayList();
                Iterator<E> iterator = this.wrapped.iterator();
                while (iterator.hasNext()) {
                    this.wrappedList.add(iterator.next());
                }
            }
            this.setRowIndex(0);
        }
    }

    public boolean isRowAvailable() {
        if (this.wrappedList == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.wrappedList.size();
    }
}

