/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.validation.constraints.Null;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public class LazyDataModelIterator<T>
implements Iterator<T> {
    private LazyDataModel<T> model;
    private int index;
    private Map<Integer, List<T>> pages;
    @Null
    private String sortField;
    @Null
    private SortOrder sortOrder;
    @Null
    private List<SortMeta> multiSortMeta;
    @Null
    private Map<String, Object> filters;

    LazyDataModelIterator(LazyDataModel<T> model) {
        this.model = model;
        this.index = -1;
        this.pages = new HashMap<Integer, List<T>>();
    }

    LazyDataModelIterator(LazyDataModel<T> model, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        this(model);
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.filters = filters;
    }

    LazyDataModelIterator(LazyDataModel<T> model, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        this(model);
        this.multiSortMeta = multiSortMeta;
        this.filters = filters;
    }

    @Override
    public boolean hasNext() {
        int pageIndex;
        int nextIndex = this.index + 1;
        int pageNo = nextIndex / this.model.getPageSize();
        if (!this.pages.containsKey(pageNo)) {
            List<T> page = this.sortField != null || this.sortOrder != null ? this.model.load(nextIndex, this.model.getPageSize(), this.sortField, this.sortOrder, this.filters) : this.model.load(nextIndex, this.model.getPageSize(), this.multiSortMeta, this.filters);
            if (page == null || page.isEmpty()) {
                return false;
            }
            this.pages.remove(pageNo - 1);
            this.pages.put(pageNo, page);
        }
        return (pageIndex = nextIndex % this.model.getPageSize()) < this.pages.get(pageNo).size();
    }

    @Override
    public T next() {
        ++this.index;
        int pageNo = this.index / this.model.getPageSize();
        int pageIndex = this.index % this.model.getPageSize();
        List<T> page = this.pages.get(pageNo);
        if (page == null || pageIndex >= page.size()) {
            throw new NoSuchElementException();
        }
        return page.get(pageIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

