/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.servlet.http.Part;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.model.UploadedFile;
import org.primefaces.shaded.commons.io.input.BoundedInputStream;
import org.primefaces.util.FileUploadUtils;

public class NativeUploadedFile
implements UploadedFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String CONTENT_DISPOSITION_FILENAME_ATTR = "filename";
    private Part part;
    private String filename;
    private byte[] cachedContent;
    private Long sizeLimit;
    private List<Part> parts;
    private List<String> filenames;

    public NativeUploadedFile() {
    }

    public NativeUploadedFile(Part part, FileUpload fileUpload) {
        this.part = part;
        this.filename = this.resolveFilename(part);
        this.sizeLimit = fileUpload.getSizeLimit();
    }

    public NativeUploadedFile(List<Part> parts, FileUpload fileUpload) {
        this.parts = parts;
        this.filenames = this.resolveFilenames(parts);
        this.sizeLimit = fileUpload.getSizeLimit();
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public List<String> getFileNames() {
        return this.filenames;
    }

    @Override
    public InputStream getInputstream() throws IOException {
        return this.sizeLimit == null ? this.part.getInputStream() : new BoundedInputStream(this.part.getInputStream(), this.sizeLimit);
    }

    @Override
    public long getSize() {
        return this.part.getSize();
    }

    @Override
    public byte[] getContents() {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        InputStream input = null;
        try {
            input = this.getInputstream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            this.cachedContent = output.toByteArray();
        }
        catch (IOException ex) {
            this.cachedContent = null;
            throw new FacesException((Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.cachedContent;
    }

    @Override
    public String getContentType() {
        return this.part.getContentType();
    }

    @Override
    public void write(String filePath) throws Exception {
        String validFilePath = FileUploadUtils.getValidFilePath(filePath);
        if (this.parts != null) {
            for (int i = 0; i < this.parts.size(); ++i) {
                Part p = this.parts.get(i);
                p.write(validFilePath);
            }
        } else {
            this.part.write(validFilePath);
        }
    }

    public Part getPart() {
        return this.part;
    }

    private String resolveFilename(Part part) {
        return FileUploadUtils.getValidFilename(this.getContentDispositionFileName(part.getHeader("content-disposition")));
    }

    private List<String> resolveFilenames(List<Part> parts) {
        this.filenames = new ArrayList<String>();
        for (int i = 0; i < parts.size(); ++i) {
            Part p = parts.get(i);
            this.filenames.add(this.resolveFilename(p));
        }
        return this.filenames;
    }

    protected String getContentDispositionFileName(String line) {
        int i = line.indexOf(CONTENT_DISPOSITION_FILENAME_ATTR);
        if (i == -1) {
            return null;
        }
        i += CONTENT_DISPOSITION_FILENAME_ATTR.length();
        int lineLength = line.length();
        while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        if (i == lineLength || line.charAt(i++) != '=') {
            throw new FacesException("Content-Disposition filename property did not have '='.");
        }
        while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        if (i == lineLength || line.charAt(i++) != '\"') {
            throw new FacesException("Content-Disposition filename property was not quoted.");
        }
        StringBuilder b = new StringBuilder();
        while (i < lineLength) {
            char c = line.charAt(i);
            if (c == '\"') {
                return this.decode(b.toString());
            }
            if (c == '\\' && i + 2 != lineLength) {
                char next;
                if ((next = line.charAt(++i)) == '\"') {
                    b.append('\"');
                } else {
                    b.append(c);
                    b.append(next);
                }
            } else {
                b.append(c);
            }
            ++i;
        }
        return this.decode(b.toString());
    }

    private String decode(String encoded) {
        try {
            encoded = encoded.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            encoded = encoded.replaceAll("\\+", "%2B");
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new FacesException((Throwable)ex);
        }
    }
}

