/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.validate.bean;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.validation.MessageInterpolator;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.util.MapBuilder;
import org.primefaces.validate.bean.AssertFalseClientValidationConstraint;
import org.primefaces.validate.bean.AssertTrueClientValidationConstraint;
import org.primefaces.validate.bean.BeanValidationMetadata;
import org.primefaces.validate.bean.ClientConstraint;
import org.primefaces.validate.bean.ClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMaxClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMinClientValidationConstraint;
import org.primefaces.validate.bean.DigitsClientValidationConstraint;
import org.primefaces.validate.bean.FutureClientValidationConstraint;
import org.primefaces.validate.bean.MaxClientValidationConstraint;
import org.primefaces.validate.bean.MessageInterpolatingConstraintWrapper;
import org.primefaces.validate.bean.MinClientValidationConstraint;
import org.primefaces.validate.bean.NotNullClientValidationConstraint;
import org.primefaces.validate.bean.NullClientValidationConstraint;
import org.primefaces.validate.bean.PastClientValidationConstraint;
import org.primefaces.validate.bean.PatternClientValidationConstraint;
import org.primefaces.validate.bean.SizeClientValidationConstraint;

public class BeanValidationMetadataMapper {
    private static final Logger LOGGER = Logger.getLogger(BeanValidationMetadataMapper.class.getName());
    private static final Map<Class<? extends Annotation>, ClientValidationConstraint> CONSTRAINT_MAPPING = MapBuilder.builder().put(NotNull.class, new NotNullClientValidationConstraint()).put(Null.class, (NotNullClientValidationConstraint)((Object)new NullClientValidationConstraint())).put(Size.class, (NotNullClientValidationConstraint)((Object)new SizeClientValidationConstraint())).put(Min.class, (NotNullClientValidationConstraint)((Object)new MinClientValidationConstraint())).put(Max.class, (NotNullClientValidationConstraint)((Object)new MaxClientValidationConstraint())).put(DecimalMin.class, (NotNullClientValidationConstraint)((Object)new DecimalMinClientValidationConstraint())).put(DecimalMax.class, (NotNullClientValidationConstraint)((Object)new DecimalMaxClientValidationConstraint())).put(AssertTrue.class, (NotNullClientValidationConstraint)((Object)new AssertTrueClientValidationConstraint())).put(AssertFalse.class, (NotNullClientValidationConstraint)((Object)new AssertFalseClientValidationConstraint())).put(Digits.class, (NotNullClientValidationConstraint)((Object)new DigitsClientValidationConstraint())).put(Past.class, (NotNullClientValidationConstraint)((Object)new PastClientValidationConstraint())).put(Future.class, (NotNullClientValidationConstraint)((Object)new FutureClientValidationConstraint())).put(Pattern.class, (NotNullClientValidationConstraint)((Object)new PatternClientValidationConstraint())).build();

    private BeanValidationMetadataMapper() {
    }

    public static BeanValidationMetadata resolveValidationMetadata(FacesContext context, UIComponent component, PrimeApplicationContext applicationContext) throws IOException {
        ArrayList<String> validatorIds;
        HashMap<String, Object> metadata;
        block13: {
            metadata = null;
            validatorIds = null;
            try {
                Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractAllConstraintDescriptors(context, applicationContext, component.getValueExpression("value"));
                if (constraints == null || constraints.isEmpty()) break block13;
                boolean interpolateClientSideValidationMessages = applicationContext.getConfig().isInterpolateClientSideValidationMessages();
                MessageInterpolator messageInterpolator = null;
                if (interpolateClientSideValidationMessages) {
                    messageInterpolator = applicationContext.getValidatorFactory().getMessageInterpolator();
                }
                for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                    Map<String, Object> constraintMetadata;
                    Class<?> resolvedBy;
                    ClientConstraint clientConstraint;
                    Class<? extends Annotation> annotationType = constraintDescriptor.getAnnotation().annotationType();
                    ClientValidationConstraint clientValidationConstraint = CONSTRAINT_MAPPING.get(annotationType);
                    if (clientValidationConstraint == null && (clientConstraint = annotationType.getAnnotation(ClientConstraint.class)) != null && (resolvedBy = clientConstraint.resolvedBy()) != null) {
                        try {
                            clientValidationConstraint = (ClientValidationConstraint)resolvedBy.newInstance();
                        }
                        catch (Exception e) {
                            throw new FacesException("Could not instantiate ClientValidationConstraint!", (Throwable)e);
                        }
                    }
                    if (clientValidationConstraint == null) continue;
                    String validatorId = clientValidationConstraint.getValidatorId();
                    if (interpolateClientSideValidationMessages) {
                        MessageInterpolatingConstraintWrapper interpolatingConstraint = new MessageInterpolatingConstraintWrapper(messageInterpolator, constraintDescriptor);
                        constraintMetadata = clientValidationConstraint.getMetadata(interpolatingConstraint);
                    } else {
                        constraintMetadata = clientValidationConstraint.getMetadata(constraintDescriptor);
                    }
                    if (constraintMetadata != null) {
                        if (metadata == null) {
                            metadata = new HashMap<String, Object>();
                        }
                        metadata.putAll(constraintMetadata);
                    }
                    if (validatorId == null) continue;
                    if (validatorIds == null) {
                        validatorIds = new ArrayList<String>();
                    }
                    validatorIds.add(validatorId);
                }
            }
            catch (PropertyNotFoundException e) {
                String message = "Skip resolving of CSV BV metadata for component \"" + component.getClientId(context) + "\" because the ValueExpression of the \"value\" attribute isn't resolvable completely (e.g. a sub-expression returns null)";
                LOGGER.log(Level.FINE, message);
            }
        }
        if (metadata == null && validatorIds == null) {
            return null;
        }
        return new BeanValidationMetadata(metadata, validatorIds);
    }

    public static void registerConstraintMapping(Class<? extends Annotation> constraint, ClientValidationConstraint clientValidationConstraint) {
        CONSTRAINT_MAPPING.put(constraint, clientValidationConstraint);
    }

    public static ClientValidationConstraint removeConstraintMapping(Class<? extends Annotation> constraint) {
        return CONSTRAINT_MAPPING.remove(constraint);
    }
}

