/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method;

import javax.xml.transform.Source;
import org.springframework.core.MethodParameter;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadMethodProcessor;

public abstract class AbstractPayloadSourceMethodProcessor
extends AbstractPayloadMethodProcessor {
    public final Object resolveArgument(MessageContext messageContext, MethodParameter parameter) throws Exception {
        Source requestPayload = this.getRequestPayload(messageContext);
        return requestPayload != null ? this.resolveRequestPayloadArgument(parameter, requestPayload) : null;
    }

    private Source getRequestPayload(MessageContext messageContext) {
        WebServiceMessage request = messageContext.getRequest();
        return request != null ? request.getPayloadSource() : null;
    }

    protected abstract Object resolveRequestPayloadArgument(MethodParameter var1, Source var2) throws Exception;

    public final void handleReturnValue(MessageContext messageContext, MethodParameter returnType, Object returnValue) throws Exception {
        Source responsePayload;
        if (returnValue != null && (responsePayload = this.createResponsePayload(returnType, returnValue)) != null) {
            WebServiceMessage response = messageContext.getResponse();
            this.transform(responsePayload, response.getPayloadResult());
        }
    }

    protected abstract Source createResponsePayload(MethodParameter var1, Object var2) throws Exception;
}

