/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.roma.component;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.model.menu.MenuModel;

@ListenerFor(sourceClass=RomaMenu.class, systemEventClass=PostAddToViewEvent.class)
public class RomaMenu
extends AbstractMenu
implements Widget,
ComponentSystemEventListener {
    public static final String COMPONENT_TYPE = "org.primefaces.component.RomaMenu";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.RomaMenuRenderer";
    private static final String[] LEGACY_RESOURCES = new String[]{"primefaces.css", "jquery/jquery.js", "jquery/jquery-plugins.js", "primefaces.js"};
    private static final String[] MODERN_RESOURCES = new String[]{"components.css", "jquery/jquery.js", "jquery/jquery-plugins.js", "core.js"};

    public RomaMenu() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public MenuModel getModel() {
        return (MenuModel)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.model), null);
    }

    public void setModel(MenuModel _model) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.model), (Object)_model);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event instanceof PostAddToViewEvent) {
            String[] resources;
            boolean isPrimeConfig;
            FacesContext context = this.getFacesContext();
            UIViewRoot root = context.getViewRoot();
            try {
                isPrimeConfig = Class.forName("org.primefaces.config.PrimeConfiguration") != null;
            }
            catch (ClassNotFoundException e) {
                isPrimeConfig = false;
            }
            for (String res : resources = isPrimeConfig ? MODERN_RESOURCES : LEGACY_RESOURCES) {
                UIComponent component = context.getApplication().createComponent("javax.faces.Output");
                if (res.endsWith("css")) {
                    component.setRendererType("javax.faces.resource.Stylesheet");
                } else if (res.endsWith("js")) {
                    component.setRendererType("javax.faces.resource.Script");
                }
                component.getAttributes().put("library", "primefaces");
                component.getAttributes().put("name", res);
                root.addComponentResource(context, component);
            }
        }
    }

    protected static enum PropertyKeys {
        widgetVar,
        model,
        style,
        styleClass;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

