/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Units;

public abstract class Bitmap
extends HSLFPictureData {
    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        int prefixLen = 16 * this.getUIDInstanceCount() + 1;
        byte[] imgdata = IOUtils.safelyAllocate((long)(rawdata.length - prefixLen), (int)rawdata.length);
        System.arraycopy(rawdata, prefixLen, imgdata, 0, imgdata.length);
        return imgdata;
    }

    public void setData(byte[] data) throws IOException {
        byte[] checksum = Bitmap.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        if (this.getUIDInstanceCount() == 2) {
            out.write(checksum);
        }
        out.write(0);
        out.write(data);
        this.setRawData(out.toByteArray());
    }

    public Dimension getImageDimension() {
        try {
            BufferedImage bi = ImageIO.read(new ByteArrayInputStream(this.getData()));
            return new Dimension((int)Units.pixelToPoints((int)bi.getWidth()), (int)Units.pixelToPoints((int)bi.getHeight()));
        }
        catch (IOException e) {
            return new Dimension(200, 200);
        }
    }
}

