/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.button;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import org.primefaces.component.button.ButtonBase;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Button
extends ButtonBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Button";
    private static final Logger LOGGER = Logger.getLogger(Button.class.getName());

    public String resolveIcon() {
        String icon = this.getIcon();
        if (icon == null && (icon = this.getImage()) != null) {
            LOGGER.info("image attribute is deprecated to define an icon, use icon attribute instead.");
        }
        return icon;
    }

    public String resolveStyleClass() {
        String userStyleClass;
        String icon = this.resolveIcon();
        Object value = this.getValue();
        String styleClass = "";
        if (value != null && LangUtils.isValueBlank(icon)) {
            styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only";
        } else if (value != null && !LangUtils.isValueBlank(icon)) {
            styleClass = this.getIconPos().equals("left") ? "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left" : "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-right";
        } else if (value == null && !LangUtils.isValueBlank(icon)) {
            styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only";
        }
        if (this.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        if ((userStyleClass = this.getStyleClass()) != null) {
            styleClass = styleClass + " " + userStyleClass;
        }
        return styleClass;
    }

    @Override
    public Map<String, List<String>> getParams() {
        return ComponentUtils.getUIParams((UIComponent)this);
    }
}

