/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datalist;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import org.primefaces.PrimeFaces;
import org.primefaces.component.datalist.DataListBase;
import org.primefaces.component.datalist.DataListState;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class DataList
extends DataListBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataList";
    public static final String DATALIST_CLASS = "ui-datalist ui-widget";
    public static final String CONTENT_CLASS = "ui-datalist-content ui-widget-content";
    public static final String LIST_CLASS = "ui-datalist-data";
    public static final String NO_BULLETS_CLASS = "ui-datalist-nobullets";
    public static final String LIST_ITEM_CLASS = "ui-datalist-item";
    public static final String HEADER_CLASS = "ui-datalist-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datalist-footer ui-widget-header ui-corner-bottom";
    public static final String DATALIST_EMPTY_MESSAGE_CLASS = "ui-datalist-empty-message";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("page", PageEvent.class).put("tap", SelectEvent.class).put("taphold", SelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getListTag() {
        String type = this.getType();
        if (type.equalsIgnoreCase("unordered")) {
            return "ul";
        }
        if (type.equalsIgnoreCase("ordered")) {
            return "ol";
        }
        if (type.equalsIgnoreCase("definition")) {
            return "dl";
        }
        if (type.equalsIgnoreCase("none")) {
            return null;
        }
        throw new FacesException("DataList '" + this.getClientId() + "' has invalid list type:'" + type + "'");
    }

    public boolean isDefinition() {
        return this.getType().equalsIgnoreCase("definition");
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = lazyModel.load(this.getFirst(), this.getRows(), null, null, null);
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)this, this.getFacesContext()) && this.isPaginator()) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            if (eventName.equals("page")) {
                String clientId = this.getClientId(context);
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                PageEvent pageEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
                pageEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)pageEvent);
            } else if (eventName.equals("tap") || eventName.equals("taphold")) {
                String clientId = this.getClientId(context);
                int index = Integer.parseInt((String)params.get(clientId + "_item"));
                this.setRowIndex(index);
                SelectEvent selectEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
                selectEvent.setPhaseId(behaviorEvent.getPhaseId());
                this.setRowIndex(-1);
                super.queueEvent((FacesEvent)selectEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    protected void processFacets(FacesContext context, PhaseId phaseId) {
        if (this.getFacetCount() > 0) {
            UIComponent descriptionFacet = this.getFacet("description");
            for (UIComponent facet : this.getFacets().values()) {
                if (facet.equals(descriptionFacet)) continue;
                this.process(context, facet, phaseId);
            }
        }
    }

    @Override
    protected void processChildren(FacesContext context, PhaseId phaseId) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIComponent child : this.getIterableChildren()) {
                if (!child.isRendered()) continue;
                this.process(context, child, phaseId);
            }
            UIComponent descriptionFacet = this.getFacet("description");
            if (descriptionFacet == null || !this.isDefinition()) continue;
            this.process(context, descriptionFacet, phaseId);
        }
    }

    public void restoreDataListState() {
        DataListState ls = this.getDataListState(false);
        if (ls != null && this.isPaginator()) {
            this.setFirst(ls.getFirst());
            int rows = ls.getRows() == 0 ? this.getRows() : ls.getRows();
            this.setRows(rows);
        }
    }

    public DataListState getDataListState(boolean create) {
        DataListState ls;
        FacesContext fc = this.getFacesContext();
        Map sessionMap = fc.getExternalContext().getSessionMap();
        HashMap<String, DataListState> dlState = (HashMap<String, DataListState>)sessionMap.get("primefaces.DATALIST_STATE");
        String viewId = fc.getViewRoot().getViewId().replaceFirst("^/*", "");
        String stateKey = viewId + "_" + this.getClientId(fc);
        if (dlState == null) {
            dlState = new HashMap<String, DataListState>();
            sessionMap.put("primefaces.DATALIST_STATE", dlState);
        }
        if ((ls = (DataListState)dlState.get(stateKey)) == null && create) {
            ls = new DataListState();
            dlState.put(stateKey, ls);
        }
        return ls;
    }
}

