/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.model.DataModel;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTableBase;
import org.primefaces.component.datatable.MultiSortState;
import org.primefaces.component.datatable.TableState;
import org.primefaces.component.datatable.feature.AddRowFeature;
import org.primefaces.component.datatable.feature.CellEditFeature;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.DraggableColumnsFeature;
import org.primefaces.component.datatable.feature.DraggableRowsFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.component.datatable.feature.PageFeature;
import org.primefaces.component.datatable.feature.ResizableColumnsFeature;
import org.primefaces.component.datatable.feature.RowEditFeature;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.ScrollFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.component.row.Row;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.ReorderEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.event.ToggleSelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SelectableDataModelWrapper;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.Visibility;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.util.SharedStringBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class DataTable
extends DataTableBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
    public static final String CONTAINER_CLASS = "ui-datatable ui-widget";
    public static final String TABLE_WRAPPER_CLASS = "ui-datatable-tablewrapper";
    public static final String REFLOW_CLASS = "ui-datatable-reflow";
    public static final String RTL_CLASS = "ui-datatable-rtl";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String DYNAMIC_COLUMN_HEADER_CLASS = "ui-dynamic-column";
    public static final String COLUMN_HEADER_CONTAINER_CLASS = "ui-header-column";
    public static final String COLUMN_FOOTER_CLASS = "ui-state-default";
    public static final String COLUMN_FOOTER_CONTAINER_CLASS = "ui-footer-column";
    public static final String DATA_CLASS = "ui-datatable-data ui-widget-content";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTABLE_ROW_CLASS = "ui-datatable-selectable";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-datatable-empty-message";
    public static final String HEADER_CLASS = "ui-datatable-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datatable-footer ui-widget-header ui-corner-bottom";
    public static final String SORTABLE_COLUMN_CLASS = "ui-sortable-column";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String STATIC_COLUMN_CLASS = "ui-static-column";
    public static final String UNSELECTABLE_COLUMN_CLASS = "ui-column-unselectable";
    public static final String HIDDEN_COLUMN_CLASS = "ui-helper-hidden";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_TITLE_CLASS = "ui-column-title";
    public static final String COLUMN_FILTER_CLASS = "ui-column-filter ui-widget ui-state-default ui-corner-left";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String COLUMN_CUSTOM_FILTER_CLASS = "ui-column-customfilter";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String EXPANDED_ROW_CLASS = "ui-expanded-row";
    public static final String EXPANDED_ROW_CONTENT_CLASS = "ui-expanded-row-content";
    public static final String ROW_TOGGLER_CLASS = "ui-row-toggler";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String CELL_EDITOR_CLASS = "ui-cell-editor";
    public static final String CELL_EDITOR_INPUT_CLASS = "ui-cell-editor-input";
    public static final String CELL_EDITOR_OUTPUT_CLASS = "ui-cell-editor-output";
    public static final String CELL_EDITOR_DISABLED_CLASS = "ui-cell-editor-disabled";
    public static final String ROW_EDITOR_COLUMN_CLASS = "ui-row-editor-column";
    public static final String ROW_EDITOR_CLASS = "ui-row-editor ui-helper-clearfix";
    public static final String SELECTION_COLUMN_CLASS = "ui-selection-column";
    public static final String EVEN_ROW_CLASS = "ui-datatable-even";
    public static final String ODD_ROW_CLASS = "ui-datatable-odd";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-datatable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-datatable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-datatable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-datatable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-datatable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-datatable-scrollable-footer-box";
    public static final String VIRTUALSCROLL_WRAPPER_CLASS = "ui-datatable-virtualscroll-wrapper";
    public static final String VIRTUALSCROLL_TABLE_CLASS = "ui-datatable-virtualscroll-table";
    public static final String COLUMN_RESIZER_CLASS = "ui-column-resizer";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-datatable-resizable";
    public static final String SUBTABLE_HEADER = "ui-datatable-subtable-header";
    public static final String SUBTABLE_FOOTER = "ui-datatable-subtable-footer";
    public static final String SUMMARY_ROW_CLASS = "ui-datatable-summaryrow ui-widget-header";
    public static final String HEADER_ROW_CLASS = "ui-rowgroup-header ui-datatable-headerrow ui-widget-header";
    public static final String ROW_GROUP_TOGGLER_CLASS = "ui-rowgroup-toggler";
    public static final String ROW_GROUP_TOGGLER_ICON_CLASS = "ui-rowgroup-toggler-icon ui-icon ui-icon-circle-triangle-s";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    public static final String STICKY_HEADER_CLASS = "ui-datatable-sticky";
    public static final String ARIA_FILTER_BY = "primefaces.datatable.aria.FILTER_BY";
    public static final String ARIA_HEADER_CHECKBOX_ALL = "primefaces.datatable.aria.HEADER_CHECKBOX_ALL";
    public static final String SORT_LABEL = "primefaces.datatable.SORT_LABEL";
    public static final String SORT_ASC = "primefaces.datatable.SORT_ASC";
    public static final String SORT_DESC = "primefaces.datatable.SORT_DESC";
    public static final String ROW_GROUP_TOGGLER = "primefaces.rowgrouptoggler.aria.ROW_GROUP_TOGGLER";
    static final Map<DataTableFeatureKey, DataTableFeature> FEATURES = MapBuilder.builder().put(DataTableFeatureKey.DRAGGABLE_COLUMNS, new DraggableColumnsFeature()).put(DataTableFeatureKey.FILTER, (DraggableColumnsFeature)((Object)new FilterFeature())).put(DataTableFeatureKey.PAGE, (DraggableColumnsFeature)((Object)new PageFeature())).put(DataTableFeatureKey.SORT, (DraggableColumnsFeature)((Object)new SortFeature())).put(DataTableFeatureKey.RESIZABLE_COLUMNS, (DraggableColumnsFeature)((Object)new ResizableColumnsFeature())).put(DataTableFeatureKey.SELECT, (DraggableColumnsFeature)((Object)new SelectionFeature())).put(DataTableFeatureKey.ROW_EDIT, (DraggableColumnsFeature)((Object)new RowEditFeature())).put(DataTableFeatureKey.CELL_EDIT, (DraggableColumnsFeature)((Object)new CellEditFeature())).put(DataTableFeatureKey.ROW_EXPAND, (DraggableColumnsFeature)((Object)new RowExpandFeature())).put(DataTableFeatureKey.SCROLL, (DraggableColumnsFeature)((Object)new ScrollFeature())).put(DataTableFeatureKey.DRAGGABLE_ROWS, (DraggableColumnsFeature)((Object)new DraggableRowsFeature())).put(DataTableFeatureKey.ADD_ROW, (DraggableColumnsFeature)((Object)new AddRowFeature())).build();
    private static final String SB_GET_SELECTED_ROW_KEYS_AS_STRING = DataTable.class.getName() + "#getSelectedRowKeysAsString";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("page", PageEvent.class).put("sort", SortEvent.class).put("filter", FilterEvent.class).put("rowSelect", SelectEvent.class).put("rowUnselect", UnselectEvent.class).put("rowEdit", RowEditEvent.class).put("rowEditInit", RowEditEvent.class).put("rowEditCancel", RowEditEvent.class).put("colResize", ColumnResizeEvent.class).put("toggleSelect", ToggleSelectEvent.class).put("colReorder", null).put("contextMenu", SelectEvent.class).put("rowSelectRadio", SelectEvent.class).put("rowSelectCheckbox", SelectEvent.class).put("rowUnselectCheckbox", UnselectEvent.class).put("rowDblselect", SelectEvent.class).put("rowToggle", ToggleEvent.class).put("cellEditInit", CellEditEvent.class).put("cellEdit", CellEditEvent.class).put("rowReorder", ReorderEvent.class).put("tap", SelectEvent.class).put("taphold", SelectEvent.class).put("cellEditCancel", CellEditEvent.class).put("virtualScroll", PageEvent.class).build();
    private static final Pattern STATIC_FIELD_PATTERN = Pattern.compile("^#\\{\\w+\\.(.*)\\}$");
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private int columnsCountWithSpan = -1;
    private List filterMetadata;
    private boolean reset = false;
    private List<Object> selectedRowKeys = new ArrayList<Object>();
    private boolean isRowKeyRestored = false;
    private int columnsCount = -1;
    private List<UIColumn> columns;
    private UIColumn sortColumn;
    private List<SortMeta> multiSortMeta = null;
    private Columns dynamicColumns;
    private ValueExpression sortByVE;
    private String togglableColumnsAsString;
    private Map<String, Boolean> togglableColsMap;
    private String resizableColumnsAsString;
    private Map<String, String> resizableColsMap;
    private List<UIComponent> iterableChildren;

    public DataTableFeature getFeature(DataTableFeatureKey key) {
        return FEATURES.get((Object)key);
    }

    public boolean shouldEncodeFeature(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_encodeFeature");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditAction");
    }

    public boolean isRowEditInitRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditInit");
    }

    public boolean isCellEditCancelRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditCancel");
    }

    public boolean isCellEditInitRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditInit");
    }

    public boolean isClientCacheRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_clientCache");
    }

    public boolean isPageStateRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_pageState");
    }

    public boolean isScrollingRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_scrolling");
    }

    public boolean isRowEditCancelRequest(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(this.getClientId(context) + "_rowEditAction");
        return value != null && value.equals("cancel");
    }

    public boolean isRowSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    public boolean isColumnSelectionEnabled() {
        return this.getColumnSelectionMode() != null;
    }

    public String getColumnSelectionMode() {
        for (UIComponent child : this.getChildren()) {
            String selectionMode;
            if (!child.isRendered() || !(child instanceof Column) || (selectionMode = ((Column)child).getSelectionMode()) == null) continue;
            return selectionMode;
        }
        return null;
    }

    public boolean isSelectionEnabled() {
        return this.isRowSelectionEnabled() || this.isColumnSelectionEnabled();
    }

    public boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        if (selectionMode != null) {
            return selectionMode.equalsIgnoreCase("single");
        }
        if (columnSelectionMode != null) {
            return columnSelectionMode.equalsIgnoreCase("single");
        }
        return false;
    }

    @Override
    public void processValidators(FacesContext context) {
        super.processValidators(context);
        if (this.isFilterRequest(context)) {
            FEATURES.get((Object)DataTableFeatureKey.FILTER).decode(context, this);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        List filterMeta;
        super.processUpdates(context);
        ValueExpression selectionVE = this.getValueExpression(DataTableBase.PropertyKeys.selection.toString());
        if (selectionVE != null) {
            selectionVE.setValue(context.getELContext(), this.getLocalSelection());
            this.setSelection(null);
        }
        if ((filterMeta = this.getFilterMetadata()) != null && !filterMeta.isEmpty()) {
            ELContext eLContext = context.getELContext();
            for (FilterMeta fm : filterMeta) {
                UIColumn column = fm.getColumn();
                ValueExpression columnFilterValueVE = column.getValueExpression(ColumnBase.PropertyKeys.filterValue.toString());
                if (columnFilterValueVE == null) continue;
                if (column.isDynamic()) {
                    DynamicColumn dynamicColumn = (DynamicColumn)column;
                    dynamicColumn.applyStatelessModel();
                    columnFilterValueVE.setValue(eLContext, fm.getFilterValue());
                    dynamicColumn.cleanStatelessModel();
                }
                columnFilterValueVE.setValue(eLContext, fm.getFilterValue());
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("rowSelect") || eventName.equals("rowSelectRadio") || eventName.equals("contextMenu") || eventName.equals("rowSelectCheckbox") || eventName.equals("rowDblselect")) {
                String rowKey = (String)params.get(clientId + "_instantSelectedRowKey");
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("rowUnselect") || eventName.equals("rowUnselectCheckbox")) {
                String rowKey = (String)params.get(clientId + "_instantUnselectedRowKey");
                wrapperEvent = new UnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("page") || eventName.equals("virtualScroll")) {
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
            } else if (eventName.equals("sort")) {
                UIColumn sortColumn;
                SortOrder order;
                int sortColumnIndex = 0;
                if (this.isMultiSort()) {
                    String[] sortDirs = ((String)params.get(clientId + "_sortDir")).split(",");
                    String[] sortKeys = ((String)params.get(clientId + "_sortKey")).split(",");
                    order = SortOrder.valueOf(((SortFeature)FEATURES.get((Object)DataTableFeatureKey.SORT)).convertSortOrderParam(sortDirs[sortDirs.length - 1]));
                    sortColumn = this.findColumn(sortKeys[sortKeys.length - 1]);
                    sortColumnIndex = sortKeys.length - 1;
                } else {
                    order = SortOrder.valueOf(((SortFeature)FEATURES.get((Object)DataTableFeatureKey.SORT)).convertSortOrderParam((String)params.get(clientId + "_sortDir")));
                    sortColumn = this.findColumn((String)params.get(clientId + "_sortKey"));
                }
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), sortColumn, order, sortColumnIndex);
            } else if (eventName.equals("filter")) {
                wrapperEvent = new FilterEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getFilteredValue());
            } else if (eventName.equals("rowEdit") || eventName.equals("rowEditCancel") || eventName.equals("rowEditInit")) {
                int rowIndex = Integer.parseInt((String)params.get(clientId + "_rowEditIndex"));
                this.setRowIndex(rowIndex);
                wrapperEvent = new RowEditEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Double.valueOf((String)params.get(clientId + "_width")).intValue();
                int height = Double.valueOf((String)params.get(clientId + "_height")).intValue();
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if (eventName.equals("toggleSelect")) {
                boolean checked = Boolean.parseBoolean((String)params.get(clientId + "_checked"));
                wrapperEvent = new ToggleSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), checked);
            } else if (eventName.equals("colReorder")) {
                wrapperEvent = behaviorEvent;
            } else if (eventName.equals("rowToggle")) {
                boolean expansion = params.containsKey(clientId + "_rowExpansion");
                Visibility visibility = expansion ? Visibility.VISIBLE : Visibility.HIDDEN;
                String rowIndex = expansion ? (String)params.get(clientId + "_expandedRowIndex") : (String)params.get(clientId + "_collapsedRowIndex");
                this.setRowIndex(Integer.parseInt(rowIndex));
                wrapperEvent = new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility, this.getRowData());
            } else if (eventName.equals("cellEdit") || eventName.equals("cellEditCancel") || eventName.equals("cellEditInit")) {
                String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                int rowIndex = Integer.parseInt(cellInfo[0]);
                int cellIndex = Integer.parseInt(cellInfo[1]);
                String rowKey = null;
                if (cellInfo.length == 3) {
                    rowKey = cellInfo[2];
                }
                int i = -1;
                UIColumn column = null;
                for (UIColumn col : this.getColumns()) {
                    if (!col.isRendered() || ++i != cellIndex) continue;
                    column = col;
                    break;
                }
                wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), rowIndex, column, rowKey);
            } else if (eventName.equals("rowReorder")) {
                int fromIndex = Integer.parseInt((String)params.get(clientId + "_fromIndex"));
                int toIndex = Integer.parseInt((String)params.get(clientId + "_toIndex"));
                wrapperEvent = new ReorderEvent((UIComponent)this, behaviorEvent.getBehavior(), fromIndex, toIndex);
            } else if (eventName.equals("tap") || eventName.equals("taphold")) {
                String rowkey = (String)params.get(clientId + "_rowkey");
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowkey));
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(event.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public UIColumn findColumn(String clientId) {
        for (UIColumn column : this.getColumns()) {
            if (!column.getColumnKey().equals(clientId)) continue;
            return column;
        }
        if (this.getFrozenColumns() > 0) {
            UIColumn column = this.findColumnInGroup(clientId, this.getColumnGroup("frozenHeader"));
            if (column == null) {
                column = this.findColumnInGroup(clientId, this.getColumnGroup("scrollableHeader"));
            }
            if (column != null) {
                return column;
            }
        } else {
            return this.findColumnInGroup(clientId, this.getColumnGroup("header"));
        }
        throw new FacesException("Cannot find column with key: " + clientId);
    }

    public UIColumn findColumnInGroup(String clientId, ColumnGroup group) {
        if (group == null) {
            return null;
        }
        FacesContext context = this.getFacesContext();
        for (UIComponent row : group.getChildren()) {
            for (UIComponent rowChild : row.getChildren()) {
                if (rowChild instanceof Column) {
                    if (!rowChild.getClientId(context).equals(clientId)) continue;
                    return (UIColumn)rowChild;
                }
                if (!(rowChild instanceof Columns)) continue;
                Columns uiColumns = (Columns)rowChild;
                List<DynamicColumn> dynaColumns = uiColumns.getDynamicColumns();
                for (UIColumn uIColumn : dynaColumns) {
                    if (!uIColumn.getColumnKey().equals(clientId)) continue;
                    return uIColumn;
                }
            }
        }
        return null;
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public boolean hasFooterColumn() {
        for (UIComponent child : this.getChildren()) {
            UIColumn column;
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            List filters;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = null;
            this.calculateFirst();
            FacesContext context = this.getFacesContext();
            int first = this.getFirst();
            if (this.isClientCacheRequest(context)) {
                Map params = context.getExternalContext().getRequestParameterMap();
                first = Integer.parseInt((String)params.get(this.getClientId(context) + "_first")) + this.getRows();
            }
            if (this.isMultiViewState() && (filters = this.getFilterBy()) != null) {
                String globalFilterParam = this.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
                List filterMetaDataList = this.getFilterMetadata();
                if (filterMetaDataList != null) {
                    FilterFeature filterFeature = (FilterFeature)this.getFeature(DataTableFeatureKey.FILTER);
                    Map<String, Object> filterParameterMap = filterFeature.populateFilterParameterMap(context, this, filterMetaDataList, globalFilterParam);
                    this.setFilters(filterParameterMap);
                }
            }
            data = this.isMultiSort() ? lazyModel.load(first, this.getRows(), this.getMultiSortMeta(), this.getFilters()) : lazyModel.load(first, this.getRows(), this.resolveSortField(), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)this, context) && (this.isPaginator() || this.isLiveScroll() || this.isVirtualScroll())) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void loadLazyScrollData(int offset, int rows) {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = null;
            data = this.isMultiSort() ? lazyModel.load(offset, rows, this.getMultiSortMeta(), this.getFilters()) : lazyModel.load(offset, rows, this.resolveSortField(), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(rows);
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)this, this.getFacesContext()) && (this.isPaginator() || this.isLiveScroll() || this.isVirtualScroll())) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    protected String resolveSortField() {
        String field;
        String sortField = null;
        UIColumn column = this.getSortColumn();
        ValueExpression tableSortByVE = this.getValueExpression(DataTableBase.PropertyKeys.sortBy.toString());
        Object tableSortByProperty = this.getSortBy();
        sortField = column == null ? ((field = this.getSortField()) == null ? (tableSortByVE == null ? (String)tableSortByProperty : this.resolveStaticField(tableSortByVE)) : field) : this.resolveColumnField(this.sortColumn);
        return sortField;
    }

    public String resolveColumnField(UIColumn column) {
        String columnField;
        ValueExpression columnSortByVE = column.getValueExpression(DataTableBase.PropertyKeys.sortBy.toString());
        if (column.isDynamic()) {
            ((DynamicColumn)column).applyStatelessModel();
            Object sortByProperty = column.getSortBy();
            String field = column.getField();
            columnField = field == null ? (sortByProperty == null ? this.resolveDynamicField(columnSortByVE) : sortByProperty.toString()) : field;
        } else {
            String field = column.getField();
            columnField = field == null ? (columnSortByVE == null ? (String)column.getSortBy() : this.resolveStaticField(columnSortByVE)) : field;
        }
        return columnField;
    }

    public SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        return SortOrder.valueOf(sortOrder.toUpperCase(Locale.ENGLISH));
    }

    public String resolveStaticField(ValueExpression exprVE) {
        String exprStr;
        Matcher matcher;
        if (exprVE != null && (matcher = STATIC_FIELD_PATTERN.matcher(exprStr = exprVE.getExpressionString())).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String resolveDynamicField(ValueExpression expression) {
        if (expression == null) {
            return null;
        }
        FacesContext context = this.getFacesContext();
        ELContext elContext = context.getELContext();
        String expressionString = expression.getExpressionString();
        if (expressionString.startsWith("#{" + this.getVar() + "[")) {
            expressionString = expressionString.substring(expressionString.indexOf("[") + 1, expressionString.indexOf("]"));
            expressionString = "#{" + expressionString + "}";
            ValueExpression dynaVE = context.getApplication().getExpressionFactory().createValueExpression(elContext, expressionString, String.class);
            return (String)dynaVE.getValue(elContext);
        }
        return (String)expression.getValue(elContext);
    }

    public void clearLazyCache() {
        if (this.getDataModel() instanceof LazyDataModel) {
            LazyDataModel model = (LazyDataModel)this.getDataModel();
            model.setWrappedData(null);
        }
    }

    public Map<String, Object> getFilters() {
        return (Map)this.getStateHelper().eval((Serializable)((Object)"filters"), new HashMap());
    }

    public void setFilters(Map<String, Object> filters) {
        this.getStateHelper().put((Serializable)((Object)"filters"), filters);
    }

    public int getScrollOffset() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)"scrollOffset"), (Object)0);
    }

    public void setScrollOffset(int scrollOffset) {
        this.getStateHelper().put((Serializable)((Object)"scrollOffset"), (Object)scrollOffset);
    }

    public List getFilterMetadata() {
        return this.filterMetadata;
    }

    public void setFilterMetadata(List filterMetadata) {
        this.filterMetadata = filterMetadata;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void resetValue() {
        this.setValue(null);
        this.setFilteredValue(null);
        this.setFilters(null);
    }

    public void reset() {
        this.resetValue();
        this.setFirst(0);
        this.reset = true;
        this.setValueExpression("sortBy", this.getDefaultSortByVE());
        this.setSortFunction(this.getDefaultSortFunction());
        this.setSortOrder(this.getDefaultSortOrder());
        this.setSortByVE(null);
        this.setSortColumn(null);
        this.setSortField(null);
        this.setDefaultSort(true);
        this.clearMultiSortMeta();
    }

    public void resetRows() {
        this.getStateHelper().remove((Serializable)((Object)"rows"));
    }

    public boolean isFilteringEnabled() {
        Object value = this.getStateHelper().get((Serializable)((Object)"filtering"));
        return value != null;
    }

    public void enableFiltering() {
        this.getStateHelper().put((Serializable)((Object)"filtering"), (Object)true);
    }

    public RowExpansion getRowExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof RowExpansion)) continue;
            return (RowExpansion)kid;
        }
        return null;
    }

    public Object getLocalSelection() {
        return this.getStateHelper().get((Serializable)((Object)DataTableBase.PropertyKeys.selection));
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isBodyUpdate(FacesContext context) {
        String clientId = this.getClientId(context);
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_updateBody");
    }

    public SubTable getSubTable() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof SubTable)) continue;
            return (SubTable)kid;
        }
        return null;
    }

    public Object getRowKeyFromModel(Object object) {
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled.");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowKey(object);
    }

    public Object getRowData(String rowKey) {
        boolean hasRowKeyVe = this.getValueExpression(DataTableBase.PropertyKeys.rowKey.toString()) != null;
        DataModel model = this.getDataModel();
        if (hasRowKeyVe && !(model instanceof LazyDataModel)) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            String var = this.getVar();
            Collection data = (Collection)this.getDataModel().getWrappedData();
            if (data != null) {
                for (Object object : data) {
                    requestMap.put(var, object);
                    if (!String.valueOf(this.getRowKey()).equals(rowKey)) continue;
                    return object;
                }
            }
            return null;
        }
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement " + SelectableDataModel.class.getName() + " when selection is enabled or you need to define rowKey attribute");
        }
        return ((SelectableDataModel)model).getRowData(rowKey);
    }

    public void findSelectedRowKeys() {
        Object selection = this.getSelection();
        boolean hasRowKeyVe = this.getValueExpression(DataTableBase.PropertyKeys.rowKey.toString()) != null;
        String var = this.getVar();
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        if (this.isMultiViewState() && selection == null && this.isRowKeyRestored && this.getSelectedRowKeys() != null) {
            this.selectedRowKeys = this.getSelectedRowKeys();
            this.isRowKeyRestored = false;
        } else {
            this.selectedRowKeys = new ArrayList<Object>();
        }
        if (this.isSelectionEnabled() && selection != null) {
            if (this.isSingleSelectionMode()) {
                this.addToSelectedRowKeys(selection, requestMap, var, hasRowKeyVe);
            } else if (selection.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(selection); ++i) {
                    this.addToSelectedRowKeys(Array.get(selection, i), requestMap, var, hasRowKeyVe);
                }
            } else {
                List list = (List)selection;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.addToSelectedRowKeys(it.next(), requestMap, var, hasRowKeyVe);
                }
            }
            requestMap.remove(var);
        }
    }

    protected void addToSelectedRowKeys(Object object, Map<String, Object> requestMap, String var, boolean hasRowKey) {
        Object rowKey;
        requestMap.put(var, object);
        Object object2 = rowKey = hasRowKey ? this.getRowKey() : this.getRowKeyFromModel(object);
        if (rowKey != null && !this.isDisabledSelection()) {
            this.selectedRowKeys.add(rowKey);
        }
    }

    public List<Object> getSelectedRowKeys() {
        return this.selectedRowKeys;
    }

    public String getSelectedRowKeysAsString() {
        StringBuilder builder = SharedStringBuilder.get(SB_GET_SELECTED_ROW_KEYS_AS_STRING);
        Iterator<Object> iter = this.getSelectedRowKeys().iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public SummaryRow getSummaryRow() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof SummaryRow)) continue;
            return (SummaryRow)kid;
        }
        return null;
    }

    public HeaderRow getHeaderRow() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof HeaderRow)) continue;
            return (HeaderRow)kid;
        }
        return null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Columns) {
                    int dynamicColumnsCount = ((Columns)kid).getRowCount();
                    if (dynamicColumnsCount <= 0) continue;
                    this.columnsCount += dynamicColumnsCount;
                    continue;
                }
                if (kid instanceof Column) {
                    if (!((UIColumn)kid).isVisible()) continue;
                    ++this.columnsCount;
                    continue;
                }
                if (!(kid instanceof SubTable)) continue;
                SubTable subTable = (SubTable)kid;
                for (UIComponent subTableKid : subTable.getChildren()) {
                    if (!subTableKid.isRendered() || !(subTableKid instanceof Column)) continue;
                    ++this.columnsCount;
                }
            }
        }
        return this.columnsCount;
    }

    public int getColumnsCountWithSpan() {
        if (this.columnsCountWithSpan == -1) {
            this.columnsCountWithSpan = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Columns) {
                    int dynamicColumnsCount = ((Columns)kid).getRowCount();
                    if (dynamicColumnsCount <= 0) continue;
                    this.columnsCountWithSpan += dynamicColumnsCount;
                    continue;
                }
                if (kid instanceof Column) {
                    Column col = (Column)kid;
                    if (!col.isVisible()) continue;
                    this.columnsCountWithSpan += col.getColspan();
                    continue;
                }
                if (!(kid instanceof SubTable)) continue;
                SubTable subTable = (SubTable)kid;
                for (UIComponent subTableKid : subTable.getChildren()) {
                    if (!subTableKid.isRendered() || !(subTableKid instanceof Column)) continue;
                    this.columnsCountWithSpan += ((Column)subTableKid).getColspan();
                }
            }
        }
        return this.columnsCountWithSpan;
    }

    public List<UIColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<UIColumn>();
            FacesContext context = this.getFacesContext();
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Column) {
                    this.columns.add((UIColumn)child);
                    continue;
                }
                if (!(child instanceof Columns)) continue;
                Columns uiColumns = (Columns)child;
                String uiColumnsClientId = uiColumns.getClientId(context);
                for (int i = 0; i < uiColumns.getRowCount(); ++i) {
                    DynamicColumn dynaColumn = new DynamicColumn(i, uiColumns);
                    dynaColumn.setColumnKey(uiColumnsClientId + separator + i);
                    this.columns.add(dynaColumn);
                }
            }
        }
        return this.columns;
    }

    public void setColumns(List<UIColumn> columns) {
        this.columns = columns;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    @Override
    protected boolean shouldSkipChildren(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String paramValue = (String)params.get("primefaces.skipchildren");
        if (paramValue != null && !Boolean.parseBoolean(paramValue)) {
            return false;
        }
        return this.isSkipChildren() || params.containsKey(this.getClientId(context) + "_skipChildren");
    }

    public UIColumn getSortColumn() {
        String sortColumnKey;
        if (this.sortColumn == null && (sortColumnKey = (String)this.getStateHelper().get((Serializable)((Object)"sortColumnKey"))) != null) {
            this.sortColumn = this.findColumn(sortColumnKey);
        }
        return this.sortColumn;
    }

    public void setSortColumn(UIColumn column) {
        this.sortColumn = column;
        if (column == null) {
            this.getStateHelper().remove((Serializable)((Object)"sortColumnKey"));
        } else {
            this.getStateHelper().put((Serializable)((Object)"sortColumnKey"), (Object)column.getColumnKey());
        }
    }

    public boolean isMultiSort() {
        String sortMode = this.getSortMode();
        return sortMode != null && sortMode.equals("multiple");
    }

    public List<MultiSortState> getMultiSortState() {
        return (List)this.getStateHelper().get((Serializable)((Object)"multiSortState"));
    }

    public void setMultiSortState(List<MultiSortState> _multiSortState) {
        this.getStateHelper().put((Serializable)((Object)"multiSortState"), _multiSortState);
    }

    public List<SortMeta> getMultiSortMeta() {
        if (this.multiSortMeta != null) {
            return this.multiSortMeta;
        }
        List<MultiSortState> multiSortStateList = this.getMultiSortState();
        if (multiSortStateList != null && !multiSortStateList.isEmpty()) {
            this.multiSortMeta = new ArrayList<SortMeta>();
            for (int i = 0; i < multiSortStateList.size(); ++i) {
                MultiSortState multiSortState = multiSortStateList.get(i);
                UIColumn column = this.findColumn(multiSortState.getSortKey());
                if (column == null) continue;
                SortMeta sortMeta = new SortMeta();
                sortMeta.setSortBy(column);
                sortMeta.setSortField(multiSortState.getSortField());
                sortMeta.setSortOrder(multiSortState.getSortOrder());
                sortMeta.setSortFunction(multiSortState.getSortFunction());
                this.multiSortMeta.add(sortMeta);
            }
        } else {
            ValueExpression ve = this.getValueExpression(DataTableBase.PropertyKeys.sortBy.toString());
            if (ve != null) {
                this.multiSortMeta = (List)ve.getValue(this.getFacesContext().getELContext());
            }
        }
        return this.multiSortMeta;
    }

    public void setMultiSortMeta(List<SortMeta> value) {
        this.multiSortMeta = value;
        if (value != null && !value.isEmpty()) {
            ArrayList<MultiSortState> multiSortStateList = new ArrayList<MultiSortState>();
            for (int i = 0; i < value.size(); ++i) {
                multiSortStateList.add(new MultiSortState(value.get(i)));
            }
            this.setMultiSortState(multiSortStateList);
        }
    }

    private void clearMultiSortMeta() {
        this.multiSortMeta = null;
        this.getStateHelper().remove((Serializable)((Object)"multiSortState"));
    }

    public String resolveSelectionMode() {
        String tableSelectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        String selectionMode = null;
        if (tableSelectionMode != null) {
            selectionMode = tableSelectionMode;
        } else if (columnSelectionMode != null) {
            selectionMode = columnSelectionMode.equals("single") ? "radio" : "checkbox";
        }
        return selectionMode;
    }

    @Override
    protected boolean requiresColumns() {
        return true;
    }

    public Columns getDynamicColumns() {
        return this.dynamicColumns;
    }

    public void setDynamicColumns(Columns value) {
        this.dynamicColumns = value;
    }

    @Override
    protected void processColumnFacets(FacesContext context, PhaseId phaseId) {
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof UIColumn) {
                    if (child instanceof Column) {
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                        continue;
                    }
                    if (!(child instanceof Columns)) continue;
                    Columns uicolumns = (Columns)child;
                    int f = uicolumns.getFirst();
                    int r = uicolumns.getRows();
                    int l = r == 0 ? uicolumns.getRowCount() : f + r;
                    for (int i = f; i < l; ++i) {
                        uicolumns.setRowIndex(i);
                        if (!uicolumns.isRowAvailable()) break;
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                    }
                    uicolumns.setRowIndex(-1);
                    continue;
                }
                if (!(child instanceof ColumnGroup) || child.getChildCount() <= 0) continue;
                for (UIComponent columnGroupChild : child.getChildren()) {
                    if (columnGroupChild instanceof Row && columnGroupChild.getChildCount() > 0) {
                        for (UIComponent rowChild : columnGroupChild.getChildren()) {
                            if (rowChild instanceof Column && rowChild.getFacetCount() > 0) {
                                for (UIComponent facet : rowChild.getFacets().values()) {
                                    this.process(context, facet, phaseId);
                                }
                                continue;
                            }
                            this.process(context, rowChild, phaseId);
                        }
                        continue;
                    }
                    this.process(context, columnGroupChild, phaseId);
                }
            }
        }
    }

    @Override
    protected void processChildren(FacesContext context, PhaseId phaseId) {
        int first = this.getFirst();
        int rows = this.getRows();
        int rowCount = this.getRowCount();
        int last = rows == 0 ? (this.isLiveScroll() ? this.getScrollRows() + this.getScrollOffset() : rowCount) : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIComponent child : this.getIterableChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Column) {
                    for (UIComponent grandkid : child.getChildren()) {
                        this.process(context, grandkid, phaseId);
                    }
                    continue;
                }
                this.process(context, child, phaseId);
            }
        }
    }

    public ValueExpression getSortByVE() {
        return this.sortByVE;
    }

    public void setSortByVE(ValueExpression ve) {
        this.sortByVE = ve;
    }

    public ValueExpression getDefaultSortByVE() {
        return this.getValueExpression("defaultSortBy");
    }

    public void setDefaultSortByVE(ValueExpression ve) {
        this.setValueExpression("defaultSortBy", ve);
    }

    public String getDefaultSortOrder() {
        return (String)this.getStateHelper().get((Serializable)((Object)"defaultSortOrder"));
    }

    public void setDefaultSortOrder(String val) {
        this.getStateHelper().put((Serializable)((Object)"defaultSortOrder"), (Object)val);
    }

    public MethodExpression getDefaultSortFunction() {
        return (MethodExpression)this.getStateHelper().get((Serializable)((Object)"defaultSortFunction"));
    }

    public void setDefaultSortFunction(MethodExpression obj) {
        this.getStateHelper().put((Serializable)((Object)"defaultSortFunction"), (Object)obj);
    }

    public boolean isDefaultSort() {
        Object value = this.getStateHelper().get((Serializable)((Object)"defaultSort"));
        if (value == null) {
            return true;
        }
        return (Boolean)value;
    }

    public void setDefaultSort(boolean defaultSort) {
        this.getStateHelper().put((Serializable)((Object)"defaultSort"), (Object)defaultSort);
    }

    public void setTogglableColumnsAsString(String togglableColumnsAsString) {
        this.togglableColumnsAsString = togglableColumnsAsString;
    }

    public Map getTogglableColumnsMap() {
        if (this.togglableColsMap == null) {
            this.togglableColsMap = new HashMap<String, Boolean>();
            boolean isValueBlank = LangUtils.isValueBlank(this.togglableColumnsAsString);
            if (isValueBlank) {
                FacesContext context = this.getFacesContext();
                Map params = context.getExternalContext().getRequestParameterMap();
                this.setTogglableColumnsAsString((String)params.get(this.getClientId(context) + "_columnTogglerState"));
            }
            if (!isValueBlank) {
                String[] colsArr = this.togglableColumnsAsString.split(",");
                for (int i = 0; i < colsArr.length; ++i) {
                    String temp = colsArr[i];
                    int sepIndex = temp.lastIndexOf("_");
                    this.togglableColsMap.put(temp.substring(0, sepIndex), Boolean.parseBoolean(temp.substring(sepIndex + 1, temp.length())));
                }
            }
        }
        return this.togglableColsMap;
    }

    public void setTogglableColumnsMap(Map<String, Boolean> togglableColsMap) {
        this.togglableColsMap = togglableColsMap;
    }

    public String getResizableColumnsAsString() {
        return this.resizableColumnsAsString;
    }

    public void setResizableColumnsAsString(String resizableColumnsAsString) {
        this.resizableColumnsAsString = resizableColumnsAsString;
    }

    public Map getResizableColumnsMap() {
        if (this.resizableColsMap == null) {
            this.resizableColsMap = new HashMap<String, String>();
            boolean isValueBlank = LangUtils.isValueBlank(this.resizableColumnsAsString);
            if (isValueBlank) {
                FacesContext context = this.getFacesContext();
                Map params = context.getExternalContext().getRequestParameterMap();
                this.setResizableColumnsAsString((String)params.get(this.getClientId(context) + "_resizableColumnState"));
            }
            if (!isValueBlank) {
                String[] colsArr = this.resizableColumnsAsString.split(",");
                for (int i = 0; i < colsArr.length; ++i) {
                    String temp = colsArr[i];
                    int sepIndex = temp.lastIndexOf("_");
                    this.resizableColsMap.put(temp.substring(0, sepIndex), temp.substring(sepIndex + 1, temp.length()));
                }
            }
        }
        return this.resizableColsMap;
    }

    public void setResizableColumnsMap(Map<String, String> resizableColsMap) {
        this.resizableColsMap = resizableColsMap;
    }

    public List findOrderedColumns(String columnOrder) {
        FacesContext context = this.getFacesContext();
        ArrayList<Object> orderedColumns = null;
        if (columnOrder != null) {
            orderedColumns = new ArrayList<Object>();
            String[] order = columnOrder.split(",");
            String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
            block0: for (String columnId : order) {
                for (UIComponent child : this.getChildren()) {
                    String columnsClientId;
                    if (child instanceof Column && child.getClientId(context).equals(columnId)) {
                        orderedColumns.add(child);
                        continue block0;
                    }
                    if (!(child instanceof Columns) || !columnId.startsWith(columnsClientId = child.getClientId(context))) continue;
                    String[] ids = columnId.split(separator);
                    int index = Integer.parseInt(ids[ids.length - 1]);
                    orderedColumns.add(new DynamicColumn(index, (Columns)child, columnsClientId + separator + index));
                    continue block0;
                }
            }
        }
        return orderedColumns;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        return LocaleUtils.resolveLocale(this.getDataLocale(), this.getClientId(context));
    }

    private boolean isFilterRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_filtering");
    }

    @Override
    protected List<UIComponent> getIterableChildren() {
        if (this.iterableChildren == null) {
            this.iterableChildren = new ArrayList<UIComponent>();
            for (UIComponent child : this.getChildren()) {
                if (child instanceof ColumnGroup) continue;
                this.iterableChildren.add(child);
            }
        }
        return this.iterableChildren;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        List filteredValue;
        super.processEvent(event);
        if (!this.isLazy() && event instanceof PostRestoreStateEvent && this == event.getComponent() && (filteredValue = this.getFilteredValue()) != null) {
            this.updateValue(filteredValue);
        }
    }

    public void updateFilteredValue(FacesContext context, List<?> value) {
        ValueExpression ve = this.getValueExpression(DataTableBase.PropertyKeys.filteredValue.toString());
        if (ve != null) {
            ve.setValue(context.getELContext(), value);
        } else {
            this.setFilteredValue(value);
        }
    }

    public void updateValue(Object value) {
        Object originalValue = this.getValue();
        if (originalValue instanceof SelectableDataModel) {
            this.setValue(new SelectableDataModelWrapper((SelectableDataModel)originalValue, value));
        } else {
            this.setValue(value);
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this.isFilteringEnabled()) {
            this.setValue(null);
        }
        return super.saveState(context);
    }

    @Override
    protected void preDecode(FacesContext context) {
        this.resetDynamicColumns();
        super.preDecode(context);
    }

    @Override
    protected void preValidate(FacesContext context) {
        this.resetDynamicColumns();
        super.preValidate(context);
    }

    @Override
    protected void preUpdate(FacesContext context) {
        this.resetDynamicColumns();
        super.preUpdate(context);
    }

    @Override
    protected void preEncode(FacesContext context) {
        this.resetDynamicColumns();
        super.preEncode(context);
    }

    private void resetDynamicColumns() {
        Columns dynamicCols = this.getDynamicColumns();
        if (dynamicCols != null && this.isNestedWithinIterator().booleanValue()) {
            dynamicCols.setRowIndex(-1);
            this.setColumns(null);
        }
    }

    public void restoreTableState() {
        TableState ts = this.getTableState(false);
        if (ts != null) {
            if (this.isPaginator()) {
                this.setFirst(ts.getFirst());
                int rows = ts.getRows() == 0 ? this.getRows() : ts.getRows();
                this.setRows(rows);
            }
            this.setMultiSortState(ts.getMultiSortState());
            this.setValueExpression("sortBy", ts.getSortBy());
            this.setSortOrder(ts.getSortOrder());
            this.setSortFunction(ts.getSortFunction());
            this.setSortField(ts.getSortField());
            this.setDefaultSort(false);
            this.setDefaultSortByVE(ts.getDefaultSortBy());
            this.setDefaultSortOrder(ts.getDefaultSortOrder());
            this.setDefaultSortFunction(ts.getDefaultSortFunction());
            if (this.isSelectionEnabled()) {
                this.selectedRowKeys = ts.getRowKeys();
                this.isRowKeyRestored = true;
            }
            this.setFilterBy(ts.getFilters());
            this.setGlobalFilter(ts.getGlobalFilterValue());
            this.setColumns(this.findOrderedColumns(ts.getOrderedColumnsAsString()));
            this.setTogglableColumnsAsString(ts.getTogglableColumnsAsString());
            this.setResizableColumnsAsString(ts.getResizableColumnsAsString());
        }
    }

    public TableState getTableState(boolean create) {
        TableState ts;
        FacesContext fc = this.getFacesContext();
        Map sessionMap = fc.getExternalContext().getSessionMap();
        HashMap<String, TableState> dtState = (HashMap<String, TableState>)sessionMap.get("primefaces.TABLE_STATE");
        String viewId = fc.getViewRoot().getViewId().replaceFirst("^/*", "");
        String stateKey = viewId + "_" + this.getClientId(fc);
        if (dtState == null) {
            dtState = new HashMap<String, TableState>();
            sessionMap.put("primefaces.TABLE_STATE", dtState);
        }
        if ((ts = (TableState)dtState.get(stateKey)) == null && create) {
            ts = new TableState();
            dtState.put(stateKey, ts);
        }
        return ts;
    }

    public String getGroupedColumnIndexes() {
        List<UIColumn> columns = this.getColumns();
        int size = columns.size();
        boolean hasIndex = false;
        if (size > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < size; ++i) {
                UIColumn column = columns.get(i);
                if (!column.isGroupRow()) continue;
                if (hasIndex) {
                    sb.append(",");
                }
                sb.append(i);
                hasIndex = true;
            }
            sb.append("]");
            return sb.toString();
        }
        return null;
    }
}

