/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterFactory;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.expression.SearchExpressionFacade;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression encoding;
    private ValueExpression pageOnly;
    private ValueExpression selectionOnly;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;
    private ValueExpression repeat;
    private ValueExpression options;
    private MethodExpression onTableRender;
    private ValueExpression customExporter;

    public DataExporter() {
    }

    public DataExporter(ValueExpression target, ValueExpression type, ValueExpression fileName, ValueExpression pageOnly, ValueExpression selectionOnly, ValueExpression encoding, MethodExpression preProcessor, MethodExpression postProcessor, ValueExpression options, MethodExpression onTableRender) {
        this.target = target;
        this.type = type;
        this.fileName = fileName;
        this.pageOnly = pageOnly;
        this.selectionOnly = selectionOnly;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.encoding = encoding;
        this.options = options;
        this.onTableRender = onTableRender;
    }

    public void processAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        String tables = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        String encodingType = "UTF-8";
        if (this.encoding != null) {
            encodingType = (String)this.encoding.getValue(elContext);
        }
        boolean repeating = false;
        if (this.repeat != null) {
            repeating = this.repeat.isLiteralText() ? Boolean.parseBoolean(this.repeat.getValue(context.getELContext()).toString()) : (Boolean)this.repeat.getValue(context.getELContext());
        }
        boolean isPageOnly = false;
        if (this.pageOnly != null) {
            isPageOnly = this.pageOnly.isLiteralText() ? Boolean.parseBoolean(this.pageOnly.getValue(context.getELContext()).toString()) : (Boolean)this.pageOnly.getValue(context.getELContext());
        }
        boolean isSelectionOnly = false;
        if (this.selectionOnly != null) {
            isSelectionOnly = this.selectionOnly.isLiteralText() ? Boolean.parseBoolean(this.selectionOnly.getValue(context.getELContext()).toString()) : (Boolean)this.selectionOnly.getValue(context.getELContext());
        }
        ExporterOptions exporterOptions = null;
        if (this.options != null) {
            exporterOptions = (ExporterOptions)this.options.getValue(elContext);
        }
        Object customExporterInstance = null;
        if (this.customExporter != null) {
            customExporterInstance = this.customExporter.getValue(elContext);
        }
        try {
            Exporter exporter = this.getExporter(exportAs, exporterOptions, customExporterInstance);
            if (!repeating) {
                List<UIComponent> components = SearchExpressionFacade.resolveComponents(context, event.getComponent(), tables);
                if (components.size() > 1) {
                    exporter.export(context, outputFileName, components, isPageOnly, isSelectionOnly, encodingType, this.preProcessor, this.postProcessor, exporterOptions, this.onTableRender);
                } else {
                    UIComponent component = components.get(0);
                    if (!(component instanceof DataTable)) {
                        throw new FacesException("Unsupported datasource target:\"" + component.getClass().getName() + "\", exporter must target a PrimeFaces DataTable.");
                    }
                    DataTable table = (DataTable)component;
                    exporter.export(context, table, outputFileName, isPageOnly, isSelectionOnly, encodingType, this.preProcessor, this.postProcessor, exporterOptions, this.onTableRender);
                }
            } else {
                String[] clientIds = tables.split("\\s+|,");
                exporter.export(context, Arrays.asList(clientIds), outputFileName, isPageOnly, isSelectionOnly, encodingType, this.preProcessor, this.postProcessor, exporterOptions, this.onTableRender);
            }
            context.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected Exporter getExporter(String exportAs, ExporterOptions exporterOptions, Object customExporterInstance) {
        if (customExporterInstance == null) {
            return ExporterFactory.getExporterForType(exportAs, exporterOptions);
        }
        if (customExporterInstance instanceof Exporter) {
            return (Exporter)customExporterInstance;
        }
        throw new FacesException("Component " + this.getClass().getName() + " customExporterInstance=" + customExporterInstance.getClass().getName() + " does not extend Exporter!");
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void setRepeat(ValueExpression ve) {
        this.repeat = ve;
    }

    public ValueExpression getCustomExporter() {
        return this.customExporter;
    }

    public void setCustomExporter(ValueExpression customExporter) {
        this.customExporter = customExporter;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.pageOnly = (ValueExpression)values[3];
        this.selectionOnly = (ValueExpression)values[4];
        this.preProcessor = (MethodExpression)values[5];
        this.postProcessor = (MethodExpression)values[6];
        this.encoding = (ValueExpression)values[7];
        this.repeat = (ValueExpression)values[8];
        this.options = (ValueExpression)values[9];
        this.onTableRender = (MethodExpression)values[10];
        this.customExporter = (ValueExpression)values[11];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.type, this.fileName, this.pageOnly, this.selectionOnly, this.preProcessor, this.postProcessor, this.encoding, this.repeat, this.options, this.onTableRender, this.customExporter};
        return values;
    }
}

