/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionListener;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.component.export.DataExporter;

public class DataExporterTagHandler
extends TagHandler {
    private final TagAttribute target = this.getRequiredAttribute("target");
    private final TagAttribute type = this.getRequiredAttribute("type");
    private final TagAttribute fileName = this.getRequiredAttribute("fileName");
    private final TagAttribute pageOnly = this.getAttribute("pageOnly");
    private final TagAttribute selectionOnly = this.getAttribute("selectionOnly");
    private final TagAttribute preProcessor;
    private final TagAttribute postProcessor;
    private final TagAttribute encoding = this.getAttribute("encoding");
    private final TagAttribute repeat;
    private final TagAttribute options;
    private final TagAttribute onTableRender;
    private final TagAttribute customExporter;

    public DataExporterTagHandler(TagConfig tagConfig) {
        super(tagConfig);
        this.preProcessor = this.getAttribute("preProcessor");
        this.postProcessor = this.getAttribute("postProcessor");
        this.repeat = this.getAttribute("repeat");
        this.options = this.getAttribute("options");
        this.onTableRender = this.getAttribute("onTableRender");
        this.customExporter = this.getAttribute("customExporter");
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (ComponentHandler.isNew((UIComponent)parent)) {
            ValueExpression targetVE = this.target.getValueExpression(faceletContext, Object.class);
            ValueExpression typeVE = this.type.getValueExpression(faceletContext, Object.class);
            ValueExpression fileNameVE = this.fileName.getValueExpression(faceletContext, Object.class);
            ValueExpression pageOnlyVE = null;
            ValueExpression selectionOnlyVE = null;
            ValueExpression encodingVE = null;
            MethodExpression preProcessorME = null;
            MethodExpression postProcessorME = null;
            ValueExpression repeatVE = null;
            ValueExpression optionsVE = null;
            MethodExpression onTableRenderME = null;
            ValueExpression customExporterVE = null;
            if (this.encoding != null) {
                encodingVE = this.encoding.getValueExpression(faceletContext, Object.class);
            }
            if (this.pageOnly != null) {
                pageOnlyVE = this.pageOnly.getValueExpression(faceletContext, Object.class);
            }
            if (this.selectionOnly != null) {
                selectionOnlyVE = this.selectionOnly.getValueExpression(faceletContext, Object.class);
            }
            if (this.preProcessor != null) {
                preProcessorME = this.preProcessor.getMethodExpression(faceletContext, null, new Class[]{Object.class});
            }
            if (this.postProcessor != null) {
                postProcessorME = this.postProcessor.getMethodExpression(faceletContext, null, new Class[]{Object.class});
            }
            if (this.repeat != null) {
                repeatVE = this.repeat.getValueExpression(faceletContext, Object.class);
            }
            if (this.options != null) {
                optionsVE = this.options.getValueExpression(faceletContext, Object.class);
            }
            if (this.onTableRender != null) {
                onTableRenderME = this.onTableRender.getMethodExpression(faceletContext, null, new Class[]{Object.class, Object.class});
            }
            if (this.customExporter != null) {
                customExporterVE = this.customExporter.getValueExpression(faceletContext, Object.class);
            }
            ActionSource actionSource = (ActionSource)parent;
            DataExporter dataExporter = new DataExporter(targetVE, typeVE, fileNameVE, pageOnlyVE, selectionOnlyVE, encodingVE, preProcessorME, postProcessorME, optionsVE, onTableRenderME);
            dataExporter.setRepeat(repeatVE);
            dataExporter.setCustomExporter(customExporterVE);
            actionSource.addActionListener((ActionListener)dataExporter);
        }
    }
}

