/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.NativeUploadedFile;
import org.primefaces.model.UploadedFileWrapper;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.virusscan.VirusException;

public class NativeFileUploadDecoder {
    private NativeFileUploadDecoder() {
    }

    public static void decode(FacesContext context, FileUpload fileUpload, String inputToDecodeId) {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        try {
            if (fileUpload.getMode().equals("simple")) {
                NativeFileUploadDecoder.decodeSimple(context, fileUpload, request, inputToDecodeId);
            } else {
                NativeFileUploadDecoder.decodeAdvanced(context, fileUpload, request);
            }
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
        catch (ServletException se) {
            throw new FacesException((Throwable)se);
        }
    }

    private static void decodeSimple(FacesContext context, FileUpload fileUpload, HttpServletRequest request, String inputToDecodeId) throws IOException, ServletException {
        if (fileUpload.isMultiple()) {
            Collection parts = request.getParts();
            ArrayList<Part> uploadedInputParts = new ArrayList<Part>();
            for (Part p : parts) {
                if (!p.getName().equals(inputToDecodeId)) continue;
                uploadedInputParts.add(p);
            }
            if (!uploadedInputParts.isEmpty() && NativeFileUploadDecoder.isValidFile(context, fileUpload, uploadedInputParts)) {
                fileUpload.setSubmittedValue(new UploadedFileWrapper(new NativeUploadedFile(uploadedInputParts, fileUpload)));
            } else {
                fileUpload.setSubmittedValue("");
            }
        } else {
            Part part = request.getPart(inputToDecodeId);
            if (part != null) {
                NativeUploadedFile uploadedFile = new NativeUploadedFile(part, fileUpload);
                if (NativeFileUploadDecoder.isValidFile(context, fileUpload, uploadedFile)) {
                    fileUpload.setSubmittedValue(new UploadedFileWrapper(uploadedFile));
                }
            } else {
                fileUpload.setSubmittedValue("");
            }
        }
    }

    private static void decodeAdvanced(FacesContext context, FileUpload fileUpload, HttpServletRequest request) throws IOException, ServletException {
        NativeUploadedFile uploadedFile;
        String clientId = fileUpload.getClientId(context);
        Part part = request.getPart(clientId);
        if (part != null && NativeFileUploadDecoder.isValidFile(context, fileUpload, uploadedFile = new NativeUploadedFile(part, fileUpload))) {
            fileUpload.queueEvent(new FileUploadEvent((UIComponent)fileUpload, uploadedFile));
        }
    }

    private static boolean isValidFile(FacesContext context, FileUpload fileUpload, NativeUploadedFile uploadedFile) throws IOException {
        boolean valid;
        boolean bl = valid = (fileUpload.getSizeLimit() == null || uploadedFile.getSize() <= fileUpload.getSizeLimit()) && FileUploadUtils.isValidType(fileUpload, uploadedFile.getFileName(), uploadedFile.getInputstream());
        if (valid) {
            try {
                FileUploadUtils.performVirusScan(context, fileUpload, uploadedFile.getInputstream());
            }
            catch (VirusException ex) {
                return false;
            }
        }
        return valid;
    }

    private static boolean isValidFile(FacesContext context, FileUpload fileUpload, List<Part> parts) throws IOException {
        long totalPartSize = 0L;
        for (int i = 0; i < parts.size(); ++i) {
            Part p = parts.get(i);
            totalPartSize += p.getSize();
            NativeUploadedFile uploadedFile = new NativeUploadedFile(p, fileUpload);
            if (!FileUploadUtils.isValidType(fileUpload, uploadedFile.getFileName(), uploadedFile.getInputstream())) {
                return false;
            }
            try {
                FileUploadUtils.performVirusScan(context, fileUpload, uploadedFile.getInputstream());
                continue;
            }
            catch (VirusException ex) {
                return false;
            }
        }
        return fileUpload.getSizeLimit() == null || totalPartSize <= fileUpload.getSizeLimit();
    }
}

