/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.lifecycle;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.primefaces.component.lifecycle.Lifecycle;
import org.primefaces.component.lifecycle.LifecyclePhaseListener;
import org.primefaces.component.lifecycle.PhaseInfo;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class LifecycleRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Lifecycle lifecycle = (Lifecycle)component;
        String clientId = lifecycle.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)lifecycle);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)"ui-lifecycle ui-widget", null);
        writer.startElement("tr", null);
        for (PhaseId phaseId : PhaseId.VALUES) {
            if (phaseId == PhaseId.ANY_PHASE) continue;
            this.encodePhase(phaseId, phaseId.toString(), context, writer);
        }
        this.encodePhase(PhaseId.ANY_PHASE, "ALL", context, writer);
        writer.endElement("tr");
        writer.endElement("table");
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Lifecycle", lifecycle.resolveWidgetVar(), clientId);
        wb.finish();
    }

    protected void encodePhase(PhaseId phaseId, String name, FacesContext context, ResponseWriter writer) throws IOException {
        PhaseInfo phaseInfo = LifecyclePhaseListener.getPhaseInfo(phaseId, context);
        writer.startElement("td", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-lifecycle-name", null);
        writer.write(name);
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)("ui-lifecycle-result ui-lifecycle-score-" + this.getScore(phaseId, phaseInfo.getDuration())), null);
        writer.write(phaseInfo.getDuration() + "ms");
        writer.endElement("div");
        writer.endElement("td");
    }

    protected int getScore(PhaseId phaseId, double duration) {
        if (phaseId == PhaseId.ANY_PHASE) {
            if (duration <= 400.0) {
                return 100;
            }
            if (duration <= 800.0) {
                return 66;
            }
            if (duration <= 1200.0) {
                return 33;
            }
        } else if (phaseId == PhaseId.RESTORE_VIEW || phaseId == PhaseId.RENDER_RESPONSE) {
            if (duration <= 100.0) {
                return 100;
            }
            if (duration <= 200.0) {
                return 66;
            }
            if (duration <= 400.0) {
                return 33;
            }
        } else {
            if (duration <= 50.0) {
                return 100;
            }
            if (duration <= 100.0) {
                return 66;
            }
            if (duration <= 200.0) {
                return 33;
            }
        }
        return 0;
    }
}

