/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.messages.Messages;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.UINotificationRenderer;

public class MessagesRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Messages uiMessages = (Messages)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = uiMessages.getClientId(context);
        boolean globalOnly = uiMessages.isGlobalOnly();
        String containerClass = uiMessages.isShowIcon() ? "ui-messages ui-widget" : "ui-messages ui-messages-noicon ui-widget";
        String style = uiMessages.getStyle();
        String styleClass = uiMessages.getStyleClass();
        styleClass = styleClass == null ? containerClass : containerClass + " " + styleClass;
        HashMap<String, List<FacesMessage>> messagesBySeverity = null;
        List<FacesMessage> messages = this.collectFacesMessages(uiMessages, context);
        if (messages != null && !messages.isEmpty()) {
            messagesBySeverity = new HashMap<String, List<FacesMessage>>(4);
            for (int i = 0; i < messages.size(); ++i) {
                FacesMessage message = messages.get(i);
                FacesMessage.Severity severity = message.getSeverity();
                if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                    this.addMessage(uiMessages, message, messagesBySeverity, "info");
                    continue;
                }
                if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                    this.addMessage(uiMessages, message, messagesBySeverity, "warn");
                    continue;
                }
                if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                    this.addMessage(uiMessages, message, messagesBySeverity, "error");
                    continue;
                }
                if (!severity.equals(FacesMessage.SEVERITY_FATAL)) continue;
                this.addMessage(uiMessages, message, messagesBySeverity, "fatal");
            }
        }
        writer.startElement("div", (UIComponent)uiMessages);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("aria-live", (Object)"polite", null);
        if (PrimeApplicationContext.getCurrentInstance(context).getConfig().isClientSideValidationEnabled()) {
            writer.writeAttribute("data-global", (Object)String.valueOf(globalOnly), null);
            writer.writeAttribute("data-summary", (Object)uiMessages.isShowSummary(), null);
            writer.writeAttribute("data-detail", (Object)uiMessages.isShowDetail(), null);
            writer.writeAttribute("data-severity", (Object)this.getClientSideSeverity(uiMessages.getSeverity()), null);
            writer.writeAttribute("data-redisplay", (Object)String.valueOf(uiMessages.isRedisplay()), null);
        }
        if (messagesBySeverity != null) {
            for (Map.Entry entry : messagesBySeverity.entrySet()) {
                this.encodeMessages(context, uiMessages, (String)entry.getKey(), (List)entry.getValue());
            }
        }
        writer.endElement("div");
    }

    protected void addMessage(Messages uiMessages, FacesMessage message, Map<String, List<FacesMessage>> messagesBySeverity, String severity) {
        if (this.shouldRender(uiMessages, message, severity)) {
            List<FacesMessage> severityMessages = messagesBySeverity.get(severity);
            if (severityMessages == null) {
                severityMessages = new ArrayList<FacesMessage>();
                messagesBySeverity.put(severity, severityMessages);
            }
            severityMessages.add(message);
        }
    }

    protected void encodeMessages(FacesContext context, Messages uiMessages, String severity, List<FacesMessage> messages) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClassPrefix = "ui-messages-" + severity;
        boolean escape = uiMessages.isEscape();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)(styleClassPrefix + " ui-corner-all"), null);
        if (uiMessages.isClosable()) {
            this.encodeCloseIcon(context, uiMessages);
        }
        if (uiMessages.isShowIcon()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(styleClassPrefix + "-icon"), null);
            writer.endElement("span");
        }
        writer.startElement("ul", null);
        for (int i = 0; i < messages.size(); ++i) {
            FacesMessage message = messages.get(i);
            this.encodeMessage(writer, uiMessages, message, styleClassPrefix, escape);
            message.rendered();
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMessage(ResponseWriter writer, Messages uiMessages, FacesMessage message, String styleClassPrefix, boolean escape) throws IOException {
        String detail;
        writer.startElement("li", null);
        writer.writeAttribute("role", (Object)"alert", null);
        writer.writeAttribute("aria-atomic", (Object)"true", null);
        String summary = message.getSummary() != null ? message.getSummary() : "";
        String string = detail = message.getDetail() != null ? message.getDetail() : summary;
        if (uiMessages.isShowSummary()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(styleClassPrefix + "-summary"), null);
            if (escape) {
                writer.writeText((Object)summary, null);
            } else {
                writer.write(summary);
            }
            writer.endElement("span");
        }
        if (uiMessages.isShowDetail()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(styleClassPrefix + "-detail"), null);
            if (escape) {
                writer.writeText((Object)detail, null);
            } else {
                writer.write(detail);
            }
            writer.endElement("span");
        }
        writer.endElement("li");
    }

    protected void encodeCloseIcon(FacesContext context, Messages uiMessages) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-messages-close", null);
        writer.writeAttribute("onclick", (Object)"$(this).parent().slideUp();return false;", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected List<FacesMessage> collectFacesMessages(Messages uiMessages, FacesContext context) {
        ArrayList<FacesMessage> messages;
        block8: {
            Iterator messagesIterator;
            block7: {
                String forComponentClientId;
                UIComponent forComponent;
                messages = null;
                String _for = uiMessages.getFor();
                if (this.isValueBlank(_for)) break block7;
                String forType = uiMessages.getForType();
                if (forType == null || forType.equals("key")) {
                    Iterator messagesIterator2 = context.getMessages(_for);
                    while (messagesIterator2.hasNext()) {
                        if (messages == null) {
                            messages = new ArrayList();
                        }
                        messages.add((FacesMessage)messagesIterator2.next());
                    }
                }
                if (forType != null && !forType.equals("expression") || (forComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)uiMessages, _for, 2)) == null || _for.equals(forComponentClientId = forComponent.getClientId(context))) break block8;
                Iterator messagesIterator3 = context.getMessages(forComponentClientId);
                while (messagesIterator3.hasNext()) {
                    FacesMessage next = (FacesMessage)messagesIterator3.next();
                    if (messages == null) {
                        messages = new ArrayList();
                    }
                    if (messages.contains(next)) continue;
                    messages.add(next);
                }
                break block8;
            }
            Iterator iterator = messagesIterator = uiMessages.isGlobalOnly() ? context.getMessages(null) : context.getMessages();
            while (messagesIterator.hasNext()) {
                if (messages == null) {
                    messages = new ArrayList<FacesMessage>();
                }
                messages.add((FacesMessage)messagesIterator.next());
            }
        }
        return messages;
    }
}

