/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.password;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.password.Password;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class PasswordRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Password password = (Password)component;
        if (!this.shouldDecode((UIInput)password)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)password);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(password.getClientId(context));
        if (submittedValue != null) {
            password.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Password password = (Password)component;
        this.encodeMarkup(context, password);
        this.encodeScript(context, password);
    }

    protected void encodeScript(FacesContext context, Password password) throws IOException {
        String clientId = password.getClientId(context);
        boolean feedback = password.isFeedback();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Password", password.resolveWidgetVar(), clientId);
        if (feedback) {
            wb.attr("feedback", true).attr("inline", password.isInline()).attr("promptLabel", password.getPromptLabel()).attr("weakLabel", password.getWeakLabel()).attr("goodLabel", password.getGoodLabel()).attr("strongLabel", password.getStrongLabel());
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Password password) throws IOException {
        String valueToRender;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = password.getClientId(context);
        boolean disabled = password.isDisabled();
        String inputClass = "ui-inputfield ui-password ui-widget ui-state-default ui-corner-all";
        inputClass = password.isValid() ? inputClass : inputClass + " ui-state-error";
        inputClass = !disabled ? inputClass : inputClass + " ui-state-disabled";
        String styleClass = password.getStyleClass() == null ? inputClass : inputClass + " " + password.getStyleClass();
        writer.startElement("input", (UIComponent)password);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"password", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (password.getStyle() != null) {
            writer.writeAttribute("style", (Object)password.getStyle(), null);
        }
        if (!LangUtils.isValueBlank(valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)password)) && password.isRedisplay()) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)password);
        this.renderPassThruAttributes(context, (UIComponent)password, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)password, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)password);
        writer.endElement("input");
    }
}

