/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.piechart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.component.piechart.PieChart;
import org.primefaces.model.charts.pie.PieChartOptions;
import org.primefaces.util.WidgetBuilder;

public class PieChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PieChart chart = (PieChart)component;
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        String styleClass = chart.getStyleClass();
        this.encodeMarkup(context, clientId, style, styleClass);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, PieChart chart) throws IOException {
        String clientId = chart.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PieChart", chart.resolveWidgetVar(), clientId);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        PieChartOptions pieOptions = (PieChartOptions)options;
        writer.write(",\"options\":{");
        writer.write("\"animation\":{");
        writer.write("\"animateRotate\":" + pieOptions.isAnimateRotate());
        writer.write(",\"animateScale\":" + pieOptions.isAnimateScale());
        writer.write("}");
        if (pieOptions.getCutoutPercentage() != null) {
            writer.write(",\"cutoutPercentage\":" + pieOptions.getCutoutPercentage());
        }
        if (pieOptions.getRotation() != null) {
            writer.write(",\"rotation\":" + pieOptions.getRotation());
        }
        if (pieOptions.getCircumference() != null) {
            writer.write(",\"cutoutPercentage\":" + pieOptions.getCircumference());
        }
        this.encodeElements(context, pieOptions.getElements(), true);
        this.encodeTitle(context, pieOptions.getTitle(), true);
        this.encodeTooltip(context, pieOptions.getTooltip(), true);
        this.encodeLegend(context, pieOptions.getLegend(), true);
        writer.write("}");
    }
}

