/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.schedule;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.schedule.ScheduleBase;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.ScheduleEntryMoveEvent;
import org.primefaces.event.ScheduleEntryResizeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="schedule/schedule.css"), @ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="moment/moment.js"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="schedule/schedule.js")})
public class Schedule
extends ScheduleBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Schedule";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("dateSelect", SelectEvent.class).put("eventSelect", SelectEvent.class).put("eventMove", ScheduleEntryMoveEvent.class).put("eventResize", ScheduleEntryResizeEvent.class).put("viewChange", SelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private Locale appropriateLocale;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    Locale calculateLocale(FacesContext facesContext) {
        if (this.appropriateLocale == null) {
            this.appropriateLocale = LocaleUtils.resolveLocale(this.getLocale(), this.getClientId(facesContext));
        }
        return this.appropriateLocale;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        TimeZone tz = CalendarUtils.calculateTimeZone(this.getTimeZone(), TimeZone.getTimeZone("UTC"));
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            if (eventName.equals("dateSelect")) {
                Long milliseconds = Long.valueOf((String)params.get(clientId + "_selectedDate"));
                Calendar calendar = Calendar.getInstance(tz);
                calendar.setTimeInMillis(milliseconds - (long)tz.getOffset(milliseconds));
                Date selectedDate = calendar.getTime();
                SelectEvent selectEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), selectedDate);
                selectEvent.setPhaseId(behaviorEvent.getPhaseId());
                wrapperEvent = selectEvent;
            } else if (eventName.equals("eventSelect")) {
                String selectedEventId = (String)params.get(clientId + "_selectedEventId");
                ScheduleEvent selectedEvent = this.getValue().getEvent(selectedEventId);
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), selectedEvent);
            } else if (eventName.equals("eventMove")) {
                String movedEventId = (String)params.get(clientId + "_movedEventId");
                ScheduleEvent movedEvent = this.getValue().getEvent(movedEventId);
                int dayDelta = Double.valueOf((String)params.get(clientId + "_dayDelta")).intValue();
                int minuteDelta = Double.valueOf((String)params.get(clientId + "_minuteDelta")).intValue();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(movedEvent.getStartDate());
                calendar.setTimeZone(tz);
                calendar.add(5, dayDelta);
                calendar.add(12, minuteDelta);
                movedEvent.getStartDate().setTime(calendar.getTimeInMillis());
                calendar = Calendar.getInstance();
                calendar.setTime(movedEvent.getEndDate());
                calendar.setTimeZone(tz);
                calendar.add(5, dayDelta);
                calendar.add(12, minuteDelta);
                movedEvent.getEndDate().setTime(calendar.getTimeInMillis());
                wrapperEvent = new ScheduleEntryMoveEvent((UIComponent)this, behaviorEvent.getBehavior(), movedEvent, dayDelta, minuteDelta);
            } else if (eventName.equals("eventResize")) {
                String resizedEventId = (String)params.get(clientId + "_resizedEventId");
                ScheduleEvent resizedEvent = this.getValue().getEvent(resizedEventId);
                int dayDelta = Double.valueOf((String)params.get(clientId + "_dayDelta")).intValue();
                int minuteDelta = Double.valueOf((String)params.get(clientId + "_minuteDelta")).intValue();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(resizedEvent.getEndDate());
                calendar.setTimeZone(tz);
                calendar.add(5, dayDelta);
                calendar.add(12, minuteDelta);
                resizedEvent.getEndDate().setTime(calendar.getTimeInMillis());
                wrapperEvent = new ScheduleEntryResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), resizedEvent, dayDelta, minuteDelta);
            } else if (eventName.equals("viewChange")) {
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getView());
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        ValueExpression expr = this.getValueExpression(ScheduleBase.PropertyKeys.view.toString());
        if (expr != null) {
            expr.setValue(this.getFacesContext().getELContext(), (Object)this.getView());
            this.getStateHelper().remove((Serializable)((Object)ScheduleBase.PropertyKeys.view));
        }
    }
}

