/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.texteditor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.texteditor.TextEditor;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.HtmlSanitizer;
import org.primefaces.util.WidgetBuilder;

public class TextEditorRenderer
extends InputRenderer {
    private static final Logger LOGGER = Logger.getLogger(TextEditorRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        TextEditor editor = (TextEditor)component;
        if (!this.shouldDecode(editor)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)editor);
        String inputParam = editor.getClientId(context) + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(inputParam);
        if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isHtmlSanitizerAvailable()) {
            value = HtmlSanitizer.sanitizeHtml(value, editor.isAllowBlocks(), editor.isAllowFormatting(), editor.isAllowLinks(), editor.isAllowStyles(), editor.isAllowImages());
        } else if (!(editor.isAllowBlocks() && editor.isAllowFormatting() && editor.isAllowLinks() && editor.isAllowStyles() && editor.isAllowImages())) {
            LOGGER.warning("HTML sanitizer not available - skip sanitizing....");
        }
        if (value != null && value.equals("<br/>")) {
            value = "";
        }
        editor.setSubmittedValue(value);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TextEditor editor = (TextEditor)component;
        this.encodeMarkup(facesContext, editor);
        this.encodeScript(facesContext, editor);
    }

    protected void encodeMarkup(FacesContext context, TextEditor editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = editor.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)editor);
        String inputId = clientId + "_input";
        String editorId = clientId + "_editor";
        UIComponent toolbar = editor.getFacet("toolbar");
        String style = editor.getStyle();
        String styleClass = editor.getStyleClass();
        styleClass = styleClass != null ? "ui-texteditor " + styleClass : "ui-texteditor";
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (toolbar != null && editor.isToolbarVisible()) {
            writer.startElement("div", (UIComponent)editor);
            writer.writeAttribute("id", (Object)(clientId + "_toolbar"), null);
            writer.writeAttribute("class", (Object)"ui-editor-toolbar", null);
            toolbar.encodeAll(context);
            writer.endElement("div");
        }
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)editorId, null);
        if (valueToRender != null) {
            writer.write(valueToRender);
        }
        writer.endElement("div");
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)inputId, null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, TextEditor editor) throws IOException {
        String clientId = editor.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TextEditor", editor.resolveWidgetVar(), clientId).attr("toolbarVisible", editor.isToolbarVisible()).attr("readOnly", editor.isReadonly(), false).attr("placeholder", editor.getPlaceholder(), null).attr("height", editor.getHeight(), Integer.MIN_VALUE);
        List formats = editor.getFormats();
        if (formats != null) {
            wb.append(",formats:[");
            for (int i = 0; i < formats.size(); ++i) {
                if (i != 0) {
                    wb.append(",");
                }
                wb.append("\"" + EscapeUtils.forJavaScript((String)formats.get(i)) + "\"");
            }
            wb.append("]");
        }
        this.encodeClientBehaviors(context, editor);
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        TextEditor editor = (TextEditor)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter(context, component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)editor, value);
        }
        return value;
    }
}

