/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.toolbar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.separator.UISeparator;
import org.primefaces.component.toolbar.Toolbar;
import org.primefaces.component.toolbar.ToolbarGroup;
import org.primefaces.renderkit.CoreRenderer;

public class ToolbarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Toolbar toolbar = (Toolbar)component;
        ResponseWriter writer = context.getResponseWriter();
        String style = toolbar.getStyle();
        String styleClass = toolbar.getStyleClass();
        styleClass = styleClass == null ? "ui-toolbar ui-widget ui-widget-header ui-corner-all ui-helper-clearfix" : "ui-toolbar ui-widget ui-widget-header ui-corner-all ui-helper-clearfix " + styleClass;
        writer.startElement("div", (UIComponent)toolbar);
        writer.writeAttribute("id", (Object)toolbar.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"toolbar", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (toolbar.getChildCount() > 0) {
            this.encodeToolbarGroups(context, toolbar);
        } else {
            this.encodeFacet(context, toolbar, "left");
            this.encodeFacet(context, toolbar, "right");
        }
        writer.endElement("div");
    }

    protected void encodeToolbarGroups(FacesContext context, Toolbar toolbar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : toolbar.getChildren()) {
            if (!child.isRendered() || !(child instanceof ToolbarGroup)) continue;
            ToolbarGroup group = (ToolbarGroup)child;
            String defaultGroupClass = "ui-toolbar-group-" + group.getAlign();
            String groupClass = group.getStyleClass();
            String groupStyle = group.getStyle();
            groupClass = groupClass == null ? defaultGroupClass : defaultGroupClass + " " + groupClass;
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)groupClass, null);
            if (groupStyle != null) {
                writer.writeAttribute("style", (Object)groupStyle, null);
            }
            for (UIComponent groupChild : group.getChildren()) {
                if (groupChild instanceof UISeparator && groupChild.isRendered()) {
                    this.encodeSeparator(context, (UISeparator)groupChild);
                    continue;
                }
                groupChild.encodeAll(context);
            }
            writer.endElement("div");
        }
    }

    protected void encodeFacet(FacesContext context, Toolbar toolbar, String facetName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = toolbar.getFacet(facetName);
        if (facet != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)("ui-toolbar-group-" + facetName), null);
            facet.encodeAll(context);
            writer.endElement("div");
        }
    }

    public void encodeSeparator(FacesContext context, UISeparator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator" : "ui-separator " + styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-grip-dotted-vertical", null);
        writer.endElement("span");
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

