/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import org.primefaces.application.resource.DynamicResourcesPhaseListener;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;
import org.primefaces.util.BeanUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.ResourceUtils;

public class PrimePartialResponseWriter
extends PartialResponseWriter {
    private static final Map<String, String> CALLBACK_EXTENSION_PARAMS;
    private final PartialResponseWriter wrapped;
    private boolean metadataRendered = false;

    public PrimePartialResponseWriter(PartialResponseWriter wrapped) {
        super((ResponseWriter)wrapped);
        this.wrapped = wrapped;
    }

    public void endError() throws IOException {
        this.wrapped.endError();
    }

    public void endEval() throws IOException {
        this.wrapped.endEval();
    }

    public void endExtension() throws IOException {
        this.wrapped.endExtension();
    }

    public void endInsert() throws IOException {
        this.wrapped.endInsert();
    }

    public void endUpdate() throws IOException {
        this.wrapped.endUpdate();
    }

    public void endDocument() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        if (requestContext != null) {
            try {
                if (context.isValidationFailed()) {
                    requestContext.getCallbackParams().put("validationFailed", true);
                }
                this.encodeCallbackParams(requestContext.getCallbackParams());
                this.encodeScripts(requestContext);
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
        }
        this.wrapped.endDocument();
    }

    public void startDocument() throws IOException {
        this.wrapped.startDocument();
    }

    public void startError(String errorName) throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.startError(errorName);
    }

    public void startEval() throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.startEval();
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.startExtension(attributes);
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.startInsertAfter(targetId);
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.startInsertBefore(targetId);
    }

    public void startUpdate(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.startUpdate(targetId);
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.updateAttributes(targetId, attributes);
    }

    public void redirect(String url) throws IOException {
        this.wrapped.redirect(url);
    }

    public void delete(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        this.wrapped.delete(targetId);
    }

    public void encodeJSONObject(String paramName, JSONObject jsonObject) throws IOException, JSONException {
        String json = jsonObject.toString();
        json = EscapeUtils.forXml(json);
        this.getWrapped().write("\"");
        this.getWrapped().write(paramName);
        this.getWrapped().write("\":");
        this.getWrapped().write(json);
    }

    public void encodeJSONArray(String paramName, JSONArray jsonArray) throws IOException, JSONException {
        String json = jsonArray.toString();
        json = EscapeUtils.forXml(json);
        this.getWrapped().write("\"");
        this.getWrapped().write(paramName);
        this.getWrapped().write("\":");
        this.getWrapped().write(json);
    }

    public void encodeJSONValue(String paramName, Object paramValue) throws IOException, JSONException {
        String json = new JSONObject().put(paramName, paramValue).toString();
        json = EscapeUtils.forXml(json);
        this.getWrapped().write(json.substring(1, json.length() - 1));
    }

    public void encodeCallbackParams(Map<String, Object> params) throws IOException, JSONException {
        if (params != null && !params.isEmpty()) {
            this.startExtension(CALLBACK_EXTENSION_PARAMS);
            this.getWrapped().write("{");
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String paramName = it.next();
                Object paramValue = params.get(paramName);
                if (paramValue == null) {
                    this.encodeJSONValue(paramName, null);
                } else if (paramValue instanceof JSONObject) {
                    this.encodeJSONObject(paramName, (JSONObject)paramValue);
                } else if (paramValue instanceof JSONArray) {
                    this.encodeJSONArray(paramName, (JSONArray)paramValue);
                } else if (BeanUtils.isBean(paramValue)) {
                    this.encodeJSONObject(paramName, new JSONObject(paramValue));
                } else {
                    this.encodeJSONValue(paramName, paramValue);
                }
                if (!it.hasNext()) continue;
                this.getWrapped().write(",");
            }
            this.getWrapped().write("}");
            this.endExtension();
        }
    }

    protected void encodeScripts(PrimeRequestContext requestContext) throws IOException {
        List<String> scripts = requestContext.getScriptsToExecute();
        if (!scripts.isEmpty()) {
            this.startEval();
            for (int i = 0; i < scripts.size(); ++i) {
                this.getWrapped().write(scripts.get(i));
                this.getWrapped().write(59);
            }
            this.endEval();
        }
    }

    protected void startMetadataIfNecessary() throws IOException {
        if (this.metadataRendered) {
            return;
        }
        this.metadataRendered = true;
        FacesContext context = FacesContext.getCurrentInstance();
        PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
        if (applicationContext != null) {
            try {
                UIViewRoot viewRoot = context.getViewRoot();
                if (viewRoot != null) {
                    String parameterNamespace;
                    if (viewRoot instanceof NamingContainer && (parameterNamespace = viewRoot.getContainerClientId(context)) != null && parameterNamespace.length() > 0) {
                        String parameterPrefix = parameterNamespace;
                        if (applicationContext.getEnvironment().isAtLeastJsf23()) {
                            parameterPrefix = parameterPrefix + UINamingContainer.getSeparatorChar((FacesContext)context);
                        }
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("parameterPrefix", parameterPrefix);
                        this.encodeCallbackParams(params);
                    }
                    if (context.isPostback() && !context.getPartialViewContext().isRenderAll() && !applicationContext.getEnvironment().isAtLeastJsf23()) {
                        List<ResourceUtils.ResourceInfo> initialResources = DynamicResourcesPhaseListener.getInitialResources(context);
                        List<ResourceUtils.ResourceInfo> currentResources = ResourceUtils.getComponentResources(context);
                        if (initialResources != null && currentResources != null && currentResources.size() > initialResources.size()) {
                            ArrayList<ResourceUtils.ResourceInfo> newResources = new ArrayList<ResourceUtils.ResourceInfo>(currentResources);
                            newResources.removeAll(initialResources);
                            boolean updateStarted = false;
                            for (int i = 0; i < newResources.size(); ++i) {
                                ResourceUtils.ResourceInfo resourceInfo = (ResourceUtils.ResourceInfo)newResources.get(i);
                                if (!updateStarted) {
                                    ((PartialResponseWriter)this.getWrapped()).startUpdate("javax.faces.Resource");
                                    updateStarted = true;
                                }
                                resourceInfo.getResource().encodeAll(context);
                            }
                            if (updateStarted) {
                                ((PartialResponseWriter)this.getWrapped()).endUpdate();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
        }
    }

    static {
        HashMap<String, String> callbackExtensionParams = new HashMap<String, String>();
        callbackExtensionParams.put("ln", "primefaces");
        callbackExtensionParams.put("type", "args");
        CALLBACK_EXTENSION_PARAMS = Collections.unmodifiableMap(callbackExtensionParams);
    }
}

