/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.charts.axes.cartesian;

import java.io.IOException;
import java.io.Serializable;
import org.primefaces.model.charts.axes.AxesGridLines;
import org.primefaces.model.charts.axes.cartesian.CartesianScaleLabel;
import org.primefaces.util.ChartUtils;
import org.primefaces.util.FastStringWriter;

public abstract class CartesianAxes
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String position;
    private boolean offset = false;
    private String id;
    private AxesGridLines gridLines;
    private CartesianScaleLabel scaleLabel;
    private boolean stacked;

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public boolean isOffset() {
        return this.offset;
    }

    public void setOffset(boolean offset) {
        this.offset = offset;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AxesGridLines getGridLines() {
        return this.gridLines;
    }

    public void setGridLines(AxesGridLines gridLines) {
        this.gridLines = gridLines;
    }

    public CartesianScaleLabel getScaleLabel() {
        return this.scaleLabel;
    }

    public void setScaleLabel(CartesianScaleLabel scaleLabel) {
        this.scaleLabel = scaleLabel;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public String encode() throws IOException {
        try (FastStringWriter fsw = new FastStringWriter();){
            ChartUtils.writeDataValue(fsw, "offset", this.offset, false);
            ChartUtils.writeDataValue(fsw, "position", this.position, true);
            ChartUtils.writeDataValue(fsw, "id", this.id, true);
            ChartUtils.writeDataValue(fsw, "stacked", this.stacked, true);
            if (this.gridLines != null) {
                fsw.write(",\"gridLines\":" + this.gridLines.encode());
            }
            if (this.scaleLabel != null) {
                fsw.write(",\"scaleLabel\":" + this.scaleLabel.encode());
            }
        }
        return fsw.toString();
    }
}

