/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.shaded.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.primefaces.shaded.owasp.encoder.Encoder;

class JavaScriptEncoder
extends Encoder {
    private final Mode _mode;
    private final boolean _hexEncodeQuotes;
    private final int[] _validMasks;
    private final boolean _asciiOnly;

    JavaScriptEncoder(Mode mode, boolean asciiOnly) {
        this._mode = mode;
        this._validMasks = new int[]{0, -133, -268435457, asciiOnly ? Integer.MAX_VALUE : -1};
        if (mode == Mode.BLOCK || mode == Mode.HTML) {
            this._validMasks[1] = this._validMasks[1] & 0xFFFF5FFF;
        }
        if (mode != Mode.SOURCE) {
            this._validMasks[1] = this._validMasks[1] & 0xFFFFFFBF;
        }
        this._asciiOnly = asciiOnly;
        this._hexEncodeQuotes = mode == Mode.ATTRIBUTE || mode == Mode.HTML;
    }

    int maxEncodedLength(int n) {
        return n * 6;
    }

    int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        int[] validMasks = this._validMasks;
        for (int i = off; i < n; ++i) {
            char ch = input.charAt(i);
            if (!(ch < '\u0080' ? (validMasks[ch >>> 5] & '\u0001' << ch) == 0 : this._asciiOnly || ch == '\u2028' || ch == '\u2029')) continue;
            return i;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        in = input.array();
        out = output.array();
        n = input.arrayOffset() + input.limit();
        j = output.arrayOffset() + output.position();
        m = output.arrayOffset() + output.limit();
        validMasks = this._validMasks;
        block9: for (i = input.arrayOffset() + input.position(); i < n; ++i) {
            block22: {
                block21: {
                    block20: {
                        ch = in[i];
                        if (ch >= '\u0080') break block20;
                        if ((validMasks[ch >>> 5] & '\u0001' << ch) != 0) break block21;
                        break block22;
                    }
                    if (!this._asciiOnly && ch != '\u2028' && ch != '\u2029') break block21;
                    if (ch > '\u00ff') {
                        if (j + 6 > m) {
                            return JavaScriptEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 92;
                        out[j++] = 117;
                        out[j++] = JavaScriptEncoder.HEX[ch >>> 12];
                        out[j++] = JavaScriptEncoder.HEX[ch >>> 8 & 15];
                        out[j++] = JavaScriptEncoder.HEX[ch >>> 4 & 15];
                        out[j++] = JavaScriptEncoder.HEX[ch & 15];
                        continue;
                    }
                    ** GOTO lbl-1000
                }
                if (j >= m) {
                    return JavaScriptEncoder.overflow(input, i, output, j);
                }
                out[j++] = ch;
                continue;
            }
            switch (ch) {
                case '\b': {
                    if (j + 2 > m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 92;
                    out[j++] = 98;
                    continue block9;
                }
                case '\t': {
                    if (j + 2 > m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 92;
                    out[j++] = 116;
                    continue block9;
                }
                case '\n': {
                    if (j + 2 > m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 92;
                    out[j++] = 110;
                    continue block9;
                }
                case '\f': {
                    if (j + 2 > m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 92;
                    out[j++] = 102;
                    continue block9;
                }
                case '\r': {
                    if (j + 2 > m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 92;
                    out[j++] = 114;
                    continue block9;
                }
                case '\"': 
                case '\'': {
                    if (this._hexEncodeQuotes) ** GOTO lbl70
                }
                case '-': 
                case '/': 
                case '\\': {
                    if (j + 2 > m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 92;
                    out[j++] = ch;
                    continue block9;
                }
lbl70:
                // 2 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (j + 4 > m) {
                        return JavaScriptEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 92;
                    out[j++] = 120;
                    out[j++] = JavaScriptEncoder.HEX[ch >>> 4];
                    out[j++] = JavaScriptEncoder.HEX[ch & 15];
                }
            }
        }
        return JavaScriptEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "JavaScriptEncoder(mode=" + (Object)((Object)this._mode) + "," + (this._asciiOnly ? "ASCII" : "UNICODE") + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        SOURCE,
        ATTRIBUTE,
        BLOCK,
        HTML;

    }
}

