/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.Widget;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public class ComponentUtils {
    public static final EnumSet<VisitHint> VISIT_HINTS_SKIP_UNRENDERED = EnumSet.of(VisitHint.SKIP_UNRENDERED);
    public static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private static final String SB_ESCAPE = ComponentUtils.class.getName() + "#escape";
    private static final Object UNDEFINED_VALUE = new Object();

    private ComponentUtils() {
    }

    public static String getValueToRender(FacesContext context, UIComponent component) {
        return ComponentUtils.getValueToRender(context, component, UNDEFINED_VALUE);
    }

    public static String getValueToRender(FacesContext context, UIComponent component, Object value) {
        if (component instanceof ValueHolder) {
            if (component instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)component;
                Object submittedValue = input.getSubmittedValue();
                PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance(context).getConfig();
                if (config.isInterpretEmptyStringAsNull() && submittedValue == null && !input.isLocalValueSet() && context.isValidationFailed() && !input.isValid()) {
                    return null;
                }
                if (submittedValue != null) {
                    return submittedValue.toString();
                }
            }
            ValueHolder valueHolder = (ValueHolder)component;
            if (value == UNDEFINED_VALUE) {
                value = valueHolder.getValue();
            }
            if (value != null) {
                Converter converter = valueHolder.getConverter();
                if (converter == null) {
                    Class<?> valueType = value.getClass();
                    if (valueType == String.class && !PrimeApplicationContext.getCurrentInstance(context).getConfig().isStringConverterAvailable()) {
                        return (String)value;
                    }
                    converter = context.getApplication().createConverter(valueType);
                }
                if (converter != null) {
                    return converter.getAsString(context, component, value);
                }
                return value.toString();
            }
            return null;
        }
        return null;
    }

    public static Converter getConverter(FacesContext context, UIComponent component) {
        if (!(component instanceof ValueHolder)) {
            return null;
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        Class converterType = valueExpression.getType(context.getELContext());
        if (converterType == null || converterType == Object.class) {
            return null;
        }
        if (converterType == String.class && !PrimeApplicationContext.getCurrentInstance(context).getConfig().isStringConverterAvailable()) {
            return null;
        }
        return context.getApplication().createConverter(converterType);
    }

    @Deprecated
    public static String findComponentClientId(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent component = ComponentTraversalUtils.firstWithId(id, (UIComponent)facesContext.getViewRoot());
        return component.getClientId(facesContext);
    }

    public static String escapeSelector(String selector) {
        return selector.replaceAll(":", "\\\\\\\\:");
    }

    @Deprecated
    public static String resolveWidgetVar(String expression) {
        return ComponentUtils.resolveWidgetVar(expression, (UIComponent)FacesContext.getCurrentInstance().getViewRoot());
    }

    @Deprecated
    public static String resolveWidgetVar(String expression, UIComponent component) {
        return SearchExpressionUtils.resolveWidgetVar(expression, component);
    }

    public static boolean isRTL(FacesContext context, RTLAware component) {
        boolean globalValue = PrimeRequestContext.getCurrentInstance(context).isRTL();
        return globalValue || component.isRTL();
    }

    public static void processDecodesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processDecodes(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processDecodes(context);
            }
        }
    }

    public static void processValidatorsOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processValidators(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processValidators(context);
            }
        }
    }

    public static void processUpdatesOfFacetsAndChilds(UIComponent component, FacesContext context) {
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                facet.processUpdates(context);
            }
        }
        if (component.getChildCount() > 0) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.processUpdates(context);
            }
        }
    }

    public static NavigationCase findNavigationCase(FacesContext context, String outcome) {
        ConfigurableNavigationHandler navHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcomeValue = outcome == null ? context.getViewRoot().getViewId() : outcome;
        return navHandler.getNavigationCase(context, null, outcomeValue);
    }

    public static Map<String, List<String>> getUIParams(UIComponent component) {
        LinkedHashMap<String, ArrayList<String>> params = null;
        for (int i = 0; i < component.getChildCount(); ++i) {
            ArrayList<String> paramValues;
            UIParameter uiParam;
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!child.isRendered() || !(child instanceof UIParameter) || (uiParam = (UIParameter)child).isDisable()) continue;
            if (params == null) {
                params = new LinkedHashMap<String, ArrayList<String>>();
            }
            if ((paramValues = (ArrayList<String>)params.get(uiParam.getName())) == null) {
                paramValues = new ArrayList<String>();
                params.put(uiParam.getName(), paramValues);
            }
            paramValues.add(String.valueOf(uiParam.getValue()));
        }
        return params;
    }

    public static boolean isSkipIteration(VisitContext visitContext, FacesContext context) {
        if (PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf21()) {
            return visitContext.getHints().contains(VisitHint.SKIP_ITERATION);
        }
        Boolean skipIterationHint = (Boolean)visitContext.getFacesContext().getAttributes().get(SKIP_ITERATION_HINT);
        return skipIterationHint != null && skipIterationHint == true;
    }

    public static String resolveWidgetVar(FacesContext context, Widget widget) {
        UIComponent component = (UIComponent)widget;
        String userWidgetVar = (String)component.getAttributes().get("widgetVar");
        if (!LangUtils.isValueBlank(userWidgetVar)) {
            return userWidgetVar;
        }
        return "widget_" + component.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    @Deprecated
    public static String escapeText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = SharedStringBuilder.get(SB_ESCAPE);
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static String escapeEcmaScriptText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = SharedStringBuilder.get(SB_ESCAPE);
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                case '/': {
                    sb.append("\\/");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static String escapeXml(String string) {
        StringBuilder sb = SharedStringBuilder.get(SB_ESCAPE, string.length());
        int length = string.length();
        block6: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static UIComponent findParentForm(FacesContext context, UIComponent component) {
        return ComponentTraversalUtils.closestForm(context, component);
    }

    public static TimeZone resolveTimeZone(Object timeZone) {
        if (timeZone instanceof String) {
            return TimeZone.getTimeZone((String)timeZone);
        }
        if (timeZone instanceof TimeZone) {
            return (TimeZone)timeZone;
        }
        return TimeZone.getDefault();
    }

    public static <T extends Renderer> T getUnwrappedRenderer(FacesContext context, String family, String rendererType, Class<T> rendererClass) {
        Renderer renderer = context.getRenderKit().getRenderer(family, rendererType);
        while (renderer instanceof FacesWrapper) {
            renderer = (Renderer)((FacesWrapper)renderer).getWrapped();
        }
        return (T)renderer;
    }

    public static String calculateViewId(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestServletPath();
        }
        return viewId;
    }

    public static String encodeURI(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
    }

    public static String createContentDisposition(String value, String filename) {
        try {
            return String.format("%s;filename=\"%2$s\"; filename*=UTF-8''%2$s", value, ComponentUtils.encodeURI(filename));
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static boolean isRequestSource(UIComponent component, FacesContext context) {
        return component.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public static boolean shouldRenderFacet(UIComponent facet) {
        if (facet == null || !facet.isRendered()) {
            return false;
        }
        if (facet.getChildren().isEmpty()) {
            return true;
        }
        return ComponentUtils.shouldRenderChildren(facet);
    }

    public static boolean shouldRenderChildren(UIComponent component) {
        for (int i = 0; i < component.getChildren().size(); ++i) {
            if (!((UIComponent)component.getChildren().get(i)).isRendered()) continue;
            return true;
        }
        return false;
    }
}

