/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import org.primefaces.util.LangUtils;

public class MessageFactory {
    private static final String DEFAULT_BUNDLE_BASENAME = "javax.faces.Messages";
    private static final String PRIMEFACES_BUNDLE_BASENAME = "org.primefaces.Messages";
    private static final String DEFAULT_DETAIL_SUFFIX = "_detail";

    private MessageFactory() {
    }

    public static FacesMessage getMessage(String messageId, FacesMessage.Severity severity, Object[] params) {
        FacesMessage facesMessage = MessageFactory.getMessage(MessageFactory.getLocale(), messageId, params);
        facesMessage.setSeverity(severity);
        return facesMessage;
    }

    public static FacesMessage getMessage(Locale locale, String messageId, Object[] params) {
        String summary = null;
        String detail = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String userBundleName = application.getMessageBundle();
        ResourceBundle bundle = null;
        ClassLoader currentClassLoader = LangUtils.getCurrentClassLoader(application.getClass());
        if (userBundleName != null) {
            try {
                bundle = MessageFactory.getBundle(userBundleName, locale, currentClassLoader, facesContext);
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(PRIMEFACES_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(DEFAULT_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        summary = MessageFactory.getFormattedText(locale, summary, params);
        try {
            detail = MessageFactory.getFormattedText(locale, bundle.getString(messageId + DEFAULT_DETAIL_SUFFIX), params);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    public static String getMessage(String messageId, Object[] params) {
        FacesMessage message = MessageFactory.getMessage(MessageFactory.getLocale(), messageId, params);
        return message.getSummary();
    }

    public static String getFormattedText(Locale locale, String message, Object[] params) {
        MessageFormat messageFormat = null;
        if (params == null || message == null) {
            return message;
        }
        messageFormat = locale != null ? new MessageFormat(message, locale) : new MessageFormat(message);
        return messageFormat.format(params);
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label == null) {
            label = component.getClientId(facesContext);
        }
        return label;
    }

    protected static Locale getLocale() {
        Locale locale = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getViewRoot() != null) {
            locale = facesContext.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader, FacesContext facesContext) {
        ClassLoader jsfImplClassLoader;
        if (PRIMEFACES_BUNDLE_BASENAME.equals(baseName)) {
            ClassLoader primeFacesClassLoader = MessageFactory.class.getClassLoader();
            if (!primeFacesClassLoader.equals(classLoader)) {
                return ResourceBundle.getBundle(baseName, locale, classLoader, new OSGiFriendlyControl(primeFacesClassLoader));
            }
        } else if (DEFAULT_BUNDLE_BASENAME.equals(baseName) && !(jsfImplClassLoader = MessageFactory.getJSFImplClassLoader(facesContext)).equals(classLoader)) {
            return ResourceBundle.getBundle(baseName, locale, classLoader, new OSGiFriendlyControl(jsfImplClassLoader));
        }
        return ResourceBundle.getBundle(baseName, locale, classLoader);
    }

    private static ClassLoader getJSFImplClassLoader(FacesContext facesContext) {
        Class facesContextImplClass = FacesContext.class;
        if ((facesContext = MessageFactory.getWrappedFacesContextImpl(facesContext)) != null) {
            facesContextImplClass = facesContext.getClass();
        }
        return facesContextImplClass.getClassLoader();
    }

    private static FacesContext getWrappedFacesContextImpl(FacesContext facesContext) {
        if (facesContext == null || !(facesContext instanceof FacesContextWrapper)) {
            return facesContext;
        }
        FacesContextWrapper facesContextWrapper = (FacesContextWrapper)facesContext;
        FacesContext wrappedFacesContext = facesContextWrapper.getWrapped();
        if (wrappedFacesContext == null || FacesContext.class.equals(wrappedFacesContext.getClass())) {
            return facesContext;
        }
        return MessageFactory.getWrappedFacesContextImpl(wrappedFacesContext);
    }

    private static final class OSGiFriendlyControl
    extends ResourceBundle.Control {
        private final ClassLoader osgiBundleClassLoader;

        public OSGiFriendlyControl(ClassLoader osgiBundleClassLoader) {
            this.osgiBundleClassLoader = osgiBundleClassLoader;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            ResourceBundle resourceBundle = super.newBundle(baseName, locale, format, classLoader, reload);
            if (resourceBundle == null && !this.osgiBundleClassLoader.equals(classLoader)) {
                resourceBundle = super.newBundle(baseName, locale, format, this.osgiBundleClassLoader, reload);
            }
            return resourceBundle;
        }
    }
}

