/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.primefaces.util.LangUtils;

public class ResourceUtils {
    public static final String RENDERER_SCRIPT = "javax.faces.resource.Script";
    public static final String RENDERER_STYLESHEET = "javax.faces.resource.Stylesheet";

    private ResourceUtils() {
    }

    public static String getResourceURL(FacesContext context, String value) {
        if (LangUtils.isValueBlank(value)) {
            return "";
        }
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(url);
    }

    public static String getResourceRequestPath(FacesContext context, String resourceName) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceName, "primefaces");
        return resource.getRequestPath();
    }

    public static void addComponentResource(FacesContext context, String name, String library, String target) {
        Application application = context.getApplication();
        UIComponent componentResource = application.createComponent("javax.faces.Output");
        componentResource.setRendererType(application.getResourceHandler().getRendererTypeForResourceName(name));
        componentResource.getAttributes().put("name", name);
        componentResource.getAttributes().put("library", library);
        componentResource.getAttributes().put("target", target);
        context.getViewRoot().addComponentResource(context, componentResource, target);
    }

    public static void addComponentResource(FacesContext context, String name, String library) {
        ResourceUtils.addComponentResource(context, name, library, "head");
    }

    public static void addComponentResource(FacesContext context, String name) {
        ResourceUtils.addComponentResource(context, name, "primefaces", "head");
    }

    public static boolean isScript(UIComponent component) {
        return RENDERER_SCRIPT.equals(component.getRendererType());
    }

    public static boolean isStylesheet(UIComponent component) {
        return RENDERER_STYLESHEET.equals(component.getRendererType());
    }

    public static List<ResourceInfo> getComponentResources(FacesContext context) {
        ArrayList<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();
        List resources = context.getViewRoot().getComponentResources(context, "head");
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                UIComponent resource = (UIComponent)resources.get(i);
                ResourceInfo resourceInfo = ResourceUtils.newResourceInfo(resource);
                if (resourceInfo == null || resourceInfos.contains(resourceInfo)) continue;
                resourceInfos.add(resourceInfo);
            }
        }
        return resourceInfos;
    }

    public static boolean isInline(ResourceInfo resourceInfo) {
        if (resourceInfo != null) {
            return LangUtils.isValueBlank(resourceInfo.getLibrary()) && LangUtils.isValueBlank(resourceInfo.getName());
        }
        return false;
    }

    public static ResourceInfo newResourceInfo(UIComponent component) {
        if (!(component instanceof UIOutput)) {
            return null;
        }
        String library = (String)component.getAttributes().get("library");
        String name = (String)component.getAttributes().get("name");
        return new ResourceInfo(library, name, component);
    }

    public static Resource newResource(ResourceInfo resourceInfo, FacesContext context) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceInfo.getName(), resourceInfo.getLibrary());
        if (resource == null) {
            throw new FacesException("Resource '" + resourceInfo.getName() + "' in library '" + resourceInfo.getLibrary() + "' not found!");
        }
        return resource;
    }

    public static class ResourceInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String library;
        private String name;
        private UIComponent resource;

        public ResourceInfo(String library, String name, UIComponent resource) {
            this.library = library;
            this.name = name;
            this.resource = resource;
        }

        public String getLibrary() {
            return this.library;
        }

        public void setLibrary(String library) {
            this.library = library;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UIComponent getResource() {
            return this.resource;
        }

        public void setResource(UIComponent resource) {
            this.resource = resource;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.library != null ? this.library.hashCode() : 0);
            hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceInfo other = (ResourceInfo)obj;
            if (this.library == null ? other.library != null : !this.library.equals(other.library)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

