package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

/**
 * Un objeto de tipo ItemEnviaFacturaDTO representa cada uno de los posibles registros detalle para notificar Factura en SAP
 * Este objeto pertenece al mbito DDA.
 */
public class ItemEnviaFacturaDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String posicion;
	private String pedido;
	private String impuesto;
	private String posicionPO;
	private String importe;
	private String cantidad;
	private String isoMedida;
    
	public String getPosicion() {
		return posicion;
	}

	public void setPosicion(String posicion) {
		this.posicion = posicion;
	}

	public String getPedido() {
		return pedido;
	}

	public void setPedido(String pedido) {
		this.pedido = pedido;
	}

	public String getImpuesto() {
		return impuesto;
	}

	public void setImpuesto(String impuesto) {
		this.impuesto = impuesto;
	}

	public String getPosicionPO() {
		return posicionPO;
	}

	public void setPosicionPO(String posicionPO) {
		this.posicionPO = posicionPO;
	}

	public String getImporte() {
		return importe;
	}

	public void setImporte(String importe) {
		this.importe = importe;
	}

	public String getCantidad() {
		return cantidad;
	}

	public void setCantidad(String cantidad) {
		this.cantidad = cantidad;
	}

	public String getIsoMedida() {
		return isoMedida;
	}

	public void setIsoMedida(String isoMedida) {
		this.isoMedida = isoMedida;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" posicion: _" + this.getPosicion() + "_" + NEW_LINE);
		result.append(" pedido: _" + this.getPedido() + "_" + NEW_LINE);
		result.append(" impuesto: _" + this.getImpuesto() + "_" + NEW_LINE);
		result.append(" posicionPO: _" + this.getPosicionPO() + "_" + NEW_LINE);
		result.append(" importe: _" + this.getImporte() + "_" + NEW_LINE);
		result.append(" cantidad: _" + this.getCantidad() + "_" + NEW_LINE);
		result.append(" isoMedida: _" + this.getIsoMedida() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
