package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;


/**
 * Representa los parametros para notificar Entrada de Mercancia en SAP  enviados desde el front-end, mismos que son 
 * recibidos por este cliente. Esta clase pertenece al ambito de DDA.
 * Los nombres de cada uno de los argumentos fueron tomados del Excel de inventario de interfaces. 
 *
 */
public class ParamEntradaMercanciaDTO implements Serializable
{
	private static final long serialVersionUID = 1L;
	private String fechaContabilidad;
	private String fechaDocto;
	private String numeroPO;
	private String texto;
	private String actividad;
	private List<ItemEntradaMercanciaDTO> items;
	
	public String getFechaContabilidad() {
		return fechaContabilidad;
	}

	public void setFechaContabilidad(String fechaContabilidad) {
		this.fechaContabilidad = fechaContabilidad;
	}

	public String getFechaDocto() {
		return fechaDocto;
	}

	public void setFechaDocto(String fechaDocto) {
		this.fechaDocto = fechaDocto;
	}

	public String getNumeroPO() {
		return numeroPO;
	}

	public void setNumeroPO(String numeroPO) {
		this.numeroPO = numeroPO;
	}

	public String getTexto() {
		return texto;
	}

	public void setTexto(String texto) {
		this.texto = texto;
	}

	public String getActividad() {
		return actividad;
	}

	public void setActividad(String actividad) {
		this.actividad = actividad;
	}

	public List<ItemEntradaMercanciaDTO> getItems() {
		return items;
	}

	public void setItems(List<ItemEntradaMercanciaDTO> items) {
		this.items = items;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" fechaContabilidad: _" + this.getFechaContabilidad() + "_" + NEW_LINE);
		result.append(" fechaDocto: _" + this.getFechaDocto() + "_" + NEW_LINE);
		result.append(" numeroPO: _" + this.getNumeroPO() + "_" + NEW_LINE);
		result.append(" texto: _" + this.getTexto() + "_" + NEW_LINE);
		result.append(" actividad: _" + this.getActividad() + "_" + NEW_LINE);
		result.append(" items: _" + this.getItems().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
