package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;


/**
 * Representa los parametros para notificar Factura en SAP  enviados desde el front-end, mismos que son 
 * recibidos por este cliente. Esta clase pertenece al ambito de DDA.
 * Los nombres de cada uno de los argumentos fueron tomados del Excel de inventario de interfaces. 
 *
 */
public class ParamEnviaFacturaDTO implements Serializable
{
	private static final long serialVersionUID = 1L;
	private String sociedad;
	private String referencia;
	private String indicador;
	private String tipoDoc;
	private String fechaContabilizacion;
	private String fechaFactura;
	private String moneda;
	private String texto;
	private String monto;
	private List<ItemEnviaFacturaDTO> items;
	
	public String getSociedad() {
		return sociedad;
	}

	public void setSociedad(String sociedad) {
		this.sociedad = sociedad;
	}

	public String getReferencia() {
		return referencia;
	}

	public void setReferencia(String referencia) {
		this.referencia = referencia;
	}

	public String getIndicador() {
		return indicador;
	}

	public void setIndicador(String indicador) {
		this.indicador = indicador;
	}

	public String getTipoDoc() {
		return tipoDoc;
	}

	public void setTipoDoc(String tipoDoc) {
		this.tipoDoc = tipoDoc;
	}

	public String getFechaContabilizacion() {
		return fechaContabilizacion;
	}

	public void setFechaContabilizacion(String fechaContabilizacion) {
		this.fechaContabilizacion = fechaContabilizacion;
	}

	public String getFechaFactura() {
		return fechaFactura;
	}

	public void setFechaFactura(String fechaFactura) {
		this.fechaFactura = fechaFactura;
	}

	public String getMoneda() {
		return moneda;
	}

	public void setMoneda(String moneda) {
		this.moneda = moneda;
	}

	public String getTexto() {
		return texto;
	}

	public void setTexto(String texto) {
		this.texto = texto;
	}

	public String getMonto() {
		return monto;
	}

	public void setMonto(String monto) {
		this.monto = monto;
	}

	public List<ItemEnviaFacturaDTO> getItems() {
		return items;
	}

	public void setItems(List<ItemEnviaFacturaDTO> items) {
		this.items = items;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" sociedad: _" + this.getSociedad() + "_" + NEW_LINE);
		result.append(" referencia: _" + this.getReferencia() + "_" + NEW_LINE);
		result.append(" indicador: _" + this.getIndicador() + "_" + NEW_LINE);
		result.append(" tipoDoc: _" + this.getTipoDoc() + "_" + NEW_LINE);
		result.append(" fechaContabilizacion: _" + this.getFechaContabilizacion() + "_" + NEW_LINE);
		result.append(" fechaFactura: _" + this.getFechaFactura() + "_" + NEW_LINE);
		result.append(" moneda: _" + this.getMoneda() + "_" + NEW_LINE);
		result.append(" texto: _" + this.getTexto() + "_" + NEW_LINE);
		result.append(" monto: _" + this.getMonto() + "_" + NEW_LINE);
		result.append(" items: _" + this.getItems().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
