package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

/**
 * Representa los parametros que se deben pasar al proceso de Manejo de Titulos, Actualizacion de Contratos.
 * Los campos que usa son:
 * <br>
 * idContrato: Es el id (interno) del Contrato.
 * <br>
 * expediente: Es el expediente del usuario.
 * <br>
 * idSAPContrato: Es el id SAP del contrato en cuestion.
 * <br>
 * proveedor: Es el id del proveedor relacionado al contrato
 * <br>
 * fechaInicio: Para este caso sera el contenido del campo Fecha de Autorizacion
 * <br>
 * fechaContabilizacion: Para este caso sera el contenido del campo Fecha de Autorizacion
 */
public class ParamManejoTitulosDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String idContrato;
	private String expediente;
	private String idSAPContrato;
	private String proveedor;
	
	public String getIdContrato() {
		return idContrato;
	}
	public void setIdContrato(String idContrato) {
		this.idContrato = idContrato;
	}
	public String getExpediente() {
		return expediente;
	}
	public void setExpediente(String expediente) {
		this.expediente = expediente;
	}
	public String getIdSAPContrato() {
		return idSAPContrato;
	}
	public void setIdSAPContrato(String idSAPContrato) {
		this.idSAPContrato = idSAPContrato;
	}
	public String getProveedor() {
		return proveedor;
	}
	public void setProveedor(String proveedor) {
		this.proveedor = proveedor;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" idContrato: _" + this.getIdContrato() + "_" + NEW_LINE);
		result.append(" expediente: _" + this.getExpediente() + "_" + NEW_LINE);
		result.append(" idSAPContrato: _" + this.getIdSAPContrato() + "_" + NEW_LINE);
		result.append(" proveedor: _" + this.getProveedor() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
}
