/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.stream.StreamingPayload;

class StreamingOMDataSource
implements OMDataSource {
    private final StreamingPayload payload;

    StreamingOMDataSource(StreamingPayload payload) {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        this.payload = payload;
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter streamWriter = format != null && StringUtils.hasLength((String)format.getCharSetEncoding()) ? StAXUtils.createXMLStreamWriter((OutputStream)output, (String)format.getCharSetEncoding()) : StAXUtils.createXMLStreamWriter((OutputStream)output);
        this.serialize(streamWriter);
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter streamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        this.serialize(streamWriter);
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.payload.writeTo(xmlWriter);
        xmlWriter.flush();
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serialize(bos, null);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return StAXUtils.createXMLStreamReader((InputStream)bis);
    }
}

