package mx.com.amx.mx.dda.ws.bo;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import mx.com.amx.mx.dda.ws.dao.ProcesoDAO;
import mx.com.amx.mx.dda.ws.dto.AmortizacionDTO;
import mx.com.amx.mx.dda.ws.dto.CalculoCostoDTO;
import mx.com.amx.mx.dda.ws.dto.CargaIdBVDetalleDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalAibvDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalPNDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalTRDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalVSDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosPNExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosTRExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosVSExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTransaccionDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoDTO;
import mx.com.amx.mx.dda.ws.dto.QryMontosPresupuestoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ParamActualizaIdBVDTO;
import mx.com.amx.mx.dda.ws.dto.ParamPresupuestoDTO;
import mx.com.amx.mx.dda.ws.dto.ParamAnnioVigenteDTO;
import mx.com.amx.mx.dda.ws.dto.ParamArchivoSqlLdrDTO;
import mx.com.amx.mx.dda.ws.dto.ParamAsocTitTransCntVigentesDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCalcAmortCntDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCalculoCostoSuscriptoresDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosLFDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosPNDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosTRDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosVSDTO;
import mx.com.amx.mx.dda.ws.dto.ParamGeneraReporteDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerCostoAnualDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerSuscriptoresDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamRegAmortizaBorrarDTO;
import mx.com.amx.mx.dda.ws.dto.ParamSP_CargaTitulosPNDTO;
import mx.com.amx.mx.dda.ws.dto.ParamSuscriptoresContrato;
import mx.com.amx.mx.dda.ws.dto.ParamValidaMinimoSeleccionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValidaPresupuestoCntDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValorTituloDTO;
import mx.com.amx.mx.dda.ws.dto.QryCostoCntPorAnnioDTO;
import mx.com.amx.mx.dda.ws.dto.QryEmpresasContratoDTO;
import mx.com.amx.mx.dda.ws.dto.QryTipoPagoDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseActualizaIdBVDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseAnnioVigenteDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseAsociarTitTransCntVigentesDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCalcAmortCntDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCalculoCostoSuscriptoresDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosLFDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosPNDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosTRDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosVSDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseGeneraReporteDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseSuscriptoresContratoDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseValidaMinimoSeleccionDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseValidaPresupuestoCntDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseValorTituloDTO;
import mx.com.amx.mx.dda.ws.utils.DateManager;
import mx.com.amx.mx.dda.ws.utils.ExcelReader;
import mx.com.amx.mx.dda.ws.utils.FileManager;
import mx.com.amx.mx.dda.ws.utils.ShellManager;

@Component
@Qualifier("procesoBO")
public class ProcesoBO {
    // --------------------------------- Fields -----------------------------------

    private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
    private final String ARCHIVO_PROPIEDADES = "/general.properties";
    Properties env = new Properties();
    ParamObtenerSuscriptoresDTO pSuscriptores = new ParamObtenerSuscriptoresDTO();
    FileManager fileManager = new FileManager();
    DateManager dateManager = new DateManager();
    ShellManager shellManager = new ShellManager();

    @Autowired
    private ProcesoDAO procesoDAO;

    private String AMBIENTE;
    private String TIPO_PAGO_ESCALA;
    private String TIPO_PAGO_FLAT;
    private String CVE_TIPO_PROM_12MESES;
    private String CVE_TIPO_PROM_INIFIN;
    private String CVE_TIPO_PROM_MES_ANT;
    private String CVE_TIPO_MES_ACTUAL;
    private String TIPO_CALCULO_SUSCRIPCION;
    private String ORIGEN_REAL;
    private String ORIGEN_ESPEJO;
    private String TIPO_AMORTIZACION_EXCLUSIVIDAD;
    private String TIPO_AMORTIZACION_LINEAL;
    private String TIPO_ANNIO_CALENDARIO;
    private String TIPO_ANNIO_CONTRACTUAL;
    private String RUTA_BASE;
    private String DIR_EXCEL;
    private String DIR_DATA;
    private String DIR_SHELLS;
    private String SHELL_CARGA_TITULOS;
    private String SHELL_AMORTIZACION;
    private String SHELL_ACTUALIZA_IDBV;
    private String SHELL_PROCESA_REPORTES;
    private String SHELL_PROCESA_REPORTESCR;
    private String SHELL_EJECUTOR;
    private String SHELL_CARGA_TITULOSLF;
    private String SHELL_CARGA_TITULOSTR;
    private String SHELL_CARGA_TITULOSPN;
    private String SHELL_CARGA_TITULOSVS;
    private String MODULO_AMORTIZACION;
    private String MODULO_PRESUPUESTO;
    private String NOMBRE_ARCHIVOS_AMORTIZACION;
    private String PROCESO_CARGATITULOS;
    private String PROCESO_AMORTIZACION_CONTRATO;
    private String PROCESO_ACTUALIZA_IDBV;
    private String PROCESO_REPORTES;
    private String PROCESO_CARGATITULOS_LF;
    private String PROCESO_CARGATITULOS_TR;
    private String PROCESO_CARGATITULOS_PN;
    private String PROCESO_CARGATITULOSVS;
    private String U;
    private String P;
    private String INSTANCIA;

    public ProcesoBO() {
        super();
        try {
            env.load(this.getClass().getResourceAsStream(ARCHIVO_PROPIEDADES));
            AMBIENTE = env.getProperty("ambiente");
            TIPO_PAGO_ESCALA = env.getProperty("tipo.pago.escala");
            TIPO_PAGO_FLAT = env.getProperty("tipo.pago.flat");
            CVE_TIPO_PROM_12MESES = env.getProperty("cve.tipo.prom.12");
            CVE_TIPO_PROM_INIFIN = env.getProperty("cve.tipo.prom.inifin");
            CVE_TIPO_PROM_MES_ANT = env.getProperty("cve.tipo.prom.mes.anterior");
            CVE_TIPO_MES_ACTUAL = env.getProperty("cve.tipo.mes.actual");
            TIPO_CALCULO_SUSCRIPCION = env.getProperty("tipo.calculo.suscripcion");
            ORIGEN_REAL = env.getProperty("origen.real");
            ORIGEN_ESPEJO = env.getProperty("origen.espejo");
            TIPO_AMORTIZACION_EXCLUSIVIDAD = env.getProperty("tipo.amortizacion.exclusividad");
            TIPO_AMORTIZACION_LINEAL = env.getProperty("tipo.amortizacion.lineal");
            TIPO_ANNIO_CALENDARIO = env.getProperty("tipo.annio.calendario");
            TIPO_ANNIO_CONTRACTUAL = env.getProperty("tipo.annio.contractual");
            RUTA_BASE = env.getProperty(AMBIENTE + ".ruta.base");
            DIR_EXCEL = env.getProperty("dir.excel");
            DIR_DATA = env.getProperty("dir.data");
            DIR_SHELLS = env.getProperty("dir.shells");
            SHELL_CARGA_TITULOS = env.getProperty("shell.carga.titulos");
            SHELL_AMORTIZACION = env.getProperty("shell.carga.amortizacion");
            SHELL_ACTUALIZA_IDBV = env.getProperty("shell.actualiza.idbv");
            SHELL_PROCESA_REPORTES = env.getProperty("shell.procesa.reportes");
            SHELL_PROCESA_REPORTESCR = env.getProperty("shell.procesa.reportes.cr");
            SHELL_EJECUTOR = env.getProperty("shell.ejecutor");
            SHELL_CARGA_TITULOSLF = env.getProperty("shell.carga.tituloslf");
            SHELL_CARGA_TITULOSTR = env.getProperty("shell.carga.titulostr");
            SHELL_CARGA_TITULOSPN = env.getProperty("shell.carga.titulospn");
            SHELL_CARGA_TITULOSVS = env.getProperty("shell.carga.titulosvs");
            MODULO_AMORTIZACION = env.getProperty("modulo.amortizacion");
            MODULO_PRESUPUESTO = env.getProperty("modulo.presupuesto");
            NOMBRE_ARCHIVOS_AMORTIZACION = env.getProperty("nombre.archivo.amortizacion");
            PROCESO_CARGATITULOS = env.getProperty("proceso.cargaTitulos");
            PROCESO_AMORTIZACION_CONTRATO = env.getProperty("proceso.amortizacion.contrato");
            PROCESO_ACTUALIZA_IDBV = env.getProperty("proceso.actualizacion.idbv");
            PROCESO_REPORTES = env.getProperty("proceso.reportes");
            PROCESO_CARGATITULOS_LF = env.getProperty("proceso.cargaTitulosLF");
            PROCESO_CARGATITULOS_TR = env.getProperty("proceso.cargaTitulosTR");
            PROCESO_CARGATITULOS_PN = env.getProperty("proceso.cargaTitulosPN");
            PROCESO_CARGATITULOSVS = env.getProperty("proceso.cargaTitulosVS");
            U = env.getProperty(AMBIENTE + ".bdu");
            P = env.getProperty(AMBIENTE + ".bdp");
            INSTANCIA = env.getProperty(AMBIENTE + ".bd.instancia");

        } catch (Exception e) {
            LOG.error(">Constructor[" + this.getClass().getSimpleName() + "] Ocurrio un error : " + e.getMessage());
        }
    }

    public ResponseCalculoCostoSuscriptoresDTO calcularCostoSuscriptores(ParamCalculoCostoSuscriptoresDTO dto) throws Exception {
        ResponseCalculoCostoSuscriptoresDTO resultado = new ResponseCalculoCostoSuscriptoresDTO();

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::calcularCostoSuscriptores] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());
        try {
            String lstFechaMes = (dto.getFechaMes() != null && dto.getFechaMes().trim().length() > 0) ? dto.getFechaMes() : "";

            // --Limpieza de registros previos de Costos para el mes proporcionado
            LOG.info("    [INI]. Limpieza de registros previos de Costos para el mes [" + lstFechaMes + "].");
            boolean lboLimpia = this.limpiaRegistrosPrevios(lstFechaMes);
            LOG.info("    [FIN]. Limpieza de registros previos de Costos para el mes [" + lstFechaMes + "]. Resultado: _" + lboLimpia + "_");

            if (lboLimpia) {
                // -- Obtener contratos Suscripcion mas actuales con base en el mes proporcionado
                LOG.info("    [INI]. Obtener contratos suscripcion.");
                // --REAL CODE
                List<ContratoDTO> lobContratosSuscripcion = procesoDAO.obtenerContratosSuscripcion(lstFechaMes);

                // --TEST
                // 1.
                // List<ContratoDTO> lobContratosSuscripcionLF = new ArrayList<ContratoDTO>();
                LOG.info("    [FIN]. Obtener contratos suscripcion. Contratos Encontrados:_" + lobContratosSuscripcion.size() + "_");

                if (lobContratosSuscripcion.size() > 0) {
                    // --Recorrer los contratos obtenidos
                    int lnuContratosObtenidos = lobContratosSuscripcion.size();

                    LOG.info("    [INI]. Inicia recorrido de los Contratos Obtenidos.");
                    for (int xContrato = 0; xContrato < lnuContratosObtenidos; xContrato++) {
                        ContratoDTO contrato = (ContratoDTO) lobContratosSuscripcion.get(xContrato);

                        String lstIdContrato = (contrato.getID_CONTRATO() != null && contrato.getID_CONTRATO().trim().length() > 0) ? contrato.getID_CONTRATO() : "";

                        LOG.info("     ");
                        LOG.info("        <Registro:[" + xContrato + "], IdContrato:[" + lstIdContrato + "]>");

                        // --Obtener las empresas del Contrato con base en las filiales
                        LOG.info("        [INI]. Obtener las empresas del Contrato[" + lstIdContrato + "].");
                        List<QryEmpresasContratoDTO> lobEmpresasContrato = procesoDAO.obtenerEmpresasContrato(lstIdContrato);
                        LOG.info("        [FIN]. Obtener las empresas del Contrato[" + lstIdContrato + "]. Empresas encontradas:_" + lobEmpresasContrato.size() + "_");

                        if (lobEmpresasContrato.size() > 0) {
                            // --Determinar el tipo de pago del Contrato
                            LOG.info("        [INI]. Obtener tipo pago del Contrato[" + lstIdContrato + "].");
                            QryTipoPagoDTO lobTipoPago = procesoDAO.obtenerTipoPago(lstIdContrato, lstFechaMes);
                            LOG.info("        [FIN]. Obtener tipo pago del Contrato[" + lstIdContrato + "].");

                            if (lobTipoPago != null) {
                                String lstClaveTipo = (lobTipoPago.getCLAVE_TIPO() != null && lobTipoPago.getCLAVE_TIPO().trim().length() > 0) ? lobTipoPago.getCLAVE_TIPO() : "";
                                String lstTipoAnnio = (lobTipoPago.getTIPO_ANNIO() != null && lobTipoPago.getTIPO_ANNIO().trim().length() > 0) ? lobTipoPago.getTIPO_ANNIO() : "";
                                String lstTipoPago = (lobTipoPago.getTIPO_PAGO() != null && lobTipoPago.getTIPO_PAGO().trim().length() > 0) ? lobTipoPago.getTIPO_PAGO() : "";
                                String lstIdContratoPago = (lobTipoPago.getID_CONTRATO_PAGO() != null && lobTipoPago.getID_CONTRATO_PAGO().trim().length() > 0) ? lobTipoPago.getID_CONTRATO_PAGO() : "";
                                LOG.info("        <DatosTipoPago: ClaveTipo[" + lstClaveTipo + "],TipoAnnio[" + lstTipoAnnio + "],TipoPago[" + lstTipoPago + "], IdContratoPago:[" + lstIdContratoPago + "]>");

                                // --Determina tipo de Pago
                                LOG.info("        [INI/FIN]. Determina tipo de Pago.");
                                if (lstTipoPago.equalsIgnoreCase(TIPO_PAGO_ESCALA)) {
                                    LOG.info("        Tipo de Pago:_" + TIPO_PAGO_ESCALA + "_");
                                    String lstPromedioSuscriptores = "-1";

                                    // --Determina Clave de Tipo
                                    LOG.info("        [INI/FIN]. Determina Clave Tipo.");
                                    if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_PROM_12MESES)) {

                                        // --Obtener los suscriptores de acuerdo al metodo Prom12Meses
                                        LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_12MESES + ".");
                                        pSuscriptores.setEmpresas(lobEmpresasContrato);
                                        pSuscriptores.setFechaMes(lstFechaMes);
                                        lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresProm12Meses(pSuscriptores);
                                        LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_12MESES + ". Resultado:_" + lstPromedioSuscriptores + "_");

                                    } // Ends if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_PROM_12MESES"))
                                    else if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_PROM_INIFIN)) {

                                        // --Obtener los suscriptores de acuerdo al metodo PromInicioFin
                                        LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_INIFIN + ".");
                                        pSuscriptores.setEmpresas(lobEmpresasContrato);
                                        pSuscriptores.setFechaMes(lstFechaMes);
                                        lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresPromIniFin(pSuscriptores);
                                        LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_INIFIN + ". Resultado:_" + lstPromedioSuscriptores + "_");

                                    } // Ends else if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_PROM_INIFIN"))
                                    else if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_PROM_MES_ANT)) {
                                        // --Obtener los suscriptores de acuerdo al metodo PromMesAnterior
                                        LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_MES_ANT + ".");
                                        pSuscriptores.setEmpresas(lobEmpresasContrato);
                                        pSuscriptores.setFechaMes(lstFechaMes);
                                        lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresPromMesAnterior(pSuscriptores);
                                        LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_MES_ANT + ". Resultado:_" + lstPromedioSuscriptores + "_");

                                    } // Ends else if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_PROM_MES_ANT"))
                                    else if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_MES_ACTUAL)) {
                                        // --Obtener los suscriptores de acuerdo al metodo MesActual
                                        LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_MES_ACTUAL + ".");
                                        pSuscriptores.setEmpresas(lobEmpresasContrato);
                                        pSuscriptores.setFechaMes(lstFechaMes);
                                        lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresMesActual(pSuscriptores);
                                        LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_MES_ACTUAL + ". Resultado:_" + lstPromedioSuscriptores + "_");

                                    } // Ends else if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_MES_ACTUAL"))

                                    if (!lstPromedioSuscriptores.equals("-1")) {

                                        // --Obtener la lista de titulos asociada al contrato mas reciente.
                                        LOG.info("        [INI]. Obtener la lista mas reciente asociada al contrato[" + lstIdContrato + "] Tipo Pago Escala.");
                                        String lsIdListaReciente = procesoDAO.obtenerListaMasReciente(lstIdContrato, ORIGEN_REAL);
                                        LOG.info("        [FIN]. Obtener la lista mas reciente asociada al contrato[" + lstIdContrato + "] Tipo Pago Escala. Resultado:_" + lsIdListaReciente + "_");

                                        if (!lsIdListaReciente.equals("-1")) {
                                            // --Obtener los titulos asociados al contrato
                                            LOG.info("        [INI]. Obtener los titulos asociados al contrato[" + lstIdContrato + "] Tipo Pago Escala.");
                                            ParamObtenerTitulosDTO pobTitulos = new ParamObtenerTitulosDTO();
                                            pobTitulos.setFechaMes(lstFechaMes);
                                            pobTitulos.setIdContrato(lstIdContrato);
                                            pobTitulos.setIdLista(lsIdListaReciente);
                                            pobTitulos.setOrigen(ORIGEN_REAL);
                                            List<ContratoTituloDTO> lobTitulos = procesoDAO.obtenerTitulosPorContrato(pobTitulos);
                                            LOG.info("        [FIN]. Obtener los titulos asociados al contrato[" + lstIdContrato + "] Tipo Pago Escala. Titulos encontrados:_" + lobTitulos.size() + "_");

                                            if (lobTitulos.size() > 0) {
                                                // --Recorrer los titulos obtenidos
                                                int lnuTotalTitulos = lobTitulos.size();
                                                LOG.info("        [INI]. Inicia recorrido de los Titulos encontrados Tipo Pago Escala.");
                                                for (int xTitulo = 0; xTitulo < lnuTotalTitulos; xTitulo++) {
                                                    ContratoTituloDTO lobTitulo = (ContratoTituloDTO) lobTitulos.get(xTitulo);

                                                    String lstIdTituloCnt = (lobTitulo.getID_TITULO_CNT() != null && lobTitulo.getID_TITULO_CNT().trim().length() > 0) ? lobTitulo.getID_TITULO_CNT() : "";
                                                    String lstIdTituloCntOrig = (lobTitulo.getID_TITULO_CNTORIG() != null && lobTitulo.getID_TITULO_CNTORIG().trim().length() > 0) ? lobTitulo.getID_TITULO_CNTORIG() : "";
                                                    String lstFechaInicioTitulo = (lobTitulo.getFECHA_INICIO() != null && lobTitulo.getFECHA_INICIO().trim().length() > 0) ? lobTitulo.getFECHA_INICIO() : "";
                                                    String lstFechaFinTitulo = (lobTitulo.getFECHA_FIN() != null && lobTitulo.getFECHA_FIN().trim().length() > 0) ? lobTitulo.getFECHA_FIN() : "";
                                                    String lstVidaUtil = (lobTitulo.getVIDA_UTIL() != null && lobTitulo.getVIDA_UTIL().trim().length() > 0) ? lobTitulo.getVIDA_UTIL() : "";
                                                    String lstIdPagoCateg = (lobTitulo.getID_PAGO_CATEG() != null && lobTitulo.getID_PAGO_CATEG().trim().length() > 0) ? lobTitulo.getID_PAGO_CATEG() : "";
                                                    String lstPrecioAnualTitulo = (lobTitulo.getPRECIO_ANUAL() != null && lobTitulo.getPRECIO_ANUAL().trim().length() > 0) ? lobTitulo.getPRECIO_ANUAL() : "";
                                                    String lstVidaUtilMeses = (lobTitulo.getMESES_VU() != null && lobTitulo.getMESES_VU().trim().length() > 0) ? lobTitulo.getMESES_VU() : "";
                                                    LOG.info("        <Titulo: Registro[" + xTitulo + "],IdTituloCnt[" + lstIdTituloCnt + "],IdTituloCntOrig:[" + lstIdTituloCntOrig + "],Fini:[" + lstFechaInicioTitulo + "],FFin[" + lstFechaFinTitulo + "], VidaUtil:[" + lstVidaUtil + "],IdPagoCateg:[" + lstIdPagoCateg + "], PrecioAnual:[" + lstPrecioAnualTitulo + "],VidaUtilMeses:[" + lstVidaUtilMeses + "]>");

                                                    // --Determinar valor de Categoria del titulo y con base en ello determinar el costo anual del titulo.
                                                    if (!lstIdPagoCateg.equals("")) {
                                                        LOG.info("        -- Caso: Titulo CON Categoria --");

                                                        // --Obtener el Precio Anual del titulo segun categoria
                                                        LOG.info("            [INI]. Obtener precio anual del Titulo[" + lstIdTituloCnt + "] segun categoria. Tipo Pago Escala.");
                                                        ParamObtenerCostoAnualDTO pobPrecioAnual = new ParamObtenerCostoAnualDTO();
                                                        pobPrecioAnual.setIdContratoPago(lstIdContratoPago);
                                                        pobPrecioAnual.setIdPagoCateg(lstIdPagoCateg);
                                                        pobPrecioAnual.setSuscriptores(lstPromedioSuscriptores);
                                                        String lstPrecioAnualEscala = procesoDAO.obtenerCostoAnualEscala(pobPrecioAnual);
                                                        LOG.info("            [FIN]. Obtener precio anual del Titulo[" + lstIdTituloCnt + "] segun categoria. Tipo Pago Escala. Resultado:_" + lstPrecioAnualEscala + "_");

                                                        if (!lstPrecioAnualEscala.equals("-1")) {
                                                            // --Obtener Costo Mensual
                                                            LOG.info("            [INI]. Obtener Costo Mensual Tipo Pago Escala.");
                                                            String lstCostoMensual = this.obtenerCostoMensual(lstPrecioAnualEscala);
                                                            LOG.info("            [FIN]. Obtener Costo Mensual Tipo de Pago Escala. Resultado:_" + lstCostoMensual + "_");

                                                            if (!lstCostoMensual.equals("-1")) {
                                                                // -- Obtener Valor del Titulo
                                                                LOG.info("            [INI]. Obtener Valor del Titulo Tipo Pago Escala.");
                                                                String lstValorTitulo = this.obtenerValorTitulo(lstCostoMensual, lstVidaUtilMeses);
                                                                LOG.info("            [FIN]. Obtener Valor del Titulo Tipo Pago Escala. Resultado:_" + lstValorTitulo + "_");

                                                                if (!lstValorTitulo.equals("-1")) {
                                                                    // --Insercion de datos
                                                                    LOG.info("            [INI]. Guardado de datos de Costo Tipo Pago Escala.");
                                                                    CalculoCostoDTO calculo = new CalculoCostoDTO();
                                                                    calculo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
                                                                    calculo.setMES(dateManager.cambiarFormato(lstFechaMes, "yyyy-MM-dd"));
                                                                    calculo.setCOSTO(lstCostoMensual);
                                                                    calculo.setCOSTO_CALCULADO(lstValorTitulo);
                                                                    calculo.setTIPO_CALCULO(TIPO_CALCULO_SUSCRIPCION);
                                                                    calculo.setPRECIO(lstPrecioAnualEscala);
                                                                    calculo.setSUSCRIPTORES(lstPromedioSuscriptores);
                                                                    calculo.setTIPO_PAGO(lstTipoPago);
                                                                    calculo.setID_CONTRATO(lstIdContrato);
                                                                    boolean lboRegistroDatosEscala = procesoDAO.registrarCalculoCostoTituloEscala(calculo);
                                                                    LOG.info("            [FIN]. Guardado de datos de Costo Tipo Pago Escala. Resultado:_" + lboRegistroDatosEscala + "_");

                                                                    if (lboRegistroDatosEscala) {
                                                                        LOG.info("Se registraron correctamente los datos de costo (Tipo Escala). Contrato[" + lstIdContrato + "], Titulo:[" + lstIdTituloCnt + "]");
                                                                    } else {
                                                                        LOG.info("No se pudo registrar el calculo de costo (Tipo Escala).");
                                                                    }

                                                                } else {
                                                                    LOG.info("No se pudo obtener el valor del Titulo (Tipo Escala).");
                                                                }

                                                            } // End if(!lstCostoMensual.equals("-1"))
                                                            else {
                                                                LOG.info("No se pudo obtener el costo mensual (Tipo Escala).");
                                                            }

                                                        } // Ends if(!lstPrecioAnualEscala.equals("-1"))
                                                        else {
                                                            LOG.info("No se pudo obtener el precio anual del Titulo (Tipo Escala).");
                                                        }

                                                    } // Ends if(!lstIdPagoCateg.equals(""))
                                                    else {
                                                        LOG.info("        -- Caso: Titulo SIN Categoria --");

                                                        if (!lstPrecioAnualTitulo.equals("")) {
                                                            LOG.info("            -Caso: CON Precio anual");

                                                            // --Obtener Costo Mensual
                                                            LOG.info("            [INI]. Obtener Costo Mensual Tipo Pago Escala.");
                                                            String lstCostoMensual = this
                                                                    .obtenerCostoMensual(lstPrecioAnualTitulo);
                                                            LOG.info("            [FIN]. Obtener Costo Mensual Tipo de Pago Escala. Resultado:_" + lstCostoMensual + "_");

                                                            if (!lstCostoMensual.equals("-1")) {
                                                                // -- Obtener Valor del Titulo
                                                                LOG.info("            [INI]. Obtener Valor del Titulo Tipo Pago Escala.");
                                                                String lstValorTitulo = this.obtenerValorTitulo(lstCostoMensual, lstVidaUtilMeses);
                                                                LOG.info("            [FIN]. Obtener Valor del Titulo Tipo Pago Escala. Resultado:_" + lstValorTitulo + "_");

                                                                if (!lstValorTitulo.equals("-1")) {
                                                                    // --Insercion de datos
                                                                    LOG.info("            [INI]. Guardado de datos de Costo Tipo Pago Escala.");
                                                                    CalculoCostoDTO calculo = new CalculoCostoDTO();
                                                                    calculo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
                                                                    calculo.setMES(dateManager.cambiarFormato(lstFechaMes, "yyyy-MM-dd"));
                                                                    calculo.setCOSTO(lstCostoMensual);
                                                                    calculo.setCOSTO_CALCULADO(lstValorTitulo);
                                                                    calculo.setTIPO_CALCULO(TIPO_CALCULO_SUSCRIPCION);
                                                                    calculo.setPRECIO(lstPrecioAnualTitulo);
                                                                    calculo.setSUSCRIPTORES(lstPromedioSuscriptores);
                                                                    calculo.setTIPO_PAGO(lstTipoPago);
                                                                    calculo.setID_CONTRATO(lstIdContrato);
                                                                    boolean lboRegistroDatosEscala = procesoDAO.registrarCalculoCostoTituloEscala(calculo);
                                                                    LOG.info("            [FIN]. Guardado de datos de Costo Tipo Pago Escala. Resultado:_" + lboRegistroDatosEscala + "_");

                                                                    if (lboRegistroDatosEscala) {
                                                                        LOG.info("Se registraron correctamente los datos de costo (Tipo Escala). Contrato[" + lstIdContrato + "], Titulo:[" + lstIdTituloCnt + "]");
                                                                    } else {
                                                                        LOG.info("No se pudo registrar el calculo de costo (Tipo Escala).");
                                                                    }

                                                                } else {
                                                                    LOG.info("No se pudo obtener el valor del Titulo (Tipo Escala).");
                                                                }

                                                            } // End if(!lstCostoMensual.equals("-1"))
                                                            else {
                                                                LOG.info("No se pudo obtener el costo mensual (Tipo Escala).");
                                                            }
                                                        } // Ends if(!lstPrecioAnualTitulo.equals(""))
                                                        else {
                                                            LOG.info("            -Caso: SIN Precio anual");

                                                            String lstCostoMensual = "0";
                                                            String lstValorTitulo = "0";
                                                            lstPrecioAnualTitulo = "0";

                                                            // -- Insercion de datos
                                                            LOG.info("            [INI]. Guardado de datos de Costo Tipo Pago Escala.");
                                                            CalculoCostoDTO calculo = new CalculoCostoDTO();
                                                            calculo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
                                                            calculo.setMES(dateManager.cambiarFormato(lstFechaMes, "yyyy-MM-dd"));
                                                            calculo.setCOSTO(lstCostoMensual);
                                                            calculo.setCOSTO_CALCULADO(lstValorTitulo);
                                                            calculo.setTIPO_CALCULO(TIPO_CALCULO_SUSCRIPCION);
                                                            calculo.setPRECIO(lstPrecioAnualTitulo);
                                                            calculo.setSUSCRIPTORES(lstPromedioSuscriptores);
                                                            calculo.setTIPO_PAGO(lstTipoPago);
                                                            calculo.setID_CONTRATO(lstIdContrato);
                                                            boolean lboRegistroDatosEscala = procesoDAO.registrarCalculoCostoTituloEscala(calculo);
                                                            LOG.info("            [FIN]. Guardado de datos de Costo Tipo Pago Escala. Resultado:_" + lboRegistroDatosEscala + "_");

                                                            if (lboRegistroDatosEscala) {
                                                                LOG.info("Se registraron correctamente los datos de costo (Tipo Escala). Contrato[" + lstIdContrato + "], Titulo:[" + lstIdTituloCnt + "]");
                                                            } else {
                                                                LOG.info("No se pudo registrar el calculo de costo (Tipo Escala).");
                                                            }

                                                        } // Ends else if(!lstPrecioAnualTitulo.equals(""))

                                                    } // Ends else if(!lstIdPagoCateg.equals(""))

                                                } // Termina for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
                                                LOG.info("        [FIN]. Inicia recorrido de los Titulos encontrados (Tipo Escala).");

                                            } // Ends if(lobTitulos.size() > 0)
                                            else {
                                                LOG.info("No se encontraron titulos asociados al contrato[" + lstIdContrato + "] (Tipo Escala).");
                                            }
                                        } else {
                                            LOG.info("No se pudo obtener la lista mas reciente asociada al contrato[" + lstIdContrato + "] (Tipo Escala).");
                                        }
                                    } else {
                                        LOG.info("No se pudieron obtener el promedio de suscriptores para las empresas asociadas al contrato[" + lstIdContrato + "] (Tipo Escala).");
                                    }

                                } // Ends if(lstTipoPago.equalsIgnoreCase("TIPO_PAGO_ESCALA"))
                                else if (lstTipoPago.equalsIgnoreCase(TIPO_PAGO_FLAT)) {
                                    LOG.info("            Tipo de Pago:_" + TIPO_PAGO_FLAT + "_");

                                    // --Obtener el numero de annio del Titulo
                                    LOG.info("        [INI]. Obtener el annio vigente(corriente) con relacion al Contrato[" + lstIdContrato + "] con base en TIPO_ANNIO  y Fecha de Carga de Suscriptores.(Tipo pago Flat).");
                                    ParamAnnioVigenteDTO pAnnio = new ParamAnnioVigenteDTO();
                                    pAnnio.setIdContrato(lstIdContrato);
                                    pAnnio.setFechaMes(lstFechaMes);
                                    pAnnio.setTipoAnnio(lstTipoAnnio);
                                    ResponseAnnioVigenteDTO lobAnnio = this.obtenerValorAnnioVigente(pAnnio);
                                    String lstAnnio = "1";
                                    if (lobAnnio != null && lobAnnio.isResultado()) {
                                        lstAnnio = lobAnnio.getAnnio();
                                    }
                                    LOG.info("        [FIN]. Obtener el annio vigente(corriente) con relacion al Contrato[" + lstIdContrato + "] con base en TIPO_ANNIO y Fecha de Carga de Suscriptores.(Tipo pago Flat). Resultado:_" + lstAnnio + "_");

                                    if (!lstAnnio.equals("-1")) {
                                        // --Obtener la lista de titulos asociada al contrato mas reciente.
                                        LOG.info("        [INI]. Obtener la lista mas reciente asociada al contrato[" + lstIdContrato + "] Tipo Pago Flat.");
                                        String lsIdListaReciente = procesoDAO.obtenerListaMasReciente(lstIdContrato, ORIGEN_REAL);
                                        LOG.info("        [FIN]. Obtener la lista mas reciente asociada al contrato[" + lstIdContrato + "] Tipo Pago Flat. Resultado:_" + lsIdListaReciente + "_");

                                        if (!lsIdListaReciente.equals("-1")) {
                                            // -Obtener los titulos asociados al contrato
                                            LOG.info("        [INI]. Obtener los titulos asociados al contrato[" + lstIdContrato + "] Tipo de Pago Flat.");
                                            ParamObtenerTitulosDTO pobTitulos = new ParamObtenerTitulosDTO();
                                            pobTitulos.setFechaMes(lstFechaMes);
                                            pobTitulos.setIdContrato(lstIdContrato);
                                            pobTitulos.setIdLista(lsIdListaReciente);
                                            pobTitulos.setOrigen(ORIGEN_REAL);
                                            List<ContratoTituloDTO> lobTitulos = procesoDAO.obtenerTitulosPorContrato(pobTitulos);
                                            LOG.info("        [FIN]. Obtener los titulos asociados al contrato[" + lstIdContrato + "] Tipo de Pago Flat. Titulos encontrados:_" + lobTitulos.size() + "_");

                                            if (lobTitulos.size() > 0) {
                                                // --Recorrer los titulos obtenidos
                                                int lnuTotalTitulos = lobTitulos.size();
                                                LOG.info("        [INI]. Inicia recorrido de los Titulos encontrados Tipo de Pago Flat.");
                                                for (int xTitulo = 0; xTitulo < lnuTotalTitulos; xTitulo++) {
                                                    ContratoTituloDTO lobTitulo = (ContratoTituloDTO) lobTitulos.get(xTitulo);

                                                    String lstIdTituloCnt = (lobTitulo.getID_TITULO_CNT() != null && lobTitulo.getID_TITULO_CNT().trim().length() > 0) ? lobTitulo.getID_TITULO_CNT() : "";
                                                    String lstIdTituloCntOrig = (lobTitulo.getID_TITULO_CNTORIG() != null && lobTitulo.getID_TITULO_CNTORIG().trim().length() > 0) ? lobTitulo.getID_TITULO_CNTORIG() : "";
                                                    String lstFechaInicioTitulo = (lobTitulo.getFECHA_INICIO() != null && lobTitulo.getFECHA_INICIO().trim().length() > 0) ? lobTitulo.getFECHA_INICIO() : "";
                                                    String lstFechaFinTitulo = (lobTitulo.getFECHA_FIN() != null && lobTitulo.getFECHA_FIN().trim().length() > 0) ? lobTitulo.getFECHA_FIN() : "";
                                                    String lstVidaUtil = (lobTitulo.getVIDA_UTIL() != null && lobTitulo.getVIDA_UTIL().trim().length() > 0) ? lobTitulo.getVIDA_UTIL() : "";
                                                    String lstIdPagoCateg = (lobTitulo.getID_PAGO_CATEG() != null && lobTitulo.getID_PAGO_CATEG().trim().length() > 0) ? lobTitulo.getID_PAGO_CATEG() : "";
                                                    String lstPrecioAnualTitulo = (lobTitulo.getPRECIO_ANUAL() != null && lobTitulo.getPRECIO_ANUAL().trim().length() > 0) ? lobTitulo.getPRECIO_ANUAL() : "";
                                                    String lstVidaUtilMeses = (lobTitulo.getMESES_VU() != null && lobTitulo.getMESES_VU().trim().length() > 0) ? lobTitulo.getMESES_VU() : "";
                                                    LOG.info("        	  <Titulo: Registro[" + xTitulo + "],IdTituloCnt[" + lstIdTituloCnt + "],IdTituloCntOrig:[" + lstIdTituloCntOrig + "],Fini:[" + lstFechaInicioTitulo + "],FFin[" + lstFechaFinTitulo + "], VidaUtil:[" + lstVidaUtil + "],IdPagoCateg:[" + lstIdPagoCateg + "], PrecioAnual:[" + lstPrecioAnualTitulo + "],VidaUtilMeses:[" + lstVidaUtilMeses + "]>");

                                                    // --Determinar valor de Categoria del titulo y con base en ello determinar el costo anual del titulo.
                                                    if (!lstIdPagoCateg.equals("")) {
                                                        LOG.info("        -- Caso: Titulo CON Categoria --");

                                                        // --Obtener el precio anual del titulo Flat
                                                        LOG.info("            [INI]. Obtener precio anual del Titulo[" + lstIdTituloCnt + "] Tipo Pago Flat.");
                                                        ParamObtenerCostoAnualDTO pobPrecioAnual = new ParamObtenerCostoAnualDTO();
                                                        pobPrecioAnual.setIdContratoPago(lstIdContratoPago);
                                                        pobPrecioAnual.setIdPagoCateg(lstIdPagoCateg);
                                                        pobPrecioAnual.setAnnio(lstAnnio);
                                                        String lstPrecioAnualFlat = procesoDAO.obtenerCostoAnualFlat(pobPrecioAnual);
                                                        LOG.info("            [FIN]. Obtener precio anual del Titulo[" + lstIdTituloCnt + "] Tipo Pago Flat. Resultado:_" + lstPrecioAnualFlat + "_");

                                                        if (!lstPrecioAnualFlat.equals("-1")) {
                                                            // --Obtener Costo Mensual
                                                            LOG.info("            [INI]. Obtener Costo Mensual Tipo Pago Flat.");
                                                            String lstCostoMensual = this.obtenerCostoMensual(lstPrecioAnualFlat);
                                                            LOG.info("            [FIN]. Obtener Costo Mensual Tipo de Pago Flat. Resultado:_" + lstCostoMensual + "_");

                                                            if (!lstCostoMensual.equals("-1")) {
                                                                // -- Obtener el valor del titulo
                                                                LOG.info("            [INI]. Obtener Valor del Titulo Tipo Pago Flat.");
                                                                String lstValorTitulo = this.obtenerValorTitulo(lstCostoMensual, lstVidaUtilMeses);
                                                                LOG.info("            [FIN]. Obtener Valor del Titulo Tipo Pago Flat. Resultado:_" + lstValorTitulo + "_");

                                                                if (!lstValorTitulo.equals("-1")) {
                                                                    // --Insercion de datos
                                                                    LOG.info("            [INI]. Guardado de datos de Costo Tipo Pago Flat.");
                                                                    CalculoCostoDTO calculo = new CalculoCostoDTO();
                                                                    calculo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
                                                                    calculo.setMES(dateManager.cambiarFormato(lstFechaMes, "yyyy-MM-dd"));
                                                                    calculo.setCOSTO(lstCostoMensual);
                                                                    calculo.setCOSTO_CALCULADO(lstValorTitulo);
                                                                    calculo.setTIPO_CALCULO(TIPO_CALCULO_SUSCRIPCION);
                                                                    calculo.setPRECIO(lstPrecioAnualFlat);
                                                                    calculo.setTIPO_PAGO(lstTipoPago);
                                                                    calculo.setANNIO_CALCULO(lstAnnio);
                                                                    calculo.setID_CONTRATO(lstIdContrato);
                                                                    boolean lboRegistroDatosFlat = procesoDAO.registrarCalculoCostoTituloFlat(calculo);
                                                                    LOG.info("            [FIN]. Guardado de datos de Costo Tipo Pago Flat. Resultado:_" + lboRegistroDatosFlat + "_");

                                                                    if (lboRegistroDatosFlat) {
                                                                        LOG.info("Se registraron correctamente los datos de costo (Tipo Flat). Contrato[" + lstIdContrato + "], Titulo:[" + lstIdTituloCnt + "]");
                                                                    } else {
                                                                        LOG.info("No se pudo registrar el calculo de costo (Tipo Flat).");
                                                                    }

                                                                } // Ends if(!lstValorTitulo.equals("-1"))
                                                                else {
                                                                    LOG.info("No se pudo obtener el valor del Titulo (Tipo de Pago Flat).");
                                                                }

                                                            } // End if(!lstCostoMensual.equals("-1"))
                                                            else {
                                                                LOG.info("No se pudo obtener el costo mensual (Tipo de pago Flat).");
                                                            }

                                                        } // Ends if(!lstPrecioAnualFlat.equals("-1"))
                                                        else {
                                                            LOG.info("No se pudo obtener el precio anual del Titulo[" + lstIdTituloCnt + "] (Tipo Flat).");
                                                        }

                                                    } // Ends if(!lstIdPagoCateg.equals(""))
                                                    else {
                                                        LOG.info("        -- Caso: Titulo SIN Categoria --");

                                                        if (!lstPrecioAnualTitulo.equals("")) {
                                                            LOG.info("            -Caso: CON Precio anual");

                                                            // --Obtener Costo Mensual
                                                            LOG.info("            [INI]. Obtener Costo Mensual Tipo Pago Flat.");
                                                            String lstCostoMensual = this.obtenerCostoMensual(lstPrecioAnualTitulo);
                                                            LOG.info("            [FIN]. Obtener Costo Mensual Tipo de Pago Flat. Resultado:_" + lstCostoMensual + "_");

                                                            if (!lstCostoMensual.equals("-1")) {
                                                                // -- Obtener el valor del titulo
                                                                LOG.info("            [INI]. Obtener Valor del Titulo Tipo Pago Flat.");
                                                                String lstValorTitulo = this.obtenerValorTitulo(lstCostoMensual, lstVidaUtilMeses);
                                                                LOG.info("            [FIN]. Obtener Valor del Titulo Tipo Pago Flat. Resultado:_" + lstValorTitulo + "_");

                                                                if (!lstValorTitulo.equals("-1")) {
                                                                    // -- Insercion de datos
                                                                    LOG.info("            [INI]. Guardado de datos de Costo Tipo Pago Flat.");
                                                                    CalculoCostoDTO calculo = new CalculoCostoDTO();
                                                                    calculo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
                                                                    calculo.setMES(dateManager.cambiarFormato(lstFechaMes, "yyyy-MM-dd"));
                                                                    calculo.setCOSTO(lstCostoMensual);
                                                                    calculo.setCOSTO_CALCULADO(lstValorTitulo);
                                                                    calculo.setTIPO_CALCULO(TIPO_CALCULO_SUSCRIPCION);
                                                                    calculo.setPRECIO(lstPrecioAnualTitulo);
                                                                    calculo.setTIPO_PAGO(lstTipoPago);
                                                                    calculo.setANNIO_CALCULO(lstAnnio);
                                                                    calculo.setID_CONTRATO(lstIdContrato);
                                                                    boolean lboRegistroDatosFlat = procesoDAO.registrarCalculoCostoTituloFlat(calculo);
                                                                    LOG.info("            [FIN]. Guardado de datos de Costo Tipo Pago Flat. Resultado:_" + lboRegistroDatosFlat + "_");

                                                                    if (lboRegistroDatosFlat) {
                                                                        LOG.info("Se registraron correctamente los datos de costo (Tipo Flat). Contrato[" + lstIdContrato + "], Titulo:[" + lstIdTituloCnt + "]");
                                                                    } else {
                                                                        LOG.info("No se pudo registrar el calculo de costo (Tipo Flat).");
                                                                    }

                                                                } // Ends if(!lstValorTitulo.equals("-1"))
                                                                else {
                                                                    LOG.info("No se pudo obtener el valor del Titulo (Tipo de Pago Flat).");
                                                                }

                                                            } // End if(!lstCostoMensual.equals("-1"))
                                                            else {
                                                                LOG.info("No se pudo obtener el costo mensual (Tipo de pago Flat).");
                                                            }

                                                        } // Ends if(!lstPrecioAnualTitulo.equals(""))
                                                        else {
                                                            LOG.info("            -Caso: SIN Precio anual");
                                                            String lstCostoMensual = "0";
                                                            String lstValorTitulo = "0";
                                                            lstPrecioAnualTitulo = "0";

                                                            // -- Insercion de datos
                                                            LOG.info("            [INI]. Guardado de datos de Costo Tipo Pago Flat.");
                                                            CalculoCostoDTO calculo = new CalculoCostoDTO();
                                                            calculo.setID_TITULO_CNTORIG(lstIdTituloCntOrig);
                                                            calculo.setMES(dateManager.cambiarFormato(lstFechaMes, "yyyy-MM-dd"));
                                                            calculo.setCOSTO(lstCostoMensual);
                                                            calculo.setCOSTO_CALCULADO(lstValorTitulo);
                                                            calculo.setTIPO_CALCULO(TIPO_CALCULO_SUSCRIPCION);
                                                            calculo.setPRECIO(lstPrecioAnualTitulo);
                                                            calculo.setTIPO_PAGO(lstTipoPago);
                                                            calculo.setANNIO_CALCULO(lstAnnio);
                                                            calculo.setID_CONTRATO(lstIdContrato);
                                                            boolean lboRegistroDatosFlat = procesoDAO.registrarCalculoCostoTituloFlat(calculo);
                                                            LOG.info("            [FIN]. Guardado de datos de Costo Tipo Pago Flat. Resultado:_" + lboRegistroDatosFlat + "_");

                                                            if (lboRegistroDatosFlat) {
                                                                LOG.info("Se registraron correctamente los datos de costo (Tipo Flat). Contrato[" + lstIdContrato + "], Titulo:[" + lstIdTituloCnt + "]");
                                                            } else {
                                                                LOG.info("No se pudo registrar el calculo de costo (Tipo Flat).");
                                                            }

                                                        } // Ends else if(!lstPrecioAnualTitulo.equals(""))

                                                    } // Ends else de if(!lstIdPagoCateg.equals(""))

                                                } // Ends for(int xTitulo=0; xTitulo < lnuTotalTitulos; xTitulo++)
                                                LOG.info("        [FIN]. Inicia recorrido de los Titulos encontrados Tipo de Pago Flat.");

                                            } // Ends if(lobTitulos.size() > 0)
                                            else {
                                                LOG.info("No se pudieron obtener los Titulos tipo Pago Flat asociados al contrato[" + lstIdContrato + "].");
                                            }

                                        } // Ends if(!lsIdListaReciente.equals("-1"))
                                        else {
                                            LOG.info("No se pudo obtener la lista mas reciente asociada al contrato[" + lstIdContrato + "] tipo Pago Flat.");
                                        }
                                    } // Ends if(!lstAnnio.equals("-1"))
                                    else {
                                        LOG.info("No se pudo obtener el annio vigente del Contrato[" + lstIdContrato + "] (Tipo Flat).");
                                    }

                                } // Ends else if(lstTipoPago.equalsIgnoreCase(TIPO_PAGO_FLAT))

                            } // Ends if(lobTipoPago != null)
                            else {
                                LOG.info("No se pudieron obtener los datos de Tipo de Pago del Contrato[" + lstIdContrato + "].");
                            }

                        } // Ends if(lobEmpresasContrato.size() > 0)
                        else {
                            LOG.info("No se pudieron obtener las Empresas asociadas al Contrato[" + lstIdContrato + "].");
                        }

                        //--Llamado de SP de calculo de Pagos a Estudios
                        LOG.info("    [INI]. Ejecucion de SP para calculo de Pagos a Estudios.");
                        boolean lboResSP = procesoDAO.ejecutarSPCalculoPagoEstudios(lstIdContrato);
                        LOG.info("    [FIN]. Ejecucion de SP para calculo de Pagos a Estudios.");

                    } // Ends for(int xContrato = 0; xContrato < lnuContratosObtenidos; xContrato++)
                    LOG.info("    [FIN]. Inicia recorrido de los Contratos Obtenidos.");

                    // --Construye respuesta
                    resultado.setResultado(true);
                    resultado.setMensaje("OK");
                    LOG.info("Respuesta devuelta: " + resultado.toString());

                } // Ends if(lobContratosSuscripcionLF.size() > 0)
                else {
                    // --Construye Respuesta
                    resultado.setResultado(false);
                    resultado.setMensaje("DDA-CCS-001: No se pudieron obtener los Contratos.");
                    LOG.info("Respuesta devuelta: " + resultado.toString());
                }
            } // Ends if(lboLimpia)
            else {
                // --Construye Respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-CCS-003: No se pudieron eliminar los registros de costo previos.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::calcularCostoSuscriptores]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::calcularCostoSuscriptores] :::::::::::::::: >>");
        return resultado;

    }

    private String obtenerCostoMensual(String pstCostoAnual) throws Exception {
        LOG.debug("    - [" + this.getClass().getSimpleName() + "::obtenerCostoMensual]");
        LOG.debug("    - Parametros: ");
        LOG.debug("           Costo Anual: " + pstCostoAnual);

        String resultado = "-1";
        BigDecimal bdResultado = new BigDecimal("0.0");
        BigDecimal bd12 = new BigDecimal("12.0");
        String lstCostoAnual = (pstCostoAnual != null && pstCostoAnual.trim().length() > 0) ? pstCostoAnual : "0.0";

        try {
            BigDecimal lnuCostoAnual = new BigDecimal(lstCostoAnual);
            bdResultado = lnuCostoAnual.divide(bd12, 4, BigDecimal.ROUND_HALF_UP);
            bdResultado = bdResultado.setScale(4, BigDecimal.ROUND_HALF_UP);
            resultado = bdResultado.toString();
        } catch (NumberFormatException nf) {
            LOG.info("Ocurrio un error al parsear las cantidades Costo Anual[" + pstCostoAnual + "]");
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerCostoMensual]: " + nf.getMessage());
            throw new Exception(nf.getMessage());
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerCostoMensual]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

    private String obtenerCostoMensualAmortizacion(String pstCosto, String pstMeses) throws Exception {
        LOG.debug("    - [" + this.getClass().getSimpleName() + "::obtenerCostoMensualAmortizacion]");
        LOG.debug("    - Parametros: ");
        LOG.debug("           Costo: " + pstCosto);
        LOG.debug("           Meses: " + pstMeses);

        String resultado = "-1";
        BigDecimal bdResultado = new BigDecimal("0.0");

        String lstCosto = (pstCosto != null && pstCosto.trim().length() > 0) ? pstCosto : "0.0";
        String lstMeses = (pstMeses != null && pstMeses.trim().length() > 0) ? pstMeses : "1.0";

        try {
            BigDecimal lnuCosto = new BigDecimal(lstCosto);
            BigDecimal lnuMeses = new BigDecimal(lstMeses);
            // MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
            bdResultado = lnuCosto.divide(lnuMeses, 4, BigDecimal.ROUND_HALF_UP);
            bdResultado = bdResultado.setScale(4, BigDecimal.ROUND_HALF_UP);
            resultado = bdResultado.toString();

        } catch (NumberFormatException nf) {
            LOG.info("Ocurrio un error al parsear las cantidades Costo[" + pstCosto + "] y Meses[" + pstMeses + "]");
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerCostoMensualAmortizacion]: " + nf.getMessage());
            throw new Exception(nf.getMessage());
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerCostoMensualAmortizacion]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

    private String obtenerValorTitulo(String pstCosto, String pstMesesExhibicion) throws Exception {
        LOG.debug("    - [" + this.getClass().getSimpleName() + "::obtenerValorTitulo]");
        LOG.debug("    - Parametros: ");
        LOG.debug("           Costo: " + pstCosto);
        LOG.debug("           Meses exhibicion: " + pstMesesExhibicion);

        String resultado = "-1";
        BigDecimal bdResultado = new BigDecimal("0.0");
        String lstCosto = (pstCosto != null && pstCosto.trim().length() > 0) ? pstCosto : "0.0";
        String lstMeses = (pstMesesExhibicion != null && pstMesesExhibicion.trim().length() > 0) ? pstMesesExhibicion : "0.0";

        try {
            BigDecimal lnuCosto = new BigDecimal(lstCosto);
            BigDecimal lnuMeses = new BigDecimal(lstMeses);
            bdResultado = lnuCosto.multiply(lnuMeses);
            bdResultado = bdResultado.setScale(4, BigDecimal.ROUND_HALF_UP);
            resultado = bdResultado.toString();
        } catch (NumberFormatException nf) {
            LOG.info("Ocurrio un error al parsear las cantidades Costo[" + lstCosto + "] y Meses exhibicion[" + lstMeses + "]");
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerValorTitulo]: " + nf.getMessage());
            throw new Exception(nf.getMessage());
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerValorTitulo]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;

    }

    public int comparaCantidades(String pstCantidadAComparar, String pstCantidadReferencia) throws Exception {
        LOG.debug("    - [" + this.getClass().getSimpleName() + "::comparaCantidades]");
        LOG.debug("    - Parametros: ");
        LOG.debug("           Cantidad a Comparar: " + pstCantidadAComparar);
        LOG.debug("           Cantidad a referencia: " + pstCantidadReferencia);

        int resultado = 0;

        String lstCantidadComparar = (pstCantidadAComparar != null && pstCantidadAComparar.trim().length() > 0) ? pstCantidadAComparar : "0.0";
        String lstCantidadReferencia = (pstCantidadReferencia != null && pstCantidadReferencia.trim().length() > 0) ? pstCantidadReferencia : "0.0";

        try {
            BigDecimal lnuCantidadComprar = new BigDecimal(lstCantidadComparar);
            BigDecimal lnuCantidadReferencia = new BigDecimal(lstCantidadReferencia);

            resultado = lnuCantidadComprar.compareTo(lnuCantidadReferencia);
        } catch (NumberFormatException nf) {
            LOG.info("Ocurrio un error al parsear las cantidades CantidadAComparar[" + lstCantidadComparar + "] y CantidadReferencia[" + lstCantidadReferencia + "]");
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::comparaCantidades]: " + nf.getMessage());
            throw new Exception(nf.getMessage());
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::comparaCantidades]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    private boolean limpiaRegistrosPrevios(String lstFechaMes) throws Exception {
        boolean resultado = false;
        try {
            // --Consulta si hay registros para eliminar
            int lnuRegistrosBorrar = procesoDAO.obtenerCuantosRegistrosBorrar(lstFechaMes);
            if (lnuRegistrosBorrar == 0) {
                resultado = true;
            } else {
                resultado = procesoDAO.limpiaRegistrosCostoMes(lstFechaMes);
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::limpiaRegistrosPrevios]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

    public ResponseValorTituloDTO obtenerCostoTitulo(ParamValorTituloDTO dto) throws Exception {
        ResponseValorTituloDTO resultado = new ResponseValorTituloDTO();

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::obtenerValorTitulo] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());
        try {
            //-- Llamada del Stored Procedure.
            LOG.info("    [INI]. Ejecucion de SP para proceso de Obtener Costo Titulo.");
            boolean lboResSP = procesoDAO.ejecutarSPObtenerCostoTitulo(dto);
            LOG.info("    [FIN]. Ejecucion de SP para proceso de Obtener Costo Titulo.");
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerValorTitulo]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::obtenerValorTitulo] :::::::::::::::: >>");
        return resultado;
    }

    private String determinaFechaBaseConsultaSuscriptores(String pstMesCalculo, String pstUltimaFechaCarga) throws Exception {

        LOG.debug("    - [" + this.getClass().getSimpleName() + "::determinaFechaBaseConsultaSuscriptores]");
        LOG.debug("    - Parametros: ");
        LOG.debug("           MesCalculo: " + pstMesCalculo);
        LOG.debug("           UltimaFechaCarga: " + pstUltimaFechaCarga);

        String resultado = pstMesCalculo;

        try {
            int lnuResComparacionFechas = dateManager.compararFechas(pstMesCalculo, pstUltimaFechaCarga);

            if (lnuResComparacionFechas == -1) {
                resultado = pstMesCalculo;
            } else if (lnuResComparacionFechas == 1) {
                resultado = pstUltimaFechaCarga;
            } else if (lnuResComparacionFechas == 0) {
                resultado = pstUltimaFechaCarga;
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::determinaFechaBaseConsultaSuscriptores]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    public ResponseValidaMinimoSeleccionDTO validarMinimoSeleccion(ParamValidaMinimoSeleccionDTO dto) throws Exception {
        ResponseValidaMinimoSeleccionDTO resultado = new ResponseValidaMinimoSeleccionDTO();
        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::validarMinimoSeleccion] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            LOG.info("    [INI]. Ejecutar validacion de minimos de seleccion.");
            String lstMsjValidacionMinSel = procesoDAO.obtenerValidacionMinSeleccion(dto);
            LOG.info("    [FIN]. Ejecutar validacion de minimos de seleccion. Resultado: " + lstMsjValidacionMinSel);

            if (lstMsjValidacionMinSel != null && lstMsjValidacionMinSel.trim().length() > 0) {
                String[] resultados = lstMsjValidacionMinSel.split("\\|");
                LOG.info("[INI/FIN]Resultado[0]: " + resultados[0] + " Resultado[1]: " + resultados[1] + "Cuantos: " + resultados.length);

                if (resultados != null && resultados.length == 2) {
                    if (resultados[0].toString().equalsIgnoreCase("OK")) {
                        List<String> lobErrores = new ArrayList<String>();
                        lobErrores.add(resultados[1].toString());
                        resultado.setResultado(true);
                        resultado.setMensaje("OK");
                        resultado.setErrores(lobErrores);
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    } else if (resultados[0].toString().equalsIgnoreCase("NO_OK")) {
                        List<String> lobErrores = new ArrayList<String>();
                        lobErrores.add(resultados[1].toString());
                        resultado.setResultado(false);
                        resultado.setMensaje("NO_OK");
                        resultado.setErrores(lobErrores);
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }
                } else {
                    List<String> lobErrores = new ArrayList<String>();
                    lobErrores.add("Ocurri&oacute; un error al determinar el resultado del proceso para validar los m&iacute;nimos de selecci&oacute;n.");
                    resultado.setResultado(false);
                    resultado.setMensaje("NO_OK");
                    resultado.setErrores(lobErrores);
                    LOG.info("Respuesta devuelta: " + resultado.toString());

                }
            } else {
                //--Construye respuesta
                List<String> lobErrores = new ArrayList<String>();
                lobErrores.add("Ocurri&oacute; un error al ejecutar el proceso para validar los m&iacute;nimos de selecci&oacute;n.");
                resultado.setResultado(false);
                resultado.setMensaje("NO_OK");
                resultado.setErrores(lobErrores);
                LOG.info("Respuesta devuelta: " + resultado.toString());

            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::validarMinimoSeleccion]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }

        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::validarMinimoSeleccion] :::::::::::::::: >>");
        return resultado;

    }

    public ResponseSuscriptoresContratoDTO obtenerSuscriptoresContrato(ParamSuscriptoresContrato dto) throws Exception {
        ResponseSuscriptoresContratoDTO resultado = new ResponseSuscriptoresContratoDTO();
        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::obtenerSuscriptoresContrato] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
            String lstFechaInicioPeriodo = (dto.getFechaInicioPeriodo() != null && dto.getFechaInicioPeriodo().trim().length() > 0) ? dto.getFechaInicioPeriodo() : "";

            // --Obtener las empresas del Contrato con base en las filiales
            LOG.info("        [INI]. Obtener lasempresas del Contrato[" + lstIdContrato + "].");
            List<QryEmpresasContratoDTO> lobEmpresasContrato = procesoDAO.obtenerEmpresasContrato(lstIdContrato);
            LOG.info("        [FIN]. Obtener las empresas del Contrato[" + lstIdContrato + "]. Empresas encontradas:_" + lobEmpresasContrato.size() + "_");

            if (lobEmpresasContrato.size() > 0) {
                // --Determinar el tipo de pago del Contrato
                LOG.info("        [INI]. Obtener tipo pago del Contrato[" + lstIdContrato + "].");
                QryTipoPagoDTO lobTipoPago = procesoDAO.obtenerTipoPago(lstIdContrato, lstFechaInicioPeriodo);
                LOG.info("        [FIN]. Obtener tipo pago del Contrato[" + lstIdContrato + "].");

                if (lobTipoPago != null) {
                    String lstClaveTipo = (lobTipoPago.getCLAVE_TIPO() != null && lobTipoPago.getCLAVE_TIPO().trim().length() > 0) ? lobTipoPago.getCLAVE_TIPO() : "";
                    String lstTipoPago = (lobTipoPago.getTIPO_PAGO() != null && lobTipoPago.getTIPO_PAGO().trim().length() > 0) ? lobTipoPago.getTIPO_PAGO() : "";
                    LOG.info("        <DatosTipoPago: ClaveTipo[" + lstClaveTipo + "],TipoPago[" + lstTipoPago + "]>");

                    // --Determina tipo de Pago
                    LOG.info("        [INI/FIN]. Determina tipo de Pago.");

                    String lstPromedioSuscriptores = "-1";

                    if (lstTipoPago.equalsIgnoreCase(TIPO_PAGO_ESCALA)) {
                        LOG.info("        Tipo de Pago:_" + TIPO_PAGO_ESCALA + "_");

                        // ---Determinar la fecha base para consulta desuscriptores
                        LOG.info("        [INI]. Obtener ultima fecha Carga de Suscriptores.");
                        String lstUltimaFechaCarga = procesoDAO.obtenerUltimaFechaCargaSuscriptores();
                        LOG.info("        [FIN]. Obtener ultima fecha Carga de Suscriptores. Resultado:_" + lstUltimaFechaCarga + "_");

                        if (!lstUltimaFechaCarga.equals("")) {

                            // ---Determinar la fecha base para consulta de suscriptores
                            LOG.info("        [INI]. Determinacion de fecha base consulta de suscriptores.");
                            String lstFechaBase = this.determinaFechaBaseConsultaSuscriptores(lstFechaInicioPeriodo, lstUltimaFechaCarga);
                            LOG.info("        [INI]. Determinacion de fecha base consulta de suscriptores. Fecha Base:_" + lstFechaBase + "_");

                            // --Determina Clave de Tipo
                            LOG.info("        [INI/FIN]. Determina Clave Tipo.");
                            if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_PROM_12MESES)) {

                                // --Obtener los suscriptores de acuerdo al metodo Prom12Meses
                                LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_12MESES + ".");
                                pSuscriptores.setEmpresas(lobEmpresasContrato);
                                pSuscriptores.setFechaMes(lstFechaBase);
                                lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresProm12Meses(pSuscriptores);
                                LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_12MESES + ". Resultado:_" + lstPromedioSuscriptores + "_");

                            } // Ends if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_PROM_12MESES"))
                            else if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_PROM_INIFIN)) {

                                // --Obtener los suscriptores de acuerdo al metodo PromInicioFin
                                LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_INIFIN + ".");
                                pSuscriptores.setEmpresas(lobEmpresasContrato);
                                pSuscriptores.setFechaMes(lstFechaBase);
                                lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresPromIniFin(pSuscriptores);
                                LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_INIFIN + ". Resultado:_" + lstPromedioSuscriptores + "_");

                            } // Ends else if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_PROM_INIFIN"))
                            else if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_PROM_MES_ANT)) {
                                // --Obtener los suscriptores de acuerdo al metodo PromMesAnterior
                                LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_MES_ANT + ".");
                                pSuscriptores.setEmpresas(lobEmpresasContrato);
                                pSuscriptores.setFechaMes(lstFechaBase);
                                lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresPromMesAnterior(pSuscriptores);
                                LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_PROM_MES_ANT + ". Resultado:_" + lstPromedioSuscriptores + "_");

                            } // Ends else if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_PROM_MES_ANT"))
                            else if (lstClaveTipo.equalsIgnoreCase(CVE_TIPO_MES_ACTUAL)) {
                                // --Obtener los suscriptores de acuerdo al metodo MesActual
                                LOG.info("        [INI]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_MES_ACTUAL + ".");
                                pSuscriptores.setEmpresas(lobEmpresasContrato);
                                pSuscriptores.setFechaMes(lstFechaBase);
                                lstPromedioSuscriptores = procesoDAO.obtenerSuscriptoresMesActual(pSuscriptores);
                                LOG.info("        [FIN]. Obtener promedio Suscriptores segun metodo:" + CVE_TIPO_MES_ACTUAL + ". Resultado:_" + lstPromedioSuscriptores + "_");

                            } // Ends else if(lstClaveTipo.equalsIgnoreCase("CVE_TIPO_MES_ACTUAL"))

                        } else {
                            LOG.info("No se pudo obtener la ultima fecha de carga de suscriptores.");
                        }

                    } // Ends if(lstTipoPago.equalsIgnoreCase("TIPO_PAGO_ESCALA"))
                    else if (lstTipoPago.equalsIgnoreCase(TIPO_PAGO_FLAT)) {
                        LOG.info("            Tipo de Pago:_" + TIPO_PAGO_FLAT + "_");
                        lstPromedioSuscriptores = "0";
                    } // Ends else if(lstTipoPago.equalsIgnoreCase(TIPO_PAGO_FLAT))

                    if (!lstPromedioSuscriptores.equals("-1")) {
                        // --Construye respuesta
                        resultado.setResultado(true);
                        resultado.setMensaje("OK");
                        resultado.setSuscriptores(lstPromedioSuscriptores);
                    } // Ends if(!lstPromedioSuscriptores.equals("-1"))
                    else {
                        LOG.info("No se pudieron obtener los datos de suscriptores.");

                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setMensaje("DDA-OSC-003: No se pudo obtener el dato de suscriptores.");
                        resultado.setSuscriptores("0");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }

                } // Ends if(lobTipoPago != null)
                else {
                    LOG.info("No se pudieron obtener los datos de Tipo de Pago del Contrato[" + lstIdContrato + "].");

                    // --Construye respuesta
                    resultado.setResultado(false);
                    resultado.setMensaje("DDA-OSC-002: No se pudieron obtener los datos de Tipo de Pago del Contrato.");
                    resultado.setSuscriptores("0");
                    LOG.info("Respuesta devuelta: " + resultado.toString());
                }

            } // Ends if(lobEmpresasContrato.size() > 0)
            else {
                LOG.info("No se pudieron obtener las Empresas asociadas al Contrato[" + lstIdContrato + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-OSC-001: No se pudieron obtener las Empresas asociadas al Contrato.");
                resultado.setSuscriptores("0");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerSuscriptoresContrato]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::obtenerSuscriptoresContrato] :::::::::::::::: >>");
        return resultado;
    }

    public ResponseAnnioVigenteDTO obtenerValorAnnioVigente(ParamAnnioVigenteDTO dto) throws Exception {
        ResponseAnnioVigenteDTO resultado = new ResponseAnnioVigenteDTO();
        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::obtenerValorAnnioVigente] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        /*
		try
		{
			String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
			String lstFechaMesProporcionada = (dto.getFechaMes() != null && dto.getFechaMes().trim().length() > 0) ? dto.getFechaMes() : "";
			String lstTipoAnnio = (dto.getTipoAnnio() != null && dto.getTipoAnnio().trim().length() > 0) ? dto.getTipoAnnio() : "";
		  
			//--Obtener el id del contrato original 
			LOG.info("        [INI]. Obtener id de contrato original a partir del Contrato["+lstIdContrato+"]."); 
			String lstIdContratoOriginal = procesoDAO.obtenerIdContratoOriginal(lstIdContrato); 
			LOG.info("        [FIN]. Obtener id de contrato original a partir del Contrato["+lstIdContrato+"]. Resultado:_"+lstIdContratoOriginal+"_");
		  
			if(!lstIdContratoOriginal.equals("-1")) 
			{ 
				//--Obtener detalle del Contrato Original 
				LOG.info("        [INI]. Obtener detalle del Contrato Original["+lstIdContratoOriginal+"]."); 
				ContratoDTO lobContratoOriginal = procesoDAO.obtenerDetalleContrato(lstIdContratoOriginal); 
				LOG.info("        [FIN]. Obtener detalle del Contrato Original["+lstIdContratoOriginal+"].");
				
				if(lobContratoOriginal != null) 
				{ 
					String lstFechaInicioCntOriginal = (lobContratoOriginal.getFECHA_INICIO() != null && lobContratoOriginal.getFECHA_INICIO().trim().length() > 0) ? lobContratoOriginal.getFECHA_INICIO() : ""; 
					LOG.info("        <Contrato Original: FechaInicioCntOriginal["+lstFechaInicioCntOriginal+"]>" );
		  
					//--Compara la fecha proporcionada con la fecha Inicial del Contrato Original 
					LOG.info("        [INI]. Compara fecha proporcionada["+lstFechaMesProporcionada+"] con fecha inicial["+lstFechaInicioCntOriginal+"] del Contrato Original["+lstIdContratoOriginal+"]."); 
					int lnuResultadoFechaInicial = dateManager.compararFechas(lstFechaMesProporcionada,lstFechaInicioCntOriginal); 
					LOG.info("        [FIN]. Compara fecha proporcionada["+lstFechaMesProporcionada+"] con fecha inicial["+lstFechaInicioCntOriginal+"] del Contrato Original["+lstIdContratoOriginal+"]. Resultado: _"+lnuResultadoFechaInicial+"_");
		  
					if(lnuResultadoFechaInicial == -1) 
					{ 
						lstFechaMesProporcionada = lstFechaInicioCntOriginal; 
						LOG.info("Caso: Fecha proporcionada ANTERIOR a fecha Inicial Contrato Original. Fecha proporcionada cambia a fecha Original. lstFechaMesProporcionada:["+lstFechaMesProporcionada+"]"); 
					}
			 
					//--Determina la maxima fecha final entre el Contrato Original y/o addendums/enmiendas 
					LOG.info("        [INI]. Obtener maxima fecha final entre el Contrato Original["+lstIdContratoOriginal+"] y/o adendums."); 
					String lstFechaMaxCntOriginal = procesoDAO.obtenerFechaMaximaCntOriginalAdendumEnmiendas(lstIdContratoOriginal); 
					LOG.info("        [FIN]. Obtener maxima fecha final entre el Contrato Original["+lstIdContratoOriginal+"] y/o adendums. Resultado:_"+lstFechaMaxCntOriginal+"_");
		  
					if(!lstFechaMaxCntOriginal.equals("")) 
					{ 
						//-- Compara la fecha proporcionada con la maxima fecha final obtenida del Contrato Original y sus adendums/enmiendas 
						LOG.info("        [INI]. Compara fecha proporcionada["+lstFechaMesProporcionada+"] con fecha maxima["+lstFechaMaxCntOriginal+"] del Contrato Original["+lstIdContratoOriginal+"]."); 
						int lnuResultadoFechaFinal = dateManager.compararFechas(lstFechaMesProporcionada,lstFechaMaxCntOriginal); 
						LOG.info("        [FIN]. Compara fecha proporcionada["+lstFechaMesProporcionada+"] con fecha maxima["+lstFechaMaxCntOriginal+"] del Contrato Original["+lstIdContratoOriginal+"]. Resultado:_"+lnuResultadoFechaFinal+"_");
			  
						if(lnuResultadoFechaFinal == 1) 
						{ 
							lstFechaMesProporcionada = lstFechaMaxCntOriginal; 
							LOG.info("Caso: Fecha proporcionada POSTERIOR a fecha maxima del Contrato Original. Fecha proporcionada cambia a fecha Maxima. lstFechaMesProporcionada:["+lstFechaMaxCntOriginal+"]"); 
						}
			  
						//--Obtener el ao de la fecha inicio 
						LOG.info("        [INI]. Obtener la parte annio de la fecha Inicial["+lstFechaInicioCntOriginal+"]."); 
						String lstAnnio_FInicio = dateManager.cambiarFormato(lstFechaInicioCntOriginal, "yyyy");
						LOG.info("        [FIN]. Obtener la parte annio de la fecha Inicial["+lstFechaInicioCntOriginal+"]. Resultado:_"+lstAnnio_FInicio+"_");
			  
						if(!lstAnnio_FInicio.equals("")) 
						{ 
							//--Obtener el mes de la fecha inicio 
							LOG.info("        [INI]. Obtener la parte mes de la fecha Inicial["+lstFechaInicioCntOriginal+"]."); 
							String lstMes_FInicio = dateManager.cambiarFormato(lstFechaInicioCntOriginal, "MM");
							LOG.info("        [FIN]. Obtener la parte mes de la fecha Inicial["+lstFechaInicioCntOriginal+"]. Resultado:_"+lstMes_FInicio+"_");
			  
							if(!lstMes_FInicio.equals("")) 
							{ 
								//--Obtener el annio de la fecha proporcionada 
								LOG.info("        [INI]. Obtener la parte annio de la fecha Proporcionada["+lstFechaMesProporcionada+"]."); 
								String lstAnnio_FProporcionada = dateManager.cambiarFormato(lstFechaMesProporcionada, "yyyy");
								LOG.info("        [FIN]. Obtener la parte annio de la fecha Proporcionada["+lstFechaMesProporcionada+"]. Resultado:_"+lstAnnio_FProporcionada+"_");
			  
								if(!lstAnnio_FProporcionada.equals("")) 
								{ 
									//--Obtener el mes de la fecha proporcionada 
									LOG.info("        [INI]. Obtener la parte mes de la fecha Proporcionada["+lstFechaMesProporcionada+"]."); 
									String lstMes_FProporcionada = dateManager.cambiarFormato(lstFechaMesProporcionada, "MM"); 
									LOG.info("        [INI]. Obtener la parte mes de la fecha Proporcionada["+lstFechaMesProporcionada+"]. Resultado:_"+lstMes_FProporcionada+"_");
			  
									if(!lstMes_FProporcionada.equals("")) 
									{ 
										//--Determina tipo de Annio
										LOG.info("        [INI/FIN]. Determina tipo de Annio.");
			  
										int lnuAnnio = 1;
										if(lstTipoAnnio.equalsIgnoreCase(TIPO_ANNIO_CALENDARIO)) 
										{ 
											LOG.info("        Tipo de Annio:_"+ TIPO_ANNIO_CALENDARIO+"_");
			  
											lnuAnnio = (Integer.parseInt(lstAnnio_FProporcionada, 10) - Integer.parseInt(lstAnnio_FInicio, 10)) + 1; 
										}//Ends if(lstTipoAnnio.equalsIgnoreCase(TIPO_ANNIO_CALENDARIO)) 
										else if(lstTipoAnnio.equalsIgnoreCase(TIPO_ANNIO_CONTRACTUAL)) 
										{ 
											LOG.info("        Tipo de Annio:_"+ TIPO_ANNIO_CONTRACTUAL+"_");
			  
											if(Integer.parseInt(lstMes_FProporcionada, 10) >= Integer.parseInt(lstMes_FInicio, 10)) 
											{ 
												lnuAnnio = (Integer.parseInt(lstAnnio_FProporcionada, 10) - Integer.parseInt(lstAnnio_FInicio, 10)) + 1; 
											} 
											else 
											{ 
												lnuAnnio = (Integer.parseInt(lstAnnio_FProporcionada, 10) - Integer.parseInt(lstAnnio_FInicio, 10)); 
											} 
										}//Ends else if(lstTipoAnnio.equalsIgnoreCase(TIPO_ANNIO_CONTRACTUAL)) 
										else 
										{
											lnuAnnio = 1; 
											LOG.info("        Tipo de Annio: NO DETERMINADO"); 
										}
			  
			  
										LOG.info("Annio Vigente: " + lnuAnnio);
			  
										//--Construye respuesta 
										resultado.setResultado(true);
										resultado.setAnnio(Integer.toString(lnuAnnio));
										resultado.setMensaje("OK"); 
										LOG.info("Respuesta devuelta: " + resultado.toString());
			  
									}//Ends if(!lstMes_FProporcionada.equals("")) 
									else 
									{ 
										LOG.info("No se pudo obtener la parte mes del valor actual de la Fecha Proporcionada.");
			  
										//--Construye respuesta 
										resultado.setResultado(false);
										//resultado.setAnnio(annio); 
										resultado.setMensaje("DDA-CAV-007: No se pudo obtener la parte mes del valor actual de la Fecha Proporcionada."); 
										LOG.info("Respuesta devuelta: " + resultado.toString()); 
									}
			  
								}//Ends if(!lstAnnio_FProporcionada.equals("")) 
								else 
								{ 
									LOG.info("No se pudo obtener la parte annio del valor actual de la Fecha Proporcionada.");
			  
									//--Construye respuesta 
									resultado.setResultado(false);
									//resultado.setAnnio(annio); 
									resultado.setMensaje("DDA-CAV-006: No se pudo obtener la parte annio del valor actual de la Fecha Proporcionada."); 
									LOG.info("Respuesta devuelta: " + resultado.toString()); 
								}
							}//Ends if(!lstMes_FInicio.equals("")) 
							else 
							{ 
								LOG.info("No se pudo obtener la parte mes de la Fecha Inicial del contrato original.");
			  
								//--Construye respuesta 
								resultado.setResultado(false);
								//resultado.setAnnio(annio); 
								resultado.setMensaje("DDA-CAV-005: No se pudo obtener la parte mes de la Fecha Inicial del contrato original."); 
								LOG.info("Respuesta devuelta: " + resultado.toString()); 
							}
			  
						}//Ends if(!lstAnnio_FInicio.equals("")) 
						else 
						{ 
							LOG.info("No se pudo obtener la parte annio de la Fecha Inicial del contrato original.");
			  
							//--Construye respuesta 
							resultado.setResultado(false);
							//resultado.setAnnio(annio); 
							resultado.setMensaje("DDA-CAV-004: No se pudo obtener la parte annio de la Fecha Inicial del contrato original."); 
							LOG.info("Respuesta devuelta: " + resultado.toString()); 
						}
					}//Ends if(!lstFechaMaxCntOriginal.equals("")) 
					else 
					{ 
						LOG.info("No se pudo obtener la maxima Fecha Final del contrato original ["+lstIdContratoOriginal+"] y/o adendums o enmiendas.");
			  
						//--Construye respuesta 
						resultado.setResultado(false);
						//resultado.setAnnio(annio); 
						resultado.setMensaje("DDA-CAV-003: No se pudo obtener la maxima Fecha Final del contrato original."); 
						LOG.info("Respuesta devuelta: " + resultado.toString()); 
					}
				}//Ends if(lobContratoOriginal != null) 
				else 
				{ 
					LOG.info("No se pudo obtener la Fecha de Inicio del contrato original ["+lstIdContratoOriginal+"].");
			  
					//--Construye respuesta 
					resultado.setResultado(false);
					//resultado.setAnnio(annio); 
					resultado.setMensaje("DDA-CAV-002: No se pudo obtener la Fecha de Inicio del contrato original."); 
					LOG.info("Respuesta devuelta: " + resultado.toString()); 
				}
			}//Ends if(!lstIdContratoOriginal.equals("-1")) 
			else 
			{ 
				LOG.info("No se pudo obtener el id del contrato original a partir del Contrato["+lstIdContrato+"].");
				
				//--Construye respuesta 
				resultado.setResultado(false);
				//resultado.setAnnio(annio); 
				resultado.setMensaje("DDA-CAV-001: No se pudo obtener el id del contrato original a partir del Contrato proporcionado"); 
				LOG.info("Respuesta devuelta: " + resultado.toString()); 
			}
		}
		catch(Exception e) 
		{
			LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerValorAnnioVigente]: "+e.getMessage() ); 
			StringWriter stack = new StringWriter(); 
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString()); 
			throw new Exception(e.getMessage()); 
		} 
	
		LOG.info("<< :::::::::::::::: FIN ["+this.getClass().getSimpleName()+"::obtenerValorAnnioVigente] :::::::::::::::: >>");
         */
        // --Construye respuesta tmp
        resultado.setResultado(true);
        resultado.setAnnio("1");
        resultado.setMensaje("OK");
        LOG.info("Respuesta devuelta: " + resultado.toString());
        return resultado;
    }

    public ResponseCargaTitulosDTO procesarCargaTitulos(ParamCargaTitulosDTO dto) throws Exception {
        ResponseCargaTitulosDTO resultado = new ResponseCargaTitulosDTO();
        String lstRutaBase = RUTA_BASE.replaceAll("%PROCESO%", PROCESO_CARGATITULOS);

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::procesarCargaTitulos] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstNombreArchivoExcel = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
            String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
            String lstIdListaActual = (dto.getIdListaActual() != null && dto.getIdListaActual().trim().length() > 0) ? dto.getIdListaActual() : "";
            String lstTipoLista = (dto.getTipoLista() != null && dto.getTipoLista().trim().length() > 0) ? dto.getTipoLista() : "";
            String lstTipoCarga = (dto.getTipoCarga() != null && dto.getTipoCarga().trim().length() > 0) ? dto.getTipoCarga() : "";
            String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().trim().length() > 0) ? dto.getExpediente() : "";
            String lstFechaInicioCnt = (dto.getFechaInicioContrato() != null && dto.getFechaInicioContrato().trim().length() > 0) ? dto.getFechaInicioContrato() : "";
            String lstFechaInicioLstNva = (dto.getFechaInicioListaNueva() != null && dto.getFechaInicioListaNueva().trim().length() > 0) ? dto.getFechaInicioListaNueva() : "VACIO";

            // --Verifica que exista el archivo espeficido en la ruta de carga
            LOG.info("    [INI]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "].");
            String lstRutaArchivoExcel = lstRutaBase + DIR_EXCEL + lstNombreArchivoExcel;
            File lobArchivoExcelTitulos = new File(lstRutaArchivoExcel);
            boolean boExisteArchivoTitulos = fileManager.existeArchivo(lobArchivoExcelTitulos);
            LOG.info("    [FIN]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "] en [" + lstRutaArchivoExcel + "]. Existe:_" + boExisteArchivoTitulos + "_");

            if (boExisteArchivoTitulos) {
                // --Leer el archivo excel cargado
                LOG.info("    [INI]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "].");
                ExcelReader lobER = new ExcelReader();
                lobER.leerArchivoExcelCargaTitulos(lstRutaArchivoExcel, lstNombreArchivoExcel);
                ArrayList<CargaTitulosExcelDTO> lobDatosArchivoXL = lobER.getDatosExcel();
                String lstMsjProcesoExcel = lobER.getMensaje();
                LOG.info("    [FIN]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "]. Mensaje:_" + lstMsjProcesoExcel + "_");

                if (lstMsjProcesoExcel.trim().length() == 0) {
                    // ---Generar archivo data con base en Datos del archivo Excel
                    String[] componentesNombreOriginal = lstNombreArchivoExcel.split("\\.");
                    String lstNombreArchivoSinExtension_Titulos = componentesNombreOriginal[0].toString();
                    String lstNombreArchivoData_Titulos = lstNombreArchivoSinExtension_Titulos + ".txt";
                    String lstRutaArchivoData_Titulos = lstRutaBase + DIR_DATA;

                    LOG.info("    [INI]. Generar archivo data[" + lstNombreArchivoData_Titulos + "] en [" + lstRutaArchivoData_Titulos + "].");
                    ParamArchivoSqlLdrDTO pArSqlLdr = new ParamArchivoSqlLdrDTO();
                    pArSqlLdr.setRutaArchivo(lstRutaArchivoData_Titulos);
                    pArSqlLdr.setNombreArchivo(lstNombreArchivoData_Titulos);
                    pArSqlLdr.setLobDatosXL(lobDatosArchivoXL);
                    boolean lboEscribioArData_Titulos = fileManager.escribeArchivoDataTitulos(pArSqlLdr);
                    LOG.info("    [FIN]. Generar archivo data[" + lstNombreArchivoData_Titulos + "] en [" + lstRutaArchivoData_Titulos + "]. Resultado:_" + lboEscribioArData_Titulos + "_");

                    if (lboEscribioArData_Titulos) {
                        // -- Obtener el id de la carga
                        LOG.info("    [INI]. Obtener id de la carga.");
                        String lstIdCarga = procesoDAO.obtenerSiguienteIdCarga();
                        //String lstIdCarga = "103";
                        LOG.info("    [FIN]. Obtener id de la carga. Resultado:_" + lstIdCarga + "_");

                        if (!lstIdCarga.equals("-1")) {
                            // --- Generar registro principal de carga de Titulos
                            LOG.info("    [INI]. Genera registro principal para la carga de Titulos.");
                            CargaPrincipalDTO pCargaPpal = new CargaPrincipalDTO();
                            pCargaPpal.setARCHIVO_XLSX(lstNombreArchivoExcel);
                            pCargaPpal.setEXPEDIENTE(lstExpediente);
                            pCargaPpal.setID_CARGA(lstIdCarga);
                            pCargaPpal.setID_CONTRATO(lstIdContrato);
                            pCargaPpal.setID_LISTA(lstIdListaActual);
                            pCargaPpal.setTIPO_CARGA(lstTipoCarga);
                            pCargaPpal.setTIPO_LISTA(lstTipoLista);
                            if (!lstFechaInicioLstNva.equalsIgnoreCase("VACIO")) {
                                pCargaPpal.setFECHA_INICIO_LSTNVA(dateManager.cambiarFormato(lstFechaInicioLstNva, "yyyy-MM-dd"));
                            } else {
                                pCargaPpal.setFECHA_INICIO_LSTNVA("NULL");
                            }
                            boolean lboGeneroRegPrincipalCarga = procesoDAO.insertarRegistroPrincipalCarga(pCargaPpal);
                            //boolean lboGeneroRegPrincipalCarga = true;
                            LOG.info("    [FIN]. Genera registro principal para la carga de Titulos. Resultado:_" + lboGeneroRegPrincipalCarga + "_");

                            if (lboGeneroRegPrincipalCarga) {

                                // --Ejecucion de shell para carga de Titulos
                                LOG.info("    [INI]. Ejecucion de shell para pre-carga de Titulos.");
                                String lstRutaShell_Titulos = lstRutaBase + DIR_SHELLS + SHELL_CARGA_TITULOS;
                                String lstComando_CargaTitulos = lstRutaShell_Titulos + " " + lstIdCarga + " " + lstNombreArchivoSinExtension_Titulos + " " + lstRutaBase + " " + U + " " + P + " " + INSTANCIA;
                                boolean lboResShell_CargaTitulos = false;
                                if (!AMBIENTE.equalsIgnoreCase("LOCAL")) {
                                    lboResShell_CargaTitulos = shellManager.getBooleanEjecutarShell(lstComando_CargaTitulos);
                                } else {
                                    lboResShell_CargaTitulos = true;
                                }
                                LOG.info("    [FIN]. Ejecucion de shell para pre-carga de Titulos. Resultado:_" + lboResShell_CargaTitulos + "_");

                                if (lboResShell_CargaTitulos) {
                                    // --Ejecucion de Stored Procedure para analisis de registros de Titulos
                                    LOG.info("    [INI]. Ejecucion de SP para proceso de carga de Titulos.");
                                    boolean lboResSP = procesoDAO.ejecutarSPProcesaCargaTitulos(pCargaPpal);
                                    LOG.info("    [FIN]. Ejecucion de SP para proceso de carga de Titulos.");

                                    // --Consulta resultados de carga
                                    LOG.info("    [INI]. Obtener resultados deproceso de carga de Titulos.");
                                    CargaPrincipalDTO lobResultadosCarga = procesoDAO.obtenerDatosFinalesCarga(lstIdCarga);
                                    LOG.info("    [FIN]. Obtener resultados deproceso de carga de Titulos.");

                                    if (lobResultadosCarga != null) {
                                        // ---Llamado del calculo de costo de titulos
                                        ParamValorTituloDTO pCT = new ParamValorTituloDTO();
                                        pCT.setIdContrato(lstIdContrato);
                                        pCT.setMesCalculo(lstFechaInicioCnt);
                                        pCT.setOrigenTitulos(ORIGEN_ESPEJO);
                                        ResponseValorTituloDTO lobProcCostoTitulo = this.obtenerCostoTitulo(pCT);
                                        boolean lboResCostoTitulo = false;

                                        if (lobProcCostoTitulo != null) {
                                            lboResCostoTitulo = lobProcCostoTitulo.getResultado();
                                        }

                                        // --Construye respuesta
                                        resultado.setResultado(true);
                                        resultado.setMensaje("OK");
                                        resultado.setDatosCarga(lobResultadosCarga);
                                        resultado.setResultadoCostoTitulo(lboResCostoTitulo);
                                        LOG.info("Respuesta devuelta: " + resultado.toString());

                                    } // Termina if(lobResultadosCarga != null)

                                } // Ends if(lboResShell_CargaTitulos)
                                else {
                                    LOG.info("Ocurrio un error al ejecutar el shell de precarga de Titulos.");

                                    // --Construye respuesta
                                    resultado.setResultado(false);
                                    resultado.setMensaje("DDA-PCT-005: Error en proceso.");
                                    LOG.info("Respuesta devuelta: " + resultado.toString());
                                }

                            } // Ends if(lboGeneroRegPrincipalCarga)
                            else {
                                LOG.info("No se pudo insertar el Registro Principal de Carga.");

                                // --Construye respuesta
                                resultado.setResultado(false);
                                resultado.setMensaje("DDA-PCT-004: No se pudo insertar el registro principal de Carga.");
                                LOG.info("Respuesta devuelta: " + resultado.toString());
                            }

                        } // Ends if(!lstIdCarga.equals("-1"))
                        else {
                            LOG.info("No se pudo obtener el siguiente Id de Carga.");

                            // --Construye respuesta
                            resultado.setResultado(false);
                            resultado.setMensaje("DDA-PCT-003: No se pudo obtener el siguiente id de carga.");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }

                    } // Ends if(lboEscribioArData_Titulos)
                    else {
                        LOG.info("No se pudo generar el archivo data[" + lstNombreArchivoData_Titulos + "].");

                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setMensaje("DDA-PCT-002: Error en proceso.");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }

                } // Ends if(lstMsjProcesoExcel.trim().length() == 0)

            } // Ends if(boExisteArchivoTitulos)
            else {
                LOG.info("No se encontro el archivo especificado[" + lstNombreArchivoExcel + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-PCT-001: No se pudo encontrar el archivo especificado.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::procesarCargaTitulos]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::procesarCargaTitulos] :::::::::::::::: >>");
        return resultado;
    }

    public ResponseCargaTitulosLFDTO procesarCargaTitulosLF(ParamCargaTitulosLFDTO dto) throws Exception {
        ResponseCargaTitulosLFDTO resultado = new ResponseCargaTitulosLFDTO();
        String lstRutaBase = RUTA_BASE.replaceAll("%PROCESO%", PROCESO_CARGATITULOS_LF);

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::procesarCargaTitulosLF] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstNombreArchivoExcel = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
            String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
            String lstIdListaActual = (dto.getIdListaActual() != null && dto.getIdListaActual().trim().length() > 0) ? dto.getIdListaActual() : "";
            String lstTipoLista = (dto.getTipoLista() != null && dto.getTipoLista().trim().length() > 0) ? dto.getTipoLista() : "";
            String lstTipoCarga = (dto.getTipoCarga() != null && dto.getTipoCarga().trim().length() > 0) ? dto.getTipoCarga() : "";
            String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().trim().length() > 0) ? dto.getExpediente() : "";
            String lstFechaInicioLstNva = (dto.getFechaInicioListaNueva() != null && dto.getFechaInicioListaNueva().trim().length() > 0) ? dto.getFechaInicioListaNueva() : "VACIO";

            // --Verifica que exista el archivo espeficido en la ruta de carga
            LOG.info("    [INI]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "].");
            String lstRutaArchivoExcel = lstRutaBase + DIR_EXCEL + lstNombreArchivoExcel;
            File lobArchivoExcelTitulos = new File(lstRutaArchivoExcel);
            boolean boExisteArchivoTitulos = fileManager.existeArchivo(lobArchivoExcelTitulos);
            LOG.info("    [FIN]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "] en [" + lstRutaArchivoExcel + "]. Existe:_" + boExisteArchivoTitulos + "_");

            if (boExisteArchivoTitulos) {
                //--Leer archivo excel cargado
                LOG.info("    [INI]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "].");
                ExcelReader lobER = new ExcelReader();
                lobER.leerArchivoExcelCargaTitulosLF(lstRutaArchivoExcel, lstNombreArchivoExcel);
                ArrayList<CargaTitulosExcelDTO> lobDatosArchivoXL = lobER.getLobDatosXL_LF();
                String lstMsjProcesoExcel = lobER.getMensaje();
                LOG.info("    [FIN]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "]. Mensaje:_" + lstMsjProcesoExcel + "_");

                if (lstMsjProcesoExcel.trim().length() == 0) {
                    // ---Generar archivo data con base en Datos del archivo Excel
                    String[] componentesNombreOriginal = lstNombreArchivoExcel.split("\\.");
                    String lstNombreArchivoSinExtension_TitulosLF = componentesNombreOriginal[0].toString();
                    String lstNombreArchivoData_TitulosLF = lstNombreArchivoSinExtension_TitulosLF + ".txt";
                    String lstRutaArchivoData_TitulosLF = lstRutaBase + DIR_DATA;

                    LOG.info("    [INI]. Generar archivo data[" + lstNombreArchivoData_TitulosLF + "] en [" + lstRutaArchivoData_TitulosLF + "].");
                    ParamArchivoSqlLdrDTO pArSqlLdr = new ParamArchivoSqlLdrDTO();
                    pArSqlLdr.setRutaArchivo(lstRutaArchivoData_TitulosLF);
                    pArSqlLdr.setNombreArchivo(lstNombreArchivoData_TitulosLF);
                    pArSqlLdr.setLobDatosXL_LF(lobDatosArchivoXL);
                    boolean lboEscribioArData_Titulos = fileManager.escribeArchivoDataTitulosLF(pArSqlLdr);
                    LOG.info("    [FIN]. Generar archivo data[" + lstNombreArchivoData_TitulosLF + "] en [" + lstRutaArchivoData_TitulosLF + "]. Resultado:_" + lboEscribioArData_Titulos + "_");

                    if (lboEscribioArData_Titulos) {
                        //--Obtener el id de la carga
                        LOG.info("    [INI]. Obtener id de la carga.");
                        String lstIdCarga = procesoDAO.obtenerSiguienteIdCarga();
                        // String lstIdCarga = "6";
                        LOG.info("    [FIN]. Obtener id de la carga. Resultado:_" + lstIdCarga + "_");

                        if (!lstIdCarga.equals("-1")) {
                            // --- Generar registro principal de carga de Titulos
                            LOG.info("    [INI]. Genera registro principal para la carga de TitulosLF.");
                            CargaPrincipalDTO pCargaPpal = new CargaPrincipalDTO();
                            pCargaPpal.setARCHIVO_XLSX(lstNombreArchivoExcel);
                            pCargaPpal.setEXPEDIENTE(lstExpediente);
                            pCargaPpal.setID_CARGA(lstIdCarga);
                            pCargaPpal.setID_CONTRATO(lstIdContrato);
                            pCargaPpal.setID_LISTA(lstIdListaActual);
                            pCargaPpal.setTIPO_CARGA(lstTipoCarga);
                            pCargaPpal.setTIPO_LISTA(lstTipoLista);
                            if (!lstFechaInicioLstNva.equalsIgnoreCase("VACIO")) {
                                pCargaPpal.setFECHA_INICIO_LSTNVA(dateManager.cambiarFormato(lstFechaInicioLstNva, "yyyy-MM-dd"));
                            } else {
                                pCargaPpal.setFECHA_INICIO_LSTNVA("NULL");
                            }
                            boolean lboGeneroRegPrincipalCarga = procesoDAO.insertarRegistroPrincipalCarga(pCargaPpal);
                            // boolean lboGeneroRegPrincipalCarga = true;
                            LOG.info("    [FIN]. Genera registro principal para la carga de TitulosLF. Resultado:_" + lboGeneroRegPrincipalCarga + "_");

                            if (lboGeneroRegPrincipalCarga) {
                                // --Ejecucion de shell para carga de Titulos
                                LOG.info("    [INI]. Ejecucion de shell para pre-carga de TitulosLF.");
                                String lstRutaShell_Titulos = lstRutaBase + DIR_SHELLS + SHELL_CARGA_TITULOSLF;
                                String lstComando_CargaTitulos = lstRutaShell_Titulos + " " + lstIdCarga + " " + lstNombreArchivoSinExtension_TitulosLF + " " + lstRutaBase + " " + U + " " + P + " " + INSTANCIA;
                                boolean lboResShell_CargaTitulos = false;
                                if (!AMBIENTE.equalsIgnoreCase("LOCAL")) {
                                    lboResShell_CargaTitulos = shellManager.getBooleanEjecutarShell(lstComando_CargaTitulos);
                                } else {
                                    lboResShell_CargaTitulos = true;
                                }
                                LOG.info("    [FIN]. Ejecucion de shell para pre-carga de Titulos. Resultado:_" + lboResShell_CargaTitulos + "_");

                                if (lboResShell_CargaTitulos) {
                                    // --Ejecucion de Stored Procedure para analisis de registros de Titulos
                                    LOG.info("    [INI]. Ejecucion de SP para proceso de carga de Titulos.");
                                    boolean lboResSP = procesoDAO.ejecutarSPProcesaCargaTitulosLF(pCargaPpal);
                                    LOG.info("    [FIN]. Ejecucion de SP para proceso de carga de Titulos.");

                                    // --Consulta resultados de carga
                                    LOG.info("    [INI]. Obtener resultados deproceso de carga de Titulos.");
                                    CargaPrincipalDTO lobResultadosCarga = procesoDAO.obtenerDatosFinalesCarga(lstIdCarga);
                                    LOG.info("    [FIN]. Obtener resultados deproceso de carga de Titulos.");

                                    if (lobResultadosCarga != null) {
                                        // --Construye respuesta
                                        resultado.setResultado(true);
                                        resultado.setMensaje("OK");
                                        resultado.setDatosCarga(lobResultadosCarga);
                                        LOG.info("Respuesta devuelta: " + resultado.toString());

                                    }//Ends if (lobResultadosCarga != null)

                                }//Ends if (lboResShell_CargaTitulos)
                                else {
                                    LOG.info("Ocurrio un error al ejecutar el shell de precarga de Titulos.");

                                    // --Construye respuesta
                                    resultado.setResultado(false);
                                    resultado.setMensaje("DDA-CTLF-005: Error en proceso.");
                                    LOG.info("Respuesta devuelta: " + resultado.toString());
                                }

                            }//Ends if (lboGeneroRegPrincipalCarga)
                            else {
                                LOG.info("No se pudo insertar el Registro Principal de Carga.");

                                // --Construye respuesta
                                resultado.setResultado(false);
                                resultado.setMensaje("DDA-CTLF-004: No se pudo insertar el registro principal de Carga.");
                                LOG.info("Respuesta devuelta: " + resultado.toString());
                            }

                        }//Ends if (!lstIdCarga.equals("-1"))
                        else {
                            LOG.info("No se pudo obtener el siguiente Id de Carga.");

                            // --Construye respuesta
                            resultado.setResultado(false);
                            resultado.setMensaje("DDA-CTLF-003: No se pudo obtener el siguiente id de carga.");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }
                    }//Ends if(lboEscribioArData_Titulos)
                    else {
                        LOG.info("No se pudo generar el archivo data[" + lstNombreArchivoData_TitulosLF + "].");

                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setMensaje("DDA-CTLF-002: Error en proceso.");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }
                }

            }//Ends if (boExisteArchivoTitulos)
            else {
                LOG.info("No se encontro el archivo especificado[" + lstNombreArchivoExcel + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-CTLF-001: No se pudo encontrar el archivo especificado.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::procesarCargaTitulosLF]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::procesarCargaTitulosLF] :::::::::::::::: >>");
        return resultado;
    }

    public ResponseCargaTitulosTRDTO procesarCargaTitulosTR(ParamCargaTitulosTRDTO dto) throws Exception {
        ResponseCargaTitulosTRDTO resultado = new ResponseCargaTitulosTRDTO();
        String lstRutaBase = RUTA_BASE.replaceAll("%PROCESO%", PROCESO_CARGATITULOS_TR);

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::procesarCargaTitulosTR] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());
        try {
            String lstNombreArchivoExcel = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
            String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
            String lstIdListaActual = (dto.getIdListaActual() != null && dto.getIdListaActual().trim().length() > 0) ? dto.getIdListaActual() : "";
            String lstTipoLista = (dto.getTipoLista() != null && dto.getTipoLista().trim().length() > 0) ? dto.getTipoLista() : "";
            String lstTipoCarga = (dto.getTipoCarga() != null && dto.getTipoCarga().trim().length() > 0) ? dto.getTipoCarga() : "";
            String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().trim().length() > 0) ? dto.getExpediente() : "";
            String lstFechaInicioLstNva = (dto.getFechaInicioListaNueva() != null && dto.getFechaInicioListaNueva().trim().length() > 0) ? dto.getFechaInicioListaNueva() : "VACIO";

            //--Verifica que exista el archivo especificado en la ruta de carga
            LOG.info("    [INI]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "].");
            String lstRutaArchivoExcel = lstRutaBase + DIR_EXCEL + lstNombreArchivoExcel;
            File lobArchivoExcelTitulos = new File(lstRutaArchivoExcel);
            boolean boExisteArchivoTitulos = fileManager.existeArchivo(lobArchivoExcelTitulos);
            LOG.info("    [FIN]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "] en [" + lstRutaArchivoExcel + "]. Existe:_" + boExisteArchivoTitulos + "_");

            if (boExisteArchivoTitulos) {
                //-- Leer archivo excel cargado
                LOG.info("    [INI]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "].");
                ExcelReader lobER = new ExcelReader();
                lobER.leerArchivoExcelCargaTitulosTR(lstRutaArchivoExcel, lstNombreArchivoExcel);
                ArrayList<CargaTitulosTRExcelDTO> lobDatosArchivoXL = lobER.getLobDatosXL_TR();
                String lstMsjProcesoExcel = lobER.getMensaje();
                LOG.info("    [FIN]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "]. Mensaje:_" + lstMsjProcesoExcel + "_");

                if (lstMsjProcesoExcel.trim().length() == 0) {
                    //--Generar archivo data con base en los datos del archivo Excel
                    String[] componentesNombreOriginal = lstNombreArchivoExcel.split("\\.");
                    String lstNombreArchivoSinExtension_TitulosTR = componentesNombreOriginal[0].toString();
                    String lstNombreArchivoData_TitulosTR = lstNombreArchivoSinExtension_TitulosTR + ".txt";
                    String lstRutaArchivoData_TitulosTR = lstRutaBase + DIR_DATA;

                    LOG.info("    [INI]. Generar archivo data[" + lstNombreArchivoData_TitulosTR + "] en [" + lstRutaArchivoData_TitulosTR + "].");
                    ParamArchivoSqlLdrDTO pArSqlLdr = new ParamArchivoSqlLdrDTO();
                    pArSqlLdr.setRutaArchivo(lstRutaArchivoData_TitulosTR);
                    pArSqlLdr.setNombreArchivo(lstNombreArchivoData_TitulosTR);
                    pArSqlLdr.setLobDatosXL_TR(lobDatosArchivoXL);
                    boolean lboEscribioArData_Titulos = fileManager.escribeArchivoDataTitulosTR(pArSqlLdr);
                    LOG.info("    [FIN]. Generar archivo data[" + lstNombreArchivoData_TitulosTR + "] en [" + lstRutaArchivoData_TitulosTR + "]. Resultado:_" + lboEscribioArData_Titulos + "_");

                    if (lboEscribioArData_Titulos) {
                        //--Obtener el id de la carga TR
                        LOG.info("    [INI]. Obtener id de la carga .");
                        String lstIdCarga = procesoDAO.obtenerSiguienteIdCargaTR();
                        //String lstIdCarga = "2";
                        LOG.info("    [FIN]. Obtener id de la carga. Resultado:_" + lstIdCarga + "_");

                        if (!lstIdCarga.equals("-1")) {
                            // --- Generar registro principal de carga de Titulos
                            LOG.info("    [INI]. Genera registro principal para la carga de TitulosTR.");

                            CargaPrincipalTRDTO pCargaPpal = new CargaPrincipalTRDTO();
                            pCargaPpal.setARCHIVO_XLSX(lstNombreArchivoExcel);
                            pCargaPpal.setEXPEDIENTE(lstExpediente);
                            pCargaPpal.setID_CARGA(lstIdCarga);
                            pCargaPpal.setID_CONTRATO(lstIdContrato);
                            pCargaPpal.setID_LISTA(lstIdListaActual);
                            pCargaPpal.setTIPO_CARGA(lstTipoCarga);
                            pCargaPpal.setTIPO_LISTA(lstTipoLista);
                            if (!lstFechaInicioLstNva.equalsIgnoreCase("VACIO")) {
                                pCargaPpal.setFECHA_INICIO_LSTNVA(dateManager.cambiarFormato(lstFechaInicioLstNva, "yyyy-MM-dd"));
                            } else {
                                pCargaPpal.setFECHA_INICIO_LSTNVA("NULL");
                            }

                            boolean lboGeneroRegPrincipalCarga = procesoDAO.insertarRegistroPrincipalCargaTR(pCargaPpal);

                            //boolean lboGeneroRegPrincipalCarga = true;
                            LOG.info("    [FIN]. Genera registro principal para la carga de TitulosTR. Resultado:_" + lboGeneroRegPrincipalCarga + "_");

                            if (lboGeneroRegPrincipalCarga) {

                                //--Ejecucion de shell para la carga de los Titulos
                                LOG.info("    [INI]. Ejecucion de shell para pre-carga de TitulosTR.");
                                String lstRutaShell_Titulos = lstRutaBase + DIR_SHELLS + SHELL_CARGA_TITULOSTR;
                                String lstComando_CargaTitulos = lstRutaShell_Titulos + " " + lstIdCarga + " " + lstNombreArchivoSinExtension_TitulosTR + " " + lstRutaBase + " " + U + " " + P + " " + INSTANCIA;
                                boolean lboResShell_CargaTitulos = false;
                                if (!AMBIENTE.equalsIgnoreCase("LOCAL")) {
                                    lboResShell_CargaTitulos = shellManager.getBooleanEjecutarShell(lstComando_CargaTitulos);
                                } else {
                                    lboResShell_CargaTitulos = true;
                                }
                                LOG.info("    [FIN]. Ejecucion de shell para pre-carga de TitulosTR. Resultado:_" + lboResShell_CargaTitulos + "_");

                                if (lboResShell_CargaTitulos) {

                                    //--Ejecucion de Stored Procedure para analisis de registros de pre-carga de Titulos TR
                                    LOG.info("    [INI]. Ejecucion de SP para proceso de carga de TitulosTR.");
                                    boolean lboResSPTR = procesoDAO.ejecutarSPProcesaCargaTitulosTR(pCargaPpal);
                                    LOG.info("    [FIN]. Ejecucion de SP para proceso de carga de TitulosTR.");

                                    //--Consulta resultados de carga
                                    LOG.info("    [INI]. Obtener resultados deproceso de carga de TitulosTR.");
                                    CargaPrincipalTRDTO lobResultadosCarga = procesoDAO.obtenerDatosFinalesCargaTR(lstIdCarga);
                                    LOG.info("    [FIN]. Obtener resultados deproceso de carga de TitulosTR.");

                                    if (lobResultadosCarga != null) {

                                        // --Construye respuesta
                                        resultado.setResultado(true);
                                        resultado.setMensaje("OK");
                                        resultado.setDatosCarga(lobResultadosCarga);
                                        LOG.info("Respuesta devuelta: " + resultado.toString());

                                    } // Termina if(lobResultadosCarga != null)

                                }//End if(lboResShell_CargaTitulos)
                                else {
                                    LOG.info("Ocurrio un error al ejecutar el shell de precarga de Titulos.");

                                    // --Construye respuesta
                                    resultado.setResultado(false);
                                    resultado.setMensaje("DDA-CTTR-005: Error en proceso.");
                                    LOG.info("Respuesta devuelta: " + resultado.toString());
                                }

                            }//Ends if (lboGeneroRegPrincipalCarga)
                            else {
                                LOG.info("No se pudo insertar el Registro Principal de Carga.");

                                // --Construye respuesta
                                resultado.setResultado(false);
                                resultado.setMensaje("DDA-CTTR-004: No se pudo insertar el registro principal de Carga.");
                                LOG.info("Respuesta devuelta: " + resultado.toString());
                            }

                        }//Ends if (!lstIdCarga.equals("-1"))
                        else {
                            LOG.info("No se pudo obtener el siguiente Id de Carga.");

                            // --Construye respuesta
                            resultado.setResultado(false);
                            resultado.setMensaje("DDA-CTTR-003: No se pudo obtener el siguiente id de carga.");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }

                    }//Ends if(lboEscribioArData_Titulos)
                    else {
                        LOG.info("No se pudo generar el archivo data[" + lstNombreArchivoData_TitulosTR + "].");

                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setMensaje("DDA-CTTR-002: Error en proceso.");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }

                }//Ends if (lstMsjProcesoExcel.trim().length() == 0)

            }//Ends if (boExisteArchivoTitulos)
            else {
                LOG.info("No se encontro el archivo especificado[" + lstNombreArchivoExcel + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-CTTR-001: No se pudo encontrar el archivo especificado.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::procesarCargaTitulosTR]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::procesarCargaTitulosTR] :::::::::::::::: >>");
        return resultado;
    }

    public ResponseCargaTitulosPNDTO procesarCargaTitulosPN(ParamCargaTitulosPNDTO dto) throws Exception {
        ResponseCargaTitulosPNDTO resultado = new ResponseCargaTitulosPNDTO();
        String lstRutaBase = RUTA_BASE.replaceAll("%PROCESO%", PROCESO_CARGATITULOS_PN);

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::procesarCargaTitulosPN] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstNombreArchivoExcel = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
            String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().trim().length() > 0) ? dto.getExpediente() : "";
            String lstIdCargaTransacciones = (dto.getIdCargaTransacciones() != null && dto.getIdCargaTransacciones().trim().length() > 0) ? dto.getIdCargaTransacciones() : "";

            //--Verifica que exista el archivo especificado en la ruta de carga
            LOG.info("    [INI]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "].");
            String lstRutaArchivoExcel = lstRutaBase + DIR_EXCEL + lstNombreArchivoExcel;
            File lobArchivoExcelTitulos = new File(lstRutaArchivoExcel);
            boolean boExisteArchivoTitulos = fileManager.existeArchivo(lobArchivoExcelTitulos);
            LOG.info("    [FIN]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "] en [" + lstRutaArchivoExcel + "]. Existe:_" + boExisteArchivoTitulos + "_");

            if (boExisteArchivoTitulos) {
                //-- Leer archivo excel cargado
                LOG.info("    [INI]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "].");
                ExcelReader lobER = new ExcelReader();
                lobER.leerArchivoExcelCargaTitulosPN(lstRutaArchivoExcel, lstNombreArchivoExcel);
                ArrayList<CargaTitulosPNExcelDTO> lobDatosArchivoXL = lobER.getLobDatosXL_PN();
                String lstMsjProcesoExcel = lobER.getMensaje();
                LOG.info("    [FIN]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "]. Mensaje:_" + lstMsjProcesoExcel + "_");

                if (lstMsjProcesoExcel.trim().length() == 0) {
                    //--Generar archivo data con base en los datos del archivo Excel
                    String[] componentesNombreOriginal = lstNombreArchivoExcel.split("\\.");
                    String lstNombreArchivoSinExtension_TitulosPN = componentesNombreOriginal[0].toString();
                    String lstNombreArchivoData_TitulosPN = lstNombreArchivoSinExtension_TitulosPN + ".txt";
                    String lstRutaArchivoData_TitulosPN = lstRutaBase + DIR_DATA;

                    LOG.info("    [INI]. Generar archivo data[" + lstNombreArchivoData_TitulosPN + "] en [" + lstRutaArchivoData_TitulosPN + "].");
                    ParamArchivoSqlLdrDTO pArSqlLdr = new ParamArchivoSqlLdrDTO();
                    pArSqlLdr.setRutaArchivo(lstRutaArchivoData_TitulosPN);
                    pArSqlLdr.setNombreArchivo(lstNombreArchivoData_TitulosPN);
                    pArSqlLdr.setLobDatosXL_PN(lobDatosArchivoXL);
                    boolean lboEscribioArData_Titulos = fileManager.escribeArchivoDataTitulosPN(pArSqlLdr);
                    LOG.info("    [FIN]. Generar archivo data[" + lstNombreArchivoData_TitulosPN + "] en [" + lstRutaArchivoData_TitulosPN + "]. Resultado:_" + lboEscribioArData_Titulos + "_");

                    if (lboEscribioArData_Titulos) {
                        //--Obtener el id de la carga PN
                        LOG.info("    [INI]. Obtener id de la carga .");
                        String lstIdCarga = procesoDAO.obtenerSiguienteIdCargaPN();
                        //String lstIdCarga = "1";
                        LOG.info("    [FIN]. Obtener id de la carga. Resultado:_" + lstIdCarga + "_");

                        if (!lstIdCarga.equals("-1")) {

                            // --- Generar registro principal de carga de Titulos
                            LOG.info("    [INI]. Genera registro principal para la carga de TitulosPN.");

                            CargaPrincipalPNDTO pCargaPpal = new CargaPrincipalPNDTO();
                            pCargaPpal.setARCHIVO_XLSX(lstNombreArchivoExcel);
                            pCargaPpal.setEXPEDIENTE(lstExpediente);
                            pCargaPpal.setID_CARGA(lstIdCarga);

                            boolean lboGeneroRegPrincipalCarga = procesoDAO.insertarRegistroPrincipalCargaPN(pCargaPpal);
                            //boolean lboGeneroRegPrincipalCarga = true;
                            LOG.info("    [FIN]. Genera registro principal para la carga de TitulosPN. Resultado:_" + lboGeneroRegPrincipalCarga + "_");

                            if (lboGeneroRegPrincipalCarga) {
                                //--Ejecucion de shell para la carga de los Titulos
                                LOG.info("    [INI]. Ejecucion de shell para pre-carga de TitulosPN.");
                                String lstRutaShell_Titulos = lstRutaBase + DIR_SHELLS + SHELL_CARGA_TITULOSPN;
                                String lstComando_CargaTitulos = lstRutaShell_Titulos + " " + lstIdCarga + " " + lstNombreArchivoSinExtension_TitulosPN + " " + lstRutaBase + " " + U + " " + P + " " + INSTANCIA;
                                boolean lboResShell_CargaTitulos = false;
                                if (!AMBIENTE.equalsIgnoreCase("LOCAL")) {
                                    lboResShell_CargaTitulos = shellManager.getBooleanEjecutarShell(lstComando_CargaTitulos);
                                } else {
                                    lboResShell_CargaTitulos = true;
                                }
                                LOG.info("    [FIN]. Ejecucion de shell para pre-carga de TitulosPN. Resultado:_" + lboResShell_CargaTitulos + "_");

                                if (lboResShell_CargaTitulos) {
                                    //--Ejecucion de Stored Procedure para analisis de registros de pre-carga de Titulos PN
                                    LOG.info("    [INI]. Ejecucion de SP para proceso de carga de TitulosPN.");
                                    ParamSP_CargaTitulosPNDTO paramSP = new ParamSP_CargaTitulosPNDTO();
                                    paramSP.setIdCargaPN(lstIdCarga);
                                    paramSP.setIdCargaTransacciones(lstIdCargaTransacciones);
                                    LOG.debug("Parametros SP PN enviados: " + paramSP.toString());

                                    boolean lboResSPPN = procesoDAO.ejecutarSPProcesaCargaTitulosPN(paramSP);
                                    LOG.info("    [FIN]. Ejecucion de SP para proceso de carga de TitulosPN.");

                                    //--Consulta resultados de la carga
                                    LOG.info("    [INI]. Obtener resultados de proceso de carga de TitulosPN.");
                                    CargaPrincipalPNDTO lobResultadosCarga = procesoDAO.obtenerDatosFinalesCargaPN(lstIdCarga);
                                    LOG.info("    [FIN]. Obtener resultados de proceso de carga de TitulosPN.");

                                    if (lobResultadosCarga != null) {
                                        //--Construye respuesta
                                        resultado.setResultado(false);
                                        resultado.setMensaje("OK");
                                        resultado.setDatosCarga(lobResultadosCarga);
                                        LOG.info("Respuesta devuelta: " + resultado.toString());
                                    }//Termina if(lobResultadosCarga != null)

                                }//Ends if(lboResShell_CargaTitulos)
                                else {
                                    LOG.info("Ocurrio un error al ejecutar el shell de precarga de Titulos.");

                                    // --Construye respuesta
                                    resultado.setResultado(false);
                                    resultado.setMensaje("DDA-CTPN-005: Error en proceso.");
                                    LOG.info("Respuesta devuelta: " + resultado.toString());
                                }

                            }//Ends if (lboGeneroRegPrincipalCarga)
                            else {
                                LOG.info("No se pudo insertar el Registro Principal de Carga.");

                                // --Construye respuesta
                                resultado.setResultado(false);
                                resultado.setMensaje("DDA-CTPN-004: No se pudo insertar el registro principal de Carga.");
                                LOG.info("Respuesta devuelta: " + resultado.toString());
                            }
                        }//Ends if (!lstIdCarga.equals("-1"))
                        else {
                            LOG.info("No se pudo obtener el siguiente Id de Carga.");

                            // --Construye respuesta
                            resultado.setResultado(false);
                            resultado.setMensaje("DDA-CTPN-003: No se pudo obtener el siguiente id de carga.");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }
                    } else {
                        LOG.info("No se pudo generar el archivo data[" + lstNombreArchivoData_TitulosPN + "].");

                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setMensaje("DDA-CTPN-002: Error en proceso.");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }

                }//Termina if(lstMsjProcesoExcel.trim().length() == 0)
            } else {
                LOG.info("No se encontro el archivo especificado[" + lstNombreArchivoExcel + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-CTPN-001: No se pudo encontrar el archivo especificado.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::procesarCargaTitulosPN]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::procesarCargaTitulosPN] :::::::::::::::: >>");
        return resultado;

    }

    public ResponseCargaTitulosVSDTO procesarCargaTitulosVS(ParamCargaTitulosVSDTO dto) throws Exception {
        ResponseCargaTitulosVSDTO resultado = new ResponseCargaTitulosVSDTO();
        String lstRutaBase = RUTA_BASE.replaceAll("%PROCESO%", PROCESO_CARGATITULOSVS);

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::procesarCargaTitulosVS] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());
        try {
            String lstNombreArchivoExcel = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
            String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().trim().length() > 0) ? dto.getExpediente() : "";
            String lstMesCarga = (dto.getMesCarga() != null && dto.getMesCarga().trim().length() > 0) ? dto.getMesCarga() : "";

            //--Verifica que exista el archivo especificado en la ruta de carga
            LOG.info("    [INI]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "].");
            String lstRutaArchivoExcel = lstRutaBase + DIR_EXCEL + lstNombreArchivoExcel;
            File lobArchivoExcelVisualizaciones = new File(lstRutaArchivoExcel);
            boolean boExisteArchivoVisualizaciones = fileManager.existeArchivo(lobArchivoExcelVisualizaciones);
            LOG.info("    [FIN]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "] en [" + lstRutaArchivoExcel + "]. Existe:_" + boExisteArchivoVisualizaciones + "_");

            if (boExisteArchivoVisualizaciones) {
                //-- Leer archivo excel cargado
                LOG.info("    [INI]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "].");
                ExcelReader lobER = new ExcelReader();
                lobER.leerArchivoExcelCargaVS(lstRutaArchivoExcel, lstNombreArchivoExcel);
                ArrayList<CargaTitulosVSExcelDTO> lobDatosArchivoXL = lobER.getLobDatosXL_VS();
                String lstMsjProcesoExcel = lobER.getMensaje();
                LOG.info("    [FIN]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "]. Mensaje:_" + lstMsjProcesoExcel + "_");

                if (lstMsjProcesoExcel.trim().length() == 0) {
                    //--Generar archivo data con base en los datos del archivo Excel
                    String[] componentesNombreOriginal = lstNombreArchivoExcel.split("\\.");
                    String lstNombreArchivoSinExtension_TitulosVS = componentesNombreOriginal[0].toString();
                    String lstNombreArchivoData_TitulosVS = lstNombreArchivoSinExtension_TitulosVS + ".txt";
                    String lstRutaArchivoData_TitulosVS = lstRutaBase + DIR_DATA;

                    LOG.info("    [INI]. Generar archivo data[" + lstNombreArchivoData_TitulosVS + "] en [" + lstRutaArchivoData_TitulosVS + "].");
                    ParamArchivoSqlLdrDTO pArSqlLdr = new ParamArchivoSqlLdrDTO();
                    pArSqlLdr.setRutaArchivo(lstRutaArchivoData_TitulosVS);
                    pArSqlLdr.setNombreArchivo(lstNombreArchivoData_TitulosVS);
                    pArSqlLdr.setLobDatosXL_VS(lobDatosArchivoXL);
                    boolean lboEscribioArData_VS = fileManager.escribeArchivoDataTitulosVS(pArSqlLdr);
                    LOG.info("    [FIN]. Generar archivo data[" + lstNombreArchivoData_TitulosVS + "] en [" + lstRutaArchivoData_TitulosVS + "]. Resultado:_" + lboEscribioArData_VS + "_");

                    if (lboEscribioArData_VS) {
                        //--Obtener el id de la carga VS
                        LOG.info("    [INI]. Obtener id de la carga .");
                        String lstIdCarga = procesoDAO.obtenerSiguienteIdCargaVS();
                        //String lstIdCarga = "3";
                        LOG.info("    [FIN]. Obtener id de la carga. Resultado:_" + lstIdCarga + "_");

                        if (!lstIdCarga.equals("-1")) {
                            // --- Generar registro principal de carga de Titulos
                            LOG.info("    [INI]. Genera registro principal para la carga de TitulosVS.");
                            CargaPrincipalVSDTO pCargaPpal = new CargaPrincipalVSDTO();
                            pCargaPpal.setARCHIVO_XLSX(lstNombreArchivoExcel);
                            pCargaPpal.setEXPEDIENTE(lstExpediente);
                            pCargaPpal.setID_CARGA(lstIdCarga);
                            pCargaPpal.setMES(dateManager.cambiarFormato(lstMesCarga, "yyyy-MM-dd"));

                            boolean lboGeneroRegPrincipalCarga = procesoDAO.insertarRegistroPrincipalCargaVS(pCargaPpal);
                            //boolean lboGeneroRegPrincipalCarga = true;
                            LOG.info("    [FIN]. Genera registro principal para la carga de TitulosVS. Resultado:_" + lboGeneroRegPrincipalCarga + "_");

                            if (lboGeneroRegPrincipalCarga) {
                                //--Ejecucion de shell para la carga de los Titulos
                                LOG.info("    [INI]. Ejecucion de shell para pre-carga de TitulosVS.");
                                String lstRutaShell_Titulos = lstRutaBase + DIR_SHELLS + SHELL_CARGA_TITULOSVS;
                                String lstComando_CargaTitulos = lstRutaShell_Titulos + " " + lstIdCarga + " " + lstNombreArchivoSinExtension_TitulosVS + " " + lstRutaBase + " " + U + " " + P + " " + INSTANCIA;
                                boolean lboResShell_CargaTitulos = false;
                                if (!AMBIENTE.equalsIgnoreCase("LOCAL")) {
                                    lboResShell_CargaTitulos = shellManager.getBooleanEjecutarShell(lstComando_CargaTitulos);
                                } else {
                                    lboResShell_CargaTitulos = true;
                                }
                                LOG.info("    [FIN]. Ejecucion de shell para pre-carga de TitulosTR. Resultado:_" + lboResShell_CargaTitulos + "_");

                                if (lboResShell_CargaTitulos) {
                                    //--Ejecucion de Stored Procedure para analisis de registros de pre-carga de Titulos VS
                                    LOG.info("    [INI]. Ejecucion de SP para proceso de carga de TitulosVS.");
                                    boolean lboResSPTR = procesoDAO.ejecutarSPProcesaCargaTitulosVS(pCargaPpal);
                                    LOG.info("    [FIN]. Ejecucion de SP para proceso de carga de TitulosVS.");

                                    //--Consulta resultados de la carga
                                    LOG.info("    [INI]. Obtener resultados deproceso de carga de TitulosVS.");
                                    CargaPrincipalVSDTO lobResultadosCarga = procesoDAO.obtenerDatosFinalesCargaVS(lstIdCarga);
                                    LOG.info("    [FIN]. Obtener resultados deproceso de carga de TitulosVS.");

                                    if (lobResultadosCarga != null) {

                                        // --Construye respuesta
                                        resultado.setResultado(true);
                                        resultado.setMensaje("OK");
                                        resultado.setDatosCarga(lobResultadosCarga);
                                        LOG.info("Respuesta devuelta: " + resultado.toString());

                                    } // Termina if(lobResultadosCarga != null)

                                }//End if(lboResShell_CargaTitulos)
                                else {
                                    LOG.info("Ocurrio un error al ejecutar el shell de precarga de Titulos.");

                                    // --Construye respuesta
                                    resultado.setResultado(false);
                                    resultado.setMensaje("DDA-CVS-005: Error en proceso.");
                                    LOG.info("Respuesta devuelta: " + resultado.toString());
                                }
                            }//Ends if (lboGeneroRegPrincipalCarga)
                            else {
                                LOG.info("No se pudo insertar el Registro Principal de Carga.");

                                // --Construye respuesta
                                resultado.setResultado(false);
                                resultado.setMensaje("DDA-CVS-004: No se pudo insertar el registro principal de Carga.");
                                LOG.info("Respuesta devuelta: " + resultado.toString());
                            }

                        }//Ends if (!lstIdCarga.equals("-1"))
                        else {
                            LOG.info("No se pudo obtener el siguiente Id de Carga.");

                            // --Construye respuesta
                            resultado.setResultado(false);
                            resultado.setMensaje("DDA-CVS-003: No se pudo obtener el siguiente id de carga.");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }

                    }//Ends if(lboEscribioArData_VS)
                    else {
                        LOG.info("No se pudo generar el archivo data[" + lstNombreArchivoData_TitulosVS + "].");

                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setMensaje("DDA-CVS-002: Error en proceso.");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }

                }//Ends if (lstMsjProcesoExcel.trim().length() == 0)

            }//Ends if (boExisteArchivoVisualizaciones)
            else {
                LOG.info("No se encontro el archivo especificado[" + lstNombreArchivoExcel + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-CVS-001: No se pudo encontrar el archivo especificado.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::procesarCargaTitulosVS]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::procesarCargaTitulosVS] :::::::::::::::: >>");
        return resultado;
    }

    public ResponseCalcAmortCntDTO calcularAmortizacionPorContrato(ParamCalcAmortCntDTO dto) throws Exception {

        /*
		ResponseCalcAmortCntDTO resultado = new ResponseCalcAmortCntDTO();

		LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName()+ "::calcularAmortizacionPorContrato] :::::::::::::::: >>");
		LOG.info("     -->  Parametros: " + dto.toString());

		try 
		{

			String lstIdContratoPpal = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";

			//--Consultar todos los titulos del contrato (Sin excepcion o filtro alguno)
			LOG.info("    [INI]. Consulta de los titulos Contrato[" + lstIdContratoPpal + "].");
			List<ContratoTituloDTO> lobTitulosCnt = procesoDAO.obtenerTitulosPorContratoAmortizacion(lstIdContratoPpal);
			LOG.info("    [FIN]. Consulta de los titulos Contrato[" + lstIdContratoPpal + "]. Contratos encontrados:_"+lobTitulosCnt.size()+"_");
			
			//--Eliminacion de amortizacin previa del contrato
			LOG.info("    [INI]. Eliminacion de amortizacion previa del Contrato[" + lstIdContratoPpal + "].");
			boolean lboEliminacionAmortPrevia = this.limpiaRegistrosAmortizacionPrevia(lstIdContratoPpal);
			LOG.info("    [FIN]. Eliminacion de amortizacion previa del Contrato[" + lstIdContratoPpal + "]. Resultado:_"+lboEliminacionAmortPrevia+"_");
			
			if(lboEliminacionAmortPrevia)
			{
				//-- Recorrido de los titulos asociados al contrato.
				int lnuTotalTitulos = lobTitulosCnt.size();
				
				LOG.info("    [INI]. Inicia recorrido de los Titulos asociados al contrato ["+lstIdContratoPpal+"].");
				for(int xTitulo = 0; xTitulo < lnuTotalTitulos; xTitulo++)
				{
					ContratoTituloDTO lobTitulo = (ContratoTituloDTO)lobTitulosCnt.get(xTitulo); 
					String lstIdTituloCnt = (lobTitulo.getID_TITULO_CNT() != null && lobTitulo.getID_TITULO_CNT().trim().length() > 0) ? lobTitulo.getID_TITULO_CNT() : "";
					String lstCosto = (lobTitulo.getCOSTO() != null && lobTitulo.getCOSTO().trim().length() > 0) ? lobTitulo.getCOSTO() : "";
					String lstMesesVU = (lobTitulo.getMESES_VU() != null && lobTitulo.getMESES_VU().trim().length() > 0) ? lobTitulo.getMESES_VU() : "";
					String lstFechaInicio = (lobTitulo.getFECHA_INICIO() != null && lobTitulo.getFECHA_INICIO().trim().length() > 0) ? lobTitulo.getFECHA_INICIO() : "";
					
					LOG.info("     ");
					LOG.info("        <Registro:[" + xTitulo + "], IdTituloCnt:[" + lstIdTituloCnt + "], Costo:["+lstCosto+"], MesesVU:["+lstMesesVU+"], FechaIni:["+lstFechaInicio+"]>");
					
					//--Determinar monto mensual
					LOG.info("            [INI]. Obtener Costo Mensual.");
					String lstMontoMensual = this.obtenerCostoMensualAmortizacion(lstCosto, lstMesesVU);
					LOG.info("            [FIN]. Obtener Costo Mensual. Resultado:_"+ lstMontoMensual + "_");
					
					//--Insertar amortizacin previa. (Meses de amortizacin del titulo a partir del mes de la fecha de inicio)
					LOG.info("            [INI]. Insertar amortizacion previa a partir de ["+lstFechaInicio+"].");
					AmortizacionPreviaDTO amortPrevia = new AmortizacionPreviaDTO();
					amortPrevia.setID_CONTRATO(lstIdContratoPpal);
					amortPrevia.setID_TITULO_CNT(lstIdTituloCnt);
					amortPrevia.setMES(lstFechaInicio);
					amortPrevia.setMONTO(lstMontoMensual);
					
					boolean lboRegAmortPrevia = procesoDAO.registrarAmortizacionPrevia(amortPrevia,lstMesesVU);
					LOG.info("            [FIN]. Insertar amortizacion previa a partir de ["+lstFechaInicio+"]. Resultado:_"+lboRegAmortPrevia+"_");
					
					if(!lboRegAmortPrevia)
					{
						
						LOG.info("Ocurrio un error al insertar la amortizacin previa del titulo["+lstIdTituloCnt+"] del contrato["+lstIdContratoPpal+"] para el mes["+lstFechaInicio+"].");

						// --Construye respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-CAPC-004: No se pudo insertar la amortizacion previa del contrato "+lstIdContratoPpal+".");
						LOG.info("Respuesta devuelta: " + resultado.toString());
						
						break;
					}//End if(!lboRegAmortPrevia)
					
					
				}//Ends for(int xTitulo = 0; xTitulo < lnuTotalTitulos; xTitulo++)
				LOG.info("    [FIN]. Inicia recorrido de los Titulos asociados al contrato ["+lstIdContratoPpal+"].");
				
				//--Eliminacion de la amortizacion anual previa del contrato
				LOG.info("    [INI]. Borrado de registros de Amortizacion Anual previa para el contrato["+ lstIdContratoPpal + "] .");
				boolean lboEliminarAmortizacionPresupuesto = this.limpiaRegistrosAmortizacionAnualPrevios(lstIdContratoPpal);
				LOG.info("    [FIN]. Borrado de registros de Amortizacion Anual previa para el contrato["+ lstIdContratoPpal + "] .");
				
				if(lboEliminarAmortizacionPresupuesto)
				{
					//--Insercion de la amortizacion anual del contrato
					LOG.info("    [INI]. Registro de Amortizacion Anual para el contrato["+ lstIdContratoPpal + "].");
					boolean lboInsAmortAnual = procesoDAO.registrarAmortizacionAnual(lstIdContratoPpal);
					LOG.info("    [FIN]. Registro de Amortizacion Anual para el contrato["+ lstIdContratoPpal + "]. Resultado:_"+lboInsAmortAnual+"_");
					
					if(lboInsAmortAnual)
					{
						// --Construye respuesta
						resultado.setResultado(true);
						resultado.setMensaje("OK");
						LOG.info("Respuesta devuelta: " + resultado.toString());
					}//End if(lboInsAmortAnual)
					else
					{
						LOG.info("No se pudo registrar la amortizacion Anual para el Contrato ["+lstIdContratoPpal+"].");

						// --Construye respuesta
						resultado.setResultado(false);
						resultado.setMensaje("DDA-CAPC-003: No se pudo registrar la amortizacion anual del contrato "+lstIdContratoPpal+".");
						LOG.info("Respuesta devuelta: " + resultado.toString());
					}
					
				}//Ends if(lboEliminarAmortizacionPresupuesto)
				else
				{
					LOG.info("No se pudo eliminar la amortizacion Anual para el Contrato ["+lstIdContratoPpal+"].");

					// --Construye respuesta
					resultado.setResultado(false);
					resultado.setMensaje("DDA-CAPC-002: No se pudo eliminar la amortizacion anual del contrato "+lstIdContratoPpal+".");
					LOG.info("Respuesta devuelta: " + resultado.toString());
				}
				
			}//Termina if(lboEliminacionAmortPrevia)
			else
			{
				LOG.info("No se pudieron eliminar los registros de amortizacion previa del contrato [" + lstIdContratoPpal + "].");

				// --Construye respuesta
				resultado.setResultado(false);
				resultado.setMensaje("DDA-CAPC-001: No se pudo encontrar el archivo especificado.");
				LOG.info("Respuesta devuelta: " + resultado.toString());
				
			}

		} 
		catch (Exception e) 
		{
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::calcularAmortizacionPorContrato]: "+ e.getMessage());
			StringWriter stack = new StringWriter();
			e.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			throw new Exception(e.getMessage());
		}
		LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName()+ "::calcularAmortizacionPorContrato] :::::::::::::::: >>");
		return resultado;
		
         */
        /**
         * **
         * Se manda llamar el SP porque en 3000 registros el WS se tarda mas de
         * 1 min en responder ejecutandolo en SP los 3000 registros tarda 7seg
         * en responder
         */
        ResponseCalcAmortCntDTO resultado = new ResponseCalcAmortCntDTO();

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::calcularAmortizacionPorContrato] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";

            // --Ejecucion de Stored Procedure para asociacion de Titulos Transaccionales a Contratos Vigentes
            LOG.info("    [INI]. Ejecucion de SP para proceso de amortizacion previa.");
            boolean lboResSP = procesoDAO.ejecutarSPAmortizacionPrevia(lstIdContrato);
            LOG.info("    [FIN]. Ejecucion de SP para proceso de amortizacion previa. Ejecuto?:_" + lboResSP + "_");

            //--Eliminacion de la amortizacion anual previa del contrato
            LOG.info("    [INI]. Borrado de registros de Amortizacion Anual previa para el contrato[" + lstIdContrato + "] .");
            boolean lboEliminarAmortizacionPresupuesto = this.limpiaRegistrosAmortizacionAnualPrevios(lstIdContrato);
            LOG.info("    [FIN]. Borrado de registros de Amortizacion Anual previa para el contrato[" + lstIdContrato + "] .");

            if (lboEliminarAmortizacionPresupuesto) {
                //--Insercion de la amortizacion anual del contrato
                LOG.info("    [INI]. Registro de Amortizacion Anual para el contrato[" + lstIdContrato + "].");
                boolean lboInsAmortAnual = procesoDAO.registrarAmortizacionAnual(lstIdContrato);
                LOG.info("    [FIN]. Registro de Amortizacion Anual para el contrato[" + lstIdContrato + "]. Resultado:_" + lboInsAmortAnual + "_");

                if (lboInsAmortAnual) {
                    // --Construye respuesta
                    resultado.setResultado(true);
                    resultado.setMensaje("OK");
                    LOG.info("Respuesta devuelta: " + resultado.toString());
                }//End if(lboInsAmortAnual)
                else {
                    LOG.info("No se pudo registrar la amortizacion Anual para el Contrato [" + lstIdContrato + "].");

                    // --Construye respuesta
                    resultado.setResultado(false);
                    resultado.setMensaje("DDA-CAPC-003: No se pudo registrar la amortizacion anual del contrato " + lstIdContrato + ".");
                    LOG.info("Respuesta devuelta: " + resultado.toString());
                }

            }//Ends if(lboEliminarAmortizacionPresupuesto)
            else {
                LOG.info("No se pudo eliminar la amortizacion Anual para el Contrato [" + lstIdContrato + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-CAPC-002: No se pudo eliminar la amortizacion anual del contrato " + lstIdContrato + ".");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::asociarTitTransCntVigentes]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::asociarTitTransCntVigentes] :::::::::::::::: >>");
        return resultado;

    }

    public ResponseValidaPresupuestoCntDTO validarPresupuestoPorContrato(ParamValidaPresupuestoCntDTO dto) throws Exception {
        ResponseValidaPresupuestoCntDTO resultado = new ResponseValidaPresupuestoCntDTO();
        List<String> error = new ArrayList<String>();

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::validarPresupuestoPorContrato] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";

            // ---- Obtener la fecha de sicronizacion con SAP
            LOG.info("    [INI]. Obtener la fecha de sincronizacion con SAP.");
            String lstFechaSincronizacionSAP = procesoDAO.obtenerFechaSincronizacionSAP();
            LOG.info("    [INI]. Obtener la fecha de sincronizacion con SAP. Resultado: _" + lstFechaSincronizacionSAP + "_");

            if (!lstFechaSincronizacionSAP.equals("")) {
                // --Consulta de datos del Contrato
                LOG.info("    [INI]. Obtener datos de Contrato[" + lstIdContrato + "].");
                ContratoDTO lobCnt = procesoDAO.obtenerDetalleContrato(lstIdContrato);
                LOG.info("    [FIN]. Obtener datos de Contrato[" + lstIdContrato + "].");

                if (lobCnt != null) {
                    String lstIdApdo = (lobCnt.getID_APARTADO() != null && lobCnt.getID_APARTADO().trim().length() > 0) ? lobCnt.getID_APARTADO() : "";
                    String lstFechaInicioCnt = (lobCnt.getFECHA_INICIO() != null && lobCnt.getFECHA_INICIO().trim().length() > 0) ? lobCnt.getFECHA_INICIO() : "";
                    String lstIdCntOriginal = (lobCnt.getID_CONTRATO_ORIGINAL() != null && lobCnt.getID_CONTRATO_ORIGINAL().trim().length() > 0) ? lobCnt.getID_CONTRATO_ORIGINAL() : "-1";
                    LOG.info("        <Titulo: Contrato[" + lstIdContrato + "],IdApdo[" + lstIdApdo + "],Fini:[" + lstFechaInicioCnt + "], IdCntOriginal:[" + lstIdCntOriginal + "]>");

                    if (lstIdCntOriginal != "-1") {
                        // --Comparar fecha de Inicio del Contrato contra Fecha de Sincronizacion SAP
                        LOG.info("    [INI]. Compara fecha inicio Contrato [" + lstFechaInicioCnt + "] y Sincronizacion SAP[" + lstFechaSincronizacionSAP + "].");
                        int lnuResCompara_FechaSinc = dateManager.compararFechas(lstFechaInicioCnt, lstFechaSincronizacionSAP);
                        LOG.info("    [FIN]. Compara fecha inicio Contrato [" + lstFechaInicioCnt + "] y Sincronizacion SAP[" + lstFechaSincronizacionSAP + "]. Resultado: _" + lnuResCompara_FechaSinc + "_");

                        if (lnuResCompara_FechaSinc == 0 || lnuResCompara_FechaSinc == 1) {
                            LOG.info("    [INI]. Obtener los costos anuales del contrato [" + lstIdContrato + "].");
                            List<QryCostoCntPorAnnioDTO> lobCostoPorAnnio = procesoDAO.obtenerCostoContratoPorAnnio(lstIdContrato);
                            LOG.info("    [FIN]. Obtener los costos anuales del contrato [" + lstIdContrato + "]. Aos encontrados:_" + lobCostoPorAnnio.size() + "_");

                            // --Recorrer los titulos obtenidos
                            int lnuTotal = lobCostoPorAnnio.size();
                            boolean lboResultado = true;
                            List<String> lboMensajes = new ArrayList<String>();

                            if (lnuTotal > 0) {
                                LOG.info("    [INI]. Inicia recorrido de los aos encontrados.");

                                for (int xCA = 0; xCA < lnuTotal; xCA++) {
                                    QryCostoCntPorAnnioDTO lobCostoAnual = (QryCostoCntPorAnnioDTO) lobCostoPorAnnio.get(xCA);

                                    String lstAnnio = (lobCostoAnual.getANNIO() != null && lobCostoAnual.getANNIO().trim().length() > 0) ? lobCostoAnual.getANNIO() : "";
                                    String lstCostoCnt = (lobCostoAnual.getMONTO() != null && lobCostoAnual.getMONTO().trim().length() > 0) ? lobCostoAnual.getMONTO() : "";

                                    LOG.info("        [INI]. Obtener los montos del apartado para el ao:_" + lstAnnio + "_ el contrato original:_" + lstIdCntOriginal + "_ y el apartado:_" + lstIdApdo + "_");

                                    ParamPresupuestoDTO params = new ParamPresupuestoDTO();
                                    params.setIdCntOriginal(lstIdCntOriginal);
                                    params.setIdApartado(lstIdApdo);
                                    params.setAnnio(lstAnnio);

                                    QryMontosPresupuestoDTO lobMontosPpto = procesoDAO.obtenerMontosPresupuestoAnual(params);

                                    Double lobMontoAsignado = new Double(lobMontosPpto.getASIGNADO());
                                    Double lobMontoComprometido = new Double(lobMontosPpto.getCOMPROMETIDO());
                                    Double lobMontoContrato = new Double(lstCostoCnt);

                                    double lnuMontoConsiderar = lobMontoComprometido.doubleValue() + lobMontoContrato.doubleValue();

                                    LOG.info("            Ao:_" + lstAnnio + "_");
                                    LOG.info("            Monto asignado:_" + lobMontoAsignado.doubleValue() + "_");
                                    LOG.info("            Monto comprometido:_" + lobMontoComprometido.doubleValue() + "_");
                                    LOG.info("            Monto contrato:_" + lobMontoContrato.doubleValue() + "_");
                                    LOG.info("            Monto considerar:_" + lnuMontoConsiderar + "_");

                                    if (lobMontosPpto.getASIGNADO().equals("0")) {
                                        lboResultado = false;
                                        lboMensajes.add("El apartado del contrato para el ao " + lstAnnio + " no tiene presupuesto asignado");
                                    } else if (lnuMontoConsiderar > lobMontoAsignado.doubleValue()) {
                                        lboResultado = false;
                                        lboMensajes.add("El contrato para el ao " + lstAnnio + " esta fuera de presupuesto");
                                    } else {
                                        lboMensajes.add("El contrato para el ao " + lstAnnio + " se encuentra dentro de presupuesto");
                                    }

                                    LOG.info("        [FIN]. Obtener los montos del apartado para el ao:_" + lstAnnio + "_ el contrato original:_" + lstIdCntOriginal + "_ y el apartado:_" + lstIdApdo + "_");

                                }

                                resultado.setMensaje(lboMensajes);
                                resultado.setResultado(lboResultado);
                                LOG.info("Respuesta devuelta: " + resultado.toString());

                                LOG.info("    [INI]. Finaliza recorrido de los aos encontrados. Resultado:_" + lboResultado + "_");
                            } else {
                                // --Construye respuesta
                                error.add("El contrato no tiene aos para verificar presupuesto");
                                resultado.setMensaje(error);
                                resultado.setResultado(true);
                                LOG.info("Respuesta devuelta: " + resultado.toString());
                            }
                        } else if (lnuResCompara_FechaSinc == -1) {
                            // --Construye respuesta
                            error.add("El contrato ha sido previamente autorizado y notificado a SAP");
                            resultado.setMensaje(error);
                            resultado.setResultado(true);
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }
                    } else {
                        // --Construye respuesta
                        error.add("DDA-VPPC-003: No se pudo obtener el id del contrato original del contrato [" + lstIdContrato + "].");
                        resultado.setMensaje(error);
                        resultado.setResultado(false);
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }

                } // Ends if(lobCnt != null)
                else {
                    // --Construye respuesta
                    error.add("DDA-VPPC-002:No se pudieron obtener los datos del contrato [" + lstIdContrato + "].");
                    resultado.setMensaje(error);
                    resultado.setResultado(false);
                    LOG.info("Respuesta devuelta: " + resultado.toString());
                }
            } // Ends if(!lstFechaSincronizacionSAP.equals(""))
            else {
                // --Construye respuesta
                error.add("DDA-VPPC-001:No se pudo obtener la fecha de sincronizacion SAP");
                resultado.setMensaje(error);
                resultado.setResultado(false);
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::validarPresupuestoPorContrato]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }

        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::validarPresupuestoPorContrato] :::::::::::::::: >>");

        return resultado;

    }

    public ResponseActualizaIdBVDTO actualizarIdBroadView(ParamActualizaIdBVDTO dto) throws Exception {
        ResponseActualizaIdBVDTO resultado = new ResponseActualizaIdBVDTO();
        String lstRutaBase = RUTA_BASE.replaceAll("%PROCESO%", PROCESO_ACTUALIZA_IDBV);

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::actualizarIdBroadView] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstNombreArchivoExcel = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
            String lstIdContratoActual = (dto.getIdContratoActual() != null && dto.getIdContratoActual().trim().length() > 0) ? dto.getIdContratoActual() : "";
            String lstExpediente = (dto.getExpediente() != null && dto.getExpediente().trim().length() > 0) ? dto.getExpediente() : "";

            // --Verifica que exista el archivo espeficido en la ruta de carga
            LOG.info("    [INI]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "].");
            String lstRutaArchivoExcel = lstRutaBase + DIR_EXCEL + lstNombreArchivoExcel;
            File lobArchivoExcelIdBV = new File(lstRutaArchivoExcel);
            boolean boExisteArchivoIdBV = fileManager.existeArchivo(lobArchivoExcelIdBV);
            LOG.info("    [FIN]. Verifica si existe el archivo proporcionado[" + lstNombreArchivoExcel + "]. Existe:_" + boExisteArchivoIdBV + "_");

            if (boExisteArchivoIdBV) {
                // -- Leer el archivo excel cargado
                LOG.info("    [INI]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "].");
                ExcelReader lobER = new ExcelReader();
                lobER.leerArchivoExcelActualizaIdBV(lstRutaArchivoExcel, lstNombreArchivoExcel);
                ArrayList<CargaIdBVDetalleDTO> lobDatosArchivoXL = lobER.getDatosExcel_AIB();
                String lstMsjProcesoExcel = lobER.getMensaje();
                LOG.info("    [FIN]. Leer archivo excel cargado[" + lstNombreArchivoExcel + "]. Mensaje:_" + lstMsjProcesoExcel + "_");

                if (lstMsjProcesoExcel.trim().length() == 0) {
                    // -- Generar archivo data con base en los datos obtenidos del Excel
                    String[] componentesNombreOriginal = lstNombreArchivoExcel.split("\\.");
                    String lstNombreArchivoSinExtension_AIBV = componentesNombreOriginal[0].toString();
                    String lstNombreArchivoData_AIBV = lstNombreArchivoSinExtension_AIBV + ".txt";
                    String lstRutaArchivoData_AIBV = lstRutaBase + DIR_DATA;

                    LOG.info("    [INI]. Generar archivo data[" + lstNombreArchivoData_AIBV + "] en [" + lstRutaArchivoData_AIBV + "].");
                    ParamArchivoSqlLdrDTO pArSqlLdr = new ParamArchivoSqlLdrDTO();
                    pArSqlLdr.setRutaArchivo(lstRutaArchivoData_AIBV);
                    pArSqlLdr.setNombreArchivo(lstNombreArchivoData_AIBV);
                    pArSqlLdr.setLobDatos_AIBV(lobDatosArchivoXL);
                    boolean lboEscribioArData_AIBV = fileManager.escribeArchivoDataActIdBroadView(pArSqlLdr);
                    LOG.info("    [FIN]. Generar archivo data[" + lstNombreArchivoData_AIBV + "] en [" + lstRutaArchivoData_AIBV + "]. Resultado:_" + lboEscribioArData_AIBV + "_");

                    if (lboEscribioArData_AIBV) {
                        // -- Obtener el id de la Carga
                        LOG.info("    [INI]. Obtener id de la carga para Actualizar el Id de BV.");
                        String lstIdCarga = procesoDAO.obtenerSiguienteIdCargaAIBV();
                        // String lstIdCarga = "7";
                        LOG.info("    [FIN]. Obtener id de la carga para Actualizar el Id de BV. Resultado:_" + lstIdCarga + "_");

                        if (!lstIdCarga.equals("-1")) {
                            // -- Generar registro principal de carga para
                            // Actualizacion de Id BV
                            LOG.info("    [INI]. Genera registro principal para la carga de Actualizacion de Id BV.");
                            CargaPrincipalAibvDTO pCargaPpal = new CargaPrincipalAibvDTO();
                            pCargaPpal.setARCHIVO_XLSX(lstNombreArchivoExcel);
                            pCargaPpal.setEXPEDIENTE(lstExpediente);
                            pCargaPpal.setID_CARGA(lstIdCarga);
                            pCargaPpal.setID_CONTRATO(lstIdContratoActual);
                            boolean lboGeneroRegPrincipalCargaAIBV = procesoDAO.insertarRegistroPrincipalCargaAIBV(pCargaPpal);
                            // boolean lboGeneroRegPrincipalCargaAIBV = true;
                            LOG.info("    [FIN]. Genera registro principal para la carga de Actualizacion de Id BV. Resultado:_" + lboGeneroRegPrincipalCargaAIBV + "_");

                            if (lboGeneroRegPrincipalCargaAIBV) {
                                // --Ejecucion de shell para carga de registros para Actualizacion de Id BV
                                LOG.info("    [INI]. Ejecucion de shell para pre-carga de Actualizacion de Id de BV.");
                                String lstRutaShell_ActIdBV = lstRutaBase + DIR_SHELLS + SHELL_ACTUALIZA_IDBV;
                                String lstComando_ActIdBV = lstRutaShell_ActIdBV + " " + lstIdCarga + " " + lstNombreArchivoSinExtension_AIBV + " " + lstRutaBase + " " + U + " " + P + " " + INSTANCIA;
                                boolean lboResShell_ActualizaIdBV = false;
                                if (!AMBIENTE.equalsIgnoreCase("LOCAL")) {
                                    lboResShell_ActualizaIdBV = shellManager.getBooleanEjecutarShell(lstComando_ActIdBV);
                                } else {
                                    lboResShell_ActualizaIdBV = true;
                                }
                                LOG.info("    [FIN]. Ejecucion de shell para pre-carga de Actualizacion de Id de BV. Resultado:_" + lboResShell_ActualizaIdBV + "_");

                                // ----
                                if (lboResShell_ActualizaIdBV) {
                                    // --Ejecucion de Stored Procedure para analisis de registros de Actualizacion de Id de BV
                                    LOG.info("    [INI]. Ejecucion de SP para proceso de registros de Actualizacion de Id de BV.");
                                    boolean lboResSP = procesoDAO.ejecutarSPProcesaActualizaIdBV(pCargaPpal);
                                    LOG.info("    [FIN]. Ejecucion de SP para proceso de registros de Actualizacion de Id de BV.");

                                    // --Consulta resultados de carga
                                    LOG.info("    [INI]. Obtener resultados deproceso de carga de Titulos.");
                                    CargaPrincipalAibvDTO lobResultadosCarga = procesoDAO
                                            .obtenerDatosFinalesActualizaIdBV(lstIdCarga);
                                    LOG.info("    [FIN]. Obtener resultados deproceso de carga de Titulos.");

                                    if (lobResultadosCarga != null) {
                                        // --Construye respuesta
                                        resultado.setResultado(true);
                                        resultado.setMensaje("OK");
                                        resultado.setDatosCarga(lobResultadosCarga);
                                        LOG.info("Respuesta devuelta: " + resultado.toString());

                                    } // Termina if(lobResultadosCarga != null)

                                } // Ends if(lboResShell_CargaTitulos)
                                else {
                                    LOG.info("Ocurrio un error al ejecutar el shell de precarga de Actualizacion de ID BV.");

                                    // --Construye respuesta
                                    resultado.setResultado(false);
                                    resultado.setMensaje("DDA-AIBV-005: Error en proceso.");
                                    LOG.info("Respuesta devuelta: " + resultado.toString());
                                }
                                // ---
                            } // Ends if(lboGeneroRegPrincipalCargaAIBV)
                            else {
                                LOG.info("No se pudo insertar el Registro Principal de Carga.");

                                // --Construye respuesta
                                resultado.setResultado(false);
                                resultado.setMensaje("DDA-AIBV-004: No se pudo insertar el registro principal de Carga.");
                                LOG.info("Respuesta devuelta: " + resultado.toString());
                            }

                        } // Ends if(!lstIdCarga.equals("-1"))
                        else {
                            LOG.info("No se pudo obtener el siguiente Id de Carga para Actualiza el Id de BV.");

                            // --Construye respuesta
                            resultado.setResultado(false);
                            resultado.setMensaje("DDA-AIBV-003: No se pudo obtener el siguiente id de carga.");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }

                    } // Ends if(lboEscribioArData_AIBV)
                    else {
                        LOG.info("No se pudo generar el archivo data[" + lstNombreArchivoData_AIBV + "].");

                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setMensaje("DDA-AIBV-002: Error en proceso.");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }
                } // Ends if(lstMsjProcesoExcel.trim().length() == 0)

            } // Ends if(boExisteArchivoIdBV)
            else {
                LOG.info("No se encontro el archivo especificado[" + lstNombreArchivoExcel + "].");

                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("DDA-AIBV-001: No se pudo encontrar el archivo especificado.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::actualizarIdBroadView]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::actualizarIdBroadView] :::::::::::::::: >>");
        return resultado;
    }

    public ResponseGeneraReporteDTO generarReporte(ParamGeneraReporteDTO dto) throws Exception {
        ResponseGeneraReporteDTO resultado = new ResponseGeneraReporteDTO();
        String lstRutaBase = RUTA_BASE.replaceAll("%PROCESO%", PROCESO_REPORTES);

        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::generarReporte] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
            String lstFormato = (dto.getFormato() != null && dto.getFormato().trim().length() > 0) ? dto.getFormato() : "txt";
            String lstComprimir = (dto.getComprimir() != null && dto.getComprimir().trim().length() > 0) ? dto.getComprimir() : "n";

            // --Ejecucion del shell
            LOG.info("    [INI]. Ejecucion de shell para proceso de Reportes.");
            String lstRutaShell_Reportes = lstRutaBase + DIR_SHELLS;
            String lstRutaShExecutor_Reportes = lstRutaShell_Reportes + SHELL_EJECUTOR;
             LOG.info("  RFD lista nombre archivo."+lstNombreArchivo);
             LOG.info("  RFD lista formato."+lstFormato);
             LOG.info("  RFD lista lista comprimir."+lstComprimir);
            //String lstComando_Reportes = lstRutaShell_Reportes + " " + SHELL_PROCESA_REPORTES + " " + SHELL_PROCESA_REPORTESCR + " tm" + SHELL_PROCESA_REPORTESCR + " \"-fname="+lstNombreArchivo+" -basepath="+lstRutaBase+" -u "+U+" -p "+P+" -i "+INSTANCIA+" -format="+lstFormato+" -zip="+lstComprimir+"\" ";
            String[] lstComando_Reportes = new String[]{lstRutaShExecutor_Reportes, SHELL_PROCESA_REPORTES, SHELL_PROCESA_REPORTESCR, "tm" + SHELL_PROCESA_REPORTESCR, "--fname=" + lstNombreArchivo + " --basepath=" + lstRutaBase + " -u " + U + " -p " + P + " -i " + INSTANCIA + " --format=" + lstFormato + " --zip=" + lstComprimir, lstRutaShell_Reportes};
            LOG.debug("    CmdSh: " + lstComando_Reportes);
            LOG.info("    CmdSh: " + lstComando_Reportes);
            String lstResShell_Reportes = "";

            if (!AMBIENTE.equalsIgnoreCase("LOCAL")) {
                lstResShell_Reportes = shellManager.getStringEjecutarShell(lstComando_Reportes);
            } else {
                lstResShell_Reportes = "";
            }
            LOG.info("    [FIN]. Ejecucion de shell para proceso de Reportes. Resultado:_" + lstResShell_Reportes + "_");

            //--Verificacion del resultado obtenido
            String lstCadRes = "";

            //-- [INI] Test
            /*
			lstResShell_Reportes = "SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> SQL> Disconnected from Oracle Database 11g Enterprise Edition Release 11.2.0.1.0 - Production"+
					"With the Partitioning, OLAP, Data Mining and Real Application Testing options"+
					"gpg: 3DES encrypted data"+
					"gpg: encrypted with 1 passphrase"+
					"gpg: WARNING: message was not integrity protected(@128|/home/admonDLA/dda/sqlReportes/js/CntTitulo.js@)";
             */
            //--[FIN] Test
            int lnuPosIni = lstResShell_Reportes.indexOf("(@");
            int lnuPosFin = lstResShell_Reportes.lastIndexOf("@)");
            LOG.info("    [INI/FIN]. Respuesta encontrada en: (" + lnuPosIni + "," + lnuPosFin + ") ");

            if (lnuPosIni != -1) {
                lstCadRes = lstResShell_Reportes.substring(lnuPosIni + 2, lnuPosFin);
                LOG.info("lstCadRes: " + lstCadRes);

                String[] lobayResultado = lstCadRes.split("\\|");

                if (lobayResultado.length == 2) {
                    String lstRegistros = lobayResultado[0];
                    String lstRutaRes = lobayResultado[1];
                    LOG.info("[INI/FIN] Registros devueltos: [" + lstRegistros + "]  Ruta: [" + lstRutaRes + "]");

                    if (lstRegistros != null && lstRegistros.trim().length() > 0) {

                        int lnuRegistros = Integer.parseInt(lstRegistros, 10);
                        LOG.info("[INI/FIN] Registros (number): " + lnuRegistros);

                        if (lnuRegistros > 1) {
                            // --Construye respuesta
                            resultado.setResultado(true);
                            resultado.setRegistros(lstRegistros);
                            resultado.setRuta(lstRutaRes);
                            resultado.setMensaje("OK");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        } else {
                            // --Construye respuesta
                            resultado.setResultado(true);
                            resultado.setRegistros("0");
                            resultado.setRuta("");
                            resultado.setMensaje("DDA-GR-004: No se encontraron registros en el reporte que satisfagan los criterios especificados.");
                            LOG.info("Respuesta devuelta: " + resultado.toString());
                        }

                    }//Ends if(lstRegistros != null && lstRegistros.trim().length() > 0)
                    else {
                        // --Construye respuesta
                        resultado.setResultado(false);
                        resultado.setRegistros("-1");
                        resultado.setRuta("");
                        resultado.setMensaje("DDA-GR-003: No se pudo obtener el dato de registros obtenidos del reporte.");
                        LOG.info("Respuesta devuelta: " + resultado.toString());
                    }

                }// Ends if(lobayResultado.length == 2)
                else {
                    // --Construye respuesta
                    resultado.setResultado(false);
                    resultado.setRegistros("-1");
                    resultado.setRuta("");
                    resultado.setMensaje("DDA-GR-002: No se pudo obtener el dato de registros obtenidos del reporte.");
                    LOG.info("Respuesta devuelta: " + resultado.toString());
                }// Ends else if(lobayResultado.length == 2)

            }// Ends if(lnuPosIni != -1)
            else {
                // --Construye respuesta
                resultado.setResultado(false);
                resultado.setRegistros("-1");
                resultado.setRuta("");
                resultado.setMensaje("DDA-GR-001: No se pudo obtener la cadena de resultado desde el proceso.");
                LOG.info("Respuesta devuelta: " + resultado.toString());
            }//Ends else if(lnuPosIni != -1)

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::generarReporte]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::generarReporte] :::::::::::::::: >>");
        return resultado;
    }

    public ResponseAsociarTitTransCntVigentesDTO asociarTitTransCntVigentes(ParamAsocTitTransCntVigentesDTO dto) throws Exception {
        ResponseAsociarTitTransCntVigentesDTO resultado = new ResponseAsociarTitTransCntVigentesDTO();
        LOG.info("<< :::::::::::::::: INI [" + this.getClass().getSimpleName() + "::asociarTitTransCntVigentes] :::::::::::::::: >>");
        LOG.info("     -->  Parametros: " + dto.toString());

        try {
            String lstIdCargaTrans = (dto.getIdCargaTrans() != null && dto.getIdCargaTrans().trim().length() > 0) ? dto.getIdCargaTrans() : "";

            // --Ejecucion de Stored Procedure para asociacion de Titulos Transaccionales a Contratos Vigentes
            LOG.info("    [INI]. Ejecucion de SP para proceso de asociacion de Titulos Transaccionales a Contratos Vigentes.");
            boolean lboResSP = procesoDAO.ejecutarSPAsociarTitTransCntVigentes(lstIdCargaTrans);
            LOG.info("    [FIN]. Ejecucion de SP para proceso de asociacion de Titulos Transaccionales a Contratos Vigentes. Ejecuto?:_" + lboResSP + "_");

            // --Consulta resultados de proceso
            LOG.info("    [INI]. Obtener resultados de proceso de asociacion de Titulos Transaccionales a Contratos Vigentes.");
            CargaTransaccionDTO lobResultadosProceso = procesoDAO.obtenerDatosFinalesAsocTitTransCntVigentes(lstIdCargaTrans);
            LOG.info("    [FIN]. Obtener resultados de proceso de asociacion de Titulos Transaccionales a Contratos Vigentes. Resultado:_" + lobResultadosProceso + "_");

            if (lobResultadosProceso != null) {
                //--Determinar resultado
                int lnuTotalError = Integer.parseInt(lobResultadosProceso.getTOTAL_ERROR(), 10);
                int lnuTotalCorrecto = Integer.parseInt(lobResultadosProceso.getTOTAL_CORRECTOS(), 10);
                int lnuTotalRegistros = Integer.parseInt(lobResultadosProceso.getTOTAL_REGISTROS(), 10);
                LOG.info("    [INI/FIN]. Total Registros:[" + lnuTotalRegistros + "], Total Correctos:[" + lnuTotalCorrecto + "], Total Error:[" + lnuTotalError + "]. ");

                if (lnuTotalError == 0) {
                    //--Construye respuesta
                    resultado.setResultado(true);
                    resultado.setMensaje("OK");
                } else {
                    //--Construye respuesta
                    resultado.setResultado(false);
                    resultado.setMensaje("NO_OK");
                }

                LOG.info("Respuesta devuelta: " + resultado.toString());

            } // Termina if(lobResultadosCarga != null)
            else {
                //--Construye respuesta
                resultado.setResultado(false);
                resultado.setMensaje("No se pudo obtener los resultados finales del proceso.");
            }

        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::asociarTitTransCntVigentes]: " + e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            LOG.debug("Stack : " + stack.toString());
            throw new Exception(e.getMessage());
        }
        LOG.info("<< :::::::::::::::: FIN [" + this.getClass().getSimpleName() + "::asociarTitTransCntVigentes] :::::::::::::::: >>");
        return resultado;
    }

    // ***************************************** Metodos Auxiliares para el Calculo de Amortizacion **************************
    public boolean limpiaRegistrosAmortizacionesPrevios(ParamRegAmortizaBorrarDTO dto) throws Exception {
        LOG.debug("    - [" + this.getClass().getSimpleName() + "::limpiaRegistrosAmortizacionesPrevios]");
        LOG.debug("    - Parametros: " + dto.toString());

        boolean resultado = false;
        try {
            // --Consulta si hay registros para eliminar
            int lnuRegistrosBorrar = procesoDAO.obtenerCuantosRegistrosBorrarAmortizacion(dto);
            if (lnuRegistrosBorrar == 0) {
                resultado = true;
            } else {
                resultado = procesoDAO.limpiaRegistrosAmortizacionesPrevios(dto);
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::limpiaRegistrosAmortizacionesPrevios]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

    public boolean registrarAmortizacion(AmortizacionDTO dto) throws Exception {
        LOG.debug("    - [" + this.getClass().getSimpleName() + "::registrarAmortizacion]");
        LOG.debug("    - Parametros: ");
        LOG.debug("           AmortizacionDTO: " + dto.toString());

        String lstMesAuxiliar = dateManager.cambiarFormato(dto.getMES(), "yyyy-MM-dd");
        dto.setMES(lstMesAuxiliar);

        boolean resultado = false;
        try {
            resultado = procesoDAO.registrarAmortizacion(dto);
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::registrarAmortizacion]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }

        return resultado;
    }

    private boolean limpiaRegistrosAmortizacionAnualPrevios(String pstIdContrato) throws Exception {
        boolean resultado = false;
        try {
            // --Consulta si hay registros para eliminar
            int lnuRegistrosBorrar = procesoDAO.obtenerRegistrosBorrarAmortizacionAnual(pstIdContrato);
            if (lnuRegistrosBorrar == 0) {
                resultado = true;
            } else {
                resultado = procesoDAO.eliminarAmortizacionAnual(pstIdContrato);
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::limpiaRegistrosAmortizacionAnualPrevios]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

    private boolean limpiaRegistrosAmortizacionPrevia(String pstIdContrato) throws Exception {
        boolean resultado = false;
        try {
            // --Consulta si hay registros para eliminar
            int lnuRegistrosBorrar = procesoDAO.obtenerRegistrosBorrarAmortizacionPrevia(pstIdContrato);
            if (lnuRegistrosBorrar == 0) {
                resultado = true;
            } else {
                resultado = procesoDAO.eliminarAmortizacionPrevia(pstIdContrato);
            }
        } catch (Exception e) {
            LOG.error("Exception[" + this.getClass().getSimpleName() + "::limpiaRegistrosAmortizacionPrevia]: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        return resultado;
    }

}
