package mx.com.amx.mx.dda.ws.dao;

import java.util.HashMap;
import java.util.List;

import mx.com.amx.mx.dda.ws.dto.AmortizacionDTO;
import mx.com.amx.mx.dda.ws.dto.AmortizacionPreviaDTO;
import mx.com.amx.mx.dda.ws.dto.CalculoCostoDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalAibvDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalPNDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalTRDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalVSDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTransaccionDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoDTO;
import mx.com.amx.mx.dda.ws.dto.QryMinSeleccionTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.QryMontosPresupuestoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoPagoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ParamActualizaCostoTitulo;
import mx.com.amx.mx.dda.ws.dto.ParamPresupuestoDTO;
import mx.com.amx.mx.dda.ws.dto.ParamAnnioVigenteDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCalcAmortizaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamListaMes;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerCostoAnualDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerSuscriptoresDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamRegAmortizaBorrarDTO;
import mx.com.amx.mx.dda.ws.dto.ParamSP_CargaTitulosPNDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValidaMinimoSeleccionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValorTituloDTO;
import mx.com.amx.mx.dda.ws.dto.PresupuestoApdoDTO;
import mx.com.amx.mx.dda.ws.dto.QryCostoCntPorAnnioDTO;
import mx.com.amx.mx.dda.ws.dto.QryEmpresasContratoDTO;
import mx.com.amx.mx.dda.ws.dto.QryListaMesDTO;
import mx.com.amx.mx.dda.ws.dto.QryTipoPagoDTO;

public interface IProcesoDAO 
{
	public List<ContratoDTO> obtenerContratosSuscripcion(String pstFechaMes) throws Exception;
	public List<QryEmpresasContratoDTO> obtenerEmpresasContrato(String pstIdContrato) throws Exception;
	public QryTipoPagoDTO obtenerTipoPago(String pstIdContrato, String pstFechaMes) throws Exception;
	public String obtenerSuscriptoresProm12Meses(ParamObtenerSuscriptoresDTO dto) throws Exception;
	public String obtenerSuscriptoresPromIniFin(ParamObtenerSuscriptoresDTO dto) throws Exception;
	public String obtenerSuscriptoresPromMesAnterior(ParamObtenerSuscriptoresDTO dto) throws Exception;
	public String obtenerSuscriptoresMesActual(ParamObtenerSuscriptoresDTO dto) throws Exception;
	public String obtenerListaMasReciente(String pstIdContrato,String pstOrigen) throws Exception;
	public List<ContratoTituloDTO> obtenerTitulosPorContrato(ParamObtenerTitulosDTO dto) throws Exception;
	public String obtenerCostoAnualEscala(ParamObtenerCostoAnualDTO dto) throws Exception;
	public boolean registrarCalculoCostoTituloEscala(CalculoCostoDTO dto) throws Exception;
	public String obtenerCostoAnualFlat(ParamObtenerCostoAnualDTO dto) throws Exception;
	public boolean registrarCalculoCostoTituloFlat(CalculoCostoDTO dto) throws Exception;
	public boolean limpiaRegistrosCostoMes(String pstFechaMes) throws Exception;
	public int obtenerCuantosRegistrosBorrar(String pstFechaMes)  throws Exception;
	public boolean actualizaCostoTitulo(ParamActualizaCostoTitulo dto) throws Exception;
	public List<ContratoTituloDTO> obtenerTitulosPorContratoAmortizacion(String pstIdContrato) throws Exception;
	public String obtenerUltimaFechaCargaSuscriptores() throws Exception;
	public List<ContratoTituloDTO> obtenerTitulosPorContratoCT(ParamObtenerTitulosDTO dto) throws Exception;
	public String obtenerUltimaFechaCntPagoPorContrato(String pstIdContrato) throws Exception;
	public ContratoPagoDTO obtenerTipoPagoMinimoSeleccionado(String pstIdContrato, String pstFecha) throws Exception;
	public String obtenerAnnioRecienteConfFlat(String pstIdCntPago) throws Exception;
	public String obtenerMinimoSeleccionMonetarioEscala(String pstIdCntPago) throws Exception;
	public String obtenerMinimoSeleccionMonetarioFlat(String pstIdCntPago, String pstAnnio) throws Exception;
	public String obtenerSumatoriaCostoTitulosMinSel(ParamObtenerTitulosDTO dto) throws Exception;
	public List<QryMinSeleccionTitulosDTO> obtenerMinSeleccionCategoria(String pstIdCntPago) throws Exception;
	public List<QryMinSeleccionTitulosDTO> obtenerMinSeleccionCategoriaAnnio(String pstIdCntPago, String pstAnnio) throws Exception;
	public HashMap<String, String> obtenerTotalTitulosCategoria(String pstIdContrato, String pstLista) throws Exception;
	public String obtenerIdContratoOriginal(String pstIdContrato) throws Exception;
	public ContratoDTO obtenerDetalleContrato(String pstIdContrato) throws Exception;
	public String obtenerFechaMaximaCntOriginalAdendumEnmiendas(String pstIdContratoOriginal) throws Exception;
	public String obtenerSiguienteIdCarga() throws Exception; 
	public String obtenerSiguienteIdCargaTR() throws Exception;
	public String obtenerSiguienteIdCargaPN() throws Exception;
	public String obtenerSiguienteIdCargaVS() throws Exception;
	public boolean ejecutarSPProcesaCargaTitulos(CargaPrincipalDTO dto) throws Exception;
	public boolean insertarRegistroPrincipalCarga(CargaPrincipalDTO dto) throws Exception;
	public boolean insertarRegistroPrincipalCargaAIBV(CargaPrincipalAibvDTO dto) throws Exception;
	public boolean insertarRegistroPrincipalCargaTR(CargaPrincipalTRDTO dto) throws Exception;
	public boolean insertarRegistroPrincipalCargaPN(CargaPrincipalPNDTO dto) throws Exception;
	public boolean insertarRegistroPrincipalCargaVS(CargaPrincipalVSDTO dto) throws Exception;
	public CargaPrincipalDTO obtenerDatosFinalesCarga(String pstIdCarga) throws Exception;
	public int obtenerCuantosRegistrosBorrarAmortizacion(ParamRegAmortizaBorrarDTO dto) throws Exception;
	public boolean limpiaRegistrosAmortizacionesPrevios(ParamRegAmortizaBorrarDTO dto) throws Exception;
	public boolean registrarAmortizacion(AmortizacionDTO dto) throws Exception;
	public boolean eliminarAmortizacionAnual(String pstIdContrato) throws Exception;
	public boolean registrarAmortizacionAnual(String pstIdContrato) throws Exception;
	public int obtenerRegistrosBorrarAmortizacionAnual(String pstIdContrato) throws Exception;
	public int obtenerRegistrosBorrarAmortizacionPrevia(String pstIdContrato) throws Exception;
	public String obtenerFechaSincronizacionSAP() throws Exception;
	public List<QryCostoCntPorAnnioDTO> obtenerCostoContratoPorAnnio( String pstIdContrato ) throws Exception;
	public QryMontosPresupuestoDTO obtenerMontosPresupuestoAnual( ParamPresupuestoDTO dto ) throws Exception;
	public String obtenerSiguienteIdCargaAIBV() throws Exception;
	public boolean ejecutarSPProcesaActualizaIdBV(CargaPrincipalAibvDTO dto) throws Exception;
	public CargaPrincipalAibvDTO obtenerDatosFinalesActualizaIdBV(String pstIdCarga) throws Exception;
	public boolean ejecutarSPObtenerCostoTitulo(ParamValorTituloDTO dto) throws Exception;
	public boolean ejecutarSPCalculoPagoEstudios(String pstIdContrato) throws Exception;
	public String obtenerValidacionMinSeleccion(ParamValidaMinimoSeleccionDTO dto) throws Exception;
	public boolean ejecutarSPProcesaCargaTitulosLF(CargaPrincipalDTO dto) throws Exception;
	public boolean ejecutarSPProcesaCargaTitulosTR(CargaPrincipalTRDTO dto) throws Exception;
	public boolean ejecutarSPProcesaCargaTitulosPN(ParamSP_CargaTitulosPNDTO dto) throws Exception;
	public boolean ejecutarSPProcesaCargaTitulosVS(CargaPrincipalVSDTO dto) throws Exception;
	public CargaPrincipalTRDTO obtenerDatosFinalesCargaTR(String pstIdCarga) throws Exception;
	public CargaPrincipalPNDTO obtenerDatosFinalesCargaPN(String pstIdCarga) throws Exception;
	public CargaPrincipalVSDTO obtenerDatosFinalesCargaVS(String pstIdCarga) throws Exception;
	public boolean ejecutarSPAsociarTitTransCntVigentes(String pstIdCargaTrans) throws Exception;
	public CargaTransaccionDTO obtenerDatosFinalesAsocTitTransCntVigentes(String pstIdCargaTrans) throws Exception;
	public boolean eliminarAmortizacionPrevia(String pstIdContrato) throws Exception;
	public boolean registrarAmortizacionPrevia(AmortizacionPreviaDTO dto, String pstMesesVU) throws Exception;
	
	public boolean ejecutarSPAmortizacionPrevia(String pstIdContrato) throws Exception;
	
}
