package mx.com.amx.mx.dda.ws.dao;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import mx.com.amx.mx.dda.ws.dto.AmortizacionDTO;
import mx.com.amx.mx.dda.ws.dto.AmortizacionPreviaDTO;
import mx.com.amx.mx.dda.ws.dto.CalculoCostoDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalAibvDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalPNDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalTRDTO;
import mx.com.amx.mx.dda.ws.dto.CargaPrincipalVSDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTransaccionDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoDTO;
import mx.com.amx.mx.dda.ws.dto.QryMinSeleccionTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.QryMontosPresupuestoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoPagoDTO;
import mx.com.amx.mx.dda.ws.dto.ContratoTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ItTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ParamActualizaCostoTitulo;
import mx.com.amx.mx.dda.ws.dto.ParamPresupuestoDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerCostoAnualDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerSuscriptoresDTO;
import mx.com.amx.mx.dda.ws.dto.ParamObtenerTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamRegAmortizaBorrarDTO;
import mx.com.amx.mx.dda.ws.dto.ParamSP_CargaTitulosPNDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValidaMinimoSeleccionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValorTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ParametroDTO;
import mx.com.amx.mx.dda.ws.dto.QryCostoCntPorAnnioDTO;
import mx.com.amx.mx.dda.ws.dto.QryEmpresasContratoDTO;
import mx.com.amx.mx.dda.ws.dto.QryListaMesDTO;
import mx.com.amx.mx.dda.ws.dto.QryTipoPagoDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseValidaMinimoSeleccionDTO;
import mx.com.amx.mx.dda.ws.utils.GeneralUtils;


@Component
@Qualifier("procesoDAO")
public class ProcesoDAO implements IProcesoDAO
{
                private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
                private final String ARCHIVO_PROPIEDADES       = "/general.properties";
                Properties env =             new Properties();
                private JdbcTemplate jdbcTemplate;
                private GeneralUtils utils = new GeneralUtils();
                
                private String AMBIENTE;
                private String ESTATUS_VIGENTE;
                private String ESTATUS_AUTORIZADO;
                private String TIPO_CONTRATO_SUSCRIPCION;
                private String TIPO_CONTRATO_LICENSEFEE;
                private String TIPO_CALCULO_SUSCRIPCION;
                private String ORIGEN_REAL;
                private String ORIGEN_ESPEJO;
                private String ESTATUS_TITULO_ACTIVO;
                private String MODULO_AMORTIZACION;
                private String MODULO_PRESUPUESTO;
                private String CVE_SINCRONIZACION;
                private String ESQUEMA;
                
                
                public ProcesoDAO()
                {
                               super();
                               try
                               {
                                               env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
                                               AMBIENTE = env.getProperty("ambiente");
                                               ESTATUS_VIGENTE = env.getProperty("estatus.vigente");
                                                ESTATUS_AUTORIZADO = env.getProperty("estatus.autorizado");
                                               TIPO_CONTRATO_SUSCRIPCION = env.getProperty("tipo.contrato.suscripcion");
                                               TIPO_CONTRATO_LICENSEFEE = env.getProperty("tipo.contrato.licensefee");
                                               TIPO_CALCULO_SUSCRIPCION = env.getProperty("tipo.calculo.suscripcion");
                                               ORIGEN_REAL = env.getProperty("origen.real");
                                               ORIGEN_ESPEJO = env.getProperty("origen.espejo");
                                               ESTATUS_TITULO_ACTIVO = env.getProperty("estatus.titulo.activo");
                                               MODULO_AMORTIZACION = env.getProperty("modulo.amortizacion");
                                               MODULO_PRESUPUESTO = env.getProperty("modulo.presupuesto");
                                               CVE_SINCRONIZACION = env.getProperty("cve.sincronizacion.sap");
                                               ESQUEMA = env.getProperty(AMBIENTE + ".esquema");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
                               }
                }
                
                public JdbcTemplate getJdbcTemplate() 
                {
                               return jdbcTemplate;
                }
                
                @Autowired
                public void setJdbcTemplate(JdbcTemplate jdbcTemplate) 
                {
                               this.jdbcTemplate = jdbcTemplate;
                }

                @Override
                public List<ContratoDTO> obtenerContratosSuscripcion(String pstFechaMes) throws Exception 
                {
                               List<ContratoDTO> lobResultado = new ArrayList<ContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("max(cnt.ID_CONTRATO) as ID_CONTRATO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO cnt ");
                                               sbD.append("where ");
                                               sbD.append("cnt.ID_TIPO_CONTRATO = "+TIPO_CONTRATO_SUSCRIPCION+" ");
                                               sbD.append("and to_date('"+pstFechaMes+"','dd/mm/yyyy') >= to_date(to_char(cnt.FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sbD.append("and to_date('"+pstFechaMes+"','dd/mm/yyyy') <= to_date(to_char(cnt.FECHA_FIN,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sbD.append("and (cnt.ID_ESTATUS = "+ESTATUS_VIGENTE+" or cnt.ID_ESTATUS = "+ESTATUS_AUTORIZADO+") ");
                                               sbD.append("group by ID_CONTRATO_ORIGINAL ");
                                               LOG.debug(">Sql_D [obtenerContratosSuscripcion]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("max(cnt.ID_CONTRATO) as ID_CONTRATO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO cnt ");
                                               sb.append("where ");
                                               sb.append("cnt.ID_TIPO_CONTRATO = ? ");
                                               sb.append("and to_date(?,'dd/mm/yyyy') >= to_date(to_char(cnt.FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sb.append("and to_date(?,'dd/mm/yyyy') <= to_date(to_char(cnt.FECHA_FIN,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sb.append("and (cnt.ID_ESTATUS = ? or cnt.ID_ESTATUS = ?) ");
                                               sb.append("group by ID_CONTRATO_ORIGINAL ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(TIPO_CONTRATO_SUSCRIPCION);
                                               qryParams.add(pstFechaMes);
                                               qryParams.add(pstFechaMes);
                                               qryParams.add(ESTATUS_VIGENTE);
                                               qryParams.add(ESTATUS_AUTORIZADO);
                                               
                                               lobResultado = (ArrayList<ContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoDTO>(ContratoDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerContratosSuscripcion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                @Override
                public List<QryEmpresasContratoDTO> obtenerEmpresasContrato(String pstIdContrato) throws Exception 
                {
                               List<QryEmpresasContratoDTO> lobResultado = new ArrayList<QryEmpresasContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("cnt.ID_CONTRATO as ID_CONTRATO, ");
                                               sbD.append("dfilial.ID_FILIAL as ID_FILIAL, ");
                                               sbD.append("filial.ID_EMPRESA as ID_EMPRESA, ");
                                               sbD.append("emp.DESCRIPCION as DESC_EMPRESA ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO cnt, ");
                                               sbD.append("DDA_T_CONTRATO_DEAL_FILIAL dfilial, ");
                                               sbD.append("DDA_C_FILIAL filial, ");
                                               sbD.append("DDA_C_EMPRESA_VENTA emp ");
                                               sbD.append("where ");
                                               sbD.append("cnt.ID_CONTRATO = dfilial.ID_CONTRATO ");
                                               sbD.append("and filial.ID_FILIAL = dfilial.ID_FILIAL ");
                                               sbD.append("and filial.ID_EMPRESA = emp.ID_EMPRESA ");
                                               sbD.append("and cnt.ID_CONTRATO = "+pstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerEmpresasContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("cnt.ID_CONTRATO as ID_CONTRATO, ");
                                               sb.append("dfilial.ID_FILIAL as ID_FILIAL, ");
                                               sb.append("filial.ID_EMPRESA as ID_EMPRESA, ");
                                               sb.append("emp.DESCRIPCION as DESC_EMPRESA ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO cnt, ");
                                               sb.append("DDA_T_CONTRATO_DEAL_FILIAL dfilial, ");
                                               sb.append("DDA_C_FILIAL filial, ");
                                               sb.append("DDA_C_EMPRESA_VENTA emp ");
                                               sb.append("where ");
                                               sb.append("cnt.ID_CONTRATO = dfilial.ID_CONTRATO ");
                                               sb.append("and filial.ID_FILIAL = dfilial.ID_FILIAL ");
                                               sb.append("and filial.ID_EMPRESA = emp.ID_EMPRESA ");
                                               sb.append("and cnt.ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<QryEmpresasContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryEmpresasContratoDTO>(QryEmpresasContratoDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerEmpresasContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                @Override
                public QryTipoPagoDTO obtenerTipoPago(String pstIdContrato, String pstFechaMes) throws Exception 
                {
                               List<QryTipoPagoDTO> lobResultado = new ArrayList<QryTipoPagoDTO>();
                               QryTipoPagoDTO resultado = new QryTipoPagoDTO();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                                
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               String lstFechaMes = (pstFechaMes != null && pstFechaMes.trim().length() > 0) ? pstFechaMes : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(cpago.TIPO_PAGO,'-') as TIPO_PAGO, ");
                                               sbD.append("NVL(stipo.CLAVE_TIPO,'-') as CLAVE_TIPO, ");
                                               sbD.append("NVL(cpago.TIPO_ANNIO,'-') as TIPO_ANNIO, ");
                                               sbD.append("NVL(cpago.ID_CONTRATO_PAGO,'-1') as ID_CONTRATO_PAGO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_PAGO cpago left join DDA_C_SUSCRIPTOR_TIPO stipo ");
                                               sbD.append("on cpago.ID_TIPO_SUSCRIPTOR = stipo.ID_TIPO_SUSCRIPTOR ");
                                               sbD.append("where to_date('"+lstFechaMes+"','dd/mm/yyyy') >= to_date(to_char(cpago.FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sbD.append("and to_date('"+lstFechaMes+"','dd/mm/yyyy') <= to_date(to_char(cpago.FECHA_FIN,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sbD.append("and cpago.ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerTipoPago]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(cpago.TIPO_PAGO,'-') as TIPO_PAGO, ");
                                               sb.append("NVL(stipo.CLAVE_TIPO,'-') as CLAVE_TIPO, ");
                                               sb.append("NVL(cpago.TIPO_ANNIO,'-') as TIPO_ANNIO, ");
                                               sb.append("NVL(cpago.ID_CONTRATO_PAGO,'-1') as ID_CONTRATO_PAGO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_PAGO cpago left join DDA_C_SUSCRIPTOR_TIPO stipo ");
                                               sb.append("on cpago.ID_TIPO_SUSCRIPTOR = stipo.ID_TIPO_SUSCRIPTOR ");
                                               sb.append("where to_date(?,'dd/mm/yyyy') >= to_date(to_char(cpago.FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sb.append("and to_date(?,'dd/mm/yyyy') <= to_date(to_char(cpago.FECHA_FIN,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sb.append("and cpago.ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(pstFechaMes);
                                               qryParams.add(pstFechaMes);
                                               qryParams.add(lstIdContrato);
                                               
                                               
                                               lobResultado = (ArrayList<QryTipoPagoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryTipoPagoDTO>(QryTipoPagoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (QryTipoPagoDTO) lobResultado.get(0);
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTipoPago]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public String obtenerSuscriptoresProm12Meses(ParamObtenerSuscriptoresDTO dto) throws Exception 
                {
                               /*
                               * Consultar los suscriptores cargados a las empresas del contrato considerando los ltimos 12 meses apartir del mes proporcionado, sumados por empresa. 
                                * Si mes es igual a dic 2015, entonces rango es Ene-Dic2015. 
                                * 
                                **/

                               String resultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                                
                               try
                               {
                                               //--Debug
                                               sbD.append("select NVL(avg(SUSCRIPTORES),-1) from ");
                                               sbD.append("( ");
                                               sbD.append("select ");
                                               sbD.append("sum(SUSCRIPTORES) as SUSCRIPTORES, MES_CARGA ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sbD.append("where ");
                                               sbD.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sbD.append("and to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') >= ADD_MONTHS(to_date('"+dto.getFechaMes()+"','dd/mm/yyyy'),-11) ");
                                               sbD.append("and to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') <= to_date('"+dto.getFechaMes()+"','dd/mm/yyyy') ");
                                               sbD.append("group by MES_CARGA ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [obtenerSuscriptoresProm12Meses]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select NVL(avg(SUSCRIPTORES),-1) from ");
                                               sb.append("( ");
                                               sb.append("select ");
                                               sb.append("sum(SUSCRIPTORES) as SUSCRIPTORES, MES_CARGA ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sb.append("where ");
                                               sb.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sb.append("and to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') >= ADD_MONTHS(to_date(?,'dd/mm/yyyy'),-11) ");
                                               sb.append("and to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') <= to_date(?,'dd/mm/yyyy') ");
                                               sb.append("group by MES_CARGA ");
                                               sb.append(") ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(dto.getFechaMes());
                                               qryParams.add(dto.getFechaMes());
                                               
                                               
                                               resultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return resultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresProm12Meses]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresProm12Meses]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                }

                @Override
                public String obtenerSuscriptoresPromIniFin(ParamObtenerSuscriptoresDTO dto) throws Exception 
                {
                               /*
                               * Consultar los suscriptores cargados a las empresas del contrato considerando solamente los registros de carga de hace 12 meses a partir del mes proporcionado y los registros del mes proporcionado, sumados por empresa. 
                                * Si el mes proporcionado es Dic 2015, entonces los registros que se buscan son los de Ene-2015 y de Dic2015 solamente, los demas no se toman en cuenta 
                                * 
                                **/
                               
                               String resultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select NVL(avg(SUSCRIPTORES),-1) from ");
                                               sbD.append("( ");
                                               sbD.append("select ");
                                               sbD.append("sum(SUSCRIPTORES) as SUSCRIPTORES, MES_CARGA ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sbD.append("where ");
                                               sbD.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sbD.append("and ");
                                               sbD.append("( ");
                                               sbD.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = ADD_MONTHS(to_date('"+dto.getFechaMes()+"','dd/mm/yyyy'),-11) ");
                                               sbD.append("OR "); 
                                               sbD.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date('"+dto.getFechaMes()+"','dd/mm/yyyy') ");
                                               sbD.append(") ");
                                               sbD.append("group by MES_CARGA ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [obtenerSuscriptoresPromIniFin]:" + sbD.toString());

                                               //--Ejecucion
                                               sb.append("select NVL(avg(SUSCRIPTORES),-1) from ");
                                               sb.append("( ");
                                               sb.append("select ");
                                               sb.append("sum(SUSCRIPTORES) as SUSCRIPTORES, MES_CARGA ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sb.append("where ");
                                               sb.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sb.append("and ");
                                               sb.append("( ");
                                               sb.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = ADD_MONTHS(to_date(?,'dd/mm/yyyy'),-11) ");
                                               sb.append("OR "); 
                                               sb.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date(?,'dd/mm/yyyy') ");
                                               sb.append(") ");
                                               sb.append("group by MES_CARGA ");
                                               sb.append(") ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(dto.getFechaMes());
                                               qryParams.add(dto.getFechaMes());
                                               
                                               
                                               resultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return resultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresPromIniFin]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresPromIniFin]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                }

                @Override
                public String obtenerSuscriptoresPromMesAnterior(ParamObtenerSuscriptoresDTO dto) throws Exception 
                {
                               /*
                               * Consultar los suscriptores cargados a las empresas del contrato considerando solamente los registros del mes anterior al mes proporcionado y los registros del mes proporcionado, sumados por empresa. 
                                * Si el mes proporcionado es Dic 2015, entonces los registros que se buscan son los de Nov-2015 y de Dic2015 solamente, los demas no se toman en cuenta 
                                * 
                                **/
                               
                               String resultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select NVL(avg(SUSCRIPTORES),-1) from ");
                                               sbD.append("( ");
                                               sbD.append("select ");
                                               sbD.append("sum(SUSCRIPTORES) as SUSCRIPTORES, MES_CARGA ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sbD.append("where ");
                                               sbD.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sbD.append("and ");
                                               sbD.append("( ");
                                               sbD.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = ADD_MONTHS(to_date('"+dto.getFechaMes()+"','dd/mm/yyyy'),-1) ");
                                               sbD.append("OR "); 
                                               sbD.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date('"+dto.getFechaMes()+"','dd/mm/yyyy') ");
                                               sbD.append(") ");
                                               sbD.append("group by MES_CARGA ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [obtenerSuscriptoresPromMesAnterior]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select NVL(avg(SUSCRIPTORES),-1) from ");
                                               sb.append("( ");
                                               sb.append("select ");
                                               sb.append("sum(SUSCRIPTORES) as SUSCRIPTORES, MES_CARGA ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sb.append("where ");
                                               sb.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sb.append("and ");
                                               sb.append("( ");
                                               sb.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = ADD_MONTHS(to_date(?,'dd/mm/yyyy'),-1) ");
                                               sb.append("OR "); 
                                               sb.append("to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date(?,'dd/mm/yyyy') ");
                                               sb.append(") ");
                                               sb.append("group by MES_CARGA ");
                                               sb.append(") ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(dto.getFechaMes());
                                               qryParams.add(dto.getFechaMes());
                                               
                                               
                                               resultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return resultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresPromMesAnterior]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresPromMesAnterior]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }

                @Override
                public String obtenerSuscriptoresMesActual(ParamObtenerSuscriptoresDTO dto) throws Exception 
                {
                               /*
                               * Consultar los suscriptores cargados a las empresas del contrato considerando solamente los registros del mes proporcionado. 
                                * Si el mes proporcionado es Dic 2015, entonces los registros que se buscan son los de Dic2015 solamente, los demas no se toman en cuenta 
                                * 
                                **/
                               
                               String resultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(sum(SUSCRIPTORES),'-1') as SUSCRIPTORES ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sbD.append("where ");
                                               sbD.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sbD.append("and to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date('"+dto.getFechaMes()+"','dd/mm/yyyy') ");
                                               LOG.debug(">Sql_D [obtenerSuscriptoresPromMesActual]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(sum(SUSCRIPTORES),'-1') as SUSCRIPTORES ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               sb.append("where ");
                                               sb.append("ID_EMPRESA in ("+dto.listEmpresas()+") ");
                                               sb.append("and to_date(to_char(MES_CARGA,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date(?,'dd/mm/yyyy') ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(dto.getFechaMes());
                                               
                                               resultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return resultado;
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresPromMesActual]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSuscriptoresPromMesActual]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }              
                }

                @Override
                public String obtenerListaMasReciente(String pstIdContrato,String pstOrigen) throws Exception 
                {
                               String resultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstOrigen = (pstOrigen != null && pstOrigen.trim().length() > 0) ? pstOrigen : "";
                               String lstNombreTabla = "";
                               
                               if(lstOrigen.equalsIgnoreCase(ORIGEN_REAL))
                                               lstNombreTabla = "DDA_T_CONTRATO_LISTA";
                               else if(lstOrigen.equalsIgnoreCase(ORIGEN_ESPEJO))
                                               lstNombreTabla = "DDA_M_CONTRATO_LISTA";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("max(ID_LISTA) ");
                                               sbD.append("from ");
                                               sbD.append(lstNombreTabla + " ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+pstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerListaMasReciente]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("max(ID_LISTA) ");
                                               sb.append("from ");
                                               sb.append(lstNombreTabla + " ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(pstIdContrato);
                                               
                                               
                                               resultado = (String)getJdbcTemplate().queryForObject(lstSQL,qryParams.toArray(),String.class);
                                               return resultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerListaMasReciente]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerListaMasReciente]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }              
                }
                
                
                @Override
                public List<ContratoTituloDTO> obtenerTitulosPorContrato(ParamObtenerTitulosDTO dto) throws Exception 
                {
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstNombreTabla = "";
                               
                               String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
                               String lstFechaMes = (dto.getFechaMes() != null && dto.getFechaMes().trim().length() > 0) ? dto.getFechaMes() : "";
                               String lstIdLista = (dto.getIdLista() != null && dto.getIdLista().trim().length() > 0) ? dto.getIdLista() : "";
                               String lstOrigen = (dto.getOrigen() != null && dto.getOrigen().trim().length() > 0) ? dto.getOrigen() : "";
                               
                               if(lstOrigen.equalsIgnoreCase(ORIGEN_REAL))
                                               lstNombreTabla = "DDA_T_CONTRATO_TITULO";
                               else if(lstOrigen.equalsIgnoreCase(ORIGEN_ESPEJO))
                                               lstNombreTabla = "DDA_M_CONTRATO_TITULO";

                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_TITULO_CNT, ");
                                               sbD.append("ID_TITULO_CNTORIG, ");
                                               sbD.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO, ");
                                               sbD.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN, ");
                                               sbD.append("VIDA_UTIL, ");
                                               sbD.append("ID_PAGO_CATEG, ");
                                               sbD.append("PRECIO_ANUAL, ");
                                               sbD.append("MESES_VU ");
                                               sbD.append("from "); 
                                               sbD.append(lstNombreTabla + " ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and ID_LISTA = "+lstIdLista+" ");
                                               sbD.append("and ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               sbD.append("and to_date('"+lstFechaMes+"','dd/mm/yyyy') >= to_date(to_char(FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sbD.append("and to_date('"+lstFechaMes+"','dd/mm/yyyy') <= to_date(to_char(FECHA_FIN,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               LOG.debug(">Sql_D [obtenerTitulosPorContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_TITULO_CNT, ");
                                               sb.append("ID_TITULO_CNTORIG, ");
                                               sb.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO, ");
                                               sb.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN, ");
                                               sb.append("VIDA_UTIL, ");
                                               sb.append("ID_PAGO_CATEG, ");
                                               sb.append("PRECIO_ANUAL, ");
                                               sb.append("MESES_VU ");
                                               sb.append("from "); 
                                               sb.append(lstNombreTabla + " ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               sb.append("and ID_LISTA = ? ");
                                               sb.append("and ESTATUS = ? ");
                                               sb.append("and to_date(?,'dd/mm/yyyy') >= to_date(to_char(FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               sb.append("and to_date(?,'dd/mm/yyyy') <= to_date(to_char(FECHA_FIN,'dd/mm/yyyy'),'dd/mm/yyyy') ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdLista);
                                               qryParams.add(ESTATUS_TITULO_ACTIVO);
                                               qryParams.add(lstFechaMes);
                                               qryParams.add(lstFechaMes);
                                               
                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTitulosPorContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                               
                }

                @Override
                public String obtenerCostoAnualEscala(ParamObtenerCostoAnualDTO dto) throws Exception 
                {
                               List<CalculoCostoDTO> lobResultado = new ArrayList<CalculoCostoDTO>();
                               String resultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdPagoCateg = (dto.getIdPagoCateg() != null && dto.getIdPagoCateg().trim().length() > 0) ? dto.getIdPagoCateg() : "";
                               String lstIdCntPago = (dto.getIdContratoPago() != null && dto.getIdContratoPago().trim().length() > 0) ? dto.getIdContratoPago() : "";
                               String lstSuscriptores = (dto.getSuscriptores() != null && dto.getSuscriptores().trim().length() > 0) ? dto.getSuscriptores() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(pcosto.COSTO,-1) as COSTO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_PAGO_COSTO pcosto, ");
                                               sbD.append("DDA_T_CONTRATO_PAGO_RANGO prango ");
                                               sbD.append("where ");
                                               sbD.append("pcosto.ID_PAGO_RANGO = prango.ID_PAGO_RANGO ");
                                               sbD.append("and pcosto.ID_PAGO_CATEG = "+lstIdPagoCateg+" ");
                                               sbD.append("and prango.ID_CONTRATO_PAGO = "+lstIdCntPago+" ");
                                               sbD.append("and "+lstSuscriptores+" >= TO_NUMBER(prango.DESDE) ");
                                               sbD.append("and "+lstSuscriptores+" <= TO_NUMBER(prango.HASTA) ");
                                               LOG.debug(">Sql_D [obtenerCostoAnualEscala]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(pcosto.COSTO,-1) AS COSTO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_PAGO_COSTO pcosto, ");
                                               sb.append("DDA_T_CONTRATO_PAGO_RANGO prango ");
                                               sb.append("where ");
                                               sb.append("pcosto.ID_PAGO_RANGO = prango.ID_PAGO_RANGO ");
                                               sb.append("and pcosto.ID_PAGO_CATEG = ? ");
                                               sb.append("and prango.ID_CONTRATO_PAGO = ? ");
                                               sb.append("and ? >= TO_NUMBER(prango.DESDE) ");
                                               sb.append("and ? <= TO_NUMBER(prango.HASTA) ");
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdPagoCateg);
                                               qryParams.add(lstIdCntPago);
                                               qryParams.add(lstSuscriptores);
                                               qryParams.add(lstSuscriptores);
                                               
                                               lobResultado = (ArrayList<CalculoCostoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CalculoCostoDTO>(CalculoCostoDTO.class));
                                               if(lobResultado.size() == 1)
                                                               resultado = lobResultado.get(0).getCOSTO();
                                               
                                               
                                               return resultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCostoAnualEscala]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCostoAnualEscala]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }

                @Override
                public boolean registrarCalculoCostoTituloEscala(CalculoCostoDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().trim().length() > 0) ? dto.getID_TITULO_CNTORIG() : "";
                               String lstFechaMes = (dto.getMES() != null && dto.getMES().trim().length() > 0) ? dto.getMES() : "";
                               String lstCosto = (dto.getCOSTO() != null && dto.getCOSTO().trim().length() > 0) ? dto.getCOSTO() : "";
                               String lstCostoCalculado = (dto.getCOSTO_CALCULADO() != null && dto.getCOSTO_CALCULADO().trim().length() > 0) ? dto.getCOSTO_CALCULADO() : "";
                               String lstTipoCalculo = (dto.getTIPO_CALCULO() != null && dto.getTIPO_CALCULO().trim().length() > 0) ? dto.getTIPO_CALCULO() : "";
                               String lstPrecio = (dto.getPRECIO() != null && dto.getPRECIO().trim().length() > 0) ? dto.getPRECIO() : "";
                               String lstSuscriptores = (dto.getSUSCRIPTORES() != null && dto.getSUSCRIPTORES().trim().length() > 0) ? dto.getSUSCRIPTORES() : "";
                               String lstTipoPago = (dto.getTIPO_PAGO() != null && dto.getTIPO_PAGO().trim().length() > 0) ? dto.getTIPO_PAGO() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO "); 
                                               sbD.append("DDA_T_CALCULO_COSTO ");
                                               sbD.append("( ");
                                               sbD.append("ID_CALCULO_COSTO, "); 
                                               sbD.append("ID_TITULO_CNTORIG, "); 
                                               sbD.append("MES, "); 
                                               sbD.append("COSTO, "); 
                                               sbD.append("COSTO_CALCULADO, "); 
                                               sbD.append("TIPO_CALCULO, "); 
                                               sbD.append("PRECIO, "); 
                                               sbD.append("SUSCRIPTORES, "); 
                                               sbD.append("TIPO_PAGO, "); 
                                               sbD.append("ID_CONTRATO ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append("DDA_SQT_CALCULO_COSTO.NEXTVAL, ");
                                               sbD.append(lstIdTituloCntOrig+", ");
                                               sbD.append("to_date('"+lstFechaMes+"','yyyy-mm-dd'), ");
                                               sbD.append("'"+lstCosto+"', ");
                                               sbD.append("'"+lstCostoCalculado+"', ");
                                               sbD.append("'"+lstTipoCalculo+"', ");
                                               sbD.append("'"+lstPrecio+"', ");
                                               sbD.append("'"+lstSuscriptores+"', ");
                                               sbD.append("'"+lstTipoPago+"', ");
                                               sbD.append(lstIdContrato+" ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [registrarCalculoCostoTituloEscala]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO "); 
                                               sb.append("DDA_T_CALCULO_COSTO ");
                                               sb.append("( ");
                                               sb.append("ID_CALCULO_COSTO, "); 
                                               sb.append("ID_TITULO_CNTORIG, "); 
                                               sb.append("MES, "); 
                                               sb.append("COSTO, "); 
                                               sb.append("COSTO_CALCULADO, "); 
                                               sb.append("TIPO_CALCULO, "); 
                                               sb.append("PRECIO, "); 
                                               sb.append("SUSCRIPTORES, "); 
                                               sb.append("TIPO_PAGO, "); 
                                               sb.append("ID_CONTRATO ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("DDA_SQT_CALCULO_COSTO.NEXTVAL, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("ROUND(?), ");
                                               sb.append("?, ");
                                               sb.append("? ");
                                               sb.append(") ");
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdTituloCntOrig);
                                               lobTSFecha.setTime(df.parse(lstFechaMes+" 12:00:00").getTime());
                                               qryParams.add(lobTSFecha);
                                               qryParams.add(lstCosto);
                                               qryParams.add(lstCostoCalculado);
                                               qryParams.add(lstTipoCalculo);
                                               qryParams.add(lstPrecio);
                                               qryParams.add(lstSuscriptores);
                                               qryParams.add(lstTipoPago);
                                               qryParams.add(lstIdContrato);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarCalculoCostoTituloEscala]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                
                @Override
                public String obtenerCostoAnualFlat(ParamObtenerCostoAnualDTO dto) throws Exception 
                {
                               List<CalculoCostoDTO> lobResultado = new ArrayList<CalculoCostoDTO>();
                               String resultado = "-1";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdPagoCateg = (dto.getIdPagoCateg() != null && dto.getIdPagoCateg().trim().length() > 0) ? dto.getIdPagoCateg() : "";
                               String lstIdCntPago = (dto.getIdContratoPago() != null && dto.getIdContratoPago().trim().length() > 0) ? dto.getIdContratoPago() : "";
                               String lstAnnio = (dto.getAnnio() != null && dto.getAnnio().trim().length() > 0) ? dto.getAnnio() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(COSTO,-1) AS COSTO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_PAGO_FLAT ");
                                               sbD.append("where ");
                                               sbD.append("ID_PAGO_CATEG = "+lstIdPagoCateg+" ");
                                               sbD.append("and ID_CONTRATO_PAGO = "+lstIdCntPago+" ");
                                               sbD.append("and ANNIO = "+lstAnnio+" ");
                                               LOG.debug(">Sql_D [obtenerCostoAnualFlat]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(COSTO,-1) AS COSTO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_PAGO_FLAT ");
                                               sb.append("where ");
                                               sb.append("ID_PAGO_CATEG = ? ");
                                               sb.append("and ID_CONTRATO_PAGO = ? ");
                                               sb.append("and ANNIO = ? ");
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdPagoCateg);
                                               qryParams.add(lstIdCntPago);
                                               qryParams.add(lstAnnio);
                                               
                                               lobResultado = (ArrayList<CalculoCostoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CalculoCostoDTO>(CalculoCostoDTO.class));
                                               if(lobResultado.size() == 1)
                                                               resultado = lobResultado.get(0).getCOSTO();
                                                               

                                               return resultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCostoAnualFlat]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCostoAnualFlat]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }

                @Override
                public boolean registrarCalculoCostoTituloFlat(CalculoCostoDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().trim().length() > 0) ? dto.getID_TITULO_CNTORIG() : "";
                               String lstFechaMes = (dto.getMES() != null && dto.getMES().trim().length() > 0) ? dto.getMES() : "";
                               String lstCosto = (dto.getCOSTO() != null && dto.getCOSTO().trim().length() > 0) ? dto.getCOSTO() : "";
                               String lstCostoCalculado = (dto.getCOSTO_CALCULADO() != null && dto.getCOSTO_CALCULADO().trim().length() > 0) ? dto.getCOSTO_CALCULADO() : "";
                               String lstAnnioCalculo = (dto.getANNIO_CALCULO() != null && dto.getANNIO_CALCULO().trim().length() > 0) ? dto.getANNIO_CALCULO() : "";
                               String lstTipoCalculo = (dto.getTIPO_CALCULO() != null && dto.getTIPO_CALCULO().trim().length() > 0) ? dto.getTIPO_CALCULO() : "";
                               String lstPrecio = (dto.getPRECIO() != null && dto.getPRECIO().trim().length() > 0) ? dto.getPRECIO() : "";
                               String lstTipoPago = (dto.getTIPO_PAGO() != null && dto.getTIPO_PAGO().trim().length() > 0) ? dto.getTIPO_PAGO() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO "); 
                                               sbD.append("DDA_T_CALCULO_COSTO ");
                                               sbD.append("( ");
                                               sbD.append("ID_CALCULO_COSTO, "); 
                                               sbD.append("ID_TITULO_CNTORIG, "); 
                                               sbD.append("MES, "); 
                                               sbD.append("COSTO, "); 
                                               sbD.append("COSTO_CALCULADO, ");
                                               sbD.append("ANNIO_CALCULO, "); 
                                               sbD.append("TIPO_CALCULO, "); 
                                               sbD.append("PRECIO, "); 
                                                sbD.append("TIPO_PAGO, "); 
                                               sbD.append("ID_CONTRATO ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append("DDA_SQT_CALCULO_COSTO.NEXTVAL, ");
                                               sbD.append(lstIdTituloCntOrig+", ");
                                               sbD.append("to_date('"+lstFechaMes+"','yyyy-mm-dd'), ");
                                               sbD.append("'"+lstCosto+"', ");
                                               sbD.append("'"+lstCostoCalculado+"', ");
                                               sbD.append("'"+lstAnnioCalculo+"', ");
                                               sbD.append("'"+lstTipoCalculo+"', ");
                                               sbD.append("'"+lstPrecio+"', ");
                                               sbD.append("'"+lstTipoPago+"', ");
                                               sbD.append(lstIdContrato+" ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [registrarCalculoCostoTituloFlat]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO "); 
                                               sb.append("DDA_T_CALCULO_COSTO ");
                                               sb.append("( ");
                                               sb.append("ID_CALCULO_COSTO, "); 
                                               sb.append("ID_TITULO_CNTORIG, "); 
                                               sb.append("MES, "); 
                                               sb.append("COSTO, "); 
                                               sb.append("COSTO_CALCULADO, ");
                                               sb.append("ANNIO_CALCULO, "); 
                                               sb.append("TIPO_CALCULO, "); 
                                               sb.append("PRECIO, "); 
                                               sb.append("TIPO_PAGO, "); 
                                               sb.append("ID_CONTRATO ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("DDA_SQT_CALCULO_COSTO.NEXTVAL, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("? ");
                                               sb.append(") ");
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdTituloCntOrig);
                                               lobTSFecha.setTime(df.parse(lstFechaMes+" 12:00:00").getTime());
                                               qryParams.add(lobTSFecha);
                                               qryParams.add(lstCosto);
                                               qryParams.add(lstCostoCalculado);
                                               qryParams.add(lstAnnioCalculo);
                                               qryParams.add(lstTipoCalculo);
                                               qryParams.add(lstPrecio);
                                               qryParams.add(lstTipoPago);
                                               qryParams.add(lstIdContrato);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarCalculoCostoTituloFlat]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                
                @Override
                public boolean limpiaRegistrosCostoMes(String pstFechaMes) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("delete ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CALCULO_COSTO ");
                                               sbD.append("where ");
                                               sbD.append("to_date(to_char(MES,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date('"+pstFechaMes+"','dd/mm/yyyy') ");
                                               sbD.append("and TIPO_CALCULO = '"+TIPO_CALCULO_SUSCRIPCION+"' ");
                                               LOG.debug(">Sql_D [limpiaRegistrosCostoMes]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("delete ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CALCULO_COSTO ");
                                               sb.append("where ");
                                               sb.append("to_date(to_char(MES,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date(?,'dd/mm/yyyy') ");
                                               sb.append("and TIPO_CALCULO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(pstFechaMes);
                                               qryParams.add(TIPO_CALCULO_SUSCRIPCION);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::limpiaRegistrosCostoMes]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                
                @Override
                public int obtenerCuantosRegistrosBorrar(String pstFechaMes)  throws Exception
                {
                               int resultado = 0;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //-- Debug
                                               sbD.append("select ");
                                               sbD.append("count(ID_CALCULO_COSTO) as CUANTOS ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CALCULO_COSTO ");
                                               sbD.append("where ");
                                               sbD.append("to_date(to_char(MES,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date('"+pstFechaMes+"','dd/mm/yyyy') ");
                                               sbD.append("and TIPO_CALCULO = '"+TIPO_CALCULO_SUSCRIPCION+"' ");
                                               LOG.debug(">Sql_D [obtenerCuatosRegistrosBorrar]:" + sbD.toString());
                                               
                                               //-- Ejecucion
                                               sb.append("select ");
                                               sb.append("count(ID_CALCULO_COSTO) as CUANTOS ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CALCULO_COSTO ");
                                               sb.append("where ");
                                               sb.append("to_date(to_char(MES,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date(?,'dd/mm/yyyy') ");
                                               sb.append("and TIPO_CALCULO = '"+TIPO_CALCULO_SUSCRIPCION+"' ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(pstFechaMes);
                                               
                                               resultado = (int)getJdbcTemplate().queryForInt(lstSQL,qryParams.toArray());
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCuatosRegistrosBorrar]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               return resultado;
                }

                @Override
                public boolean actualizaCostoTitulo(ParamActualizaCostoTitulo dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstNombreTabla = "";
                               
                               String lstIdCntTitulo = (dto.getPstIdCntTitulo() != null && dto.getPstIdCntTitulo().trim().length() > 0) ? dto.getPstIdCntTitulo() : "";
                               String lstCosto = (dto.getPstCosto() != null && dto.getPstCosto().trim().length() > 0) ? dto.getPstCosto() : "";
                               String lstOrigen = (dto.getPstOrigen() != null && dto.getPstOrigen().trim().length() > 0) ? dto.getPstOrigen() : "";
                               
                               if(lstOrigen.equalsIgnoreCase(ORIGEN_REAL))
                                               lstNombreTabla = "DDA_T_CONTRATO_TITULO";
                               else if(lstOrigen.equalsIgnoreCase(ORIGEN_ESPEJO))
                                               lstNombreTabla = "DDA_M_CONTRATO_TITULO";

                               try
                               {

                                               //--Debug
                                               sbD.append("UPDATE "+lstNombreTabla+" "); 
                                               sbD.append("SET COSTO='"+lstCosto+"' ");
                                               sbD.append("WHERE ");
                                               sbD.append("ID_TITULO_CNT="+lstIdCntTitulo+" ");
                                               LOG.debug(">Sql_D [actualizaCostoTitulo]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("UPDATE "+lstNombreTabla+" "); 
                                               sb.append("SET COSTO=? ");
                                               sb.append("WHERE ");
                                               sb.append("ID_TITULO_CNT=? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstCosto);
                                               qryParams.add(lstIdCntTitulo);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::actualizaCostoTitulo]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }



                @Override
                public String obtenerUltimaFechaCargaSuscriptores() throws Exception 
                {
                               String resultado = "";
                               List<QryListaMesDTO> lobResultado = new ArrayList<QryListaMesDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select "); 
                                               sbD.append("to_char(MAX(MES_CARGA),'dd/mm/yyyy') as MES ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               LOG.debug(">Sql_D [obtenerUltimaFechaCargaSuscriptores]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select "); 
                                               sb.append("to_char(MAX(MES_CARGA),'dd/mm/yyyy') as MES ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CARGA_SUSCRIPTOR ");
                                               
                                               final String lstSQL = sb.toString();
                                               
                                               
                                               lobResultado = (ArrayList<QryListaMesDTO>) getJdbcTemplate().query(lstSQL,new BeanPropertyRowMapper<QryListaMesDTO>(QryListaMesDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getMES();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerUltimaFechaCargaSuscriptores]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public List<ContratoTituloDTO> obtenerTitulosPorContratoCT(ParamObtenerTitulosDTO dto) throws Exception 
                {
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstNombreTabla = "";
                               
                               String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
                                String lstIdLista = (dto.getIdLista() != null && dto.getIdLista().trim().length() > 0) ? dto.getIdLista() : "";
                               String lstOrigen = (dto.getOrigen() != null && dto.getOrigen().trim().length() > 0) ? dto.getOrigen() : "";
                               
                               if(lstOrigen.equalsIgnoreCase(ORIGEN_REAL))
                                               lstNombreTabla = "DDA_T_CONTRATO_TITULO";
                               else if(lstOrigen.equalsIgnoreCase(ORIGEN_ESPEJO))
                                               lstNombreTabla = "DDA_M_CONTRATO_TITULO";

                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_TITULO_CNT, ");
                                               sbD.append("ID_TITULO_CNTORIG, ");
                                               sbD.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO, ");
                                               sbD.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN, ");
                                               sbD.append("VIDA_UTIL, ");
                                               sbD.append("ID_PAGO_CATEG, ");
                                               sbD.append("PRECIO_ANUAL, ");
                                               sbD.append("MESES_VU ");
                                               sbD.append("from "); 
                                               sbD.append(lstNombreTabla + " ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and ID_LISTA = "+lstIdLista+" ");
                                               sbD.append("and ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               LOG.debug(">Sql_D [obtenerTitulosPorContratoCT]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_TITULO_CNT, ");
                                               sb.append("ID_TITULO_CNTORIG, ");
                                               sb.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO, ");
                                               sb.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN, ");
                                               sb.append("VIDA_UTIL, ");
                                               sb.append("ID_PAGO_CATEG, ");
                                               sb.append("PRECIO_ANUAL, ");
                                               sb.append("MESES_VU ");
                                               sb.append("from "); 
                                               sb.append(lstNombreTabla + " ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               sb.append("and ID_LISTA = ? ");
                                               sb.append("and ESTATUS = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdLista);
                                               qryParams.add(ESTATUS_TITULO_ACTIVO);
                                               
                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTitulosPorContratoCT]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                ///---------------------------------------------------------------------------------------
                @Override
                public String obtenerMinimoSeleccionMonetarioEscala(String pstIdCntPago) throws Exception 
                {
                               String resultado = "";
                               List<QryMinSeleccionTitulosDTO> lobResultado = new ArrayList<QryMinSeleccionTitulosDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntPago = (pstIdCntPago != null && pstIdCntPago.trim().length() > 0) ? pstIdCntPago : "";

                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(msel.MINIMO_SELECCION,'0') as MINIMO_SELECCION ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_MSELECCION msel ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO_PAGO = "+pstIdCntPago+" ");
                                               sbD.append("and msel.ID_PAGO_CATEG is null ");
                                               sbD.append("and msel.ANNIO is null ");
                                               LOG.debug(">Sql_D [obtenerMinimoSeleccionMonetarioEscala]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(msel.MINIMO_SELECCION,'0') as MINIMO_SELECCION ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_MSELECCION msel ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO_PAGO = ? ");
                                               sb.append("and msel.ID_PAGO_CATEG is null ");
                                               sb.append("and msel.ANNIO is null ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCntPago);
                                               
                                               lobResultado = (ArrayList<QryMinSeleccionTitulosDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryMinSeleccionTitulosDTO>(QryMinSeleccionTitulosDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getMINIMO_SELECCION();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMinimoSeleccionMonetarioEscala]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                @Override
                public String obtenerMinimoSeleccionMonetarioFlat(String pstIdCntPago, String pstAnnio) throws Exception
                {
                               String resultado = "0";
                               List<QryMinSeleccionTitulosDTO> lobResultado = new ArrayList<QryMinSeleccionTitulosDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntPago = (pstIdCntPago != null && pstIdCntPago.trim().length() > 0) ? pstIdCntPago : "";
                               String lstAnnio = (pstAnnio != null && pstAnnio.trim().length() > 0) ? pstAnnio : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(msel.MINIMO_SELECCION,'0') as MINIMO_SELECCION ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_MSELECCION msel ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO_PAGO = "+pstIdCntPago+" ");
                                               sbD.append("and ANNIO = "+pstAnnio+" ");
                                               sbD.append("and msel.ID_PAGO_CATEG is null ");
                                               LOG.debug(">Sql_D [obtenerMinimoSeleccionMonetarioFlat]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(msel.MINIMO_SELECCION,'0') as MINIMO_SELECCION ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_MSELECCION msel ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO_PAGO = ? ");
                                               sb.append("and ANNIO = ? ");
                                               sb.append("and msel.ID_PAGO_CATEG is null ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCntPago);
                                               qryParams.add(lstAnnio);
                                               
                                               lobResultado = (ArrayList<QryMinSeleccionTitulosDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryMinSeleccionTitulosDTO>(QryMinSeleccionTitulosDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getMINIMO_SELECCION();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMinimoSeleccionMonetarioFlat]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                               
                }

                @Override
                public String obtenerSumatoriaCostoTitulosMinSel(ParamObtenerTitulosDTO dto) throws Exception 
                {
                               String resultado = "0";
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstNombreTabla = "";
                               
                               String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
                               String lstIdLista = (dto.getIdLista() != null && dto.getIdLista().trim().length() > 0) ? dto.getIdLista() : "";
                               String lstOrigen = (dto.getOrigen() != null && dto.getOrigen().trim().length() > 0) ? dto.getOrigen() : "";
                               
                               if(lstOrigen.equalsIgnoreCase(ORIGEN_REAL))
                                               lstNombreTabla = "DDA_T_CONTRATO_TITULO";
                               else if(lstOrigen.equalsIgnoreCase(ORIGEN_ESPEJO))
                                               lstNombreTabla = "DDA_M_CONTRATO_TITULO";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(SUM(COSTO),'0') as COSTO ");
                                               sbD.append("from "); 
                                               sbD.append(lstNombreTabla + " ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and ID_LISTA = "+lstIdLista+" ");
                                               sbD.append("and ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               LOG.debug(">Sql_D [obtenerSumatoriaCostoTitulosMinSel]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(SUM(COSTO),'0') as COSTO ");
                                               sb.append("from "); 
                                               sb.append(lstNombreTabla + " ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               sb.append("and ID_LISTA = ? ");
                                               sb.append("and ESTATUS = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdLista);
                                               qryParams.add(ESTATUS_TITULO_ACTIVO);
                                               
                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getCOSTO();
                                               
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSumatoriaCostoTitulosMinSel]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;             
                               
                }

                @Override
                public String obtenerUltimaFechaCntPagoPorContrato(String pstIdContrato) throws Exception 
                {
                               String resultado = "";
                               List<ContratoPagoDTO> lobResultado = new ArrayList<ContratoPagoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("to_char(max(FECHA_INICIO),'dd/mm/yyyy') as FECHA_INICIO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_PAGO ");
                                               sbD.append("where ID_CONTRATO = "+pstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerUltimaFechaCntPagoPorContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("to_char(max(FECHA_INICIO),'dd/mm/yyyy') as FECHA_INICIO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_PAGO ");
                                               sb.append("where ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<ContratoPagoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoPagoDTO>(ContratoPagoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getFECHA_INICIO();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerUltimaFechaCntPagoPorContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public ContratoPagoDTO obtenerTipoPagoMinimoSeleccionado(String pstIdContrato, String pstFecha) throws Exception 
                {
                               ContratoPagoDTO resultado = new ContratoPagoDTO();
                               List<ContratoPagoDTO> lobResultado = new ArrayList<ContratoPagoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               String lstUltimaFecha  = (pstFecha != null && pstFecha.trim().length() > 0) ? pstFecha : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                                sbD.append("cntpago.TIPO_PAGO, ");
                                               sbD.append("cntpago.ID_CONTRATO_PAGO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_PAGO cntpago ");
                                               sbD.append("where ");
                                               sbD.append("to_date(to_char(cntpago.FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date('"+pstFecha+"','dd/mm/yyyy') ");
                                               sbD.append("and cntpago.ID_CONTRATO = "+pstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerTipoPagoMinimoSeleccionado]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("cntpago.TIPO_PAGO, ");
                                               sb.append("cntpago.ID_CONTRATO_PAGO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_PAGO cntpago ");
                                               sb.append("where ");
                                               sb.append("to_date(to_char(cntpago.FECHA_INICIO,'dd/mm/yyyy'),'dd/mm/yyyy') = to_date(?,'dd/mm/yyyy') ");
                                               sb.append("and cntpago.ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstUltimaFecha);
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<ContratoPagoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoPagoDTO>(ContratoPagoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (ContratoPagoDTO) lobResultado.get(0);
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTipoPagoMinimoSeleccionado]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public String obtenerAnnioRecienteConfFlat(String pstIdCntPago) throws Exception 
                {
                               String resultado = "-1";
                               List<QryTipoPagoDTO> lobResultado = new ArrayList<QryTipoPagoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntPago = (pstIdCntPago != null && pstIdCntPago.trim().length() > 0) ? pstIdCntPago : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(max(ANNIO),'-1') as ANNIO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_PAGO_FLAT ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO_PAGO = "+lstIdCntPago+" ");
                                               sbD.append("and COSTO IS NOT NULL ");
                                               LOG.debug(">Sql_D [obtenerAnnioRecienteConfFlat]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(max(ANNIO),'-1') as ANNIO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_PAGO_FLAT ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO_PAGO = ? ");
                                               sb.append("and COSTO IS NOT NULL ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCntPago);
                                               
                                               lobResultado = (ArrayList<QryTipoPagoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryTipoPagoDTO>(QryTipoPagoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getANNIO();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerAnnioRecienteConfFlat]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                               
                }

                @Override
                public List<QryMinSeleccionTitulosDTO> obtenerMinSeleccionCategoria(String pstIdCntPago) throws Exception 
                {
                               List<QryMinSeleccionTitulosDTO> lobResultado = new ArrayList<QryMinSeleccionTitulosDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntPago = (pstIdCntPago != null && pstIdCntPago.trim().length() > 0) ? pstIdCntPago : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("msel.MINIMO_SELECCION, ");
                                               sbD.append("pcat.DESC_CATEGORIA, ");
                                               sbD.append("msel.ID_PAGO_CATEG ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_MSELECCION msel, ");
                                               sbD.append("DDA_T_CONTRATO_PAGO_CATEG pcat ");
                                               sbD.append("where "); 
                                               sbD.append("msel.ID_PAGO_CATEG = pcat.ID_PAGO_CATEG ");
                                               sbD.append("and msel.MINIMO_SELECCION > 0 ");
                                               sbD.append("and msel.ID_CONTRATO_PAGO = " + lstIdCntPago);
                                               LOG.debug(">Sql_D [obtenerMinSeleccionCategoria]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("msel.MINIMO_SELECCION, ");
                                               sb.append("pcat.DESC_CATEGORIA, ");
                                               sb.append("msel.ID_PAGO_CATEG ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_MSELECCION msel, ");
                                               sb.append("DDA_T_CONTRATO_PAGO_CATEG pcat ");
                                               sb.append("where "); 
                                               sb.append("msel.ID_PAGO_CATEG = pcat.ID_PAGO_CATEG ");
                                               sb.append("and msel.MINIMO_SELECCION > 0 ");
                                               sb.append("and msel.ID_CONTRATO_PAGO = ?");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCntPago);
                                               
                                               lobResultado = (ArrayList<QryMinSeleccionTitulosDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryMinSeleccionTitulosDTO>(QryMinSeleccionTitulosDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMinSeleccionCategoria]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                               
                }

                @Override
                public List<QryMinSeleccionTitulosDTO> obtenerMinSeleccionCategoriaAnnio(String pstIdCntPago, String pstAnnio) throws Exception 
                {
                               List<QryMinSeleccionTitulosDTO> lobResultado = new ArrayList<QryMinSeleccionTitulosDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntPago = (pstIdCntPago != null && pstIdCntPago.trim().length() > 0) ? pstIdCntPago : "";
                               String lstAnnio = (pstAnnio != null && pstAnnio.trim().length() > 0) ? pstAnnio : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("msel.MINIMO_SELECCION, ");
                                               sbD.append("pcat.DESC_CATEGORIA, ");
                                               sbD.append("msel.ID_PAGO_CATEG ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_MSELECCION msel, ");
                                               sbD.append("DDA_T_CONTRATO_PAGO_CATEG pcat ");
                                               sbD.append("where "); 
                                               sbD.append("msel.ID_PAGO_CATEG = pcat.ID_PAGO_CATEG ");
                                               sbD.append("and msel.MINIMO_SELECCION > 0 ");
                                               sbD.append("and msel.ID_CONTRATO_PAGO = "+pstIdCntPago+" ");
                                               sbD.append("and msel.ANNIO = "+pstAnnio+" ");
                                               sbD.append("and msel.ID_PAGO_CATEG IS NOT NULL ");
                                               LOG.debug(">Sql_D [obtenerMinSeleccionCategoriaAnnio]:" + sbD.toString());
                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("msel.MINIMO_SELECCION, ");
                                               sb.append("pcat.DESC_CATEGORIA, ");
                                               sb.append("msel.ID_PAGO_CATEG ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_MSELECCION msel, ");
                                               sb.append("DDA_T_CONTRATO_PAGO_CATEG pcat ");
                                               sb.append("where "); 
                                               sb.append("msel.ID_PAGO_CATEG = pcat.ID_PAGO_CATEG ");
                                               sb.append("and msel.MINIMO_SELECCION > 0 ");
                                               sb.append("and msel.ID_CONTRATO_PAGO = ? ");
                                               sb.append("and msel.ANNIO = ? ");
                                               sb.append("and msel.ID_PAGO_CATEG IS NOT NULL ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCntPago);
                                               qryParams.add(lstAnnio);
                                               
                                               lobResultado = (ArrayList<QryMinSeleccionTitulosDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryMinSeleccionTitulosDTO>(QryMinSeleccionTitulosDTO.class));
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMinSeleccionCategoriaAnnio]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                @Override
                public HashMap<String, String> obtenerTotalTitulosCategoria(String pstIdContrato, String pstLista) throws Exception 
                {
                               HashMap<String,String> resultado = new HashMap<String,String>();
                               List<QryMinSeleccionTitulosDTO> lobResultado = new ArrayList<QryMinSeleccionTitulosDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstLista = (pstLista != null && pstLista.trim().length() > 0) ? pstLista : "";
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("count(ID_TITULO_CNT) as CUANTOS, ");
                                               sbD.append("ID_PAGO_CATEG ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_TITULO ");
                                               sbD.append("where ");
                                               sbD.append("ID_LISTA = "+lstLista+" ");
                                               sbD.append("and ID_CONTRATO = "+lstIdContrato+" ");
                                               sbD.append("and ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               sbD.append("group by ID_PAGO_CATEG ");
                                               LOG.debug(">Sql_D [obtenerTotalTitulosCategoria]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("count(ID_TITULO_CNT) as CUANTOS, ");
                                               sb.append("ID_PAGO_CATEG ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO ");
                                               sb.append("where ");
                                               sb.append("ID_LISTA = ? ");
                                               sb.append("and ID_CONTRATO = ? ");
                                               sb.append("and ESTATUS = '"+ESTATUS_TITULO_ACTIVO+"' ");
                                               sb.append("group by ID_PAGO_CATEG ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstLista);
                                               qryParams.add(lstIdContrato);
                                               
                                               
                                               lobResultado = (ArrayList<QryMinSeleccionTitulosDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryMinSeleccionTitulosDTO>(QryMinSeleccionTitulosDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() > 0)
                                               {
                                                               
                                                               for (QryMinSeleccionTitulosDTO registro : lobResultado) 
                                                               {
                                                                               resultado.put(registro.getID_PAGO_CATEG(), registro.getCUANTOS());   
                                                               }

                                               }//Ends if(lobResultado != null && lobResultado.size() > 0)
                                               
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTotalTitulosCategoria]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public String obtenerIdContratoOriginal(String pstIdContrato) throws Exception 
                {
                               String resultado = "-1";
                               List<ContratoDTO> lobResultado = new ArrayList<ContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("NVL(ID_CONTRATO_ORIGINAL,'-1') as ID_CONTRATO_ORIGINAL ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CONTRATO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerIdContratoOriginal]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("NVL(ID_CONTRATO_ORIGINAL,'-1') as ID_CONTRATO_ORIGINAL ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CONTRATO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<ContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoDTO>(ContratoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getID_CONTRATO_ORIGINAL();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerIdContratoOriginal]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public ContratoDTO obtenerDetalleContrato(String pstIdContrato) throws Exception 
                {
                               ContratoDTO resultado = new ContratoDTO();
                               List<ContratoDTO> lobResultado = new ArrayList<ContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ID_ESTUDIO, "); 
                                               sbD.append("ID_ESTATUS, "); 
                                               sbD.append("ID_TIPO_MOVIMIENTO, "); 
                                               sbD.append("ID_TIPO_CONTRATO, "); 
                                               sbD.append("ID_APARTADO, "); 
                                               sbD.append("NUMERO_CONTRATO, "); 
                                               sbD.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO, "); 
                                               sbD.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN, "); 
                                               sbD.append("ID_CONTRATO_ORIGINAL, "); 
                                               sbD.append("to_char(FECHA_ALTA,'dd/mm/yyyy') as FECHA_ALTA, "); 
                                               sbD.append("ID_SAP, "); 
                                               sbD.append("AMORTIZABLE, "); 
                                               sbD.append("to_char(FECHA_WS,'dd/mm/yyyy') as FECHA_WS, "); 
                                               sbD.append("to_char(FECHA_MODIFSAP,'dd/mm/yyyy') as FECHA_MODIFSAP, "); 
                                               sbD.append("ANNIOS, "); 
                                               sbD.append("MESES, "); 
                                               sbD.append("INFLACION, "); 
                                               sbD.append("LIMITES_LICENCIA, "); 
                                               sbD.append("ID_BV ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CONTRATO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato);
                                               LOG.debug(">Sql_D [obtenerDetalleContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ID_ESTUDIO, "); 
                                               sb.append("ID_ESTATUS, "); 
                                               sb.append("ID_TIPO_MOVIMIENTO, "); 
                                               sb.append("ID_TIPO_CONTRATO, "); 
                                               sb.append("ID_APARTADO, "); 
                                               sb.append("NUMERO_CONTRATO, "); 
                                               sb.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO, "); 
                                               sb.append("to_char(FECHA_FIN,'dd/mm/yyyy') as FECHA_FIN, "); 
                                               sb.append("ID_CONTRATO_ORIGINAL, "); 
                                               sb.append("to_char(FECHA_ALTA,'dd/mm/yyyy') as FECHA_ALTA, "); 
                                               sb.append("ID_SAP, "); 
                                               sb.append("AMORTIZABLE, "); 
                                               sb.append("to_char(FECHA_WS,'dd/mm/yyyy') as FECHA_WS, "); 
                                               sb.append("to_char(FECHA_MODIFSAP,'dd/mm/yyyy') as FECHA_MODIFSAP, "); 
                                               sb.append("ANNIOS, "); 
                                               sb.append("MESES, "); 
                                               sb.append("INFLACION, "); 
                                               sb.append("LIMITES_LICENCIA, "); 
                                               sb.append("ID_BV ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CONTRATO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<ContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoDTO>(ContratoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (ContratoDTO) lobResultado.get(0);
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDetalleContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public String obtenerFechaMaximaCntOriginalAdendumEnmiendas(String pstIdContratoOriginal) throws Exception 
                {
                               String resultado = "";
                               List<ContratoDTO> lobResultado = new ArrayList<ContratoDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContratoOriginal = (pstIdContratoOriginal != null && pstIdContratoOriginal.trim().length() > 0) ? pstIdContratoOriginal : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("to_char(MAX(FECHA_FIN),'dd/mm/yyyy') as FECHA_FIN ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO_ORIGINAL = "+lstIdContratoOriginal);
                                               LOG.debug(">Sql_D [obtenerFechaMaximaCntOriginalAdendumEnmiendas]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("to_char(MAX(FECHA_FIN),'dd/mm/yyyy') as FECHA_FIN ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO_ORIGINAL = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContratoOriginal);
                                               
                                               lobResultado = (ArrayList<ContratoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoDTO>(ContratoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getFECHA_FIN();
                               }
                               catch(Exception e)
                               {
                                    LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerFechaMaximaCntOriginalAdendumEnmiendas]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                               
                }

                
                @Override
                public String obtenerSiguienteIdCarga() throws Exception 
                {
                               /* Se usa el objeto de ContratoTituloDTO para no tener que crear un DTO para el ID de Carga ya que solo se usaria para este proposito*/
                               String resultado = "-1";
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select DDA_SQT_CARGA_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               LOG.debug(">Sql_D [obtenerSiguienteIdCarga]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select DDA_SQT_CARGA_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               final String lstSQL = sb.toString();

                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getID_LISTA();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSiguienteIdCarga]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                
                @Override
                public String obtenerSiguienteIdCargaTR() throws Exception 
                {
                               /* Se usa el objeto de ContratoTituloDTO para no tener que crear un DTO para el ID de Carga ya que solo se usaria para este proposito*/
                               String resultado = "-1";
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select DDA_SQT_CARGATR_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               LOG.debug(">Sql_D [obtenerSiguienteIdCargaTR]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select DDA_SQT_CARGATR_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               final String lstSQL = sb.toString();

                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getID_LISTA();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSiguienteIdCargaTR]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                
                
                @Override
                public boolean ejecutarSPProcesaCargaTitulos(CargaPrincipalDTO dto) throws Exception 
                {
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               String lstIdListaActual = (dto.getID_LISTA() != null && dto.getID_LISTA().trim().length() > 0) ? dto.getID_LISTA() : "";
                               String lstTipoLista = (dto.getTIPO_LISTA() != null && dto.getTIPO_LISTA().trim().length() > 0) ? dto.getTIPO_LISTA() : "";
                               String lstTipoCarga = (dto.getTIPO_CARGA() != null && dto.getTIPO_CARGA().trim().length() > 0) ? dto.getTIPO_CARGA() : "";
                               String lstFechaInicioLstNva = (dto.getFECHA_INICIO_LSTNVA() != null && dto.getFECHA_INICIO_LSTNVA().trim().length() > 0) ? dto.getFECHA_INICIO_LSTNVA() : "";
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_CARGATITULOS");
                                               LOG.debug(">Sql_D [ejecutarSPProcesaCargaTitulos]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_CARGATITULOS(?,?,?,?,?,?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdListaActual);
                                               qryParams.add(lstTipoLista);
                                               qryParams.add(lstTipoCarga);
                                               qryParams.add(lstFechaInicioLstNva);
                                               
                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPProcesaCargaTitulos]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean insertarRegistroPrincipalCarga(CargaPrincipalDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               String lstIdListaActual = (dto.getID_LISTA() != null && dto.getID_LISTA().trim().length() > 0) ? dto.getID_LISTA() : "";
                               String lstTipoLista = (dto.getTIPO_LISTA() != null && dto.getTIPO_LISTA().trim().length() > 0) ? dto.getTIPO_LISTA() : "";
                               String lstTipoCarga = (dto.getTIPO_CARGA() != null && dto.getTIPO_CARGA().trim().length() > 0) ? dto.getTIPO_CARGA() : "";
                               String lstArchivoXL = (dto.getARCHIVO_XLSX() != null && dto.getARCHIVO_XLSX().trim().length() > 0) ? dto.getARCHIVO_XLSX() : "";
                               String lstExpediente = (dto.getEXPEDIENTE() != null && dto.getEXPEDIENTE().trim().length() > 0) ? dto.getEXPEDIENTE() : "";
                               String lstFechaInicioLstNva = (dto.getFECHA_INICIO_LSTNVA() != null && dto.getFECHA_INICIO_LSTNVA().trim().length() > 0) ? dto.getFECHA_INICIO_LSTNVA() : "VACIO";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CARGA_PRINCIPAL ");
                                               sbD.append("( ");
                                               sbD.append("ID_CARGA, "); 
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ID_LISTA, "); 
                                               sbD.append("TIPO_LISTA, "); 
                                               sbD.append("TIPO_CARGA, "); 
                                               sbD.append("ARCHIVO_XLSX, "); 
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("FECHA_CARGA, ");
                                               sbD.append("FECHA_INICIO_LSTNVA ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append(lstIdCarga+", "); 
                                               sbD.append(lstIdContrato+", "); 
                                               sbD.append(lstIdListaActual+", "); 
                                               sbD.append("'"+lstTipoLista+"', "); 
                                               sbD.append("'"+lstTipoCarga+"', "); 
                                               sbD.append("'"+lstArchivoXL+"', "); 
                                               sbD.append("'"+lstExpediente+"', ");
                                               sbD.append("SYSDATE, ");
                                               if(lstFechaInicioLstNva.equalsIgnoreCase("NULL"))
                                                               sbD.append("NULL ");
                                               else
                                                               sbD.append("to_date('"+lstFechaInicioLstNva+"','yyyy-mm-dd') ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [insertarRegistroPrincipalCarga]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CARGA_PRINCIPAL ");
                                               sb.append("( ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ID_LISTA, "); 
                                               sb.append("TIPO_LISTA, "); 
                                               sb.append("TIPO_CARGA, "); 
                                               sb.append("ARCHIVO_XLSX, "); 
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("FECHA_CARGA, ");
                                               sb.append("FECHA_INICIO_LSTNVA ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, ");
                                               sb.append("SYSDATE, ");
                                               sb.append("? ");
                                               sb.append(") ");
                                               
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdListaActual);
                                               qryParams.add(lstTipoLista);
                                               qryParams.add(lstTipoCarga);
                                               qryParams.add(lstArchivoXL);
                                               qryParams.add(lstExpediente);
                                               
                                               if(lstFechaInicioLstNva.equalsIgnoreCase("NULL"))
                                               {
                                                               qryParams.add(null);
                                               }
                                               else
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaInicioLstNva+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }

                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::insertarRegistroPrincipalCarga]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public CargaPrincipalDTO obtenerDatosFinalesCarga(String pstIdCarga) throws Exception 
                {
                               List<CargaPrincipalDTO> lobResultado = new ArrayList<CargaPrincipalDTO>();
                               CargaPrincipalDTO resultado = new CargaPrincipalDTO();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCarga = (pstIdCarga != null && pstIdCarga.trim().length() > 0) ? pstIdCarga : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_CARGA, "); 
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ID_LISTA, "); 
                                               sbD.append("TIPO_LISTA, "); 
                                               sbD.append("TIPO_CARGA, "); 
                                               sbD.append("ARCHIVO_XLSX, ");
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, "); 
                                               sbD.append("TOTAL_REGISTROS, "); 
                                               sbD.append("TOTAL_CARGADOS, "); 
                                               sbD.append("TOTAL_ERROR, ");
                                               sbD.append("ID_LISTA_NUEVA, ");
                                               sbD.append("to_char(FECHA_INICIO_LSTNVA,'mm/dd/yyyy') as FECHA_INICIO_LSTNVA ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CARGA_PRINCIPAL ");
                                               sbD.append("where "); 
                                               sbD.append("ID_CARGA = "+lstIdCarga);
                                               LOG.debug(">Sql_D [obtenerDatosFinalesCarga]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ID_LISTA, "); 
                                               sb.append("TIPO_LISTA, "); 
                                               sb.append("TIPO_CARGA, "); 
                                               sb.append("ARCHIVO_XLSX, ");
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, "); 
                                               sb.append("TOTAL_REGISTROS, "); 
                                               sb.append("TOTAL_CARGADOS, "); 
                                               sb.append("TOTAL_ERROR, ");
                                               sb.append("ID_LISTA_NUEVA, ");
                                               sb.append("to_char(FECHA_INICIO_LSTNVA,'mm/dd/yyyy') as FECHA_INICIO_LSTNVA ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CARGA_PRINCIPAL ");
                                               sb.append("where "); 
                                               sb.append("ID_CARGA = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               
                                               
                                               
                                               lobResultado = (ArrayList<CargaPrincipalDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CargaPrincipalDTO>(CargaPrincipalDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (CargaPrincipalDTO) lobResultado.get(0);
                                                
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDatosFinalesCarga]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                @Override
                public int obtenerCuantosRegistrosBorrarAmortizacion(ParamRegAmortizaBorrarDTO dto) throws Exception 
                {
                               int resultado = 0;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstCadenaTitulosEspecificos = "";
                               String lstNombreTabla = "";
                               
                               String lstIdContratoOriginal = (dto.getIdContratoOriginal() != null && dto.getIdContratoOriginal().trim().length() > 0) ? dto.getIdContratoOriginal() : "";
                               String lstOrigenDatos = (dto.getOrigen() != null && dto.getOrigen().trim().length() > 0) ? dto.getOrigen() : "";
                               List<ItTituloDTO> lobTitulosEspecificosOriginal = (dto.getLobTitulos() != null && dto.getLobTitulos().size() > 0) ? dto.getLobTitulos() :  new ArrayList<ItTituloDTO>();
                               
                               if(lobTitulosEspecificosOriginal.size() > 0 && lobTitulosEspecificosOriginal.size() < 1000)
                                               lstCadenaTitulosEspecificos = utils.getCadenaTitulos(lobTitulosEspecificosOriginal);
                               
                               
                               if(lstOrigenDatos.equalsIgnoreCase(ORIGEN_REAL))
                                               lstNombreTabla = "DDA_T_AMORTIZACION";
                               else if(lstOrigenDatos.equalsIgnoreCase(ORIGEN_ESPEJO))
                                               lstNombreTabla = "DDA_M_AMORTIZACION";
                               
                               try
                               {
                                               //-- Debug
                                                               sbD.append("select ");
                                                               sbD.append("count(ID_TITULO_CNTORIG) as CUANTOS ");
                                                               sbD.append("from ");
                                                               sbD.append(lstNombreTabla + " ");
                                                               sbD.append("where ");
                                                               sbD.append("ID_CONTRATO_ORIGINAL = "+lstIdContratoOriginal+" ");
                                                               
                                               if(!lstCadenaTitulosEspecificos.equals(""))
                                                               sbD.append("AND ID_TITULO_CNTORIG in ("+lstCadenaTitulosEspecificos+") ");

                                               LOG.debug(">Sql_D [obtenerCuatosRegistrosBorrar]:" + sbD.toString());
                                               
                                               //-- Ejecucion
                                                               sb.append("select ");
                                                               sb.append("count(ID_TITULO_CNTORIG) as CUANTOS ");
                                                               sb.append("from ");
                                                               sb.append(lstNombreTabla + " ");
                                                               sb.append("where ");
                                                               sb.append("ID_CONTRATO_ORIGINAL = ? ");
                                                               qryParams.add(lstIdContratoOriginal);
                                               
                                               if(!lstCadenaTitulosEspecificos.equals(""))
                                                               sb.append("AND ID_TITULO_CNTORIG in ("+lstCadenaTitulosEspecificos+") ");
                                               
                                               final String lstSQL = sb.toString();
                                               
                                               resultado = (int)getJdbcTemplate().queryForInt(lstSQL,qryParams.toArray());
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCuatosRegistrosBorrar]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               return resultado;
                }
                
                @Override
                public boolean limpiaRegistrosAmortizacionesPrevios(ParamRegAmortizaBorrarDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstCadenaTitulosEspecificos = "";
                               String lstNombreTabla = "";
                               
                               String lstIdContratoOriginal = (dto.getIdContratoOriginal() != null && dto.getIdContratoOriginal().trim().length() > 0) ? dto.getIdContratoOriginal() : "";
                               String lstOrigenDatos = (dto.getOrigen() != null && dto.getOrigen().trim().length() > 0) ? dto.getOrigen() : "";
                               List<ItTituloDTO> lobTitulosEspecificosOriginal = (dto.getLobTitulos() != null && dto.getLobTitulos().size() > 0) ? dto.getLobTitulos() :  new ArrayList<ItTituloDTO>();
                               
                               if(lobTitulosEspecificosOriginal.size() > 0 && lobTitulosEspecificosOriginal.size() < 1000)
                                               lstCadenaTitulosEspecificos = utils.getCadenaTitulos(lobTitulosEspecificosOriginal);
                               
                               if(lstOrigenDatos.equalsIgnoreCase(ORIGEN_REAL))
                                               lstNombreTabla = "DDA_T_AMORTIZACION";
                               else if(lstOrigenDatos.equalsIgnoreCase(ORIGEN_ESPEJO))
                                               lstNombreTabla = "DDA_M_AMORTIZACION";
                               
                               try
                               {
                                               //--Debug
                                                               sbD.append("delete "); 
                                                               sbD.append("from ");
                                                               sbD.append(lstNombreTabla + " ");
                                                               sbD.append("where ");
                                                               sbD.append("ID_CONTRATO_ORIGINAL = "+lstIdContratoOriginal+" ");
                                               
                                               if(!lstCadenaTitulosEspecificos.equals(""))
                                                               sbD.append("AND ID_TITULO_CNTORIG in ("+lstCadenaTitulosEspecificos+") ");
                                               
                                               LOG.debug(">Sql_D [limpiaRegistrosAmortizacionesPrevios]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                                               sb.append("delete "); 
                                                               sb.append("from ");
                                                               sb.append(lstNombreTabla + " ");
                                                               sb.append("where ");
                                                               sb.append("ID_CONTRATO_ORIGINAL = ? ");
                                                               qryParams.add(lstIdContratoOriginal);
                                                               
                                                               if(!lstCadenaTitulosEspecificos.equals(""))
                                                                               sb.append("AND ID_TITULO_CNTORIG in ("+lstCadenaTitulosEspecificos+") ");
                                                               
                                               final String lstSQL = sb.toString();
                                               
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::limpiaRegistrosAmortizacionesPrevios]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                
                @Override
                public boolean registrarAmortizacion(AmortizacionDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               //String 
                               String lstIdTituloCntOrig = (dto.getID_TITULO_CNTORIG() != null && dto.getID_TITULO_CNTORIG().trim().length() > 0) ? dto.getID_TITULO_CNTORIG() : ""; 
                               String lstFechaMes = (dto.getMES() != null && dto.getMES().trim().length() > 0) ? dto.getMES() : ""; 
                               String lstMonto = (dto.getMONTO() != null && dto.getMONTO().trim().length() > 0) ? dto.getMONTO() : "";
                                String lstIdContratoOriginal = (dto.getID_CONTRATO_ORIGINAL() != null && dto.getID_CONTRATO_ORIGINAL().trim().length() > 0) ? dto.getID_CONTRATO_ORIGINAL() : "";
                               
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO "); 
                                               sbD.append("DDA_T_AMORTIZACION ");
                                               sbD.append("( ");
                                               sbD.append("ID_AMORTIZACION, "); 
                                               sbD.append("ID_TITULO_CNTORIG, "); 
                                               sbD.append("MES, "); 
                                               sbD.append("MONTO, " ); 
                                               sbD.append("ID_CONTRATO_ORIGINAL ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append("DDA_SQT_AMORTIZACION.NEXTVAL, ");
                                               sbD.append(lstIdTituloCntOrig+", ");
                                               sbD.append("to_date('"+lstFechaMes+"','yyyy-mm-dd'), ");
                                               sbD.append("'"+lstMonto+"', ");
                                               sbD.append("'"+lstIdContratoOriginal+"' ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [registrarAmortizacion]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO "); 
                                               sb.append("DDA_T_AMORTIZACION ");
                                               sb.append("( ");
                                               sb.append("ID_AMORTIZACION, "); 
                                               sb.append("ID_TITULO_CNTORIG, "); 
                                               sb.append("MES, "); 
                                               sb.append("MONTO, " ); 
                                               sb.append("ID_CONTRATO_ORIGINAL ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("DDA_SQT_AMORTIZACION.NEXTVAL, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("?, ");
                                               sb.append("? ");
                                               sb.append(") ");
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdTituloCntOrig);
                                               lobTSFecha.setTime(df.parse(lstFechaMes+" 12:00:00").getTime());
                                               qryParams.add(lobTSFecha);
                                               qryParams.add(lstMonto);
                                               qryParams.add(lstIdContratoOriginal);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarAmortizacion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                               
                }

                @Override
                public boolean registrarAmortizacionAnual(String pstIdContrato) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO ");  
                                               sbD.append("DDA_T_AMORTIZACION_TITULO "); 
                                               sbD.append("( "); 
                                                               sbD.append("ID_AMORTIZACION_TITULO, ");  
                                                               sbD.append("ID_TITULO_CNTORIG, ");  
                                                               sbD.append("ID_CONTRATO, ");  
                                                               sbD.append("M1, ");  
                                                               sbD.append("M2, ");  
                                                               sbD.append("M3, ");  
                                                               sbD.append("M4, ");  
                                                               sbD.append("M5, ");  
                                                               sbD.append("M6, ");  
                                                               sbD.append("M7, ");  
                                                               sbD.append("M8, ");  
                                                               sbD.append("M9, ");  
                                                               sbD.append("M10, ");  
                                                               sbD.append("M11, ");  
                                                               sbD.append("M12, ");  
                                                               sbD.append("TOTAL, ");  
                                                               sbD.append("ANIO "); 
                                               sbD.append(") ");                             
                                               sbD.append("select "); 
                                                               sbD.append("DDA_SQT_AMORTIZACION_TITULO.NEXTVAL as ID_AMORTIZACION_TITULO, "); 
                                                               sbD.append("ID_TITULO_CNTORIG, ");  
                                                               sbD.append("ID_CONTRATO, "); 
                                                               sbD.append("ROUND( MES_1, 4 ) as MES_1, ");  
                                                               sbD.append("ROUND( MES_2, 4 ) as MES_2, ");  
                                                               sbD.append("ROUND( MES_3, 4 ) as MES_3, ");  
                                                               sbD.append("ROUND( MES_4, 4 ) as MES_4, ");  
                                                               sbD.append("ROUND( MES_5, 4 ) as MES_5, ");  
                                                               sbD.append("ROUND( MES_6, 4 ) as MES_6, ");  
                                                               sbD.append("ROUND( MES_7, 4 ) as MES_7, ");  
                                                               sbD.append("ROUND( MES_8, 4 ) as MES_8, ");  
                                                               sbD.append("ROUND( MES_9, 4 ) as MES_9, ");  
                                                               sbD.append("ROUND( MES_10, 4 ) as MES_10, ");  
                                                               sbD.append("ROUND( MES_11, 4 ) as MES_11, ");  
                                                               sbD.append("ROUND( MES_12, 4 ) as MES_12, ");  
                                                               sbD.append("( ");  
                                                                               sbD.append("ROUND( NVL( MES_1, 0 ), 4 ) + ROUND( NVL( MES_2, 0 ), 4 )  + ROUND( NVL( MES_3, 0 ), 4 )  + ROUND( NVL( MES_4, 0 ), 4 ) + ");  
                                                                               sbD.append("ROUND( NVL( MES_5, 0 ), 4 )  + ROUND( NVL( MES_6, 0 ), 4 )  + ROUND( NVL( MES_7, 0 ), 4 )  + ROUND( NVL( MES_8, 0 ), 4 )  + ");  
                                                                               sbD.append("ROUND( NVL( MES_9, 0 ), 4 )  + ROUND( NVL( MES_10, 0 ), 4 )  + ROUND( NVL( MES_11, 0 ), 4 )  + ROUND( NVL( MES_12, 0 ), 4 ) ");   
                                                               sbD.append(") AS TOTAL, "); 
                                                               sbD.append("ANNIO "); 
                                               sbD.append("from "); 
                                               sbD.append("( "); 
                                                               sbD.append("select "); 
                                                                               sbD.append("ID_CONTRATO, ID_TITULO_CNTORIG, ANNIO, ");  
                                                                               sbD.append("MES_1, MES_2, MES_3, MES_4, MES_5, MES_6, MES_7, MES_8, MES_9, MES_10, MES_11, MES_12 "); 
                                                               sbD.append("from "); 
                                                               sbD.append("( "); 
                                                                               sbD.append("select ");   
                                                                                              sbD.append("cnt.ID_CONTRATO, ");
                                                                                              sbD.append("tit.ID_TITULO_CNTORIG, "); 
                                                                                              sbD.append("TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) as ANNIO, "); 
                                                                                              sbD.append("TO_NUMBER( TO_CHAR( amor.MES, 'mm' ) ) as MESES, "); 
                                                                                              sbD.append("TO_NUMBER( amor.MONTO ) as MONTO "); 
                                                                               sbD.append("from ");                                                                                   
                                                                                              sbD.append("DDA_T_CONTRATO cnt, ");
                                                                                              sbD.append("DDA_T_CONTRATO_TITULO tit, ");
                                                                                              sbD.append("DDA_T_AMORTIZACION_PREVIA amor ");
                                                                               sbD.append("where "); 
                                                                                              sbD.append("cnt.ID_CONTRATO = tit.ID_CONTRATO ");
                                                                                              sbD.append("and cnt.ID_CONTRATO = amor.ID_CONTRATO ");
                                                                                              sbD.append("and tit.ID_TITULO_CNT = amor.ID_TITULO_CNT ");
                                                                                              sbD.append("and cnt.ID_CONTRATO = "+lstIdContrato+" ");
                                                               sbD.append(") "); 
                                                               sbD.append("PIVOT "); 
                                                               sbD.append("( ");  
                                                                               sbD.append("SUM( MONTO ) FOR MESES in ");  
                                                                               sbD.append("( ");  
                                                                                              sbD.append("1 as MES_1, 2 as MES_2, 3 as MES_3, 4 as MES_4, 5 as MES_5, 6 as MES_6, "); 
                                                                                              sbD.append("7 as MES_7, 8 as MES_8, 9 as MES_9, 10 as MES_10, 11 as MES_11, 12 as MES_12 ");  
                                                                               sbD.append(") "); 
                                                               sbD.append(") "); 
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [registrarAmortizacionAnual]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO ");  
                                               sb.append("DDA_T_AMORTIZACION_TITULO "); 
                                               sb.append("( "); 
                                                               sb.append("ID_AMORTIZACION_TITULO, ");  
                                                               sb.append("ID_TITULO_CNTORIG, ");  
                                                               sb.append("ID_CONTRATO, ");  
                                                               sb.append("M1, ");  
                                                               sb.append("M2, ");  
                                                               sb.append("M3, ");  
                                                               sb.append("M4, ");  
                                                               sb.append("M5, ");  
                                                               sb.append("M6, ");  
                                                               sb.append("M7, ");  
                                                               sb.append("M8, ");  
                                                               sb.append("M9, ");  
                                                               sb.append("M10, ");  
                                                               sb.append("M11, ");  
                                                               sb.append("M12, ");  
                                                               sb.append("TOTAL, ");  
                                                               sb.append("ANIO "); 
                                               sb.append(") ");                             
                                               sb.append("select "); 
                                                               sb.append("DDA_SQT_AMORTIZACION_TITULO.NEXTVAL as ID_AMORTIZACION_TITULO, "); 
                                                               sb.append("ID_TITULO_CNTORIG, ");  
                                                               sb.append("ID_CONTRATO, "); 
                                                               sb.append("ROUND( MES_1, 4 ) as MES_1, ");  
                                                               sb.append("ROUND( MES_2, 4 ) as MES_2, ");  
                                                               sb.append("ROUND( MES_3, 4 ) as MES_3, ");  
                                                               sb.append("ROUND( MES_4, 4 ) as MES_4, ");  
                                                               sb.append("ROUND( MES_5, 4 ) as MES_5, ");  
                                                               sb.append("ROUND( MES_6, 4 ) as MES_6, ");  
                                                               sb.append("ROUND( MES_7, 4 ) as MES_7, ");  
                                                               sb.append("ROUND( MES_8, 4 ) as MES_8, ");  
                                                               sb.append("ROUND( MES_9, 4 ) as MES_9, ");  
                                                               sb.append("ROUND( MES_10, 4 ) as MES_10, ");  
                                                               sb.append("ROUND( MES_11, 4 ) as MES_11, ");  
                                                               sb.append("ROUND( MES_12, 4 ) as MES_12, ");  
                                                               sb.append("( ");  
                                                                               sb.append("ROUND( NVL( MES_1, 0 ), 4 ) + ROUND( NVL( MES_2, 0 ), 4 )  + ROUND( NVL( MES_3, 0 ), 4 )  + ROUND( NVL( MES_4, 0 ), 4 ) + ");  
                                                                               sb.append("ROUND( NVL( MES_5, 0 ), 4 )  + ROUND( NVL( MES_6, 0 ), 4 )  + ROUND( NVL( MES_7, 0 ), 4 )  + ROUND( NVL( MES_8, 0 ), 4 )  + ");  
                                                                               sb.append("ROUND( NVL( MES_9, 0 ), 4 )  + ROUND( NVL( MES_10, 0 ), 4 )  + ROUND( NVL( MES_11, 0 ), 4 )  + ROUND( NVL( MES_12, 0 ), 4 ) ");   
                                                               sb.append(") AS TOTAL, "); 
                                                               sb.append("ANNIO "); 
                                               sb.append("from "); 
                                               sb.append("( "); 
                                                               sb.append("select "); 
                                                                               sb.append("ID_CONTRATO, ID_TITULO_CNTORIG, ANNIO, ");  
                                                                               sb.append("MES_1, MES_2, MES_3, MES_4, MES_5, MES_6, MES_7, MES_8, MES_9, MES_10, MES_11, MES_12 "); 
                                                               sb.append("from "); 
                                                               sb.append("( "); 
                                                                               sb.append("select ");   
                                                                                              sb.append("cnt.ID_CONTRATO, ");
                                                                                              sb.append("tit.ID_TITULO_CNTORIG, "); 
                                                                                              sb.append("TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) as ANNIO, "); 
                                                                                              sb.append("TO_NUMBER( TO_CHAR( amor.MES, 'mm' ) ) as MESES, "); 
                                                                                              sb.append("TO_NUMBER( amor.MONTO ) as MONTO "); 
                                                                               sb.append("from ");                                                                                      
                                                                                              sb.append("DDA_T_CONTRATO cnt, ");
                                                                                              sb.append("DDA_T_CONTRATO_TITULO tit, ");
                                                                                              sb.append("DDA_T_AMORTIZACION_PREVIA amor ");
                                                                               sb.append("where "); 
                                                                                              sb.append("cnt.ID_CONTRATO = tit.ID_CONTRATO ");
                                                                                              sb.append("and cnt.ID_CONTRATO = amor.ID_CONTRATO ");
                                                                                              sb.append("and tit.ID_TITULO_CNT = amor.ID_TITULO_CNT ");
                                                                                              sb.append("and cnt.ID_CONTRATO = ? ");
                                                               sb.append(") "); 
                                                               sb.append("PIVOT "); 
                                                               sb.append("( ");  
                                                                               sb.append("SUM( MONTO ) FOR MESES in ");  
                                                                               sb.append("( ");  
                                                                                              sb.append("1 as MES_1, 2 as MES_2, 3 as MES_3, 4 as MES_4, 5 as MES_5, 6 as MES_6, "); 
                                                                                              sb.append("7 as MES_7, 8 as MES_8, 9 as MES_9, 10 as MES_10, 11 as MES_11, 12 as MES_12 ");  
                                                                               sb.append(") "); 
                                                               sb.append(") "); 
                                               sb.append(") ");
                                               
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarAmortizacionAnual]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                               
                }

                
                @Override
                public boolean eliminarAmortizacionAnual(String pstIdContrato) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("delete "); 
                                               sbD.append("from ");
                                               sbD.append("DDA_T_AMORTIZACION_TITULO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [eliminarAmortizacionAnual]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("delete "); 
                                               sb.append("from ");
                                               sb.append("DDA_T_AMORTIZACION_TITULO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ?");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::eliminarAmortizacionAnual]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public int obtenerRegistrosBorrarAmortizacionAnual(String pstIdContrato) throws Exception 
                {
                               int resultado = 0;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //-- Debug
                                               sbD.append("select ");
                                               sbD.append("count(ID_TITULO_CNTORIG) as CUANTOS ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_AMORTIZACION_TITULO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerRegistrosBorrarAmortizacionAnual]:" + sbD.toString());
                                               
                                               //-- Ejecucion
                                               sb.append("select ");
                                               sb.append("count(ID_TITULO_CNTORIG) as CUANTOS ");
                                               sb.append("from ");
                                               sb.append("DDA_T_AMORTIZACION_TITULO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               resultado = (int)getJdbcTemplate().queryForInt(lstSQL,qryParams.toArray());
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerRegistrosBorrarAmortizacionAnual]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               return resultado;
                }

                @Override
                public String obtenerFechaSincronizacionSAP() throws Exception 
                {
                               List<ParametroDTO> lobResultado = new ArrayList<ParametroDTO>();
                               String resultado = "";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("SUBSTR(VALOR,4,2)||'/'||SUBSTR(VALOR,1,2)||'/'||SUBSTR(VALOR,7,4) as VALOR ");
                                               sbD.append("from ");
                                               sbD.append("DLA_C_PARAMETRO ");
                                               sbD.append("where ");
                                               sbD.append("CLAVE = '"+CVE_SINCRONIZACION+"' ");
                                               LOG.debug(">Sql_D [obtenerFechaSincronizacionSAP]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("SUBSTR(VALOR,4,2)||'/'||SUBSTR(VALOR,1,2)||'/'||SUBSTR(VALOR,7,4) as VALOR ");
                                               sb.append("from ");
                                               sb.append("DLA_C_PARAMETRO ");
                                               sb.append("where ");
                                               sb.append("CLAVE = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(CVE_SINCRONIZACION);
                                               
                                               lobResultado = (ArrayList<ParametroDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ParametroDTO>(ParametroDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getVALOR();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerFechaSincronizacionSAP]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                               /* SOS
                @Override
                public String obtenerAmortizacionAnualContrato(ParamAmortizacionAnualDTO dto) throws Exception 
                {
                               List<AmortizacionDTO> lobResultado = new ArrayList<AmortizacionDTO>();
                               String resultado = "";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntOriginal = (dto.getIdCntOriginal() != null && dto.getIdCntOriginal().trim().length() > 0) ? dto.getIdCntOriginal() : "";
                               String lstAnnio = (dto.getAnnio() != null && dto.getAnnio().trim().length() > 0) ? dto.getAnnio() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("nvl(sum(MONTO),0) as MONTO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_M_AMORTIZACION ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO_ORIGINAL = "+lstIdCntOriginal+" ");
                                               sbD.append("and to_char(MES,'yyyy') = '"+lstAnnio+"' ");
                                               LOG.debug(">Sql_D [obtenerAmortizacionAnualContrato]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("nvl(sum(MONTO),0) as MONTO ");
                                               sb.append("from ");
                                               sb.append("DDA_M_AMORTIZACION ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO_ORIGINAL = ? ");
                                               sb.append("and to_char(MES,'yyyy') = ? ");
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCntOriginal);
                                               qryParams.add(lstAnnio);
                                               
                                               lobResultado = (ArrayList<AmortizacionDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<AmortizacionDTO>(AmortizacionDTO.class));
                                               if(lobResultado.size() == 1)
                                                               resultado = lobResultado.get(0).getMONTO();
                                                               
                                               return resultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerAmortizacionAnualContrato]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerAmortizacionAnualContrato]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }
                               */
                
                               /* SOS
                @Override
                public String obtenerAmortizacionAnualApartado(ParamAmortizacionAnualDTO dto) throws Exception 
                {
                               List<AmortizacionDTO> lobResultado = new ArrayList<AmortizacionDTO>();
                               String resultado = "";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntOriginal = (dto.getIdCntOriginal() != null && dto.getIdCntOriginal().trim().length() > 0) ? dto.getIdCntOriginal() : "";
                               String lstAnnio = (dto.getAnnio() != null && dto.getAnnio().trim().length() > 0) ? dto.getAnnio() : "";
                               String lstIdApartado = (dto.getIdApartado() != null && dto.getIdApartado().trim().length() > 0) ? dto.getIdApartado() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select nvl(sum(MONTO),0) as MONTO ");
                                               sbD.append("from ");
                                               sbD.append("( ");
                                               sbD.append("select ");
                                               sbD.append("distinct amort.ID_AMORTIZACION, amort.MONTO as MONTO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO cnt, ");
                                               sbD.append("DDA_T_AMORTIZACION amort ");
                                               sbD.append("where ");
                                               sbD.append("ID_APARTADO = "+lstIdApartado+" ");
                                               sbD.append("and cnt.ID_CONTRATO_ORIGINAL <> "+lstIdCntOriginal+" ");
                                               sbD.append("and cnt.ID_CONTRATO_ORIGINAL = amort.ID_CONTRATO_ORIGINAL ");
                                               sbD.append("and to_char(amort.MES,'yyyy') = '"+lstAnnio+"' ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [obtenerAmortizacionAnualApartado]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select nvl(sum(MONTO),0) as MONTO ");
                                               sb.append("from ");
                                               sb.append("( ");
                                               sb.append("select ");
                                               sb.append("distinct amort.ID_AMORTIZACION, amort.MONTO as MONTO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO cnt, ");
                                               sb.append("DDA_T_AMORTIZACION amort ");
                                               sb.append("where ");
                                               sb.append("ID_APARTADO = ? ");
                                               sb.append("and cnt.ID_CONTRATO_ORIGINAL <> ? ");
                                               sb.append("and cnt.ID_CONTRATO_ORIGINAL = amort.ID_CONTRATO_ORIGINAL ");
                                               sb.append("and to_char(amort.MES,'yyyy') = ? ");
                                               sb.append(") ");
                                               
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdApartado);
                                               qryParams.add(lstIdCntOriginal);
                                               qryParams.add(lstAnnio);
                                               
                                               lobResultado = (ArrayList<AmortizacionDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<AmortizacionDTO>(AmortizacionDTO.class));
                                               if(lobResultado.size() == 1)
                                                               resultado = lobResultado.get(0).getMONTO();
                                                               
                                               return resultado;
                                               
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerAmortizacionAnualApartado]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerAmortizacionAnualApartado]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                }
                               */

                               /*
                @Override
                public String obtenerMontoAmortizablePresupuestoApdo(ParamAmortizacionAnualDTO dto) throws Exception 
                {
                               List<PresupuestoApdoDTO> lobResultado = new ArrayList<PresupuestoApdoDTO>();
                               String resultado = "";
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstAnnio = (dto.getAnnio() != null && dto.getAnnio().trim().length() > 0) ? dto.getAnnio() : "";
                               String lstIdApartado = (dto.getIdApartado() != null && dto.getIdApartado().trim().length() > 0) ? dto.getIdApartado() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("nvl(MONTO,0) as MONTO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_PRESUPUESTO_APARTADO ");
                                               sbD.append("where ");
                                               sbD.append("ANNIO = '"+lstAnnio+"' ");
                                               sbD.append("and ID_APARTADO = "+lstIdApartado+" ");
                                               LOG.debug(">Sql_D [obtenerMontoAmortizablePresupuestoApdo]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("nvl(MONTO,0) as MONTO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_PRESUPUESTO_APARTADO ");
                                               sb.append("where ");
                                               sb.append("ANNIO = ? ");
                                               sb.append("and ID_APARTADO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstAnnio);
                                               qryParams.add(lstIdApartado);
                                               
                                               lobResultado = (ArrayList<PresupuestoApdoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<PresupuestoApdoDTO>(PresupuestoApdoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = lobResultado.get(0).getMONTO();
                               }
                               catch(EmptyResultDataAccessException er)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontoAmortizablePresupuestoApdo]: No se encontraron registros coincidentes. " + er.getMessage() );
                                               throw new Exception("No se encontraron registros coincidentes.");
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontoAmortizablePresupuestoApdo]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                                               
                }
                               */

                @Override
                public String obtenerSiguienteIdCargaAIBV() throws Exception 
                {
                               /* Se usa el objeto de ContratoTituloDTO para no tener que crear un DTO para el ID de Carga ya que solo se usaria para este proposito*/
                               String resultado = "-1";
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select DDA_SQT_CARGABV_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               LOG.debug(">Sql_D [obtenerSiguienteIdCarga_AIBV]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select DDA_SQT_CARGABV_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               final String lstSQL = sb.toString();

                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getID_LISTA();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSiguienteIdCarga_AIBV]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean insertarRegistroPrincipalCargaAIBV(CargaPrincipalAibvDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               String lstArchivoXL = (dto.getARCHIVO_XLSX() != null && dto.getARCHIVO_XLSX().trim().length() > 0) ? dto.getARCHIVO_XLSX() : "";
                               String lstExpediente = (dto.getEXPEDIENTE() != null && dto.getEXPEDIENTE().trim().length() > 0) ? dto.getEXPEDIENTE() : "";

                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CARGABV_PRINCIPAL ");
                                               sbD.append("( ");
                                               sbD.append("ID_CARGA, "); 
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ARCHIVO_XLSX, "); 
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("FECHA_CARGA ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append(lstIdCarga+", "); 
                                               sbD.append(lstIdContrato+", "); 
                                               sbD.append("'"+lstArchivoXL+"', "); 
                                               sbD.append("'"+lstExpediente+"', ");
                                               sbD.append("SYSDATE ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [insertarRegistroPrincipalCargaAIBV]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CARGABV_PRINCIPAL ");
                                               sb.append("( ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ARCHIVO_XLSX, "); 
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("FECHA_CARGA ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("SYSDATE ");
                                               sb.append(") ");
                                               
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstArchivoXL);
                                               qryParams.add(lstExpediente);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::insertarRegistroPrincipalCargaAIBV]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPProcesaActualizaIdBV(CargaPrincipalAibvDTO dto) throws Exception 
                {
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_ACTUALIZAIDBV");
                                               LOG.debug(">Sql_D [ejecutarSPProcesaActualizaIdBV]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_ACTUALIZAIDBV(?,?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstIdContrato);
                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPProcesaActualizaIdBV]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                
                @Override
                public CargaPrincipalAibvDTO obtenerDatosFinalesActualizaIdBV(String pstIdCarga) throws Exception 
                {
                               List<CargaPrincipalAibvDTO> lobResultado = new ArrayList<CargaPrincipalAibvDTO>();
                               CargaPrincipalAibvDTO resultado = new CargaPrincipalAibvDTO();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCarga = (pstIdCarga != null && pstIdCarga.trim().length() > 0) ? pstIdCarga : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_CARGA, "); 
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ARCHIVO_XLSX, ");
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, "); 
                                               sbD.append("TOTAL_REGISTROS, "); 
                                               sbD.append("TOTAL_CARGADOS, "); 
                                               sbD.append("TOTAL_ERROR ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CARGABV_PRINCIPAL ");
                                               sbD.append("where "); 
                                               sbD.append("ID_CARGA = "+lstIdCarga);
                                               LOG.debug(">Sql_D [obtenerDatosFinalesActualizaIdBV]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ARCHIVO_XLSX, ");
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, "); 
                                               sb.append("TOTAL_REGISTROS, "); 
                                               sb.append("TOTAL_CARGADOS, "); 
                                               sb.append("TOTAL_ERROR ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CARGABV_PRINCIPAL ");
                                               sb.append("where "); 
                                               sb.append("ID_CARGA = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               
                                               
                                               
                                               lobResultado = (ArrayList<CargaPrincipalAibvDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CargaPrincipalAibvDTO>(CargaPrincipalAibvDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (CargaPrincipalAibvDTO) lobResultado.get(0);
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDatosFinalesActualizaIdBV]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
                
                
                @Override
                public boolean ejecutarSPObtenerCostoTitulo(ParamValorTituloDTO dto) throws Exception 
                {
                               String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0)     ? dto.getIdContrato() : "";
                               String lstFechaMes = (dto.getMesCalculo() != null && dto.getMesCalculo().trim().length() > 0)    ? dto.getMesCalculo() : "";
                               String lstOrigenTitulos = (dto.getOrigenTitulos() != null && dto.getOrigenTitulos().trim().length() > 0) ? dto.getOrigenTitulos() : "";
                               
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_COSTOTITULO");
                                               LOG.debug(">Sql_D [ejecutarSPObtenerCostoTitulo]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_COSTOTITULO(?,?,?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstFechaMes);
                                               qryParams.add(lstOrigenTitulos);
                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPObtenerCostoTitulo]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPCalculoPagoEstudios(String pstIdContrato) throws Exception 
                {
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0)            ? pstIdContrato : "";
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_REPORTEPAGOS");
                                               LOG.debug(">Sql_D [ejecutarSPCalculoPagoEstudios]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_REPORTEPAGOS(?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPCalculoPagoEstudios]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public String obtenerValidacionMinSeleccion(ParamValidaMinimoSeleccionDTO dto) throws Exception 
                {
                               String resultado = "NO_OK|Error al ejecutar el proceso";
                               List<ResponseValidaMinimoSeleccionDTO> lobResultado = new ArrayList<ResponseValidaMinimoSeleccionDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
                               String lstOrigen = (dto.getOrigenTitulos() != null && dto.getOrigenTitulos().trim().length() > 0) ? dto.getOrigenTitulos() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select DDA_VALIDARMINIMOS( "+lstIdContrato+", '"+lstOrigen+"' ) as mensaje from dual ");
                                               LOG.debug(">Sql_D [obtenerValidacionMinSeleccion]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select DDA_VALIDARMINIMOS( ?, ? ) as mensaje from dual ");
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstOrigen);
                                               
                                               lobResultado = (ArrayList<ResponseValidaMinimoSeleccionDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ResponseValidaMinimoSeleccionDTO>(ResponseValidaMinimoSeleccionDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getMensaje();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerValidacionMinSeleccion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPProcesaCargaTitulosLF(CargaPrincipalDTO dto) throws Exception 
                {
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               String lstIdListaActual = (dto.getID_LISTA() != null && dto.getID_LISTA().trim().length() > 0) ? dto.getID_LISTA() : "";
                               String lstTipoLista = (dto.getTIPO_LISTA() != null && dto.getTIPO_LISTA().trim().length() > 0) ? dto.getTIPO_LISTA() : "";
                               String lstTipoCarga = (dto.getTIPO_CARGA() != null && dto.getTIPO_CARGA().trim().length() > 0) ? dto.getTIPO_CARGA() : "";
                               String lstFechaInicioLstNva = (dto.getFECHA_INICIO_LSTNVA() != null && dto.getFECHA_INICIO_LSTNVA().trim().length() > 0) ? dto.getFECHA_INICIO_LSTNVA() : "";
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_CARGATITULOSLF");
                                               LOG.debug(">Sql_D [ejecutarSPProcesaCargaTitulosLF]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_CARGATITULOSLF(?,?,?,?,?,?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdListaActual);
                                               qryParams.add(lstTipoLista);
                                               qryParams.add(lstTipoCarga);
                                               qryParams.add(lstFechaInicioLstNva);
                                               
                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPProcesaCargaTitulosLF]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean insertarRegistroPrincipalCargaTR(CargaPrincipalTRDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               String lstIdListaActual = (dto.getID_LISTA() != null && dto.getID_LISTA().trim().length() > 0) ? dto.getID_LISTA() : "";
                               String lstTipoLista = (dto.getTIPO_LISTA() != null && dto.getTIPO_LISTA().trim().length() > 0) ? dto.getTIPO_LISTA() : "";
                               String lstTipoCarga = (dto.getTIPO_CARGA() != null && dto.getTIPO_CARGA().trim().length() > 0) ? dto.getTIPO_CARGA() : "";
                               String lstArchivoXL = (dto.getARCHIVO_XLSX() != null && dto.getARCHIVO_XLSX().trim().length() > 0) ? dto.getARCHIVO_XLSX() : "";
                               String lstExpediente = (dto.getEXPEDIENTE() != null && dto.getEXPEDIENTE().trim().length() > 0) ? dto.getEXPEDIENTE() : "";
                               String lstFechaInicioLstNva = (dto.getFECHA_INICIO_LSTNVA() != null && dto.getFECHA_INICIO_LSTNVA().trim().length() > 0) ? dto.getFECHA_INICIO_LSTNVA() : "VACIO";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CARGATR_PRINCIPAL ");
                                               sbD.append("( ");
                                               sbD.append("ID_CARGA, "); 
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ID_LISTA, "); 
                                               sbD.append("TIPO_LISTA, "); 
                                               sbD.append("TIPO_CARGA, "); 
                                               sbD.append("ARCHIVO_XLSX, "); 
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("FECHA_CARGA, ");
                                               sbD.append("FECHA_INICIO_LSTNVA ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append(lstIdCarga+", "); 
                                               sbD.append(lstIdContrato+", "); 
                                               sbD.append(lstIdListaActual+", "); 
                                               sbD.append("'"+lstTipoLista+"', "); 
                                               sbD.append("'"+lstTipoCarga+"', "); 
                                               sbD.append("'"+lstArchivoXL+"', "); 
                                               sbD.append("'"+lstExpediente+"', ");
                                               sbD.append("SYSDATE, ");
                                               if(lstFechaInicioLstNva.equalsIgnoreCase("NULL"))
                                                               sbD.append("NULL ");
                                               else
                                                               sbD.append("to_date('"+lstFechaInicioLstNva+"','yyyy-mm-dd') ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [insertarRegistroPrincipalCargaTR]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CARGATR_PRINCIPAL ");
                                               sb.append("( ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ID_LISTA, "); 
                                               sb.append("TIPO_LISTA, "); 
                                               sb.append("TIPO_CARGA, "); 
                                               sb.append("ARCHIVO_XLSX, "); 
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("FECHA_CARGA, ");
                                               sb.append("FECHA_INICIO_LSTNVA ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, ");
                                               sb.append("SYSDATE, ");
                                               sb.append("? ");
                                               sb.append(") ");
                                               
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdListaActual);
                                               qryParams.add(lstTipoLista);
                                               qryParams.add(lstTipoCarga);
                                               qryParams.add(lstArchivoXL);
                                               qryParams.add(lstExpediente);
                                               
                                               if(lstFechaInicioLstNva.equalsIgnoreCase("NULL"))
                                               {
                                                               qryParams.add(null);
                                               }
                                               else
                                               {
                                                               lobTSFecha.setTime(df.parse(lstFechaInicioLstNva+" 12:00:00").getTime());
                                                               qryParams.add(lobTSFecha);
                                               }

                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::insertarRegistroPrincipalCargaTR]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPProcesaCargaTitulosTR(CargaPrincipalTRDTO dto) throws Exception 
                {
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               String lstIdListaActual = (dto.getID_LISTA() != null && dto.getID_LISTA().trim().length() > 0) ? dto.getID_LISTA() : "";
                               String lstTipoLista = (dto.getTIPO_LISTA() != null && dto.getTIPO_LISTA().trim().length() > 0) ? dto.getTIPO_LISTA() : "";
                               String lstTipoCarga = (dto.getTIPO_CARGA() != null && dto.getTIPO_CARGA().trim().length() > 0) ? dto.getTIPO_CARGA() : "";
                               String lstFechaInicioLstNva = (dto.getFECHA_INICIO_LSTNVA() != null && dto.getFECHA_INICIO_LSTNVA().trim().length() > 0) ? dto.getFECHA_INICIO_LSTNVA() : "";
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_CARGATITULOSTR");
                                               LOG.debug(">Sql_D [ejecutarSPProcesaCargaTitulosTR]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_CARGATITULOSTR(?,?,?,?,?,?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdListaActual);
                                               qryParams.add(lstTipoLista);
                                               qryParams.add(lstTipoCarga);
                                               qryParams.add(lstFechaInicioLstNva);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPProcesaCargaTitulosTR]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public CargaPrincipalTRDTO obtenerDatosFinalesCargaTR(String pstIdCarga) throws Exception 
                {
                               List<CargaPrincipalTRDTO> lobResultado = new ArrayList<CargaPrincipalTRDTO>();
                               CargaPrincipalTRDTO resultado = new CargaPrincipalTRDTO();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCarga = (pstIdCarga != null && pstIdCarga.trim().length() > 0) ? pstIdCarga : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_CARGA, "); 
                                               sbD.append("ID_CONTRATO, "); 
                                               sbD.append("ID_LISTA, "); 
                                               sbD.append("TIPO_LISTA, "); 
                                               sbD.append("TIPO_CARGA, "); 
                                               sbD.append("ARCHIVO_XLSX, ");
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, "); 
                                               sbD.append("TOTAL_REGISTROS, "); 
                                               sbD.append("TOTAL_CARGADOS, "); 
                                               sbD.append("TOTAL_ERROR, ");
                                               sbD.append("ID_LISTA_NUEVA, ");
                                               sbD.append("to_char(FECHA_INICIO_LSTNVA,'mm/dd/yyyy') as FECHA_INICIO_LSTNVA ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CARGATR_PRINCIPAL ");
                                               sbD.append("where "); 
                                               sbD.append("ID_CARGA = "+lstIdCarga);
                                               LOG.debug(">Sql_D [obtenerDatosFinalesCargaTR]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ID_CONTRATO, "); 
                                               sb.append("ID_LISTA, "); 
                                               sb.append("TIPO_LISTA, "); 
                                               sb.append("TIPO_CARGA, "); 
                                               sb.append("ARCHIVO_XLSX, ");
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, "); 
                                               sb.append("TOTAL_REGISTROS, "); 
                                               sb.append("TOTAL_CARGADOS, "); 
                                               sb.append("TOTAL_ERROR, ");
                                               sb.append("ID_LISTA_NUEVA, ");
                                               sb.append("to_char(FECHA_INICIO_LSTNVA,'mm/dd/yyyy') as FECHA_INICIO_LSTNVA ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CARGATR_PRINCIPAL ");
                                               sb.append("where "); 
                                               sb.append("ID_CARGA = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               
                                               
                                               
                                               lobResultado = (ArrayList<CargaPrincipalTRDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CargaPrincipalTRDTO>(CargaPrincipalTRDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (CargaPrincipalTRDTO) lobResultado.get(0);
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDatosFinalesCargaTR]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public String obtenerSiguienteIdCargaPN() throws Exception 
                {
                               /* Se usa el objeto de ContratoTituloDTO para no tener que crear un DTO para el ID de Carga ya que solo se usaria para este proposito*/
                               String resultado = "-1";
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select DDA_SQT_CARGAPN_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               LOG.debug(">Sql_D [obtenerSiguienteIdCargaTR]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select DDA_SQT_CARGAPN_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               final String lstSQL = sb.toString();

                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getID_LISTA();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSiguienteIdCargaPN]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean insertarRegistroPrincipalCargaPN(CargaPrincipalPNDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstArchivoXL = (dto.getARCHIVO_XLSX() != null && dto.getARCHIVO_XLSX().trim().length() > 0) ? dto.getARCHIVO_XLSX() : "";
                               String lstExpediente = (dto.getEXPEDIENTE() != null && dto.getEXPEDIENTE().trim().length() > 0) ? dto.getEXPEDIENTE() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CARGAPN_PRINCIPAL ");
                                               sbD.append("( ");
                                               sbD.append("ID_CARGA, "); 
                                               sbD.append("ARCHIVO_XLSX, "); 
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("FECHA_CARGA ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append(lstIdCarga+", "); 
                                               sbD.append("'"+lstArchivoXL+"', "); 
                                               sbD.append("'"+lstExpediente+"', ");
                                               sbD.append("SYSDATE ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [insertarRegistroPrincipalCargaPN]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CARGAPN_PRINCIPAL ");
                                               sb.append("( ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ARCHIVO_XLSX, "); 
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("FECHA_CARGA ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("SYSDATE ");
                                               sb.append(") ");
                                               
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstArchivoXL);
                                               qryParams.add(lstExpediente);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::insertarRegistroPrincipalCargaPN]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPProcesaCargaTitulosPN(ParamSP_CargaTitulosPNDTO dto) throws Exception 
                {
                               String lstIdCargaPN = (dto.getIdCargaPN() != null && dto.getIdCargaPN().trim().length() > 0) ? dto.getIdCargaPN() : "";
                               String lstIdCargaTransacciones = (dto.getIdCargaTransacciones() != null && dto.getIdCargaTransacciones().trim().length() > 0) ? dto.getIdCargaTransacciones() : "";
                               
                               LOG.debug("lstIdCargaPN:" + lstIdCargaPN);
                               LOG.debug("lstIdCargaTransacciones:" + lstIdCargaTransacciones);
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_CARGATITULOSPN");
                                               LOG.debug(">Sql_D [ejecutarSPProcesaCargaTitulosPN]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_CARGATITULOSPN(?,?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCargaPN);
                                               qryParams.add(lstIdCargaTransacciones);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPProcesaCargaTitulosPN]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public CargaPrincipalPNDTO obtenerDatosFinalesCargaPN(String pstIdCarga) throws Exception 
                {
                               List<CargaPrincipalPNDTO> lobResultado = new ArrayList<CargaPrincipalPNDTO>();
                               CargaPrincipalPNDTO resultado = new CargaPrincipalPNDTO();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCarga = (pstIdCarga != null && pstIdCarga.trim().length() > 0) ? pstIdCarga : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_CARGA, ");
                                               sbD.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, ");
                                               sbD.append("EXPEDIENTE, ");
                                               sbD.append("ARCHIVO_XLSX, ");
                                               sbD.append("TOTAL_REGISTROS, "); 
                                               sbD.append("TOTAL_CARGADOS, "); 
                                               sbD.append("TOTAL_ERROR ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CARGAPN_PRINCIPAL ");
                                               sbD.append("where "); 
                                               sbD.append("ID_CARGA = "+lstIdCarga);
                                               LOG.debug(">Sql_D [obtenerDatosFinalesCargaPN]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_CARGA, ");
                                               sb.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, ");
                                               sb.append("EXPEDIENTE, ");
                                               sb.append("ARCHIVO_XLSX, ");
                                               sb.append("TOTAL_REGISTROS, "); 
                                               sb.append("TOTAL_CARGADOS, "); 
                                               sb.append("TOTAL_ERROR ");
                                               sb.append("from "); 
                                                sb.append("DDA_T_CARGAPN_PRINCIPAL ");
                                               sb.append("where "); 
                                               sb.append("ID_CARGA = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               LOG.debug("lstSQL: " + lstSQL);
                                               qryParams.add(lstIdCarga);
                                               
                                               lobResultado = (ArrayList<CargaPrincipalPNDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CargaPrincipalPNDTO>(CargaPrincipalPNDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (CargaPrincipalPNDTO) lobResultado.get(0);
                                               
                                }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDatosFinalesCargaPN]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPAsociarTitTransCntVigentes(String pstIdCargaTrans) throws Exception 
                {
                               String lstIdCargaTransacciones = (pstIdCargaTrans != null && pstIdCargaTrans.trim().length() > 0) ? pstIdCargaTrans : "";
                               LOG.debug("lstIdCargaTransacciones:" + lstIdCargaTransacciones);
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_ASOC_TITTRANS_CNTVIG");
                                               LOG.debug(">Sql_D [ejecutarSPAsociarTitTransCntVigentes]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_ASOC_TITTRANS_CNTVIG(?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCargaTransacciones);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPAsociarTitTransCntVigentes]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public CargaTransaccionDTO obtenerDatosFinalesAsocTitTransCntVigentes(String pstIdCargaTrans) throws Exception 
                {
                               List<CargaTransaccionDTO> lobResultado = new ArrayList<CargaTransaccionDTO>();
                               CargaTransaccionDTO resultado = new CargaTransaccionDTO();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCargaTrans = (pstIdCargaTrans != null && pstIdCargaTrans.trim().length() > 0) ? pstIdCargaTrans : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_CARGA_TRANS, ");
                                               sbD.append("to_char(MES,'mm/yyyy') as MES, ");
                                               sbD.append("to_char(FECHA_VOBO,'mm/yyyy') as FECHA_VOBO, ");
                                               sbD.append("ESTATUS_CARGA, ");
                                               sbD.append("TOTAL_REGISTROS, "); 
                                               sbD.append("TOTAL_CORRECTOS, "); 
                                               sbD.append("TOTAL_ERROR ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CARGA_TRANSACCION ");
                                               sbD.append("where "); 
                                               sbD.append("ID_CARGA_TRANS = "+lstIdCargaTrans+" ");
                                               LOG.debug(">Sql_D [obtenerDatosFinalesAsocTitTransCntVigentes]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_CARGA_TRANS, ");
                                               sb.append("to_char(MES,'mm/yyyy') as MES, ");
                                               sb.append("to_char(FECHA_VOBO,'mm/yyyy') as FECHA_VOBO, ");
                                               sb.append("ESTATUS_CARGA, ");
                                               sb.append("TOTAL_REGISTROS, "); 
                                               sb.append("TOTAL_CORRECTOS, "); 
                                               sb.append("TOTAL_ERROR ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CARGA_TRANSACCION ");
                                               sb.append("where "); 
                                               sb.append("ID_CARGA_TRANS = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               LOG.debug("lstSQL: " + lstSQL);
                                               qryParams.add(lstIdCargaTrans);
                                               
                                               lobResultado = (ArrayList<CargaTransaccionDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CargaTransaccionDTO>(CargaTransaccionDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (CargaTransaccionDTO) lobResultado.get(0);
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDatosFinalesAsocTitTransCntVigentes]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public String obtenerSiguienteIdCargaVS() throws Exception 
                {
                               /* Se usa el objeto de ContratoTituloDTO para no tener que crear un DTO para el ID de Carga ya que solo se usaria para este proposito*/
                               String resultado = "-1";
                                List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select DDA_SQT_CARGAVS_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               LOG.debug(">Sql_D [obtenerSiguienteIdCargaTR]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select DDA_SQT_CARGAVS_PRINCIPAL.NEXTVAL as ID_LISTA from dual ");
                                               final String lstSQL = sb.toString();

                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (String) lobResultado.get(0).getID_LISTA();
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerSiguienteIdCargaVS]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean insertarRegistroPrincipalCargaVS(CargaPrincipalVSDTO dto) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstArchivoXL = (dto.getARCHIVO_XLSX() != null && dto.getARCHIVO_XLSX().trim().length() > 0) ? dto.getARCHIVO_XLSX() : "";
                               String lstExpediente = (dto.getEXPEDIENTE() != null && dto.getEXPEDIENTE().trim().length() > 0) ? dto.getEXPEDIENTE() : "";
                               String lstMes = (dto.getMES() != null && dto.getMES().trim().length() > 0) ? dto.getMES() : "VACIO";
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_CARGAVS_PRINCIPAL ");
                                               sbD.append("( ");
                                               sbD.append("ID_CARGA, "); 
                                                sbD.append("ARCHIVO_XLSX, "); 
                                               sbD.append("EXPEDIENTE, "); 
                                               sbD.append("FECHA_CARGA, "); 
                                               sbD.append("MES ");
                                               sbD.append(") "); 
                                               sbD.append("VALUES ");
                                               sbD.append("( ");
                                               sbD.append(lstIdCarga+", "); 
                                               sbD.append("'"+lstArchivoXL+"', "); 
                                               sbD.append("'"+lstExpediente+"', "); 
                                               sbD.append("SYSDATE, "); 
                                               sbD.append("to_date('"+lstMes+"','yyyy-mm-dd') ");
                                               sbD.append(") ");
                                               LOG.debug(">Sql_D [insertarRegistroPrincipalCargaVS]:" + sbD.toString());
                                               

                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_CARGAVS_PRINCIPAL ");
                                               sb.append("( ");
                                               sb.append("ID_CARGA, "); 
                                               sb.append("ARCHIVO_XLSX, "); 
                                               sb.append("EXPEDIENTE, "); 
                                               sb.append("FECHA_CARGA, "); 
                                               sb.append("MES ");
                                               sb.append(") "); 
                                               sb.append("VALUES ");
                                               sb.append("( ");
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("?, "); 
                                               sb.append("SYSDATE, "); 
                                               sb.append("? ");
                                               sb.append(") ");
                                               

                                               final String sql = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstArchivoXL);
                                               qryParams.add(lstExpediente);
                                               lobTSFecha.setTime(df.parse(lstMes+" 12:00:00").getTime());
                                               qryParams.add(lobTSFecha);

                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::insertarRegistroPrincipalCargaVS]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPProcesaCargaTitulosVS(CargaPrincipalVSDTO dto) throws Exception
                {
                               String lstIdCarga = (dto.getID_CARGA() != null && dto.getID_CARGA().trim().length() > 0) ? dto.getID_CARGA() : "";
                               String lstMesCarga = (dto.getMES() != null && dto.getMES().trim().length() > 0) ? dto.getMES() : "";
                                
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_CARGATITULOSVS");
                                               LOG.debug(">Sql_D [ejecutarSPProcesaCargaTitulosVS]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_CARGATITULOSVS(?,?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdCarga);
                                               qryParams.add(lstMesCarga);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPProcesaCargaTitulosVS]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public CargaPrincipalVSDTO obtenerDatosFinalesCargaVS(String pstIdCarga) throws Exception 
                {
                               List<CargaPrincipalVSDTO> lobResultado = new ArrayList<CargaPrincipalVSDTO>();
                               CargaPrincipalVSDTO resultado = new CargaPrincipalVSDTO();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCarga = (pstIdCarga != null && pstIdCarga.trim().length() > 0) ? pstIdCarga : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_CARGA, ");
                                               sbD.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, ");
                                               sbD.append("EXPEDIENTE, ");
                                               sbD.append("ARCHIVO_XLSX, ");
                                               sbD.append("TOTAL_REGISTROS, "); 
                                               sbD.append("TOTAL_CARGADOS, "); 
                                               sbD.append("TOTAL_ERROR, ");
                                               sbD.append("to_char(MES,'mm/dd/yyyy') as MES ");
                                               sbD.append("from "); 
                                               sbD.append("DDA_T_CARGAVS_PRINCIPAL ");
                                               sbD.append("where "); 
                                               sbD.append("ID_CARGA = "+lstIdCarga);
                                               LOG.debug(">Sql_D [obtenerDatosFinalesCargaVS]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("select ");
                                               sb.append("ID_CARGA, ");
                                               sb.append("to_char(FECHA_CARGA,'mm/dd/yyyy') as FECHA_CARGA, ");
                                               sb.append("EXPEDIENTE, ");
                                               sb.append("ARCHIVO_XLSX, ");
                                               sb.append("TOTAL_REGISTROS, "); 
                                               sb.append("TOTAL_CARGADOS, "); 
                                               sb.append("TOTAL_ERROR, ");
                                               sb.append("to_char(MES,'mm/dd/yyyy') as MES ");
                                               sb.append("from "); 
                                               sb.append("DDA_T_CARGAVS_PRINCIPAL ");
                                               sb.append("where "); 
                                               sb.append("ID_CARGA = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               LOG.debug("lstSQL: " + lstSQL);
                                               qryParams.add(lstIdCarga);
                                               
                                               lobResultado = (ArrayList<CargaPrincipalVSDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<CargaPrincipalVSDTO>(CargaPrincipalVSDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (CargaPrincipalVSDTO) lobResultado.get(0);
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerDatosFinalesCargaVS]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public List<ContratoTituloDTO> obtenerTitulosPorContratoAmortizacion(String pstIdContrato) throws Exception 
                {
                               List<ContratoTituloDTO> lobResultado = new ArrayList<ContratoTituloDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("select ");
                                               sbD.append("ID_TITULO_CNT, ");
                                               sbD.append("COSTO, ");
                                               sbD.append("MESES_VU, ");
                                               sbD.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_CONTRATO_TITULO ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerTitulosPorContratoAmortizacion]:" + sbD.toString());
                                               
                                               //--Ejecucin
                                               sb.append("select ");
                                               sb.append("ID_TITULO_CNT, ");
                                               sb.append("COSTO, ");
                                               sb.append("MESES_VU, ");
                                               sb.append("to_char(FECHA_INICIO,'dd/mm/yyyy') as FECHA_INICIO ");
                                               sb.append("from ");
                                               sb.append("DDA_T_CONTRATO_TITULO ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lobResultado = (ArrayList<ContratoTituloDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<ContratoTituloDTO>(ContratoTituloDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerTitulosPorContratoAmortizacion]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                
                               return lobResultado;
                }

                @Override
                public boolean eliminarAmortizacionPrevia(String pstIdContrato) throws Exception 
                {
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("delete "); 
                                               sbD.append("from ");
                                               sbD.append("DDA_T_AMORTIZACION_PREVIA ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [eliminarAmortizacionPrevia]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("delete "); 
                                               sb.append("from ");
                                               sb.append("DDA_T_AMORTIZACION_PREVIA ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               if(lnuRowsUpdate > 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::eliminarAmortizacionPrevia]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean registrarAmortizacionPrevia(AmortizacionPreviaDTO dto, String pstMesesVU) throws Exception 
                {
                               boolean resultado = false;
                               List<Object> qryParams = new ArrayList<Object>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               
                               String lstIdContrato = (dto.getID_CONTRATO() != null && dto.getID_CONTRATO().trim().length() > 0) ? dto.getID_CONTRATO() : "";
                               String lstIdTituloCnt = (dto.getID_TITULO_CNT() != null && dto.getID_TITULO_CNT().trim().length() > 0) ? dto.getID_TITULO_CNT() : "";
                               String lstMes = (dto.getMES() != null && dto.getMES().trim().length() > 0) ? dto.getMES() : "";
                               String lstMonto = (dto.getMONTO() != null && dto.getMONTO().trim().length() > 0) ? dto.getMONTO() : "";
                               String lstVU = (pstMesesVU != null && pstMesesVU.trim().length() > 0) ? pstMesesVU : "";
                               
                               
                               DateFormat df = new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
                               Timestamp lobTSFecha = new Timestamp(df.parse("2015-01-01 12:00:00").getTime());
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("INSERT INTO DDA_T_AMORTIZACION_PREVIA ");   
                                               sbD.append("SELECT "); 
                                               sbD.append("DDA_SQT_AMORTIZACION_PREVIA.nextVal as ID_AMORTIZACION, ");
                                               sbD.append(lstIdContrato + " as ID_CONTRATO, ");
                                               sbD.append(lstIdTituloCnt + " as ID_TITULO_CNT, ");
                                               sbD.append("to_date('01/'||TO_CHAR( ADD_MONTHS( to_date('"+lstMes+"','dd/mm/yyyy'), LEVEL - 1 ), 'mm/yyyy' ),'dd/mm/yyyy') AS MES, ");
                                               sbD.append(lstMonto + " as MONTO ");
                                               sbD.append("FROM dual ");
                                               sbD.append("CONNECT BY "); 
                                               sbD.append("LEVEL <= "+lstVU+" ");
                                               LOG.debug(">Sql_D [registrarAmortizacionPrevia]:" + sbD.toString());
                                               
                                               
                                               //--Ejecucion
                                               sb.append("INSERT INTO DDA_T_AMORTIZACION_PREVIA ");   
                                               sb.append("SELECT "); 
                                               sb.append("DDA_SQT_AMORTIZACION_PREVIA.nextVal as ID_AMORTIZACION, ");
                                               sb.append("? as ID_CONTRATO, ");
                                               sb.append("? as ID_TITULO_CNT, ");
                                               sb.append("to_date('01/'||TO_CHAR( ADD_MONTHS( to_date(?,'dd/mm/yyyy'), LEVEL - 1 ), 'mm/yyyy' ),'dd/mm/yyyy') AS MES, ");
                                               sb.append("? as MONTO ");
                                               sb.append("FROM dual ");
                                               sb.append("CONNECT BY "); 
                                               sb.append("LEVEL <= ? ");
                                               
                                               final String sql = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               qryParams.add(lstIdTituloCnt);
                                               qryParams.add(lstMes);
                                               qryParams.add(lstMonto);
                                               qryParams.add(lstVU);
                                               
                                               int lnumRowsInsertados = jdbcTemplate.update(sql,qryParams.toArray());
                               
                                               if(lnumRowsInsertados > 0)
                                                               resultado = true;
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::registrarAmortizacionPrevia]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public int obtenerRegistrosBorrarAmortizacionPrevia(String pstIdContrato) throws Exception 
                {
                               int resultado = 0;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //-- Debug
                                               sbD.append("select ");
                                               sbD.append("count(ID_AMORTIZACION) as CUANTOS ");
                                               sbD.append("from ");
                                               sbD.append("DDA_T_AMORTIZACION_PREVIA ");
                                               sbD.append("where ");
                                               sbD.append("ID_CONTRATO = "+lstIdContrato+" ");
                                               LOG.debug(">Sql_D [obtenerRegistrosBorrarAmortizacionPrevia]:" + sbD.toString());
                                               
                                               //-- Ejecucion
                                               sb.append("select ");
                                               sb.append("count(ID_AMORTIZACION) as CUANTOS ");
                                               sb.append("from ");
                                               sb.append("DDA_T_AMORTIZACION_PREVIA ");
                                               sb.append("where ");
                                               sb.append("ID_CONTRATO = ? ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               resultado = (int)getJdbcTemplate().queryForInt(lstSQL,qryParams.toArray());
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerRegistrosBorrarAmortizacionPrevia]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               return resultado;
                }

                @Override
                public List<QryCostoCntPorAnnioDTO> obtenerCostoContratoPorAnnio(String pstIdContrato) throws Exception {

                               List<QryCostoCntPorAnnioDTO> lobResultado = new ArrayList<QryCostoCntPorAnnioDTO>();
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("SELECT ");
                                               sbD.append("TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) as ANNIO, ");
                                               sbD.append("ROUND( SUM( tit.COSTO ), 2 ) as MONTO ");
                                               sbD.append("FROM ");
                                               sbD.append("DDA_T_CONTRATO cnt, ");
                                               sbD.append("DDA_T_CONTRATO_TITULO tit ");
                                               sbD.append("WHERE ");
                                               sbD.append("cnt.ID_CONTRATO = " + lstIdContrato + " ");
                                               sbD.append("and cnt.ID_CONTRATO = tit.ID_CONTRATO ");
                                               sbD.append("and tit.ESTATUS = 'ACTIVO' ");
                                               sbD.append("and TO_NUMBER( TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) ) >= TO_NUMBER( TO_CHAR( sysdate, 'yyyy' ) ) ");
                                                sbD.append("group by TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) ");
                                               sbD.append("order by TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) ");
                                               
                                               LOG.debug(">Sql_D [obtenerCostoContratoPorAnnio]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("SELECT ");
                                               sb.append("TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) as ANNIO, ");
                                               sb.append("ROUND( SUM( tit.COSTO ), 2 ) as MONTO ");
                                               sb.append("FROM ");
                                               sb.append("DDA_T_CONTRATO cnt, ");
                                               sb.append("DDA_T_CONTRATO_TITULO tit ");
                                               sb.append("WHERE ");
                                               sb.append("cnt.ID_CONTRATO = ? ");
                                               sb.append("and cnt.ID_CONTRATO = tit.ID_CONTRATO ");
                                               sb.append("and tit.ESTATUS = 'ACTIVO' ");
                                               sb.append("and TO_NUMBER( TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) ) >= TO_NUMBER( TO_CHAR( sysdate, 'yyyy' ) ) ");
                                               sb.append("group by TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) ");
                                               sb.append("order by TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);                                 
                                               
                                               lobResultado = (ArrayList<QryCostoCntPorAnnioDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryCostoCntPorAnnioDTO>(QryCostoCntPorAnnioDTO.class));
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerCostoContratoPorAnnio]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return lobResultado;
                }

                @Override
                public QryMontosPresupuestoDTO obtenerMontosPresupuestoAnual(ParamPresupuestoDTO dto) throws Exception {
                               
                               List<QryMontosPresupuestoDTO> lobResultado = new ArrayList<QryMontosPresupuestoDTO>();
                               QryMontosPresupuestoDTO resultado = new QryMontosPresupuestoDTO();
                               
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               
                               String lstIdCntOriginal = (dto.getIdCntOriginal() != null && dto.getIdCntOriginal().trim().length() > 0) ? dto.getIdCntOriginal() : "";
                               String lstIdApartado = (dto.getIdApartado() != null && dto.getIdApartado().trim().length() > 0) ? dto.getIdApartado() : "";
                               String lstAnnio = (dto.getAnnio() != null && dto.getAnnio().trim().length() > 0) ? dto.getAnnio() : "";
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("SELECT ");
                                               sbD.append("NVL( ASIGNADO, 0 ) as ASIGNADO, ");
                                               sbD.append("COMPROMETIDO as COMPROMETIDO ");
                                               sbD.append("FROM ");
                                               sbD.append("( ");
                                                               sbD.append("SELECT ");     
                                                               sbD.append("'"+lstAnnio+"' as ANNIO, "); 
                                                               sbD.append("NVL( ROUND( SUM( TO_NUMBER( tit.COSTO ) ), 2 ), 0 ) as COMPROMETIDO ");
                                                               sbD.append("FROM  ");
                                                               sbD.append("( ");
                                                                               sbD.append("SELECT ");
                                                                               sbD.append("ctt.ID_CONTRATO_ORIGINAL, MAX( ctt.ID_CONTRATO ) as ID_CONTRATO ");
                                                                               sbD.append("FROM ");
                                                                               sbD.append("DDA_T_CONTRATO ctt, ");            
                                                                               sbD.append("DDA_C_CONTRATO_ESTATUS est ");
                                                                               sbD.append("WHERE ");
                                                                               sbD.append("ctt.ID_ESTATUS  = est.ID_ESTATUS ");        
                                                                               sbD.append("AND est.AFECTA_PPTO = 1 ");
                                                                               sbD.append("AND ctt.ID_TIPO_CONTRATO = " + TIPO_CONTRATO_SUSCRIPCION + " ");
                                                                               sbD.append("AND ctt.ID_APARTADO = " + lstIdApartado + "  ");
                                                                               sbD.append("AND ctt.ID_CONTRATO_ORIGINAL <> " + lstIdCntOriginal + " ");
                                                                               sbD.append("GROUP BY ctt.ID_CONTRATO_ORIGINAL ");
                                                               sbD.append(") mx, ");
                                                               sbD.append("DDA_T_CONTRATO cnt, ");    
                                                               sbD.append("DDA_T_CONTRATO_TITULO tit ");
                                                               sbD.append("WHERE ");
                                                               sbD.append("mx.ID_CONTRATO = cnt.ID_CONTRATO ");
                                                               sbD.append("and cnt.ID_CONTRATO = tit.ID_CONTRATO ");
                                                               sbD.append("and tit.ESTATUS = 'ACTIVO' ");
                                                               sbD.append("and TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) = '"+lstAnnio+"' ");
                                               sbD.append(") comp ");
                                               sbD.append("FULL OUTER JOIN ");
                                               sbD.append("( ");
                                                               sbD.append("SELECT ");
                                                               sbD.append("'"+lstAnnio+"' as ANNIO, "); 
                                                               sbD.append("TO_NUMBER( ppto.MONTO ) as ASIGNADO ");
                                                               sbD.append("FROM ");
                                                               sbD.append("DDA_T_PRESUPUESTO_APARTADO ppto ");
                                                               sbD.append("WHERE ");
                                                               sbD.append("ppto.ID_APARTADO = " + lstIdApartado + " ");
                                                               sbD.append("AND ppto.ANNIO = '"+lstAnnio+"' ");
                                               sbD.append(") asig ");
                                               sbD.append("ON ");
                                               sbD.append("comp.ANNIO = comp.ANNIO ");
                                               
                                               LOG.debug(">Sql_D [obtenerMontosPresupuestoAnual]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("SELECT ");
                                               sb.append("NVL( ASIGNADO, 0 ) as ASIGNADO, ");
                                               sb.append("COMPROMETIDO as COMPROMETIDO ");
                                               sb.append("FROM ");
                                               sb.append("( ");
                                                               sb.append("SELECT ");     
                                                               sb.append("? as ANNIO, "); 
                                                               sb.append("NVL( ROUND( SUM( TO_NUMBER( tit.COSTO ) ), 2 ), 0 ) as COMPROMETIDO ");
                                                               sb.append("FROM  ");
                                                               sb.append("( ");
                                                                               sb.append("SELECT ");
                                                                               sb.append("ctt.ID_CONTRATO_ORIGINAL, MAX( ctt.ID_CONTRATO ) as ID_CONTRATO ");
                                                                               sb.append("FROM ");
                                                                               sb.append("DDA_T_CONTRATO ctt, ");            
                                                                               sb.append("DDA_C_CONTRATO_ESTATUS est ");
                                                                               sb.append("WHERE ");
                                                                               sb.append("ctt.ID_ESTATUS  = est.ID_ESTATUS ");        
                                                                               sb.append("AND est.AFECTA_PPTO = 1 ");
                                                                               sb.append("AND ctt.ID_TIPO_CONTRATO = " + TIPO_CONTRATO_SUSCRIPCION + " ");
                                                                               sb.append("AND ctt.ID_APARTADO = ?  ");
                                                                               sb.append("AND ctt.ID_CONTRATO_ORIGINAL <> ? ");
                                                                               sb.append("GROUP BY ctt.ID_CONTRATO_ORIGINAL ");
                                                               sb.append(") mx, ");
                                                               sb.append("DDA_T_CONTRATO cnt, ");    
                                                               sb.append("DDA_T_CONTRATO_TITULO tit ");
                                                               sb.append("WHERE ");
                                                               sb.append("mx.ID_CONTRATO = cnt.ID_CONTRATO ");
                                                               sb.append("and cnt.ID_CONTRATO = tit.ID_CONTRATO ");
                                                               sb.append("and tit.ESTATUS = 'ACTIVO' ");
                                                               sb.append("and TO_CHAR( tit.FECHA_INICIO, 'yyyy' ) = ? ");
                                               sb.append(") comp ");
                                               sb.append("FULL OUTER JOIN ");
                                               sb.append("( ");
                                                               sb.append("SELECT ");
                                                               sb.append("? as ANNIO, "); 
                                                               sb.append("TO_NUMBER( ppto.MONTO ) as ASIGNADO ");
                                                               sb.append("FROM ");
                                                               sb.append("DDA_T_PRESUPUESTO_APARTADO ppto ");
                                                               sb.append("WHERE ");
                                                               sb.append("ppto.ID_APARTADO = ? ");
                                                               sb.append("AND ppto.ANNIO = ? ");
                                               sb.append(") asig ");
                                               sb.append("ON ");
                                               sb.append("comp.ANNIO = comp.ANNIO ");
                                               
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstAnnio);
                                               qryParams.add(lstIdApartado);
                                               qryParams.add(lstIdCntOriginal);
                                               qryParams.add(lstAnnio);
                                               qryParams.add(lstAnnio);
                                               qryParams.add(lstIdApartado);
                                               qryParams.add(lstAnnio);
                                               
                                               
                                               lobResultado = (ArrayList<QryMontosPresupuestoDTO>) getJdbcTemplate().query(lstSQL,qryParams.toArray(),new BeanPropertyRowMapper<QryMontosPresupuestoDTO>(QryMontosPresupuestoDTO.class));
                                               
                                               if(lobResultado != null && lobResultado.size() == 1)
                                                               resultado = (QryMontosPresupuestoDTO) lobResultado.get(0);
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::obtenerMontosPresupuestoAnual]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }

                @Override
                public boolean ejecutarSPAmortizacionPrevia(String pstIdContrato) throws Exception 
                {
                               String lstIdContrato = (pstIdContrato != null && pstIdContrato.trim().length() > 0) ? pstIdContrato : "";
                               LOG.debug("lstIdContrato:" + lstIdContrato);
                               
                               boolean resultado = false;
                               StringBuffer sb = new StringBuffer();
                               StringBuffer sbD = new StringBuffer();
                               List<Object> qryParams = new ArrayList<Object>();
                               int lnuRowsUpdate = 0;
                               
                               try
                               {
                                               //--Debug
                                               sbD.append("call DDA_AMORTIZACIONPREVIA");
                                               LOG.debug(">Sql_D [ejecutarSPAmortizacionPrevia]:" + sbD.toString());
                                               
                                               //--Ejecucion
                                               sb.append("call DDA_AMORTIZACIONPREVIA(?)");
                                                                                              
                                               final String lstSQL = sb.toString();
                                               qryParams.add(lstIdContrato);
                                               
                                               lnuRowsUpdate = jdbcTemplate.update(lstSQL,qryParams.toArray());
                                               
                                               
                                               if(lnuRowsUpdate >= 0)
                                                               resultado = true;
                                               
                               }
                               catch(Exception e)
                               {
                                               LOG.error("Exception["+this.getClass().getSimpleName()+"::ejecutarSPAmortizacionPrevia]: "+e.getMessage() );
                                               throw new Exception(e.getMessage());
                               }
                               
                               return resultado;
                }
}
  

