package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Representa el item referente a los Contratos mismos que sera parte de la respuesta del proceso de calculo de Amortizacion Mensual
 * * Los campos que usa son:
 * <br>
 * ID_CONTRATO: Es el id (interno) del Contrato.
 * lobTitulos : Es un objeto de items Titulos asociados al contrato
 *
 */

public class ItContratoDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String ID_CONTRATO;
	private List<ItTituloDTO> lobTitulos;
	
	public ItContratoDTO()
	{
		inicializaAtributos();
	}
	
	public String getID_CONTRATO() {
		return ID_CONTRATO;
	}
	public void setID_CONTRATO(String iD_CONTRATO) {
		ID_CONTRATO = iD_CONTRATO;
	}
	
	public List<ItTituloDTO> getLobTitulos() {
		return lobTitulos;
	}
	public void setLobTitulos(List<ItTituloDTO> lobTitulos) {
		this.lobTitulos = lobTitulos;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" ID_CONTRATO: _" + this.getID_CONTRATO() + "_" + NEW_LINE);
		result.append(" lobTitulos: _" + this.getLobTitulos().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
	//------  Metodos propios de la clase ---
	public void agregarItTitulo(ItTituloDTO dto)
	{
		this.lobTitulos.add(dto);
	}
	
	public void inicializaAtributos()
	{
		this.lobTitulos = new ArrayList<ItTituloDTO>();
	}
	
}
