package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;
import java.util.List;


/**
 * Representa los parametros del proceso de calcular Amortizacion Mensual 
 *  
 *  origenTitulos: Indica el origen de los Titulos del Contrato. Valores: REAL/ESPEJO
 *  contratos: Es una lista de contratos usando ContratoDTO como base.
 *  modulo: Indica el modulo que usara el servicio y con base en ello se aplican algunos filtros en la seleccion de titulos. Valores: AMORTIZACION, PRESUPUESTO.  
 *  fechaInicial: Fecha inicial del rango de busqueda de titulos en formato dd/mm/yyyy
 *  fechaFinal: Fecha final del rango de busqueda de titulos en formato dd/mm/yyyy
 *  
 *  NOTA: Para el caso de AMORTIZACION solo se considera la fecha inicial y es el dia de ejecucion del proceso CRON.
 */
public class ParamCalcAmortizaDTO implements Serializable
{
	private static final long serialVersionUID = 1L;
	private String origenTitulos;
	private List<ContratoDTO> contratos;
	private String modulo;
	private String fechaInicial;
	private String fechaFinal;
	private List<ContratoTituloDTO> lobTitulos;
	
	public String getOrigenTitulos() {
		return origenTitulos;
	}
	public void setOrigenTitulos(String origenTitulos) {
		this.origenTitulos = origenTitulos;
	}
	public List<ContratoDTO> getContratos() {
		return contratos;
	}
	public void setContratos(List<ContratoDTO> contratos) {
		this.contratos = contratos;
	}
	public String getModulo() {
		return modulo;
	}
	public void setModulo(String modulo) {
		this.modulo = modulo;
	}
	public String getFechaInicial() {
		return fechaInicial;
	}
	public void setFechaInicial(String fechaInicial) {
		this.fechaInicial = fechaInicial;
	}
	public String getFechaFinal() {
		return fechaFinal;
	}
	public void setFechaFinal(String fechaFinal) {
		this.fechaFinal = fechaFinal;
	}
	public List<ContratoTituloDTO> getLobTitulos() {
		return lobTitulos;
	}
	public void setLobTitulos(List<ContratoTituloDTO> lobTitulos) {
		this.lobTitulos = lobTitulos;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" origenTitulos: _" + this.getOrigenTitulos() + "_" + NEW_LINE);
		result.append(" contratos: _" + this.getContratos().size() + "_" + NEW_LINE);
		result.append(" modulo: _" + this.getModulo() + "_" + NEW_LINE);
		result.append(" fechaInicial: _" + this.getFechaInicial() + "_" + NEW_LINE);
		result.append(" fechaFinal: _" + this.getFechaFinal() + "_" + NEW_LINE);
		result.append(" lobTitulos: _" + this.getLobTitulos().size() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}

}
