package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

/**
 * Representa la respuesta que sera enviada al Front-End por parte de este componente al ejecutar el proceso de Carga de Titulos
 * Incluye un mensaje y resultado.
 *
 */
public class ResponseCargaTitulosDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String mensaje;
	private boolean resultado;
	private CargaPrincipalDTO datosCarga;
	private boolean resultadoCostoTitulo;
	
	public ResponseCargaTitulosDTO()
	{
		this.datosCarga = new CargaPrincipalDTO();
	}
	
	public String getMensaje() {
		return this.mensaje;
	}
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}
	
	public boolean isResultado() {
		return resultado;
	}
	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	
	public CargaPrincipalDTO getDatosCarga() {
		return datosCarga;
	}
	public void setDatosCarga(CargaPrincipalDTO datosCarga) {
		this.datosCarga = datosCarga;
	}
	public boolean getResultadoCostoTitulo() {
		return resultadoCostoTitulo;
	}
	public void setResultadoCostoTitulo(boolean resultadoCostoTitulo) {
		this.resultadoCostoTitulo = resultadoCostoTitulo;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" resultado: _" + this.isResultado() + "_" + NEW_LINE);
		result.append(" datosCarga: _" + this.getDatosCarga().toString() + "_" + NEW_LINE);
		result.append(" resultadoCostoTitulo: _" + this.getResultadoCostoTitulo() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
