package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

/**
 * Representa la respuesta que sera enviada al Front-End por parte de este componente al ejecutar el proceso de Generar Reportes
 * Incluye un mensaje, el annio vigente y resultado.
 *
 */
public class ResponseGeneraReporteDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String mensaje;
	private String registros;
	private String ruta;
	private boolean resultado;
	
	public String getMensaje() {
		return mensaje;
	}

	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}

	public String getRegistros() {
		return registros;
	}

	public void setRegistros(String registros) {
		this.registros = registros;
	}

	public boolean isResultado() {
		return resultado;
	}

	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	
	public String getRuta() {
		return ruta;
	}

	public void setRuta(String ruta) {
		this.ruta = ruta;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" resultado: _" + this.isResultado() + "_" + NEW_LINE);
		result.append(" registros: _" + this.getRegistros() + "_" + NEW_LINE);
		result.append(" ruta: _" + this.getRuta() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
