package mx.com.amx.mx.dda.ws.service;

import java.io.PrintWriter; 
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import mx.com.amx.mx.dda.ws.bo.ProcesoBO;
import mx.com.amx.mx.dda.ws.dto.ParamActualizaIdBVDTO;
import mx.com.amx.mx.dda.ws.dto.ParamAnnioVigenteDTO;
import mx.com.amx.mx.dda.ws.dto.ParamAsocTitTransCntVigentesDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCalcAmortCntDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCalcAmortizaDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCalculoCostoSuscriptoresDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosLFDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosPNDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosTRDTO;
import mx.com.amx.mx.dda.ws.dto.ParamCargaTitulosVSDTO;
import mx.com.amx.mx.dda.ws.dto.ParamGeneraReporteDTO;
import mx.com.amx.mx.dda.ws.dto.ParamSuscriptoresContrato;
import mx.com.amx.mx.dda.ws.dto.ParamValidaMinimoSeleccionDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValidaPresupuestoCntDTO;
import mx.com.amx.mx.dda.ws.dto.ParamValorTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseActualizaIdBVDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseAnnioVigenteDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseAsociarTitTransCntVigentesDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCalcAmortCntDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCalcAmortizaDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCalculoCostoSuscriptoresDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosLFDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosPNDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosTRDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseCargaTitulosVSDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseGeneraReporteDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseSuscriptoresContratoDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseValidaMinimoSeleccionDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseValidaPresupuestoCntDTO;
import mx.com.amx.mx.dda.ws.dto.ResponseValorTituloDTO;

@Controller
@RequestMapping("proceso")
public class ProcesoService
{
	protected final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	Properties env 	= 	new Properties();
	private String ERROR_PROCESO;
	
	
	@Autowired
	private ProcesoBO procesoBO;
	
	public ProcesoService()
	{
		super();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			ERROR_PROCESO = env.getProperty("error.proceso");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );
		}
	}
	
	/* --------------------------------------------------------------------------------- Methods */
	@RequestMapping( value = "/calcularCostoSuscriptores" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseCalculoCostoSuscriptoresDTO calcularCostoSuscriptores(@RequestHeader HttpHeaders headers, @RequestBody ParamCalculoCostoSuscriptoresDTO dto)
	{
		ResponseCalculoCostoSuscriptoresDTO resultado = new ResponseCalculoCostoSuscriptoresDTO();
		try
		{
			resultado = procesoBO.calcularCostoSuscriptores(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de Calculo de Costo de Suscriptores: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CCS-002: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
	@RequestMapping( value = "/obtenerCostoTitulo" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseValorTituloDTO obtenerCostoTitulo(@RequestHeader HttpHeaders headers, @RequestBody ParamValorTituloDTO dto)
	{
		ResponseValorTituloDTO resultado = new ResponseValorTituloDTO();
		try
		{
			resultado = procesoBO.obtenerCostoTitulo(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de obtener Valor Titulo: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CVT-005: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
	@RequestMapping( value = "/validarMinimoSeleccion" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseValidaMinimoSeleccionDTO validarMinimoSeleccion(@RequestHeader HttpHeaders headers, @RequestBody ParamValidaMinimoSeleccionDTO dto)
	{
		ResponseValidaMinimoSeleccionDTO resultado = new ResponseValidaMinimoSeleccionDTO();
		try
		{

			resultado = procesoBO.validarMinimoSeleccion(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de validar Minimos de Seleccion: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-VMS-001: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	@RequestMapping( value = "/obtenerSuscriptoresContrato" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseSuscriptoresContratoDTO obtenerSuscriptoresContrato(@RequestHeader HttpHeaders headers, @RequestBody ParamSuscriptoresContrato dto)
	{
		ResponseSuscriptoresContratoDTO resultado = new ResponseSuscriptoresContratoDTO();
		try
		{
			resultado = procesoBO.obtenerSuscriptoresContrato(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de obtener suscriptores del contrato: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-OSC-004: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
/*
	@RequestMapping( value = "/obtenerAnnioVigente" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseAnnioVigenteDTO obtenerValorAnnioVigente(@RequestHeader HttpHeaders headers, @RequestBody ParamAnnioVigenteDTO dto)
	{
		ResponseAnnioVigenteDTO resultado = new ResponseAnnioVigenteDTO();
		try
		{
			resultado = procesoBO.obtenerValorAnnioVigente(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de obtener el valor del annio vigente : " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CAV-008: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
*/	
	
	@RequestMapping( value = "/procesarCargaTitulos" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseCargaTitulosDTO procesarCargaTitulos(@RequestHeader HttpHeaders headers, @RequestBody ParamCargaTitulosDTO dto)
	{
		ResponseCargaTitulosDTO resultado = new ResponseCargaTitulosDTO();
		try
		{
			resultado = procesoBO.procesarCargaTitulos(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de la carga de Titulos : " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-PCT-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}	
	
	
	@RequestMapping( value = "/procesarCargaTitulosLF" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseCargaTitulosLFDTO procesarCargaTitulosLF(@RequestHeader HttpHeaders headers, @RequestBody ParamCargaTitulosLFDTO dto)
	{
		ResponseCargaTitulosLFDTO resultado = new ResponseCargaTitulosLFDTO();
		try
		{
			resultado = procesoBO.procesarCargaTitulosLF(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de la carga de Titulos LF : " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CTLF-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
	@RequestMapping( value = "/procesarCargaTitulosTR" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseCargaTitulosTRDTO procesarCargaTitulosTR(@RequestHeader HttpHeaders headers, @RequestBody ParamCargaTitulosTRDTO dto)
	{
		ResponseCargaTitulosTRDTO resultado = new ResponseCargaTitulosTRDTO();
		try
		{
			resultado = procesoBO.procesarCargaTitulosTR(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de la carga de Titulos TR : " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CTTR-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	@RequestMapping( value = "/procesarCargaTitulosPN" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseCargaTitulosPNDTO procesarCargaTitulosPN(@RequestHeader HttpHeaders headers, @RequestBody ParamCargaTitulosPNDTO dto)
	{
		ResponseCargaTitulosPNDTO resultado = new ResponseCargaTitulosPNDTO();
		try
		{
			resultado = procesoBO.procesarCargaTitulosPN(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de la carga de Titulos PN : " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CTPN-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	@RequestMapping( value = "/procesarCargaTitulosVS" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseCargaTitulosVSDTO procesarCargaTitulosVS(@RequestHeader HttpHeaders headers, @RequestBody ParamCargaTitulosVSDTO dto)
	{
		ResponseCargaTitulosVSDTO resultado = new ResponseCargaTitulosVSDTO();
		try
		{
			resultado = procesoBO.procesarCargaTitulosVS(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de la carga de Visualizaciones Suscripcion : " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CVS-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	
	
	@RequestMapping( value = "/calcularAmortizacionPorContrato" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseCalcAmortCntDTO calcularAmortizacionPorContrato(@RequestHeader HttpHeaders headers, @RequestBody ParamCalcAmortCntDTO dto)
	{
		ResponseCalcAmortCntDTO resultado = new ResponseCalcAmortCntDTO();
		try
		{
			resultado = procesoBO.calcularAmortizacionPorContrato(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de calcular Amortizacion Por Contrato: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-CAPC-008: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}
	

	@RequestMapping( value = "/validarPresupuestoPorContrato" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseValidaPresupuestoCntDTO validarPresupuestoPorContrato(@RequestHeader HttpHeaders headers, @RequestBody ParamValidaPresupuestoCntDTO dto)
	{

		ResponseValidaPresupuestoCntDTO resultado = new ResponseValidaPresupuestoCntDTO();

		try
		{
			resultado = procesoBO.validarPresupuestoPorContrato(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de validar Presupuesto por Contrato: " + e.getMessage() );
			resultado.setResultado(false);
			
			List<String> error = new ArrayList<String>();
				error.add("DDA-VPPC-010: "+ ERROR_PROCESO);
			
			resultado.setMensaje(error);
			return resultado;
		}
	}


	@RequestMapping( value = "/actualizarIdBroadView" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseActualizaIdBVDTO actualizarIdBroadView(@RequestHeader HttpHeaders headers, @RequestBody ParamActualizaIdBVDTO dto)
	{

		ResponseActualizaIdBVDTO resultado = new ResponseActualizaIdBVDTO();

		try
		{
			resultado = procesoBO.actualizarIdBroadView(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de actualizar Id de BroadView: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-AIBV-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
		
	}
	
	
	@RequestMapping( value = "/generarReporte" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseGeneraReporteDTO generarReporte(@RequestHeader HttpHeaders headers, @RequestBody ParamGeneraReporteDTO dto)
	{

		ResponseGeneraReporteDTO resultado = new ResponseGeneraReporteDTO();

		try
		{
			resultado = procesoBO.generarReporte(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de generar reporte: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-GR-005: "+ ERROR_PROCESO);
			return resultado;
		}
		
		
	}
	
	@RequestMapping( value = "/asociarTitulosTransCntVigentes" , method=RequestMethod.POST , headers="Accept=application/json; charset=utf-8", produces = "application/json; charset=utf-8" )
	@ResponseBody
	public ResponseAsociarTitTransCntVigentesDTO asociarTitTransCntVigentes(@RequestHeader HttpHeaders headers, @RequestBody ParamAsocTitTransCntVigentesDTO dto)
	{
		ResponseAsociarTitTransCntVigentesDTO resultado = new ResponseAsociarTitTransCntVigentesDTO();
		try
		{
			resultado = procesoBO.asociarTitTransCntVigentes(dto);
			return resultado;
		}
		catch(Exception e)
		{
			LOG.error(" Error al ejecutar el proceso de asociar los Titulos Transacciones a los Contratos Vigentes: " + e.getMessage() );
			resultado.setResultado(false);
			resultado.setMensaje("DDA-ATCV-006: "+ ERROR_PROCESO);
			return resultado;
		}
		
	}

}
