package mx.com.amx.mx.dda.ws.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.log4j.Logger;


public class DateManager 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	
	public DateManager()
	{
		super();
	}
	

	public String cambiarFormato(String pstFecha, String pstFormato) throws Exception
	{
		/* Los formatos deben ser acorde a la clase SimpleDateFormat. En este caso este es el usado: "yyyy-MM-dd" */
		String fechaFinal = "";
		
		try
		{
			DateFormat formatoOriginal = new SimpleDateFormat("dd/MM/yyyy");
			DateFormat formatoFinal = new SimpleDateFormat(pstFormato);
			Date fechaOriginal = formatoOriginal.parse(pstFecha);
			fechaFinal = formatoFinal.format(fechaOriginal);
		}
		catch (ParseException pe) 
		{
			LOG.info("Ocurrio un error al parsear las fechas proporcionadas.");
			LOG.error("Exception["+this.getClass().getSimpleName()+"::cambiarFormato]: "+ pe.getMessage() );
			throw new Exception(pe.getMessage());
		}  
		catch(Exception e)
		{
			LOG.info("Ocurrio un error al ejecutar el cambio de formato.");
			LOG.error("Exception["+this.getClass().getSimpleName()+"::cambiarFormato]: "+ e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return fechaFinal;
		
	}
	
	public String dateToString(Date pobDate, String pstFormato) throws Exception
	{
		/* Los formatos deben ser acorde a la clase SimpleDateFormat */
		String fechaFinal = "";
		try
		{
			DateFormat formatoFinal = new SimpleDateFormat(pstFormato);
			fechaFinal = formatoFinal.format(pobDate);
		}
		catch(Exception e)
		{
			LOG.info("Ocurrio un error al ejecutar la traduccion del Date a String.");
			LOG.error("Exception["+this.getClass().getSimpleName()+"::dateToString]: "+ e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
		return fechaFinal;
	}
	
	public String getFechaActual(String pstFormato)
	{
		String lstFechaActual = "";
		Calendar lobTiempoActual = Calendar.getInstance();
		
		//--
		int lnuDiaActual = lobTiempoActual.get(Calendar.DAY_OF_MONTH);
		int lnuMesActual = lobTiempoActual.get(Calendar.MONTH) + 1;
		int lnuAnnioActual = lobTiempoActual.get(Calendar.YEAR);

		//--
		String lstTmpDia 	= (lobTiempoActual.get(Calendar.DAY_OF_MONTH) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.DAY_OF_MONTH)) : 	Integer.toString(lobTiempoActual.get(Calendar.DAY_OF_MONTH));
		String lstTmpMes 	= (lnuMesActual < 10 ) ? "0" + Integer.toString(lnuMesActual) : Integer.toString(lnuMesActual);
		String lstTmpAnnio  = Integer.toString(lnuAnnioActual);
		String lstHora		= (lobTiempoActual.get(Calendar.HOUR_OF_DAY) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.HOUR_OF_DAY)) : 	Integer.toString(lobTiempoActual.get(Calendar.HOUR_OF_DAY));
		String lstMinutos   = (lobTiempoActual.get(Calendar.MINUTE) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.MINUTE)) : 	Integer.toString(lobTiempoActual.get(Calendar.MINUTE));
		String lstSegundos  = (lobTiempoActual.get(Calendar.SECOND) < 10) ? "0" +Integer.toString(lobTiempoActual.get(Calendar.SECOND)) : 	Integer.toString(lobTiempoActual.get(Calendar.SECOND));
		
		
		if(pstFormato.equalsIgnoreCase("dd/mm/yyyy"))
			lstFechaActual = lstTmpDia + "/" + lstTmpMes + "/" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("mm/dd/yyyy"))
			lstFechaActual = lstTmpMes + "/" + lstTmpDia + "/" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("yyyy/mm/dd"))
			lstFechaActual = lstTmpAnnio + "/" + lstTmpMes + "/" + lstTmpDia;
		else if(pstFormato.equalsIgnoreCase("dd/mm/yyyy hh:mi:ss"))
			lstFechaActual = lstTmpDia + "/" + lstTmpMes + "/" + lstTmpAnnio + lstHora + ":" + lstMinutos + ":" + lstSegundos;
		else if(pstFormato.equalsIgnoreCase("mm/dd/yyyy hh:mi:ss"))
			lstFechaActual = lstTmpMes + "/" + lstTmpDia + "/" + lstTmpAnnio + lstHora + ":" + lstMinutos + ":" + lstSegundos;
		else if(pstFormato.equalsIgnoreCase("yyyy/mm/dd hh:mi:ss"))
			lstFechaActual = lstTmpAnnio + "/" + lstTmpMes + "/" + lstTmpDia + lstHora + ":" + lstMinutos + ":" + lstSegundos;
		if(pstFormato.equalsIgnoreCase("dd-mm-yyyy"))
			lstFechaActual = lstTmpDia + "-" + lstTmpMes + "-" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("mm-dd-yyyy"))
			lstFechaActual = lstTmpMes + "-" + lstTmpDia + "-" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("yyyy-mm-dd"))
			lstFechaActual = lstTmpAnnio + "-" + lstTmpMes + "-" + lstTmpDia;
		else if(pstFormato.equalsIgnoreCase("dd.mm.yyyy"))
			lstFechaActual = lstTmpDia + "." + lstTmpMes + "." + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("mm/yyyy"))
			lstFechaActual = lstTmpMes + "/" + lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("yyyy/mm"))
			lstFechaActual =  lstTmpAnnio + "/" + lstTmpMes;
		else if(pstFormato.equalsIgnoreCase("yyyy-mm"))
			lstFechaActual =  lstTmpAnnio + "-" + lstTmpMes;
		else if(pstFormato.equalsIgnoreCase("yyyy"))
			lstFechaActual = lstTmpAnnio;
		else if(pstFormato.equalsIgnoreCase("yyyymmdd"))
			lstFechaActual = lstTmpAnnio+lstTmpMes+lstTmpDia;
			
		return lstFechaActual;
	}
	
	
	public int compararFechas(String pstFechaAComparar, String pstFechaReferencia)  throws Exception
	{
		int resultado=0;
		try 
		{
			//--Obtener las fechas enviadas en el formato a comparar
			SimpleDateFormat formateador = new SimpleDateFormat("dd/MM/yyyy"); 
			Date lobFechaACompararDate = formateador.parse(pstFechaAComparar);
			Date lobFechaReferenciaDate = formateador.parse(pstFechaReferencia);
		    
			if ( lobFechaACompararDate.before(lobFechaReferenciaDate) )
			{
			  resultado = -1;
			}
			else if ( lobFechaReferenciaDate.before(lobFechaACompararDate) ) 
			{
			  resultado = 1;
			}
			else
			{
			  resultado= 0;
			}
		} 
		catch (ParseException pe) 
		{
			LOG.info("Ocurrio un error al parsear las fechas proporcionadas.");
			LOG.error("Exception["+this.getClass().getSimpleName()+"::compararFechas]: "+ pe.getMessage() );
			throw new Exception(pe.getMessage());
		}  
		catch (Exception e)
		{
			LOG.info("Ocurrio un error al comparar las fechas proporcionadas.");
			LOG.error("Exception["+this.getClass().getSimpleName()+"::compararFechas]: "+ e.getMessage() );
			throw new Exception(e.getMessage());
		}
		
	  return resultado;
	}
	
	public boolean esFechaValida(String pstFormato, String pstFecha) 
	{
		boolean resultado = false;
		DateFormat formateador = new SimpleDateFormat(pstFormato);
		formateador.setLenient(false);
		
		try
		{
			Date fecha = formateador.parse(pstFecha);
			resultado = true;
		}
		catch(ParseException pe)
		{
			resultado = false;
		}
		
		return resultado;
	}
	
	/*
	public String obtenerFechaMayorVsActual(String pstFecha) throws Exception
	{
		String resultado = "";
		
		//--Obtener fecha actual
		String lstFechaActual = this.getFechaActual("dd/mm/yyyy");
		
		//--Determina fecha mayor
		try 
		{
			int lnuResComparacionFechas = this.compararFechas(pstFecha, lstFechaActual);

			if (lnuResComparacionFechas == -1)
				resultado = lstFechaActual;
			else if (lnuResComparacionFechas == 1)
				resultado = pstFecha;
			else if (lnuResComparacionFechas == 0)
				resultado = lstFechaActual;
		} 
		catch (Exception e) 
		{
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerFechaMayorVsActual]: "+ e.getMessage());
			throw new Exception(e.getMessage());
		}
		
		return resultado;
	}
	*/
	
	public String obtenerFechaMayorVsActual(String pstFecha, String pstFormatoSalida) throws Exception
	{
		//-- Nota: El parametro de formato salida debe apegarse a la especificacion de la clase SimpleDateFormat
		//-- Para el caso ESPECIFICO de esta funcion el parametro pstFecha se supone que viene en formato dd/mm/yyyy
		
		String resultado = "";
		
		//--Obtener fecha actual
		String lstFechaActual = this.getFechaActual("dd/mm/yyyy");
		
		//--Determina fecha mayor
		try 
		{
			int lnuResComparacionFechas = this.compararFechas(pstFecha, lstFechaActual);

			if (lnuResComparacionFechas == -1)
				resultado = lstFechaActual;
			else if (lnuResComparacionFechas == 1)
				resultado = pstFecha;
			else if (lnuResComparacionFechas == 0)
				resultado = lstFechaActual;
			
			//--Cambiar fecha a formato solicitado
			resultado = this.cambiarFormato(resultado, pstFormatoSalida);
		} 
		catch (Exception e) 
		{
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerFechaMayorVsActual]: "+ e.getMessage());
			throw new Exception(e.getMessage());
		}
		
		 
		return resultado;
	}
}
