package mx.com.amx.mx.dda.ws.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;


import mx.com.amx.mx.dda.ws.dto.CargaIdBVDetalleDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosPNExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosTRExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosVSExcelDTO;


public class ExcelReader 
{
	Properties env 	= 	new Properties();
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	DateManager dateMgr = new DateManager();
	ValidationManager valMgr = new ValidationManager();
	DataFormatter df = new DataFormatter();
	private ArrayList<CargaTitulosExcelDTO> lobDatosXL;
	private ArrayList<CargaIdBVDetalleDTO> lobDatosXL_AIB;
	private ArrayList<CargaTitulosExcelDTO> lobDatosXL_LF;
	private ArrayList<CargaTitulosTRExcelDTO> lobDatosXL_TR;
	private ArrayList<CargaTitulosPNExcelDTO> lobDatosXL_PN;
	private ArrayList<CargaTitulosVSExcelDTO> lobDatosXL_VS;
	private String lstMensaje;
	private String SEPARADOR_COLUMNAS;
	
	//--Carga de Titulos
	private String CT_COL_UNO;
	private String CT_COL_DOS;
	private String CT_COL_TRES;
	private String CT_COL_CUATRO;
	private String CT_COL_CINCO;
	private String CT_COL_SEIS;
	private String CT_COL_SIETE;
	private String CT_COL_OCHO;
	private String CT_COL_NUEVE;
	private String CT_COL_DIEZ;
	private String CT_COL_ONCE;
	private String CT_COL_DOCE;
	private String CT_COL_TRECE;
	private String CT_COL_CATORCE;
	private String CT_COL_QUINCE;
	
	//--Actualiza Id BV
	private String AIB_COL_UNO;
	private String AIB_COL_DOS;
	private String AIB_COL_TRES;
	
	//--Carga Titulos License Fee
	private String LF_COL_UNO;
	private String LF_COL_DOS;
	private String LF_COL_TRES;
	private String LF_COL_CUATRO;
	private String LF_COL_CINCO;
	private String LF_COL_SEIS;
	private String LF_COL_SIETE;
	private String LF_COL_OCHO;
	private String LF_COL_NUEVE;
	
	//--Carga Titulos Transaccional
	private String TR_COL_UNO;
	private String TR_COL_DOS;
	private String TR_COL_TRES;
	private String TR_COL_CUATRO;
	private String TR_COL_CINCO;
	private String TR_COL_SEIS;
	private String TR_COL_SIETE;
	private String TR_COL_OCHO;
	private String TR_COL_NUEVE;
	private String TR_COL_DIEZ;
	private String TR_COL_ONCE;
	private String TR_COL_DOCE;
	private String TR_COL_TRECE;
	private String TR_COL_CATORCE;
	private String TR_COL_QUINCE;
	private String TR_COL_DIECISEIS;
	private String TR_COL_DIECISIETE;
	private String TR_COL_DIECIOCHO;
	private String TR_COL_DIECINUEVE;
	private String TR_COL_VEINTE;
	private String TR_COL_VEINTIUNO;
	private String TR_COL_VEINTIDOS;
	private String TR_COL_VEINTITRES;
	private String TR_COL_VEINTICUATRO;
	private String TR_COL_VEINTICINCO;
	private String TR_COL_VEINTISEIS;
	
	//--Carga Titulos Plataforma y Net
	private String PN_COL_UNO;
	private String PN_COL_DOS;
	private String PN_COL_TRES;
	private String PN_COL_CUATRO;
	private String PN_COL_CINCO;
	private String PN_COL_SEIS;
	private String PN_COL_SIETE;
	private String PN_COL_OCHO;
	
	//--Carga Visualizaciones Suscripcion
	private String VS_COL_UNO;
	private String VS_COL_DOS;
	private String VS_COL_TRES;
	private String VS_COL_CUATRO;
	
	
	public ExcelReader()
	{
		super();
		inicializaAtributos();
		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			SEPARADOR_COLUMNAS = env.getProperty("separador.columnas");
			CT_COL_UNO  = env.getProperty("ct.columna.uno");
			CT_COL_DOS  = env.getProperty("ct.columna.dos");
			CT_COL_TRES  = env.getProperty("ct.columna.tres");
			CT_COL_CUATRO  = env.getProperty("ct.columna.cuatro");
			CT_COL_CINCO  = env.getProperty("ct.columna.cinco");
			CT_COL_SEIS  = env.getProperty("ct.columna.seis");
			CT_COL_SIETE  = env.getProperty("ct.columna.siete");
			CT_COL_OCHO  = env.getProperty("ct.columna.ocho");
			CT_COL_NUEVE  = env.getProperty("ct.columna.nueve");
			CT_COL_DIEZ  = env.getProperty("ct.columna.diez");
			CT_COL_ONCE  = env.getProperty("ct.columna.once");
			CT_COL_DOCE  = env.getProperty("ct.columna.doce");
			CT_COL_TRECE  = env.getProperty("ct.columna.trece");
			CT_COL_CATORCE = env.getProperty("ct.columna.catorce");
			CT_COL_QUINCE = env.getProperty("ct.columna.quince");
			AIB_COL_UNO = env.getProperty("aib.columna.uno");
			AIB_COL_DOS = env.getProperty("aib.columna.dos");
			AIB_COL_TRES = env.getProperty("aib.columna.tres");
			LF_COL_UNO = env.getProperty("lf.columna.uno");
			LF_COL_DOS = env.getProperty("lf.columna.dos");
			LF_COL_TRES = env.getProperty("lf.columna.tres");
			LF_COL_CUATRO = env.getProperty("lf.columna.cuatro");
			LF_COL_CINCO = env.getProperty("lf.columna.cinco");
			LF_COL_SEIS = env.getProperty("lf.columna.seis");
			LF_COL_SIETE = env.getProperty("lf.columna.siete");
			LF_COL_OCHO = env.getProperty("lf.columna.ocho");
			LF_COL_NUEVE = env.getProperty("lf.columna.nueve");
			TR_COL_UNO = env.getProperty("tr.columna.uno");
			TR_COL_DOS = env.getProperty("tr.columna.dos");
			TR_COL_TRES = env.getProperty("tr.columna.tres");
			TR_COL_CUATRO = env.getProperty("tr.columna.cuatro");
			TR_COL_CINCO = env.getProperty("tr.columna.cinco");
			TR_COL_SEIS = env.getProperty("tr.columna.seis");
			TR_COL_SIETE = env.getProperty("tr.columna.siete");
			TR_COL_OCHO = env.getProperty("tr.columna.ocho");
			TR_COL_NUEVE = env.getProperty("tr.columna.nueve");
			TR_COL_DIEZ = env.getProperty("tr.columna.diez");
			TR_COL_ONCE = env.getProperty("tr.columna.once");
			TR_COL_DOCE = env.getProperty("tr.columna.doce");
			TR_COL_TRECE = env.getProperty("tr.columna.trece");
			TR_COL_CATORCE = env.getProperty("tr.columna.catorce");
			TR_COL_QUINCE = env.getProperty("tr.columna.quince");
			TR_COL_DIECISEIS = env.getProperty("tr.columna.deciseis");
			TR_COL_DIECISIETE = env.getProperty("tr.columna.decisiete");
			TR_COL_DIECIOCHO = env.getProperty("tr.columna.dieciocho");
			TR_COL_DIECINUEVE = env.getProperty("tr.columna.diecinueve");
			TR_COL_VEINTE = env.getProperty("tr.columna.veinte");
			TR_COL_VEINTIUNO = env.getProperty("tr.columna.veintiuno");
			TR_COL_VEINTIDOS = env.getProperty("tr.columna.veintidos");
			TR_COL_VEINTITRES = env.getProperty("tr.columna.veintitres");
			TR_COL_VEINTICUATRO = env.getProperty("tr.columna.veinticuatro");
			TR_COL_VEINTICINCO = env.getProperty("tr.columna.veinticinco");
			TR_COL_VEINTISEIS = env.getProperty("tr.columna.veintiseis");
			PN_COL_UNO = env.getProperty("pn.columna.uno");
			PN_COL_DOS = env.getProperty("pn.columna.dos");
			PN_COL_TRES = env.getProperty("pn.columna.tres");
			PN_COL_CUATRO = env.getProperty("pn.columna.cuatro");
			PN_COL_CINCO = env.getProperty("pn.columna.cinco");
			PN_COL_SEIS = env.getProperty("pn.columna.seis");
			PN_COL_SIETE = env.getProperty("pn.columna.siete");
			PN_COL_OCHO = env.getProperty("pn.columna.ocho");
			VS_COL_UNO = env.getProperty("vs.columna.uno");
			VS_COL_DOS = env.getProperty("vs.columna.dos");
			VS_COL_TRES = env.getProperty("vs.columna.tres");
			VS_COL_CUATRO = env.getProperty("vs.columna.cuatro");
			
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );	
		}
	}
	
	public ArrayList<CargaTitulosExcelDTO> getDatosExcel() {
		return lobDatosXL;
	}
	
	public String getMensaje() {
		return lstMensaje;
	}
	
	public ArrayList<CargaIdBVDetalleDTO> getDatosExcel_AIB() {
		return lobDatosXL_AIB;
	}

	public ArrayList<CargaTitulosExcelDTO> getLobDatosXL_LF() {
		return lobDatosXL_LF;
	}

	public ArrayList<CargaTitulosTRExcelDTO> getLobDatosXL_TR() {
		return lobDatosXL_TR;
	}

	public ArrayList<CargaTitulosVSExcelDTO> getLobDatosXL_VS() {
		return lobDatosXL_VS;
	}

	public void setLobDatosXL_VS(ArrayList<CargaTitulosVSExcelDTO> lobDatosXL_VS) {
		this.lobDatosXL_VS = lobDatosXL_VS;
	}

	public void setLobDatosXL_TR(ArrayList<CargaTitulosTRExcelDTO> lobDatosXL_TR) {
		this.lobDatosXL_TR = lobDatosXL_TR;
	}
	
	public ArrayList<CargaTitulosPNExcelDTO> getLobDatosXL_PN() {
		return lobDatosXL_PN;
	}

	public void setLobDatosXL_PN(ArrayList<CargaTitulosPNExcelDTO> lobDatosXL_PN) {
		this.lobDatosXL_PN = lobDatosXL_PN;
	}

	public void leerArchivoExcelCargaTitulos(String pstURLArchivo, String pstNombreArchivo)
	{
		String[] componentesNombreOriginal = pstNombreArchivo.split("\\.");
		LOG.debug("[leerArchivoExcelCargaTitulos]ComponentesNombreOriginal: " + componentesNombreOriginal.toString());
				
		String lstExtension = componentesNombreOriginal[1].toString();
		LOG.debug("[leerArchivoExcelCargaTitulos]Extension: " + lstExtension);
		
		if(lstExtension.equalsIgnoreCase("xls"))
		{
			leerCargaTitulosXLS(pstURLArchivo);
		}
		else if(lstExtension.equalsIgnoreCase("xlsx"))
		{
			leerCargaTitulosXLSX(pstURLArchivo);
		}
	}
	
	@SuppressWarnings("unused")
	private void leerCargaTitulosXLS(String pstArchivoURL)
	{
		LOG.debug("leerCargaTitulosXLS["+this.getClass().getSimpleName()+"]pstArchivoURL: " + pstArchivoURL);
		
		try 
		{
			FileInputStream file = new FileInputStream(new File(pstArchivoURL));
		     
		    //Obtener la instancia de Workbook para un archivo XLS 
		    HSSFWorkbook workbook = new HSSFWorkbook(file);
		 
		    //Obtiene la primera hoja del Libro de trabajo
		    HSSFSheet sheet = workbook.getSheetAt(0);
		    
		    /*
		    int lnuUltimaFila = sheet.getLastRowNum();
		    log.debug("leerXLS[ExcelReader]lnuUltimaFila: " + lnuUltimaFila);
		    */
		    
		    int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerCargaTitulosXLS["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    //---Verifica que el encabezado coincida
		    HSSFRow filaCero = sheet.getRow(0);
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(CT_COL_UNO) &&
		    	filaCero.getCell(1).toString().toUpperCase().contains(CT_COL_DOS) &&
		    	filaCero.getCell(2).toString().toUpperCase().contains(CT_COL_TRES) &&
		    	filaCero.getCell(3).toString().toUpperCase().contains(CT_COL_CUATRO) &&
		    	filaCero.getCell(4).toString().toUpperCase().contains(CT_COL_CINCO) && 
		    	filaCero.getCell(5).toString().toUpperCase().contains(CT_COL_SEIS) &&
		    	filaCero.getCell(6).toString().toUpperCase().contains(CT_COL_SIETE) &&
		    	filaCero.getCell(7).toString().toUpperCase().contains(CT_COL_OCHO) &&
		    	filaCero.getCell(8).toString().toUpperCase().contains(CT_COL_NUEVE) &&
		    	filaCero.getCell(9).toString().toUpperCase().contains(CT_COL_DIEZ) &&
		    	filaCero.getCell(10).toString().toUpperCase().contains(CT_COL_ONCE) &&
		    	filaCero.getCell(11).toString().toUpperCase().contains(CT_COL_DOCE) &&
		    	filaCero.getCell(12).toString().toUpperCase().contains(CT_COL_TRECE) &&
		    	filaCero.getCell(13).toString().toUpperCase().contains(CT_COL_CATORCE) &&
		    	filaCero.getCell(14).toString().toUpperCase().contains(CT_COL_QUINCE))
		    {
		    	
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
			    for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
			    	CargaTitulosExcelDTO datosXL = new CargaTitulosExcelDTO(); 
			    	datosXL.setFila(Integer.toString(xFila));
			    	
			    	HSSFRow row = sheet.getRow(xFila);
			    	
			    	if(row != null)
			    	{
			    	
				    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
				    	HSSFCell cellNombreUnico =  row.getCell(0);
				    	if(cellNombreUnico != null)
				    	{
				    		cellNombreUnico.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreUnico(cellNombreUnico.toString());
				    	}
				    	else
				    		datosXL.setNombreUnico("");
				    	
				    	HSSFCell cellNombreEstandar =  row.getCell(1);
				    	if(cellNombreEstandar != null)
				    	{
				    		cellNombreEstandar.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreEstandar(cellNombreEstandar.toString());
				    	}
				    	else
				    		datosXL.setNombreEstandar("");
				    	
				    	HSSFCell cellTemporada =  row.getCell(2);
				    	if(cellTemporada != null)
				    	{
				    		cellTemporada.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setTemporada(cellTemporada.toString());
				    	}
				    	else
				    		datosXL.setTemporada("");
				    	
				    	HSSFCell cellEpisodio =  row.getCell(3);
				    	if(cellEpisodio != null)
				    	{
				    		cellEpisodio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setEpisodio(cellEpisodio.toString());
				    	}
				    	else
				    		datosXL.setEpisodio("");
				    	
				    	HSSFCell cellFechaInicio =  row.getCell(4);
				    	if(cellFechaInicio != null)
				    	{
				    		if(cellFechaInicio.getCellType() == Cell.CELL_TYPE_NUMERIC)
				    		{
				    			cellFechaInicio.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaInicio( dateMgr.dateToString(cellFechaInicio.getDateCellValue(), "dd/MM/yyyy") );
				    		}
				    		else
				    			datosXL.setFechaInicio("");
				    		
				    	}
				    	else
				    		datosXL.setFechaInicio("");
				    	
				    	
				    	HSSFCell cellFechaFin =  row.getCell(5);
				    	if(cellFechaFin != null)
				    	{
				    		if (cellFechaFin.getCellType() == Cell.CELL_TYPE_NUMERIC)
							{
					    		cellFechaFin.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaFin( dateMgr.dateToString(cellFechaFin.getDateCellValue(), "dd/MM/yyyy") );
							}
							else
								datosXL.setFechaFin("");
				    	}
				    	else
				    		datosXL.setFechaFin("");
				    	
				    	HSSFCell cellCategoriaEstudio =  row.getCell(6);
				    	if(cellCategoriaEstudio != null)
				    	{
				    		cellCategoriaEstudio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setCategoriaEstudio( cellCategoriaEstudio.toString() );
				    	}
				    	else
				    		datosXL.setCategoriaEstudio("");
				    	
				    	HSSFCell cellCategoria =  row.getCell(7);
				    	if(cellCategoria != null)
				    	{
				    		cellCategoria.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setCategoria( cellCategoria.toString() );
				    	}
				    	else
				    		datosXL.setCategoria("");
				    	
				    	HSSFCell cellPrecio =  row.getCell(8);
				    	if(cellPrecio != null)
				    	{
				    		cellPrecio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setPrecio( cellPrecio.toString() );
				    	}
				    	else
				    		datosXL.setPrecio("");
				    	
				    	HSSFCell cellAnual = row.getCell(9);
				    	if(cellAnual != null)
				    	{
				    		cellAnual.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setAnual(cellAnual.toString());
				    	}
				    	else
				    		datosXL.setAnual("NO");
				    	
				    	
				    	HSSFCell cellBriefcase =  row.getCell(10);
				    	if(cellBriefcase != null)
				    	{
				    		cellBriefcase.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setBriefcase( cellBriefcase.toString() );
				    	}
				    	else
				    		datosXL.setBriefcase("NO");
				    	
				    	HSSFCell cellIdBroadView =  row.getCell(11);
				    	if(cellIdBroadView != null)
				    	{
				    		cellIdBroadView.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdBroadView( cellIdBroadView.toString() );
				    	}
				    	else
				    		datosXL.setIdBroadView("");
				    	
				    	HSSFCell cellMesesExclusivo =  row.getCell(12);
				    	if(cellMesesExclusivo != null)
				    	{
				    		cellMesesExclusivo.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setMesesExclusivo( cellMesesExclusivo.toString() );
				    	}
				    	else
				    		datosXL.setMesesExclusivo("");
				    	
				    	HSSFCell cellPorcentajeExclusivo =  row.getCell(13);
				    	if(cellPorcentajeExclusivo != null)
				    	{
				    		cellPorcentajeExclusivo.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setPorcentajeExclusivo( cellPorcentajeExclusivo.toString() );
				    	}
				    	else
				    		datosXL.setPorcentajeExclusivo("");
				    	
				    	HSSFCell cellAnnioContrato = row.getCell(14);
				    	if(cellAnnioContrato != null)
				    	{
				    		cellAnnioContrato.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setAnnioContrato(cellAnnioContrato.toString());
				    	}
				    	else
				    		datosXL.setAnnioContrato("");
				    	
				    	LOG.debug("leerCargaTitulosXLS["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": NombreUnico:["+datosXL.getNombreUnico()+"],NombreEstandar:["+datosXL.getNombreEstandar()+"],Temporada:["+datosXL.getTemporada()+ "],Episodio:["+datosXL.getEpisodio()+"],FechaInicio:["+datosXL.getFechaInicio()+"],FechaFin:["+datosXL.getFechaFin()+"],CategoriaEstudio:["+datosXL.getCategoriaEstudio()+"],Categoria:["+datosXL.getCategoria()+"],Precio:["+datosXL.getPrecio()+"],Anual:["+datosXL.getAnual()+"],Briefcase:["+datosXL.getBriefcase()+"],IdBroadView:["+datosXL.getIdBroadView()+"],MesesExclusivo:["+datosXL.getMesesExclusivo()+"],PorcentajeExclusivo:["+datosXL.getPorcentajeExclusivo()+"], AnnioContrato:["+datosXL.getAnnioContrato()+"]");
				    	this.lobDatosXL.add(datosXL);
			    	}//Ends if(row != null)
			    	
			    }//Termina for(int xFila=0; xFila < lnuUltimaFila; xFila++)
		    }//Termina verifica Encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerCargaTitulosXLS[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
		    
		    file.close();
		} 
		catch (FileNotFoundException e) 
		{
		    LOG.error("leerCargaTitulosXLS[FileNotFoundException] No se encontro el archivo en la ruta especificada.");
		    this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
			//e.printStackTrace();
		    
		} 
		catch (IOException e) 
		{
			LOG.error("leerCargaTitulosXLS[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerCargaTitulosXLS[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
	
	}
	
	@SuppressWarnings("unused")
	private void leerCargaTitulosXLSX(String pstArchivoURL)
	{
		LOG.debug("leerCargaTitulosXLSX["+this.getClass().getSimpleName()+"]pstArchivoURL: " + pstArchivoURL);
		
		try 
		{
			FileInputStream file = new FileInputStream(new File(pstArchivoURL));
			
			//Obtener la instancia de Workbook para un archivo XLSX
			XSSFWorkbook workbook = new XSSFWorkbook(file);
			
			//Obtiene la primera hoja del Libro de trabajo
			XSSFSheet sheet = workbook.getSheetAt(0);
		
			/*
			int lnuUltimaFila = sheet.getLastRowNum();
		    log.debug("leerXLSX[ExcelReader]lnuUltimaFila: " + lnuUltimaFila);
		    */
		    
		    int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerCargaTitulosXLSX["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    
		    //---Verifica que el encabezado coincida
		    XSSFRow filaCero = sheet.getRow(0);
		    
		    LOG.debug("Encabezado cero: " + filaCero.getCell(0).toString().toUpperCase());
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(CT_COL_UNO) &&
		    	filaCero.getCell(1).toString().toUpperCase().contains(CT_COL_DOS) &&
		    	filaCero.getCell(2).toString().toUpperCase().contains(CT_COL_TRES) &&
		    	filaCero.getCell(3).toString().toUpperCase().contains(CT_COL_CUATRO) &&
		    	filaCero.getCell(4).toString().toUpperCase().contains(CT_COL_CINCO) && 
		    	filaCero.getCell(5).toString().toUpperCase().contains(CT_COL_SEIS) &&
		    	filaCero.getCell(6).toString().toUpperCase().contains(CT_COL_SIETE) &&
		    	filaCero.getCell(7).toString().toUpperCase().contains(CT_COL_OCHO) &&
		    	filaCero.getCell(8).toString().toUpperCase().contains(CT_COL_NUEVE) &&
		    	filaCero.getCell(9).toString().toUpperCase().contains(CT_COL_DIEZ) &&
		    	filaCero.getCell(10).toString().toUpperCase().contains(CT_COL_ONCE) &&
		    	filaCero.getCell(11).toString().toUpperCase().contains(CT_COL_DOCE) &&
		    	filaCero.getCell(12).toString().toUpperCase().contains(CT_COL_TRECE) &&
		    	filaCero.getCell(13).toString().toUpperCase().contains(CT_COL_CATORCE) &&
		    	filaCero.getCell(14).toString().toUpperCase().contains(CT_COL_QUINCE))
		    {
		    	
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
			    for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
			    	CargaTitulosExcelDTO datosXL = new CargaTitulosExcelDTO(); 
			    	datosXL.setFila(Integer.toString(xFila));
			    	
			    	XSSFRow row = sheet.getRow(xFila);
			    	
			    	if(row != null)
			    	{
			    	
				    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
				    	XSSFCell cellNombreUnico =  row.getCell(0);
				    	if(cellNombreUnico != null)
				    	{
				    		cellNombreUnico.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreUnico(cellNombreUnico.toString());
				    	}
				    	else
				    		datosXL.setNombreUnico("");
				    	
				    	XSSFCell cellNombreEstandar =  row.getCell(1);
				    	if(cellNombreEstandar != null)
				    	{
				    		cellNombreEstandar.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreEstandar(cellNombreEstandar.toString());
				    	}
				    	else
				    		datosXL.setNombreEstandar("");
				    	
				    	XSSFCell cellTemporada =  row.getCell(2);
				    	if(cellTemporada != null)
				    	{
				    		cellTemporada.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setTemporada(cellTemporada.toString());
				    	}
				    	else
				    		datosXL.setTemporada("");
				    	
				    	XSSFCell cellEpisodio =  row.getCell(3);
				    	if(cellEpisodio != null)
				    	{
				    		cellEpisodio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setEpisodio(cellEpisodio.toString());
				    	}
				    	else
				    		datosXL.setEpisodio("");
				    	
				    	XSSFCell cellFechaInicio =  row.getCell(4);
				    	if(cellFechaInicio != null)
				    	{
				    		
				    		if(cellFechaInicio.getCellType() == Cell.CELL_TYPE_NUMERIC)
				    		{
				    			cellFechaInicio.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaInicio( dateMgr.dateToString(cellFechaInicio.getDateCellValue(), "dd/MM/yyyy") );
				    		}
				    		else
				    			datosXL.setFechaInicio("");
				    	}
				    	else
				    		datosXL.setFechaInicio("");
				    	
				    	XSSFCell cellFechaFin =  row.getCell(5);
				    	if(cellFechaFin != null)
				    	{
				    		
				    		if (cellFechaFin.getCellType() == Cell.CELL_TYPE_NUMERIC)
							{
					    		cellFechaFin.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaFin( dateMgr.dateToString(cellFechaFin.getDateCellValue(), "dd/MM/yyyy") );
							}
							else
								datosXL.setFechaFin("");
				    	}
				    	else
				    		datosXL.setFechaFin("");
				    	
				    	XSSFCell cellCategoriaEstudio =  row.getCell(6);
				    	if(cellCategoriaEstudio != null)
				    	{
				    		cellCategoriaEstudio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setCategoriaEstudio( cellCategoriaEstudio.toString() );
				    	}
				    	else
				    		datosXL.setCategoriaEstudio("");
				    	
				    	XSSFCell cellCategoria =  row.getCell(7);
				    	if(cellCategoria != null)
				    	{
				    		cellCategoria.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setCategoria( cellCategoria.toString() );
				    	}
				    	else
				    		datosXL.setCategoria("");
				    	
				    	XSSFCell cellPrecio =  row.getCell(8);
				    	if(cellPrecio != null)
				    	{
				    		cellPrecio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setPrecio( cellPrecio.toString() );
				    	}
				    	else
				    		datosXL.setPrecio("");
				    	
				    	XSSFCell cellAnual = row.getCell(9);
				    	if(cellAnual != null)
				    	{
				    		cellAnual.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setAnual(cellAnual.toString());
				    	}
				    	else
				    		datosXL.setAnual("NO");
				    	
				    	XSSFCell cellBriefcase =  row.getCell(10);
				    	if(cellBriefcase != null)
				    	{
				    		cellBriefcase.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setBriefcase( cellBriefcase.toString() );
				    	}
				    	else
				    		datosXL.setBriefcase("NO");
				    	
				    	
				    	XSSFCell cellIdBroadView =  row.getCell(11);
				    	if(cellIdBroadView != null)
				    	{
				    		cellIdBroadView.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdBroadView( cellIdBroadView.toString() );
				    	}
				    	else
				    		datosXL.setIdBroadView("");
				    	
				    	
				    	XSSFCell cellMesesExclusivo =  row.getCell(12);
				    	if(cellMesesExclusivo != null)
				    	{
				    		cellMesesExclusivo.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setMesesExclusivo( cellMesesExclusivo.toString() );
				    	}
				    	else
				    		datosXL.setMesesExclusivo("");
				    	
				    	
				    	XSSFCell cellPorcentajeExclusivo =  row.getCell(13);
				    	if(cellPorcentajeExclusivo != null)
				    	{
				    		cellPorcentajeExclusivo.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setPorcentajeExclusivo( cellPorcentajeExclusivo.toString() );
				    	}
				    	else
				    		datosXL.setPorcentajeExclusivo("");
				    	
				    	XSSFCell cellAnnioContrato = row.getCell(14);
				    	if(cellAnnioContrato != null)
				    	{
				    		cellAnnioContrato.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setAnnioContrato(cellAnnioContrato.toString());
				    	}
				    	else
				    		datosXL.setAnnioContrato("");
				    
				    	LOG.debug("leerCargaTitulosXLSX["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": NombreUnico:["+datosXL.getNombreUnico()+"],NombreEstandar: "+datosXL.getNombreEstandar()+",Temporada:["+datosXL.getTemporada()+ "],Episodio:["+datosXL.getEpisodio()+"],FechaInicio:["+datosXL.getFechaInicio()+"],FechaFin:["+datosXL.getFechaFin()+"],CategoriaEstudio:["+datosXL.getCategoriaEstudio()+"],Categoria:["+datosXL.getCategoria()+"],Precio:["+datosXL.getPrecio()+"],Anual:["+datosXL.getAnual()+"],Briefcase:["+datosXL.getBriefcase()+"],IdBroadView:["+datosXL.getIdBroadView()+"],MesesExclusivo:["+datosXL.getMesesExclusivo()+"],PorcentajeExclusivo:["+datosXL.getPorcentajeExclusivo()+"], AnnioContrato:["+datosXL.getAnnioContrato()+"]");
				    	this.lobDatosXL.add(datosXL);
			    	}//Ends if(row != null)
			    	
			    }//Termina for(int xFila=1; xFila < lnuUltimaFila; xFila++)
		    }//Termina verifica Encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerCargaTitulosXLSX[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
		    
		    file.close();
		}
		catch (FileNotFoundException fe) 
		{
			LOG.error("leerCargaTitulosXLSX[FileNotFoundException] No se encontro el archivo en la ruta especificada." + fe.getMessage());
			this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
		    //e.printStackTrace();
		} 
		catch (IOException ioe) 
		{
			LOG.error("leerCargaTitulosXLSX[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + ioe.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerCargaTitulosXLSX[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
		
	}
	
	
	public void leerArchivoExcelActualizaIdBV(String pstURLArchivo, String pstNombreArchivo)
	{
		String[] componentesNombreOriginal = pstNombreArchivo.split("\\.");
		LOG.debug("[leerArchivoExcelActualizaIdBV]ComponentesNombreOriginal: " + componentesNombreOriginal.toString());
				
		String lstExtension = componentesNombreOriginal[1].toString();
		LOG.debug("[leerArchivoExcelActualizaIdBV]Extension: " + lstExtension);
		
		
		
		if(lstExtension.equalsIgnoreCase("xls"))
		{
			leerActualizaIdBvXLS(pstURLArchivo);
		}
		else if(lstExtension.equalsIgnoreCase("xlsx"))
		{
			leerActualizaIdBvXLSX(pstURLArchivo);
		}
	}
	
	
	@SuppressWarnings("unused")
	private void leerActualizaIdBvXLS(String pstArchivoURL)
	{
		LOG.debug("leerActualizaIdBvXLS["+this.getClass().getSimpleName()+"]pstArchivoURL: " + pstArchivoURL);
		
		try 
		{
			FileInputStream file = new FileInputStream(new File(pstArchivoURL));
		     
		    //Obtener la instancia de Workbook para un archivo XLS 
		    HSSFWorkbook workbook = new HSSFWorkbook(file);
		 
		    //Obtiene la primera hoja del Libro de trabajo
		    HSSFSheet sheet = workbook.getSheetAt(0);
		    
		    /*
		    int lnuUltimaFila = sheet.getLastRowNum();
		    log.debug("leerXLS[ExcelReader]lnuUltimaFila: " + lnuUltimaFila);
		    */
		    
		    int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerActualizaIdBvXLS["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    //---Verifica que el encabezado coincida
		    HSSFRow filaCero = sheet.getRow(0);
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(AIB_COL_UNO) &&
		    	filaCero.getCell(1).toString().toUpperCase().contains(AIB_COL_DOS) &&
		    	filaCero.getCell(2).toString().toUpperCase().contains(AIB_COL_TRES) )
		    {
		    	
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
			    for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
			    	CargaIdBVDetalleDTO datosXL = new CargaIdBVDetalleDTO(); 
			    	datosXL.setFila(Integer.toString(xFila));
			    	
			    	HSSFRow row = sheet.getRow(xFila);
			    	
			    	if(row != null)
			    	{
				    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
				    	HSSFCell cellIdDDA =  row.getCell(0);
				    	if(cellIdDDA != null)
				    	{
				    		cellIdDDA.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdDDA(cellIdDDA.toString());
				    	}
				    	else
				    		datosXL.setIdDDA("");
				    	
				    	HSSFCell cellIdBroadView =  row.getCell(1);
				    	if(cellIdBroadView != null)
				    	{
				    		cellIdBroadView.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdBroadView(cellIdBroadView.toString());
				    	}
				    	else
				    		datosXL.setIdBroadView("");
				    	
				    	HSSFCell cellNombreEstandar =  row.getCell(2);
				    	if(cellNombreEstandar != null)
				    	{
				    		cellNombreEstandar.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreEstandar(cellNombreEstandar.toString());
				    	}
				    	else
				    		datosXL.setNombreEstandar("");
			    	
			    	
				    	LOG.debug("leerActualizaIdBvXLS["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": IdDDA:["+datosXL.getIdDDA()+"],IdBroadView:["+datosXL.getIdBroadView()+"],NombreEstandar:["+datosXL.getNombreEstandar()+ "]");
				    	this.lobDatosXL_AIB.add(datosXL);
			    	}//Ends if(row != null)
			    	
			    }//Termina for(int xFila=0; xFila < lnuUltimaFila; xFila++)
		    }//Termina verifica Encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerActualizaIdBvXLS[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
		    
		    file.close();
		} 
		catch (FileNotFoundException e) 
		{
		    LOG.error("leerActualizaIdBvXLS[FileNotFoundException] No se encontro el archivo en la ruta especificada.");
		    this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
			//e.printStackTrace();
		    
		} 
		catch (IOException e) 
		{
			LOG.error("leerActualizaIdBvXLS[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerActualizaIdBvXLS[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
	
	}
	
	@SuppressWarnings("unused")
	private void leerActualizaIdBvXLSX(String pstArchivoURL)
	{
		LOG.debug("leerActualizaIdBvXLSX["+this.getClass().getSimpleName()+"]pstArchivoURL: " + pstArchivoURL);
		
		try 
		{
			FileInputStream file = new FileInputStream(new File(pstArchivoURL));
			
			//Obtener la instancia de Workbook para un archivo XLSX
			XSSFWorkbook workbook = new XSSFWorkbook(file);
			
			//Obtiene la primera hoja del Libro de trabajo
			XSSFSheet sheet = workbook.getSheetAt(0);
		
			/*
			int lnuUltimaFila = sheet.getLastRowNum();
		    log.debug("leerXLSX[ExcelReader]lnuUltimaFila: " + lnuUltimaFila);
		    */
		    
		    int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerActualizaIdBvXLSX["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    
		    //---Verifica que el encabezado coincida
		    XSSFRow filaCero = sheet.getRow(0);
		    
		    LOG.debug("Encabezado cero: " + filaCero.getCell(0).toString().toUpperCase());
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(AIB_COL_UNO) &&
		    	filaCero.getCell(1).toString().toUpperCase().contains(AIB_COL_DOS) &&
		    	filaCero.getCell(2).toString().toUpperCase().contains(AIB_COL_TRES) )
		    {
		    	
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
			    for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
			    	CargaIdBVDetalleDTO datosXL = new CargaIdBVDetalleDTO(); 
			    	datosXL.setFila(Integer.toString(xFila));
			    	
			    	XSSFRow row = sheet.getRow(xFila);
			    	
			    	if(row != null)
			    	{
			    	
				    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
				    	XSSFCell cellIdDDA =  row.getCell(0);
				    	if(cellIdDDA != null)
				    	{
				    		cellIdDDA.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdDDA(cellIdDDA.toString());
				    	}
				    	else
				    		datosXL.setIdDDA("");
				    	
				    	XSSFCell cellIdBroadView =  row.getCell(1);
				    	if(cellIdBroadView != null)
				    	{
				    		cellIdBroadView.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdBroadView(cellIdBroadView.toString());
				    	}
				    	else
				    		datosXL.setIdBroadView("");
				    	
				    	XSSFCell cellNombreEstandar =  row.getCell(2);
				    	if(cellNombreEstandar != null)
				    	{
				    		cellNombreEstandar.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreEstandar(cellNombreEstandar.toString());
				    	}
				    	else
				    		datosXL.setNombreEstandar("");
			    	
			    	
				    	LOG.debug("leerActualizaIdBvXLSX["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": IdDDA:["+datosXL.getIdDDA()+"],IdBroadView:["+datosXL.getIdBroadView()+"],NombreEstandar:["+datosXL.getNombreEstandar()+ "]");
				    	this.lobDatosXL_AIB.add(datosXL);
			    	}//Ends if(row != null)
			    	
			    }//Termina for(int xFila=1; xFila < lnuUltimaFila; xFila++)
		    }//Termina verifica Encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerActualizaIdBvXLSX[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
		    
		    file.close();
		}
		catch (FileNotFoundException fe) 
		{
			LOG.error("leerActualizaIdBvXLSX[FileNotFoundException] No se encontro el archivo en la ruta especificada." + fe.getMessage());
			this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
		    //e.printStackTrace();
		} 
		catch (IOException ioe) 
		{
			LOG.error("leerActualizaIdBvXLSX[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + ioe.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerActualizaIdBvXLSX[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
		
	}
	

	public void leerArchivoExcelCargaTitulosLF(String pstURLArchivo, String pstNombreArchivo)
	{
		String[] componentesNombreOriginal = pstNombreArchivo.split("\\.");
		LOG.debug("[leerArchivoExcelCargaTitulosLF]ComponentesNombreOriginal: " + componentesNombreOriginal.toString());
				
		String lstExtension = componentesNombreOriginal[1].toString();
		LOG.debug("[leerArchivoExcelCargaTitulosLF]Extension: " + lstExtension);
		
		if(lstExtension.equalsIgnoreCase("xls"))
		{
			leerCargaTitulosLFXLS(pstURLArchivo);
		}
		else if(lstExtension.equalsIgnoreCase("xlsx"))
		{
			leerCargaTitulosLFXLSX(pstURLArchivo);
		}
	}
	
	
	@SuppressWarnings("unused")
	private void leerCargaTitulosLFXLS(String pstArchivoURL)
	{
		LOG.debug("leerCargaTitulosLFXLS["+this.getClass().getSimpleName()+"]pstArchivoURL: " + pstArchivoURL);
		
		try 
		{
			FileInputStream file = new FileInputStream(new File(pstArchivoURL));
		     
		    //Obtener la instancia de Workbook para un archivo XLS 
		    HSSFWorkbook workbook = new HSSFWorkbook(file);
		 
		    //Obtiene la primera hoja del Libro de trabajo
		    HSSFSheet sheet = workbook.getSheetAt(0);
		    
		    /*
		    int lnuUltimaFila = sheet.getLastRowNum();
		    log.debug("leerXLS[ExcelReader]lnuUltimaFila: " + lnuUltimaFila);
		    */
		    
		    int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerCargaTitulosLFXLS["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    //---Verifica que el encabezado coincida
		    HSSFRow filaCero = sheet.getRow(0);
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(LF_COL_UNO) &&
		    	filaCero.getCell(1).toString().toUpperCase().contains(LF_COL_DOS) &&
		    	filaCero.getCell(2).toString().toUpperCase().contains(LF_COL_TRES) &&
		    	filaCero.getCell(3).toString().toUpperCase().contains(LF_COL_CUATRO) &&
		    	filaCero.getCell(4).toString().toUpperCase().contains(LF_COL_CINCO) && 
		    	filaCero.getCell(5).toString().toUpperCase().contains(LF_COL_SEIS) &&
		    	filaCero.getCell(6).toString().toUpperCase().contains(LF_COL_SIETE) &&
		    	filaCero.getCell(7).toString().toUpperCase().contains(LF_COL_OCHO) &&
		    	filaCero.getCell(8).toString().toUpperCase().contains(LF_COL_NUEVE))
		    {
		    	
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
			    for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
			    	CargaTitulosExcelDTO datosXL = new CargaTitulosExcelDTO(); 
			    	datosXL.setFila(Integer.toString(xFila));
			    	
			    	HSSFRow row = sheet.getRow(xFila);
			    	
			    	if(row != null)
			    	{
			    		
				    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
				    	HSSFCell cellNombreUnico =  row.getCell(0);
				    	if(cellNombreUnico != null)
				    	{
				    		cellNombreUnico.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreUnico(cellNombreUnico.toString());
				    	}
				    	else
				    		datosXL.setNombreUnico("");
				    	
				    	HSSFCell cellNombreEstandar =  row.getCell(1);
				    	if(cellNombreEstandar != null)
				    	{
				    		cellNombreEstandar.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreEstandar(cellNombreEstandar.toString());
				    	}
				    	else
				    		datosXL.setNombreEstandar("");
				    	
				    	HSSFCell cellTemporada =  row.getCell(2);
				    	if(cellTemporada != null)
				    	{
				    		cellTemporada.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setTemporada(cellTemporada.toString());
				    	}
				    	else
				    		datosXL.setTemporada("");
				    	
				    	HSSFCell cellEpisodio =  row.getCell(3);
				    	if(cellEpisodio != null)
				    	{
				    		cellEpisodio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setEpisodio(cellEpisodio.toString());
				    	}
				    	else
				    		datosXL.setEpisodio("");
				    	
				    	HSSFCell cellFechaInicio =  row.getCell(4);
				    	if(cellFechaInicio != null)
				    	{
				    		if(cellFechaInicio.getCellType() == Cell.CELL_TYPE_NUMERIC)
				    		{
				    			cellFechaInicio.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaInicio( dateMgr.dateToString(cellFechaInicio.getDateCellValue(), "dd/MM/yyyy") );
				    		}
				    		else
				    			datosXL.setFechaInicio("");
				    		
				    	}
				    	else
				    		datosXL.setFechaInicio("");
				    	
				    	
				    	HSSFCell cellFechaFin =  row.getCell(5);
				    	if(cellFechaFin != null)
				    	{
				    		if (cellFechaFin.getCellType() == Cell.CELL_TYPE_NUMERIC)
							{
					    		cellFechaFin.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaFin( dateMgr.dateToString(cellFechaFin.getDateCellValue(), "dd/MM/yyyy") );
							}
							else
								datosXL.setFechaFin("");
				    	}
				    	else
				    		datosXL.setFechaFin("");
				    	
				    	HSSFCell cellCategoria =  row.getCell(6);
				    	if(cellCategoria != null)
				    	{
				    		cellCategoria.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setCategoria( cellCategoria.toString() );
				    	}
				    	else
				    		datosXL.setCategoria("");
				    	
				    	HSSFCell cellBriefcase =  row.getCell(7);
				    	if(cellBriefcase != null)
				    	{
				    		cellBriefcase.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setBriefcase( cellBriefcase.toString() );
				    	}
				    	else
				    		datosXL.setBriefcase("NO");
				    	
				    	HSSFCell cellIdBroadView =  row.getCell(8);
				    	if(cellIdBroadView != null)
				    	{
				    		cellIdBroadView.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdBroadView( cellIdBroadView.toString() );
				    	}
				    	else
				    		datosXL.setIdBroadView("");
				    	
				    	LOG.debug("leerCargaTitulosLFXLS["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": NombreUnico:["+datosXL.getNombreUnico()+"],NombreEstandar:["+datosXL.getNombreEstandar()+"],Temporada:["+datosXL.getTemporada()+ "],Episodio:["+datosXL.getEpisodio()+"],FechaInicio:["+datosXL.getFechaInicio()+"],FechaFin:["+datosXL.getFechaFin()+"],Categoria:["+datosXL.getCategoria()+"],Briefcase:["+datosXL.getBriefcase()+"],IdBroadView:["+datosXL.getIdBroadView()+"]");
				    	this.lobDatosXL_LF.add(datosXL);
			    	}//Ends if(row != null)
			    	
			    }//Termina for(int xFila=0; xFila < lnuUltimaFila; xFila++)
		    }//Termina verifica Encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerCargaTitulosLFXLS[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
		    
		    file.close();
		} 
		catch (FileNotFoundException e) 
		{
		    LOG.error("leerCargaTitulosLFXLS[FileNotFoundException] No se encontro el archivo en la ruta especificada.");
		    this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
			//e.printStackTrace();
		    
		} 
		catch (IOException e) 
		{
			LOG.error("leerCargaTitulosLFXLS[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerCargaTitulosLFXLS[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
	
	}
	
	@SuppressWarnings("unused")
	private void leerCargaTitulosLFXLSX(String pstArchivoURL)
	{
		LOG.debug("leerCargaTitulosLFXLSX["+this.getClass().getSimpleName()+"]pstArchivoURL: " + pstArchivoURL);
		
		try 
		{
			FileInputStream file = new FileInputStream(new File(pstArchivoURL));
			
			//Obtener la instancia de Workbook para un archivo XLSX
			XSSFWorkbook workbook = new XSSFWorkbook(file);
			
			//Obtiene la primera hoja del Libro de trabajo
			XSSFSheet sheet = workbook.getSheetAt(0);
		
			/*
			int lnuUltimaFila = sheet.getLastRowNum();
		    log.debug("leerXLSX[ExcelReader]lnuUltimaFila: " + lnuUltimaFila);
		    */
		    
		    int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerCargaTitulosLFXLSX["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    
		    //---Verifica que el encabezado coincida
		    XSSFRow filaCero = sheet.getRow(0);
		    
		    LOG.debug("Encabezado cero: " + filaCero.getCell(0).toString().toUpperCase());
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(LF_COL_UNO) &&
		    	filaCero.getCell(1).toString().toUpperCase().contains(LF_COL_DOS) &&
		    	filaCero.getCell(2).toString().toUpperCase().contains(LF_COL_TRES) &&
		    	filaCero.getCell(3).toString().toUpperCase().contains(LF_COL_CUATRO) &&
		    	filaCero.getCell(4).toString().toUpperCase().contains(LF_COL_CINCO) && 
		    	filaCero.getCell(5).toString().toUpperCase().contains(LF_COL_SEIS) &&
		    	filaCero.getCell(6).toString().toUpperCase().contains(LF_COL_SIETE) &&
		    	filaCero.getCell(7).toString().toUpperCase().contains(LF_COL_OCHO) &&
		    	filaCero.getCell(8).toString().toUpperCase().contains(LF_COL_NUEVE))
		    {
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
			    for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
			    	CargaTitulosExcelDTO datosXL = new CargaTitulosExcelDTO(); 
			    	datosXL.setFila(Integer.toString(xFila));
			    	
			    	XSSFRow row = sheet.getRow(xFila);
			    	
			    	if(row != null)
			    	{
				    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
				    	XSSFCell cellNombreUnico =  row.getCell(0);
				    	if(cellNombreUnico != null)
				    	{
				    		cellNombreUnico.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreUnico(cellNombreUnico.toString());
				    	}
				    	else
				    		datosXL.setNombreUnico("");
				    	
				    	XSSFCell cellNombreEstandar =  row.getCell(1);
				    	if(cellNombreEstandar != null)
				    	{
				    		cellNombreEstandar.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setNombreEstandar(cellNombreEstandar.toString());
				    	}
				    	else
				    		datosXL.setNombreEstandar("");
				    	
				    	XSSFCell cellTemporada =  row.getCell(2);
				    	if(cellTemporada != null)
				    	{
				    		cellTemporada.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setTemporada(cellTemporada.toString());
				    	}
				    	else
				    		datosXL.setTemporada("");
				    	
				    	XSSFCell cellEpisodio =  row.getCell(3);
				    	if(cellEpisodio != null)
				    	{
				    		cellEpisodio.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setEpisodio(cellEpisodio.toString());
				    	}
				    	else
				    		datosXL.setEpisodio("");
				    	
				    	XSSFCell cellFechaInicio =  row.getCell(4);
				    	if(cellFechaInicio != null)
				    	{
				    		
				    		if(cellFechaInicio.getCellType() == Cell.CELL_TYPE_NUMERIC)
				    		{
				    			cellFechaInicio.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaInicio( dateMgr.dateToString(cellFechaInicio.getDateCellValue(), "dd/MM/yyyy") );
				    		}
				    		else
				    			datosXL.setFechaInicio("");
				    	}
				    	else
				    		datosXL.setFechaInicio("");
				    	
				    	XSSFCell cellFechaFin =  row.getCell(5);
				    	if(cellFechaFin != null)
				    	{
				    		
				    		if (cellFechaFin.getCellType() == Cell.CELL_TYPE_NUMERIC)
							{
					    		cellFechaFin.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaFin( dateMgr.dateToString(cellFechaFin.getDateCellValue(), "dd/MM/yyyy") );
							}
							else
								datosXL.setFechaFin("");
				    	}
				    	else
				    		datosXL.setFechaFin("");
				    	
				    	XSSFCell cellCategoria =  row.getCell(6);
				    	if(cellCategoria != null)
				    	{
				    		cellCategoria.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setCategoria( cellCategoria.toString() );
				    	}
				    	else
				    		datosXL.setCategoria("");
				    	
				    	XSSFCell cellBriefcase =  row.getCell(7);
				    	if(cellBriefcase != null)
				    	{
				    		cellBriefcase.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setBriefcase( cellBriefcase.toString() );
				    	}
				    	else
				    		datosXL.setBriefcase("NO");
				    	
				    	
				    	XSSFCell cellIdBroadView =  row.getCell(8);
				    	if(cellIdBroadView != null)
				    	{
				    		cellIdBroadView.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setIdBroadView( cellIdBroadView.toString() );
				    	}
				    	else
				    		datosXL.setIdBroadView("");
				    	
				    	LOG.debug("leerCargaTitulosLFXLSX["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": NombreUnico:["+datosXL.getNombreUnico()+"],NombreEstandar: "+datosXL.getNombreEstandar()+",Temporada:["+datosXL.getTemporada()+ "],Episodio:["+datosXL.getEpisodio()+"],FechaInicio:["+datosXL.getFechaInicio()+"],FechaFin:["+datosXL.getFechaFin()+"],Categoria:["+datosXL.getCategoria()+"],Briefcase:["+datosXL.getBriefcase()+"],IdBroadView:["+datosXL.getIdBroadView()+"]");
				    	this.lobDatosXL_LF.add(datosXL);
			    	}//Ends if(row != null)
			    	
			    }//Termina for(int xFila=1; xFila < lnuUltimaFila; xFila++)
		    }//Termina verifica Encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerCargaTitulosLFXLSX[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
		    
		    file.close();
		}
		catch (FileNotFoundException fe) 
		{
			LOG.error("leerCargaTitulosLFXLSX[FileNotFoundException] No se encontro el archivo en la ruta especificada." + fe.getMessage());
			this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
		    //e.printStackTrace();
		} 
		catch (IOException ioe) 
		{
			LOG.error("leerCargaTitulosLFXLSX[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + ioe.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerCargaTitulosLFXLSX[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
		
	}
	private void inicializaAtributos()
	{
		this.lobDatosXL = new ArrayList<CargaTitulosExcelDTO>();
		this.lobDatosXL_AIB = new ArrayList<CargaIdBVDetalleDTO>();
		this.lobDatosXL_LF = new ArrayList<CargaTitulosExcelDTO>();
		this.lobDatosXL_TR = new ArrayList<CargaTitulosTRExcelDTO>();
		this.lobDatosXL_PN = new ArrayList<CargaTitulosPNExcelDTO>();
		this.lobDatosXL_VS = new ArrayList<CargaTitulosVSExcelDTO>();
		this.lstMensaje = "";
	}
	

	public void leerArchivoExcelCargaTitulosTR(String pstURLArchivo, String pstNombreArchivo)
	{
		String lstVAL_LIBRERIA = "Librera";
		int lnuLONG_IDBROADVIEW = 12;
		int lnuLONG_NOMBREUNICO = 150;
		int lnuLONG_NOMBREESTANDAR = 150;
		int lnuLONG_TEMPORADA=10;
		int lnuLONG_EPISODIO=10;
		int lnuMAXVAL_DURACION = 250;
		int lnuLONG_NOMBREESP=150;
		int lnuLONG_NOMBREING=150;
		int lnuLONG_NOMBREPOR=150;
		
		List<String> lobVALORES_BRIEFCASE = new ArrayList<String>();
		lobVALORES_BRIEFCASE.add("SI");
		lobVALORES_BRIEFCASE.add("NO");
		
		List<String> lobVALORES_DTR = new ArrayList<String>();
		lobVALORES_DTR.add("SI");
		lobVALORES_DTR.add("NO");
		
		List<String> lobVALORES_CATDTR = new ArrayList<String>();
		lobVALORES_CATDTR.add("PREMIUM");
		lobVALORES_CATDTR.add("LIBRERA");
		lobVALORES_CATDTR.add("LIBRERIA");
		lobVALORES_CATDTR.add("PREMIER");
		
		List<String> lobVALORES_DTO = new ArrayList<String>();
		lobVALORES_DTO.add("SI");
		lobVALORES_DTO.add("NO");
		
		List<String> lobVALORES_SD = new ArrayList<String>();
		lobVALORES_SD.add("SI");
		lobVALORES_SD.add("NO");
		
		List<String> lobVALORES_HD = new ArrayList<String>();
		lobVALORES_HD.add("SI");
		lobVALORES_HD.add("NO");
		
		List<String> lobVALORES_3D = new ArrayList<String>();
		lobVALORES_3D.add("SI");
		lobVALORES_3D.add("NO");
		
		String annioActual = dateMgr.getFechaActual("yyyy");
		int lnuANNIO_ACTUAL = Integer.parseInt(annioActual, 10);
				
		LOG.debug("leerArchivoExcelCargaTitulosTR["+this.getClass().getSimpleName()+"]pstURLArchivo: " + pstURLArchivo);
		Workbook workbook = null;
		
		String[] componentesNombreOriginal = pstNombreArchivo.split("\\.");
		LOG.debug("[leerArchivoExcelCargaTitulosTR]ComponentesNombreOriginal: " + componentesNombreOriginal.toString());
				
		String lstExtension = componentesNombreOriginal[1].toString();
		LOG.debug("[leerArchivoExcelCargaTitulosTR]Extension: " + lstExtension);
		
		try 
		{
			FileInputStream file = new FileInputStream(new File(pstURLArchivo));
			
			if(lstExtension.equalsIgnoreCase("xls"))
				workbook = new HSSFWorkbook(file);
			else if(lstExtension.equalsIgnoreCase("xlsx"))
				workbook = new XSSFWorkbook(file);
			
			//Obtiene la primera hoja del Libro de trabajo
			Sheet sheet = workbook.getSheetAt(0);
			
			int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerArchivoExcelCargaTitulosTR["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    //--Verifica que el encabezado coincida
		    Row filaCero = sheet.getRow(0);
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(TR_COL_UNO) &&
			    	filaCero.getCell(1).toString().toUpperCase().contains(TR_COL_DOS) &&
			    	filaCero.getCell(2).toString().toUpperCase().contains(TR_COL_TRES) &&
			    	filaCero.getCell(3).toString().toUpperCase().contains(TR_COL_CUATRO) &&
			    	filaCero.getCell(4).toString().toUpperCase().contains(TR_COL_CINCO) && 
			    	filaCero.getCell(5).toString().toUpperCase().contains(TR_COL_SEIS) &&
			    	filaCero.getCell(6).toString().toUpperCase().contains(TR_COL_SIETE) &&
			    	filaCero.getCell(7).toString().toUpperCase().contains(TR_COL_OCHO) &&
			    	filaCero.getCell(8).toString().toUpperCase().contains(TR_COL_NUEVE) &&
			    	filaCero.getCell(9).toString().toUpperCase().contains(TR_COL_DIEZ) &&
			    	filaCero.getCell(10).toString().toUpperCase().contains(TR_COL_ONCE) &&
			    	filaCero.getCell(11).toString().toUpperCase().contains(TR_COL_DOCE) &&
			    	filaCero.getCell(12).toString().toUpperCase().contains(TR_COL_TRECE) &&
			    	filaCero.getCell(13).toString().toUpperCase().contains(TR_COL_CATORCE) &&
			    	filaCero.getCell(14).toString().toUpperCase().contains(TR_COL_QUINCE) &&
			    	filaCero.getCell(15).toString().toUpperCase().contains(TR_COL_DIECISEIS) &&
			    	filaCero.getCell(16).toString().toUpperCase().contains(TR_COL_DIECISIETE) &&
			    	filaCero.getCell(17).toString().toUpperCase().contains(TR_COL_DIECIOCHO) &&
			    	filaCero.getCell(18).toString().toUpperCase().contains(TR_COL_DIECINUEVE) &&
			    	filaCero.getCell(19).toString().toUpperCase().contains(TR_COL_VEINTE) &&
			    	filaCero.getCell(20).toString().toUpperCase().contains(TR_COL_VEINTIUNO) &&
			    	filaCero.getCell(21).toString().toUpperCase().contains(TR_COL_VEINTIDOS) &&
			    	filaCero.getCell(22).toString().toUpperCase().contains(TR_COL_VEINTITRES) &&
			    	filaCero.getCell(23).toString().toUpperCase().contains(TR_COL_VEINTICUATRO) &&
			    	filaCero.getCell(24).toString().toUpperCase().contains(TR_COL_VEINTICINCO) &&
			    	filaCero.getCell(25).toString().toUpperCase().contains(TR_COL_VEINTISEIS))
		    {
		    	
		    
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
		    	for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
		    		CargaTitulosTRExcelDTO datosXL = new CargaTitulosTRExcelDTO(); 
			    	datosXL.setFila(Integer.toString(xFila));
			    	int lnuErrores = 0;
			    	
			    	Row row = sheet.getRow(xFila);
			    	
			    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
			    	//--      El orden se ajusto para efecto de las validaciones
			    	if(row != null)
			    	{
			    		//LOG.debug("Fila:["+xFila+"], ultima celda:[" + row.getLastCellNum()+"]");
			    		
				    	//-Filial
				    	Cell cellFilial = row.getCell(0);
				    	if(cellFilial != null && cellFilial.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellFilial.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setFilial(cellFilial.toString());
				    	}
				    	else
				    	{
				    		datosXL.setFilial("");
				    		datosXL.setComentarios("Campo Filial nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
				    	
				    	
				    	//-Id Broadview
				    	Cell cellIdBroadView =  row.getCell(1);
				    	if(cellIdBroadView != null && cellIdBroadView.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellIdBroadView.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
					    		boolean boSoloNumeros = valMgr.soloNumeros(cellIdBroadView.toString());
					    		if(!boSoloNumeros)
					    		{
					    			datosXL.setComentarios("Campo IdBroadview no numerico");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
					    		else if(cellIdBroadView.toString().length() > lnuLONG_IDBROADVIEW)
					    		{
					    			datosXL.setComentarios("Campo IdBroadview mayor de "+lnuLONG_IDBROADVIEW+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setIdBroadView( cellIdBroadView.toString() );
				    	}
				    	else
				    	{
				    		datosXL.setIdBroadView("");
				    		datosXL.setComentarios("Campo Id Broadview nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
	
				    	
				    	//-Nombre unico
				    	Cell cellNombreUnico =  row.getCell(2);
				    	if(cellNombreUnico != null && cellNombreUnico.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellNombreUnico.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			if(cellNombreUnico.toString().length() > lnuLONG_NOMBREUNICO)
				    			{
				    				datosXL.setComentarios("Campo Nombre unico mayor de "+lnuLONG_NOMBREUNICO+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setNombreUnico(cellNombreUnico.toString());
				    	}
				    	else
				    	{
				    		datosXL.setNombreUnico("");
				    		datosXL.setComentarios("Campo Nombre unico nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
				    	
				    	
				    	//-Nombre estandar
				    	Cell cellNombreEstandar =  row.getCell(3);
				    	if(cellNombreEstandar != null && cellNombreEstandar.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellNombreEstandar.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			if(cellNombreEstandar.toString().length() > lnuLONG_NOMBREESTANDAR)
				    			{
				    				datosXL.setComentarios("Campo Nombre estandar mayor de "+lnuLONG_NOMBREESTANDAR+" caracteres");
				    				datosXL.setEstatus("0");
				    				lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setNombreEstandar(cellNombreEstandar.toString());
				    	}
				    	else
				    	{
				    		datosXL.setNombreEstandar("");
				    		datosXL.setComentarios("Campo Nombre estandar nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
				    	
	
				    	//-Categoria
				    	Cell cellCategoria =  row.getCell(4);
				    	if(cellCategoria != null && cellCategoria.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellCategoria.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setCategoria( cellCategoria.toString() );
				    	}
				    	else
				    	{
				    		datosXL.setCategoria("");
				    		datosXL.setComentarios("Campo Categoria nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
				    	
				    	
				    	//-Temporada
				    	Cell cellTemporada =  row.getCell(5);
				    	if(cellTemporada != null && cellTemporada.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellTemporada.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			boolean boSoloNumeros = valMgr.soloNumeros(cellTemporada.toString());
					    		if(!boSoloNumeros)
					    		{
					    			datosXL.setComentarios("Campo Temporada no numerico");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
					    		else if(cellTemporada.toString().length() > lnuLONG_TEMPORADA)
					    		{
					    			datosXL.setComentarios("Campo Temporada mayor de "+lnuLONG_TEMPORADA+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setTemporada(cellTemporada.toString());
				    	}
				    	else
				    		datosXL.setTemporada("");
				    	
				    	
				    	//-Episodio
				    	Cell cellEpisodio =  row.getCell(6);
				    	if(cellEpisodio != null && cellEpisodio.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellEpisodio.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			boolean boSoloNumeros = valMgr.soloNumeros(cellEpisodio.toString());
					    		if(!boSoloNumeros)
					    		{
					    			datosXL.setComentarios("Campo Episodio no numerico");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
					    		else if(cellEpisodio.toString().length() > lnuLONG_EPISODIO)
					    		{
					    			datosXL.setComentarios("Campo Temporada mayor de "+lnuLONG_EPISODIO+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setEpisodio(cellEpisodio.toString());
				    	}
				    	else
				    		datosXL.setEpisodio("");
				    	
				    	
				    	//-HVRD
				    	Cell cellHVRD = row.getCell(7);
				    	if(cellHVRD != null && cellHVRD.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		if(cellHVRD.getCellType() == Cell.CELL_TYPE_NUMERIC)
				    		{
				    			cellHVRD.setCellType(Cell.CELL_TYPE_NUMERIC);
				    			datosXL.setHvrd(dateMgr.dateToString(cellHVRD.getDateCellValue(), "dd/MM/yyyy"));
				    		}
				    		else
				    		{
				    			datosXL.setHvrd("");
				    			datosXL.setComentarios("Campo HVRD con datos invalidos");
					    		datosXL.setEstatus("0");
					    		lnuErrores++;
				    		}
				    		
				    	}
				    	else
				    		datosXL.setHvrd("");
	
				    	
				    	
				    	//-Fecha inicio
				    	Cell cellFechaInicio =  row.getCell(8);
				    	if(cellFechaInicio != null && cellFechaInicio.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		if(cellFechaInicio.getCellType() == Cell.CELL_TYPE_NUMERIC)
				    		{
				    			cellFechaInicio.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaInicio( dateMgr.dateToString(cellFechaInicio.getDateCellValue(), "dd/MM/yyyy") );
				    		}
				    		else
				    		{
				    			datosXL.setFechaInicio("");
				    			datosXL.setComentarios("Campo Fecha inicio con datos invalidos");
					    		datosXL.setEstatus("0");
					    		lnuErrores++;
				    		}
				    		
				    	}
				    	else
				    	{
				    		datosXL.setFechaInicio("");
				    		datosXL.setComentarios("Campo Fecha inicio nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
				    	
				    	
				    	//-Fecha fin
				    	Cell cellFechaFin =  row.getCell(9);
				    	if(cellFechaFin != null && cellFechaFin.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		if (cellFechaFin.getCellType() == Cell.CELL_TYPE_NUMERIC)
							{
					    		cellFechaFin.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setFechaFin( dateMgr.dateToString(cellFechaFin.getDateCellValue(), "dd/MM/yyyy") );
							}
							else
							{
								datosXL.setFechaFin("");
								datosXL.setComentarios("Campo Fecha fin con datos invalidos");
					    		datosXL.setEstatus("0");
					    		lnuErrores++;
							}
				    	}
				    	else
				    	{
				    		datosXL.setFechaFin("");
				    		datosXL.setComentarios("Campo Fecha fin nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
				    	
				    	
				    	//-Boxoffice
				    	Cell cellBoxOffice =  row.getCell(10);
				    	if(cellBoxOffice != null && cellBoxOffice.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellBoxOffice.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			boolean boNumPositivosMax2Dec = valMgr.numPositivosMax2Dec(cellBoxOffice.toString());
					    		if(!boNumPositivosMax2Dec)
					    		{
					    			datosXL.setComentarios("Campo BoxOffice con datos invalidos");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
				    		}//Termina if(lnuErrores == 0)
				    		
				    		datosXL.setBoxOffice(cellBoxOffice.toString());
				    	}
				    	else
				    		datosXL.setBoxOffice("");
				    	
				    	
				    	//-Briefcase
				    	Cell cellBriefcase =  row.getCell(13);
				    	if(cellBriefcase != null && cellBriefcase.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellBriefcase.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			boolean lboContieneValoresCorrectos = lobVALORES_BRIEFCASE.contains(cellBriefcase.toString().toUpperCase());
				    			if(!lboContieneValoresCorrectos)
				    			{
				    				datosXL.setComentarios("Campo Briefcase con datos invalidos");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setBriefcase( cellBriefcase.toString() );
				    	}
				    	else
				    		datosXL.setBriefcase("NO");
				    	
				    	
				    	//--DTR
				    	Cell cellDTR =  row.getCell(14);
				    	if(cellDTR != null && cellDTR.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellDTR.setCellType(Cell.CELL_TYPE_STRING);
				    		if(lnuErrores == 0)
				    		{
				    			boolean lboContieneValoresCorrectos = lobVALORES_DTR.contains(cellDTR.toString().toUpperCase());
				    			if(!lboContieneValoresCorrectos)
				    			{
				    				datosXL.setComentarios("Campo DTR con datos invalidos");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}
				    		datosXL.setDtr( cellDTR.toString() );
				    	}
				    	else
				    		datosXL.setDtr("NO");
				    	
				    	
				    	//-Categoria DTR
				    	Cell cellCatDTR =  row.getCell(11);
				    	if(cellDTR != null && cellDTR.getCellType() != Cell.CELL_TYPE_BLANK && cellDTR.toString().toUpperCase().equalsIgnoreCase("SI"))
				    	{
					    	if(cellCatDTR != null && cellCatDTR.getCellType() != Cell.CELL_TYPE_BLANK)
					    	{
					    		cellCatDTR.setCellType(Cell.CELL_TYPE_STRING);
					    		
					    		if(lnuErrores == 0)
					    		{
					    			boolean lboContieneValorCorrectos = lobVALORES_CATDTR.contains(cellCatDTR.toString().toUpperCase());
					    			if(!lboContieneValorCorrectos)
					    			{
					    				datosXL.setComentarios("Campo Categoria DTR con datos invalidos");
							    		datosXL.setEstatus("0");
							    		lnuErrores++;
					    			}
					    		}//Ends if(lnuErrores == 0)
					    		
					    		//--Antes de enviar, formatea los valores segun se requieren. 
					    		
					    		if(cellCatDTR.toString().toUpperCase().indexOf("LIB") != -1)
					    			datosXL.setCategoriaDtr(lstVAL_LIBRERIA);
					    		else
					    			datosXL.setCategoriaDtr(WordUtils.capitalizeFully(cellCatDTR.toString()));
					    	}
					    	else
					    	{
					    		datosXL.setCategoriaDtr("");
					    		datosXL.setComentarios("Campo Categoria DTR nulo");
					    		datosXL.setEstatus("0");
					    		lnuErrores++;
					    	}
				    		
				    	}//Ends if(cellDTR.toString().toUpperCase().equalsIgnoreCase("SI"))
				    	else
				    	{
					    	if(cellCatDTR != null && cellCatDTR.getCellType() != Cell.CELL_TYPE_BLANK)
					    	{
					    		cellCatDTR.setCellType(Cell.CELL_TYPE_STRING);
					    		if(lnuErrores == 0)
					    		{
					    			datosXL.setComentarios("Campo Categoria DTR innecesario.");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
					    		datosXL.setCategoriaDtr(cellCatDTR.toString());
					    	}
					    	else
					    	{
					    		datosXL.setCategoriaDtr("");
					    	}
				    	}
				    	
				    	
				    	//-DTO
				    	Cell cellDTO =  row.getCell(15);
				    	if(cellDTO != null && cellDTO.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellDTO.setCellType(Cell.CELL_TYPE_STRING);
				    		if(lnuErrores == 0)
				    		{
				    			boolean lboContieneValoresCorrectos = lobVALORES_DTO.contains(cellDTO.toString().toUpperCase());
				    			if(!lboContieneValoresCorrectos)
				    			{
				    				datosXL.setComentarios("Campo DTO con datos invalidos");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		datosXL.setDto( cellDTO.toString() );
				    	}
				    	else
				    		datosXL.setDto("NO");
				    	
				    	
				    	//-Categoria DTO
				    	Cell cellCatDTO =  row.getCell(12);
				    	if(cellDTO != null && cellDTO.getCellType() != Cell.CELL_TYPE_BLANK && cellDTO.toString().toUpperCase().equalsIgnoreCase("SI"))
				    	{
				    		//-Categoria DTO
					    	if(cellCatDTO != null && cellCatDTO.getCellType() != Cell.CELL_TYPE_BLANK)
					    	{
					    		cellCatDTO.setCellType(Cell.CELL_TYPE_STRING);
					    		datosXL.setCategoriaDto(cellCatDTO.toString());
					    	}
					    	else
					    	{
					    		datosXL.setCategoriaDto("");
					    		datosXL.setComentarios("Campo Categoria DTO nulo");
					    		datosXL.setEstatus("0");
					    		lnuErrores++;
					    	}
				    		
				    	}//Ends if(cellDTO.toString().toUpperCase().equalsIgnoreCase("SI"))
				    	else
				    	{
				    		
				    		if(cellCatDTO != null && cellCatDTO.getCellType() != Cell.CELL_TYPE_BLANK)
					    	{
				    			cellCatDTO.setCellType(Cell.CELL_TYPE_STRING);
				    			
				    			if(lnuErrores == 0)
					    		{
				    				datosXL.setComentarios("Campo Categoria DTO innecesario.");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
					    		}
				    			
				    			datosXL.setCategoriaDto(cellCatDTO.toString());
					    	}
				    		else
				    			datosXL.setCategoriaDto("");
				    		
				    	}
				    	
				    	//-SD
				    	Cell cellSD =  row.getCell(16);
				    	if(cellSD != null && cellSD.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellSD.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			boolean lboContieneValoresCorrectos = lobVALORES_SD.contains(cellSD.toString().toUpperCase());
				    			if(!lboContieneValoresCorrectos)
				    			{
				    				datosXL.setComentarios("Campo SD con datos invalidos");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setSd( cellSD.toString() );
				    	}
				    	else
				    		datosXL.setSd("NO");
				    	
				    	
				    	//-HD
				    	Cell cellHD =  row.getCell(17);
				    	if(cellHD != null && cellHD.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellHD.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			boolean lboContieneValoresCorrectos = lobVALORES_HD.contains(cellHD.toString().toUpperCase());
				    			if(!lboContieneValoresCorrectos)
				    			{
				    				datosXL.setComentarios("Campo HD con datos invalidos");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setHd( cellHD.toString() );
				    	}
				    	else
				    		datosXL.setHd("NO");
				    	
				    	
				    	//-3D
				    	Cell cell3D =  row.getCell(18);
				    	if(cell3D != null && cell3D.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cell3D.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lnuErrores == 0)
				    		{
				    			boolean lboContieneValoresCorrectos = lobVALORES_3D.contains(cell3D.toString().toUpperCase());
				    			if(!lboContieneValoresCorrectos)
				    			{
				    				datosXL.setComentarios("Campo 3D con datos invalidos");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setTresD( cell3D.toString() );
				    	}
				    	else
				    		datosXL.setTresD("NO");
				    	
				    	
				    	//-Duracion
				    	Cell cellDuracion =  row.getCell(19);
				    	if(cellDuracion != null && cellDuracion.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		
				    		String lstDuracion = df.formatCellValue(cellDuracion);
				    		//LOG.debug("Fila:["+xFila+"], Tipo:["+cellDuracion.getCellType()+"], Duracion:["+lstDuracion+"], Longitud: ["+lstDuracion.trim().length()+"]");
				    		//cellDuracion.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lstDuracion.trim().length() > 0)
				    		{
				    			if(lnuErrores == 0)
					    		{
					    			boolean boSoloNumeros = valMgr.soloNumeros(lstDuracion);
						    		if(!boSoloNumeros)
						    		{
						    			datosXL.setComentarios("Campo Duracion no numerico o entero positivo");
							    		datosXL.setEstatus("0");
							    		lnuErrores++;
						    		}
						    		else if(Integer.parseInt(lstDuracion, 10) > lnuMAXVAL_DURACION)
						    		{
						    			datosXL.setComentarios("Campo Duracion mayor de "+lnuMAXVAL_DURACION+".");
							    		datosXL.setEstatus("0");
							    		lnuErrores++;
						    		}
					    		}//Ends if(lnuErrores == 0)
					    		
					    		datosXL.setDuracion( lstDuracion );
				    		}//Ends if(lstDuracion.trim().length() > 0)
				    		else
				    			datosXL.setDuracion("");
				    	}
				    	else
				    		datosXL.setDuracion("");
				    	
				    	
				    	
				    	//-Annio
				    	Cell cellAnnio =  row.getCell(20);
				    	if(cellAnnio != null && cellAnnio.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		String lstAnnio = df.formatCellValue(cellAnnio);
				    		//LOG.debug("Fila:["+xFila+"], Tipo:["+cellAnnio.getCellType()+"], Annio:["+lstAnnio+"], Longitud: ["+lstAnnio.trim().length()+"]");
				    		//cellAnnio.setCellType(Cell.CELL_TYPE_STRING);
				    		
				    		if(lstAnnio.trim().length() > 0)
				    		{
				    			if(lnuErrores == 0)
					    		{
		
					    			boolean boSoloNumeros = valMgr.soloNumeros(cellAnnio.toString());
						    		if(!boSoloNumeros)
						    		{
						    			datosXL.setComentarios("Campo Annio no numerico o entero positivo");
							    		datosXL.setEstatus("0");
							    		lnuErrores++;
						    		}
						    		else if(Integer.parseInt(cellAnnio.toString(), 10) < (lnuANNIO_ACTUAL - 5) || Integer.parseInt(cellAnnio.toString(), 10) > (lnuANNIO_ACTUAL + 5) )
						    		{
						    			datosXL.setComentarios("Campo Annio con datos invalidos");
							    		datosXL.setEstatus("0");
							    		lnuErrores++;
						    		}
					    		}//Ends if(lnuErrores == 0)
					    		
					    		datosXL.setAnnio( cellAnnio.toString() );
				    		}//Ends if(lstAnnio.trim().length() > 0)
				    		else
				    			datosXL.setAnnio("");
				    		
				    	}
				    	else
				    		datosXL.setAnnio("");
				    	
				    	
				    	//-Genero A
				    	Cell cellGenA =  row.getCell(21);
				    	if(cellGenA != null && cellGenA.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellGenA.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setGeneroA( cellGenA.toString() );
				    	}
				    	else
				    		datosXL.setGeneroA("");
				    	
				    	
				    	//-Genero B
				    	Cell cellGenB =  row.getCell(22);
				    	if(cellGenB != null && cellGenB.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellGenB.setCellType(Cell.CELL_TYPE_STRING);
				    		datosXL.setGeneroB( cellGenB.toString() );
				    	}
				    	else
				    		datosXL.setGeneroB("");
				    	
				    	//--Nombre espaol
				    	Cell cellNombreEspanol = row.getCell(23);
				    	if(cellNombreEspanol != null && cellNombreEspanol.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellNombreEspanol.setCellType(Cell.CELL_TYPE_STRING);
				    		if(lnuErrores == 0)
				    		{
				    			if(cellNombreEspanol.toString().length() > lnuLONG_NOMBREESP)
				    			{
				    				datosXL.setComentarios("Campo Nombre Espanol mayor de "+lnuLONG_NOMBREESP+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores == 0)
				    		
				    		datosXL.setNombreEspanol(cellNombreEspanol.toString());
				    	}
				    	else
				    		datosXL.setNombreEspanol("");
				    	
				    	//--Nombre ingles
				    	Cell cellNombreIngles = row.getCell(24);
				    	if(cellNombreIngles != null && cellNombreIngles.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellNombreIngles.setCellType(Cell.CELL_TYPE_STRING);
				    		if(lnuErrores==0)
				    		{
				    			if(cellNombreIngles.toString().length() > lnuLONG_NOMBREING)
				    			{
				    				datosXL.setComentarios("Campo Nombre Ingles mayor de "+lnuLONG_NOMBREING+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores==0)
				    		
				    		datosXL.setNombreIngles(cellNombreIngles.toString());
				    	}
				    	else
				    		datosXL.setNombreIngles("");
				    	
				    	
				    	//--Nombre portugues
				    	Cell cellNombrePortugues = row.getCell(25);
				    	if(cellNombrePortugues != null && cellNombrePortugues.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		cellNombrePortugues.setCellType(Cell.CELL_TYPE_STRING);
				    		if(lnuErrores==0)
				    		{
				    			if(cellNombrePortugues.toString().length() > lnuLONG_NOMBREPOR)
				    			{
				    				datosXL.setComentarios("Campo Nombre Portugues mayor de "+lnuLONG_NOMBREPOR+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
				    			}
				    		}//Ends if(lnuErrores==0)
				    		
				    		datosXL.setNombrePortugues(cellNombrePortugues.toString());
				    	}
				    	else
				    		datosXL.setNombrePortugues("");
				    	
				    	if(lnuErrores == 0)
				    	{
				    		datosXL.setComentarios("");
				    		datosXL.setEstatus("");
				    	}
				    	
				    	//--Verificacion final
				    	StringBuffer sb = new StringBuffer();
				    	sb.append(datosXL.getFilial());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getIdBroadView());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getNombreUnico());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getNombreEstandar());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getCategoria());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getTemporada());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getEpisodio());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getHvrd());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getFechaInicio());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getFechaFin());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getBoxOffice());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getCategoriaDtr());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getCategoriaDto());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getBriefcase());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getDtr());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getDto());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getSd());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getHd());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getTresD());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getDuracion());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getAnnio());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getGeneroA());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getGeneroB());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getNombreEspanol());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getNombreIngles());
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(datosXL.getNombrePortugues());
						
				    	String lstCadVerifica =  sb.toString();
				    	//LOG.debug("Cadena verificacion: " + lstCadVerifica);
				    	
				    	if(!lstCadVerifica.equals("|||||||||||||NO|NO|NO|NO|NO|NO|||||||"))
				    	{
				    		LOG.debug("leerArchivoExcelCargaTitulosTR["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": Filial:["+datosXL.getFilial()+"],IdBroadView:["+datosXL.getIdBroadView()+"],NombreUnico:["+datosXL.getNombreUnico()+"],NombreEstandar:["+datosXL.getNombreEstandar()+"],Categoria:["+datosXL.getCategoria()+"],Temporada:["+datosXL.getTemporada()+"],Episodio:["+datosXL.getEpisodio()+"],HVRD:["+datosXL.getHvrd()+"],FechaInicio:["+datosXL.getFechaInicio()+"],FechaFin:["+datosXL.getFechaFin()+"],BoxOffice:["+datosXL.getBoxOffice()+"],CatDTR:["+datosXL.getCategoriaDtr()+"],CatDTO:["+datosXL.getCategoriaDto()+"],Briefcase:["+datosXL.getBriefcase()+"],DTR:["+datosXL.getDtr()+"],DTO:["+datosXL.getDto()+"],SD:["+datosXL.getSd()+"],HD:["+datosXL.getHd()+"],3D:["+datosXL.getTresD()+"],Duracion:["+datosXL.getDuracion()+"],Annio:["+datosXL.getAnnio()+"],GenA:["+datosXL.getGeneroA()+"],GenB:["+datosXL.getGeneroB()+"],NomEsp:["+datosXL.getNombreEspanol()+"],NomIng:["+datosXL.getNombreIngles()+"],NomPor:["+datosXL.getNombrePortugues()+"]");
					    	this.lobDatosXL_TR.add(datosXL);
				    	}
				    	
			    	}//Ends if(row != null)
			    	 
			    }//Ends for(int xFila=1; xFila < lnuUltimaFila; xFila++)
		    	
		    }//Ends Verifica encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerArchivoExcelCargaTitulosTR[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
			
			file.close();
		}
		catch (FileNotFoundException e) 
		{
		    LOG.error("leerArchivoExcelCargaTitulosTR[FileNotFoundException] No se encontro el archivo en la ruta especificada.");
		    this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
			//e.printStackTrace();
		    
		} 
		catch (IOException e) 
		{
			LOG.error("leerArchivoExcelCargaTitulosTR[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerArchivoExcelCargaTitulosTR[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}

	}
	
	public void leerArchivoExcelCargaTitulosPN(String pstURLArchivo, String pstNombreArchivo)
	{
		int lnuLONG_IDPROGRAM = 12;
		int lnuLONG_TITULO = 150;
		int lnuLONG_MEDIOPAGO = 30;
		int lnuLONG_ABONO = 150;
		
		
		List<String> lobVALORES_ABONO = new ArrayList<String>();
		lobVALORES_ABONO.add("RENTA");
		lobVALORES_ABONO.add("RENTAS");
		lobVALORES_ABONO.add("COMPRA");
		lobVALORES_ABONO.add("COMPRAS");
		lobVALORES_ABONO.add("TOP MOVIES");
		lobVALORES_ABONO.add("VENTANA ANTICIPADA");
		lobVALORES_ABONO.add("ESTNDAR");
		lobVALORES_ABONO.add("ESTANDAR");
		lobVALORES_ABONO.add("SERIE");
		
		List<String> lobTYPE1_PREMIUM = new ArrayList<String>();
		lobTYPE1_PREMIUM.add("RENTA");
		lobTYPE1_PREMIUM.add("TOP MOVIES");
		lobTYPE1_PREMIUM.add("VENTANA ANTICIPADA");
		
		List<String> lobTYPE1_PREMIER = new ArrayList<String>();
		lobTYPE1_PREMIER.add("RENTA");
		lobTYPE1_PREMIER.add("TOP MOVIES");
		
		List<String> lobTYPE2 = new ArrayList<String>();
		lobTYPE2.add("ESTANDAR");
		lobTYPE2.add("RENTA");
		
		List<String> lobEST1 = new ArrayList<String>();
		lobEST1.add("COMPRA");
		lobEST1.add("TOP MOVIES");
		
		List<String> lobEST2 = new ArrayList<String>();
		lobEST2.add("COMPRA");
		lobEST2.add("ESTANDAR");
		
		List<String> lobEST8 = new ArrayList<String>();
		lobEST8.add("COMPRA");
		lobEST8.add("SERIE");
		
		List<String> lobVALORES_FORMATO = new ArrayList<String>();
		lobVALORES_FORMATO.add("3D");
		lobVALORES_FORMATO.add("HD");
		lobVALORES_FORMATO.add("SD");
		
		
		LOG.debug("leerArchivoExcelCargaTitulosPN["+this.getClass().getSimpleName()+"]pstURLArchivo: " + pstURLArchivo);
		Workbook workbook = null;
		
		String[] componentesNombreOriginal = pstNombreArchivo.split("\\.");
		LOG.debug("[leerArchivoExcelCargaTitulosPN]ComponentesNombreOriginal: " + componentesNombreOriginal.toString());
				
		String lstExtension = componentesNombreOriginal[1].toString();
		LOG.debug("[leerArchivoExcelCargaTitulosPN]Extension: " + lstExtension);
		
		try
		{
			FileInputStream file = new FileInputStream(new File(pstURLArchivo));
			
			if(lstExtension.equalsIgnoreCase("xls"))
				workbook = new HSSFWorkbook(file);
			else if(lstExtension.equalsIgnoreCase("xlsx"))
				workbook = new XSSFWorkbook(file);
			
			//Obtiene la primera hoja del Libro de trabajo
			Sheet sheet = workbook.getSheetAt(0);
			
			int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerArchivoExcelCargaTitulosPN["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    valMgr.setValoresAbono(lobVALORES_ABONO);
		    
		    //--Verifica que el encabezado coincida
		    Row filaCero = sheet.getRow(0);
			
		    if( filaCero.getCell(0).toString().toUpperCase().contains(PN_COL_UNO) &&
		    	filaCero.getCell(1).toString().toUpperCase().contains(PN_COL_DOS) &&
		    	filaCero.getCell(2).toString().toUpperCase().contains(PN_COL_TRES)&&
		    	filaCero.getCell(3).toString().toUpperCase().contains(PN_COL_CUATRO)&&
		    	filaCero.getCell(4).toString().toUpperCase().contains(PN_COL_CINCO)&&
		    	filaCero.getCell(5).toString().toUpperCase().contains(PN_COL_SEIS)&&
		    	filaCero.getCell(6).toString().toUpperCase().contains(PN_COL_SIETE)&&
		    	filaCero.getCell(7).toString().toUpperCase().contains(PN_COL_OCHO))
		    {
		    	
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
		    	for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
		    		CargaTitulosPNExcelDTO datosXL = new CargaTitulosPNExcelDTO();
		    		datosXL.setFila(Integer.toString(xFila));
			    	int lnuErrores = 0;
			    	
			    	Row row = sheet.getRow(xFila);
			    	
			    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
			    	//--      El orden se ajusto para efecto de las validaciones
			    	if(row != null)
			    	{
			    		//LOG.debug("Fila:["+xFila+"], ultima celda:[" + row.getLastCellNum()+"]");
			    		
			    		//-Filial
			    		Cell cellFilial = row.getCell(0);
			    		if(cellFilial != null && cellFilial.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			String lstFilial = df.formatCellValue(cellFilial);
			    			datosXL.setFilial(lstFilial);
			    			
				    	}
			    		else
			    		{
			    			datosXL.setFilial("");
			    			datosXL.setComentarios("Campo Filial nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Id Program
			    		Cell cellIdProgram = row.getCell(1);
			    		if(cellIdProgram != null && cellIdProgram.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			
			    			String lstIdProgram = df.formatCellValue(cellIdProgram);
			    			if(lnuErrores == 0)
			    			{
			    				boolean boSoloNumeros = valMgr.soloNumeros(lstIdProgram);
			    				if(!boSoloNumeros)
			    				{
			    					datosXL.setComentarios("Campo IdProgram no numerico");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
			    				}
			    				else if(lstIdProgram.length() > lnuLONG_IDPROGRAM)
			    				{
			    					datosXL.setComentarios("Campo IdProgram mayor de "+lnuLONG_IDPROGRAM+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;	
			    				}
			    				
			    			}//End if(lnuErrores == 0)
			    			
			    			datosXL.setIdProgram(lstIdProgram);
			    			
			    		}
			    		else
			    		{
			    			datosXL.setIdProgram("");
			    		}
			    		
			    		
			    		//--Titulo
			    		Cell cellTitulo = row.getCell(2);
			    		if(cellTitulo != null && cellTitulo.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			String lstTitulo = df.formatCellValue(cellTitulo);
			    			//cellTitulo.setCellType(Cell.CELL_TYPE_STRING);
			    			
			    			if(lnuErrores == 0)
			    			{
			    				if(lstTitulo.length() > lnuLONG_TITULO)
			    				{
			    					datosXL.setComentarios("Campo Titulo mayor de "+lnuLONG_TITULO+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
			    				}
			    			}//End if(lnuErrores == 0)
			    			datosXL.setTitulo(lstTitulo);
				    	}
			    		else
			    		{
			    			datosXL.setTitulo("");
			    			datosXL.setComentarios("Campo Titulo nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Medio pago
			    		Cell cellMedioPago = row.getCell(3);
			    		if(cellMedioPago != null && cellMedioPago.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			String lstMedioPago = df.formatCellValue(cellMedioPago);
			    			//cellMedioPago.setCellType(Cell.CELL_TYPE_STRING);
			    			
			    			if(lnuErrores == 0)
			    			{
			    				if(lstMedioPago.length() > lnuLONG_MEDIOPAGO)
			    				{
			    					datosXL.setComentarios("Campo Medio Pago mayor de "+lnuLONG_MEDIOPAGO+" caracteres");
			    					datosXL.setEstatus("0");
						    		lnuErrores++;
			    				}
			    			}//End if(lnuErrores == 0)
			    			
			    			datosXL.setMedioPago(lstMedioPago);
				    	}
			    		else
			    		{
			    			datosXL.setMedioPago("");
			    			datosXL.setComentarios("Campo Medio Pago nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Abono
			    		Cell cellAbono = row.getCell(4);
			    		if(cellAbono != null && cellAbono.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			String lstAbono = df.formatCellValue(cellAbono);
			    			//cellAbono.setCellType(Cell.CELL_TYPE_STRING);
			    			
			    			if(lnuErrores == 0)
			    			{
			    				String lstTmpValorAbono = lstAbono.toUpperCase();
			    				
			    				if(lstTmpValorAbono.length() > lnuLONG_ABONO)
			    				{
			    					datosXL.setComentarios("Campo Abono mayor de "+lnuLONG_ABONO+" caracteres");
					    			datosXL.setEstatus("0");
						    		lnuErrores++;
			    				}
			    				else
			    				{
				    				//--Determina Type y Grupo
				    				
				    				//String lstTmpValorAbono = "Transacciones Rentas Estndar".toUpperCase();
				    				List<String> valoresValidosAbono = valMgr.valoresAbonoValidos(lstTmpValorAbono);
				    				Collections.sort(valoresValidosAbono);
				    				
				    				boolean resultadoType2 = valoresValidosAbono.equals(lobTYPE2);
		    						if(resultadoType2)
		    						{
		    							datosXL.setTypeAbono("Type 2");
				    					datosXL.setGrupoType("Type 2");
		    						}//Ends if(resultadoType2)
		    						else
		    						{
		    							boolean resultadoType1Premier = valoresValidosAbono.equals(lobTYPE1_PREMIER);
				    					if(resultadoType1Premier)
				    					{
				    						datosXL.setTypeAbono("Type 1 Premier");
					    					datosXL.setGrupoType("Type 1");
				    					}//Ends if(resultadoType1Premier)
				    					else
				    					{
				    						boolean resultadoEst8 = valoresValidosAbono.equals(lobEST8);
	    									if(resultadoEst8)
	    									{
	    										datosXL.setTypeAbono("EST 8");
						    					datosXL.setGrupoType("EST");
	    									}//Ends if(resultadoEst8)
	    									else
	    									{
	    										boolean resultadoEst2 = valoresValidosAbono.equals(lobEST2);
			    								if(resultadoEst2)
			    								{
			    									datosXL.setTypeAbono("EST 2");
							    					datosXL.setGrupoType("EST");
			    								}//End if(resultadoEst2)
			    								else
			    								{
			    									boolean resultadoEst1 = valoresValidosAbono.equals(lobEST1);
					    							if(resultadoEst1)
					    							{
					    								datosXL.setTypeAbono("EST 1");
								    					datosXL.setGrupoType("EST");
					    							}//End if(resultadoEst1)
					    							else
					    							{
					    								boolean resultadoType1Premium = valoresValidosAbono.equals(lobTYPE1_PREMIUM);
					    			    				if(resultadoType1Premium)
					    			    				{
					    			    					datosXL.setTypeAbono("Type 1 Premium");
					    			    					datosXL.setGrupoType("Type 1 Premium");
					    			    				}//Ends if(resultadoType1Premium)
					    			    				else
					    			    				{
					    			    					datosXL.setTypeAbono("");
					    			    					datosXL.setGrupoType("");
					    			    					datosXL.setComentarios("Campo Abono no pudo ser clasificado");
					    					    			datosXL.setEstatus("0");
					    						    		lnuErrores++;
					    			    				}
					    							}//Ends else if(resultadoEst1)
			    								}//Ends else if(resultadoEst2)
	    									}//End else if(resultadoEst8)
				    					}//End else if(resultadoType1Premier)
		    						}//Ends else if(resultadoType2)
			    				}
			    				
			    			}//End if(lnuErrores == 0)
			    			else
			    			{
			    				datosXL.setTypeAbono("");
		    					datosXL.setGrupoType("");
			    			}
			    			
			    			datosXL.setAbono(lstAbono);
				    	}
			    		else
			    		{
			    			datosXL.setAbono("");
			    			datosXL.setComentarios("Campo Abono nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Precio
			    		Cell cellPrecio = row.getCell(5);
			    		if(cellPrecio != null && cellPrecio.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			if (cellPrecio.getCellType() == Cell.CELL_TYPE_NUMERIC)
                                                {
                                                    cellPrecio.setCellType(Cell.CELL_TYPE_NUMERIC);
                                                    String lstPrecio = Double.toString(cellPrecio.getNumericCellValue());

                                                    if(lnuErrores == 0)
                                                    {
                                                            boolean boNumPositivosMax4Dec = valMgr.numPositivosMax4Dec(lstPrecio);
                                                            if(!boNumPositivosMax4Dec)
                                                            {
                                                                    datosXL.setComentarios("Campo Precio negativo o mas 4 decimales");
                                                                    datosXL.setEstatus("0");
                                                                    lnuErrores++;
                                                            }
                                                    }

                                                    datosXL.setPrecio(lstPrecio);
                                                }
                                                else
                                                {
                                                    try {
                                                            
                                                            Double lstPrecio = Double.parseDouble(df.formatCellValue(cellPrecio));
                                                            datosXL.setPrecio(lstPrecio.toString());
                                                        } catch(Exception e){
                                                            datosXL.setComentarios("Campo Precio sin formato correcto");
                                                            datosXL.setEstatus("0");
                                                            lnuErrores++;
                                                        }
                                                }
				    	}
			    		else
			    		{
			    			datosXL.setPrecio("");
			    			datosXL.setComentarios("Campo Precio nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Cantidad
			    		Cell cellCantidad = row.getCell(6);
			    		if(cellCantidad != null && cellCantidad.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			String lstCantidad = df.formatCellValue(cellCantidad);
			    			//cellCantidad.setCellType(Cell.CELL_TYPE_STRING);
			    			
			    			if(lnuErrores == 0)
			    			{
			    				boolean boSoloNumeros = valMgr.soloNumeros(lstCantidad);
			    				if(!boSoloNumeros)
			    				{
			    					datosXL.setComentarios("Campo Cantidad negativo o con decimales");
					    			datosXL.setEstatus("0");
						    		lnuErrores++;
			    				}
			    			}
			    			datosXL.setCantidad(lstCantidad);
				    	}
			    		else
			    		{
			    			datosXL.setCantidad("");
			    			datosXL.setComentarios("Campo Cantidad nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Formato
			    		Cell cellFormato = row.getCell(7);
			    		if(cellFormato != null && cellFormato.getCellType() != Cell.CELL_TYPE_BLANK)
			    		{
			    			String lstFormato = df.formatCellValue(cellFormato);
			    			//cellFormato.setCellType(Cell.CELL_TYPE_STRING);
			    			
			    			if(lnuErrores == 0)
			    			{
			    				boolean lboContieneValoresCorrectos = lobVALORES_FORMATO.contains(lstFormato.toUpperCase());
			    				if(!lboContieneValoresCorrectos)
			    				{
			    					datosXL.setComentarios("Campo Formato con datos invalidos");
			    					datosXL.setEstatus("0");
			    					lnuErrores++;
			    				}
			    			}
			    			
			    			datosXL.setFormato(lstFormato);
			    		}
			    		else
			    		{
			    			datosXL.setFormato("");
			    			datosXL.setComentarios("Campo Formato nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		if(lnuErrores == 0)
			    		{
			    			datosXL.setComentarios("");
			    			datosXL.setEstatus("");
			    		}
			    		
			    		LOG.debug("leerCargaTitulosTRXLS["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": Filial:["+datosXL.getFilial()+"],IdProgram:["+datosXL.getIdProgram()+"],Titulo:["+datosXL.getTitulo()+"],MedioPago:["+datosXL.getMedioPago()+"],Abono:["+datosXL.getAbono()+"],Precio:["+datosXL.getPrecio()+"],Cantidad:["+datosXL.getCantidad()+"],Formato:["+datosXL.getFormato()+"],Type:["+datosXL.getTypeAbono()+"],Grupo:["+datosXL.getGrupoType()+"],Estatus:["+datosXL.getEstatus()+"],Comentarios:["+datosXL.getComentarios()+"]");
				    	this.lobDatosXL_PN.add(datosXL);
			    		
			    	}//Ends if(row != null)
			    	
			    }//Ends for(int xFila=1; xFila < lnuUltimaFila; xFila++)
		    	
		    }// End verifica encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerArchivoExcelCargaTitulosPN[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
			
			file.close();
		    
		}
		catch (FileNotFoundException e) 
		{
		    LOG.error("leerArchivoExcelCargaTitulosTR[FileNotFoundException] No se encontro el archivo en la ruta especificada.");
		    this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
			//e.printStackTrace();
		    
		} 
		catch (IOException e) 
		{
			LOG.error("leerArchivoExcelCargaTitulosTR[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerArchivoExcelCargaTitulosTR[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
		
	}
	
	
	public void leerArchivoExcelCargaVS(String pstURLArchivo, String pstNombreArchivo)
	{
		int lnuLONG_IDBROADVIEW = 12;
		int lnuLONG_TITULO = 150;
		
		LOG.debug("leerArchivoExcelCargaVS["+this.getClass().getSimpleName()+"]pstURLArchivo: " + pstURLArchivo);
		Workbook workbook = null;
		
		String[] componentesNombreOriginal = pstNombreArchivo.split("\\.");
		LOG.debug("[leerArchivoExcelCargaVS]ComponentesNombreOriginal: " + componentesNombreOriginal.toString());
				
		String lstExtension = componentesNombreOriginal[1].toString();
		LOG.debug("[leerArchivoExcelCargaVS]Extension: " + lstExtension);
		
		try
		{
			FileInputStream file = new FileInputStream(new File(pstURLArchivo));
			
			if(lstExtension.equalsIgnoreCase("xls"))
				workbook = new HSSFWorkbook(file);
			else if(lstExtension.equalsIgnoreCase("xlsx"))
				workbook = new XSSFWorkbook(file);
			
			//Obtiene la primera hoja del Libro de trabajo
			Sheet sheet = workbook.getSheetAt(0);
			
			int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
		    LOG.debug("leerArchivoExcelCargaTitulosPN["+this.getClass().getSimpleName()+"]lnuUltimaFila: " + lnuUltimaFila);
		    
		    //--Verifica que el encabezado coincida
		    Row filaCero = sheet.getRow(0);
		    
		    if( filaCero.getCell(0).toString().toUpperCase().contains(VS_COL_UNO) &&
			    	filaCero.getCell(1).toString().toUpperCase().contains(VS_COL_DOS) &&
			    	filaCero.getCell(2).toString().toUpperCase().contains(VS_COL_TRES)&&
			    	filaCero.getCell(3).toString().toUpperCase().contains(VS_COL_CUATRO))
			{
		    	//--No consideramos la primera linea, porque se supondria que es el encabezado.
		    	for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			    {
		    		CargaTitulosVSExcelDTO datosXL = new CargaTitulosVSExcelDTO();
		    		datosXL.setFila(Integer.toString(xFila));
			    	int lnuErrores = 0;
			    	
			    	Row row = sheet.getRow(xFila);
			    	
			    	//--NOTA: Para que esto funcione, la estructura del archivo debe ser siempre la misma e invariable.
			    	//--      El orden se ajusto para efecto de las validaciones
			    	if(row != null)
			    	{
			    		//--Id Broadview
			    		Cell cellIdBroadview = row.getCell(0);
			    		if(cellIdBroadview != null && cellIdBroadview.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			String lstIdBroadview = df.formatCellValue(cellIdBroadview);
			    			if(lnuErrores == 0)
			    			{
			    				boolean boSoloNumeros = valMgr.soloNumeros(lstIdBroadview);
			    				if(!boSoloNumeros)
			    				{
			    					datosXL.setComentarios("Campo IdBroadview no numerico");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
			    				}
			    				else if(lstIdBroadview.length() > lnuLONG_IDBROADVIEW)
			    				{
			    					datosXL.setComentarios("Campo IdBroadview mayor de "+lnuLONG_IDBROADVIEW+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;	
			    				}
			    			}//Ends if(lnuErrores == 0)
			    			datosXL.setIdBroadview(lstIdBroadview);
			    			
				    	}
			    		else
			    		{
			    			datosXL.setIdBroadview("");
			    			datosXL.setComentarios("Campo IdBroadview nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Titulo
			    		Cell cellTitulo = row.getCell(1);
			    		if(cellTitulo != null && cellTitulo.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			String lstTitulo = df.formatCellValue(cellTitulo);
			    			//cellTitulo.setCellType(Cell.CELL_TYPE_STRING);
			    			
			    			if(lnuErrores == 0)
			    			{
			    				if(lstTitulo.length() > lnuLONG_TITULO)
			    				{
			    					datosXL.setComentarios("Campo Titulo mayor de "+lnuLONG_TITULO+" caracteres");
						    		datosXL.setEstatus("0");
						    		lnuErrores++;
			    				}
			    			}//End if(lnuErrores == 0)
			    			datosXL.setTitulo(lstTitulo);
				    	}
			    		else
			    		{
			    			datosXL.setTitulo("");
			    			datosXL.setComentarios("Campo Titulo nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
			    		
			    		//--Visualizaciones
			    		Cell cellVisualizaciones = row.getCell(2);
			    		if(cellVisualizaciones != null && cellVisualizaciones.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
			    			if (cellVisualizaciones.getCellType() == Cell.CELL_TYPE_NUMERIC)
                                                {
                                                    cellVisualizaciones.setCellType(Cell.CELL_TYPE_NUMERIC);

                                                    long lngVisualizaciones = new Double(cellVisualizaciones.getNumericCellValue()).longValue();
                                                    String lstVisualizaciones = Long.toString(lngVisualizaciones);

                                                    if(lnuErrores == 0)
                                                    {
                                                            boolean boSoloNumeros = valMgr.soloNumeros(lstVisualizaciones);
                                                            if(!boSoloNumeros)
                                                            {
                                                                    datosXL.setComentarios("Campo Visualizaciones negativo o con decimales");
                                                                    datosXL.setEstatus("0");
                                                                    lnuErrores++;
                                                            }
                                                            else if(lngVisualizaciones == 0)
                                                            {
                                                                    datosXL.setComentarios("Campo Visualizaciones igual a 0.");
                                                                    datosXL.setEstatus("0");
                                                                    lnuErrores++;
                                                            }

                                                    }//End if(lnuErrores == 0)
                                                    datosXL.setVisualizaciones(lstVisualizaciones);
                                                }
                                                else
                                                {
                                                    try {
                                                            
                                                            Long lstVisualizaciones = Long.parseLong(df.formatCellValue(cellVisualizaciones));
                                                            datosXL.setVisualizaciones(lstVisualizaciones.toString());
                                                        } catch(Exception e){
                                                            datosXL.setComentarios("Campo Visualizacin sin formato correcto");
                                                            datosXL.setEstatus("0");
                                                            lnuErrores++;
                                                        }
                                                }
				    	}
			    		else
			    		{
			    			datosXL.setVisualizaciones("");
			    			datosXL.setComentarios("Campo Visualizaciones nulo");
			    			datosXL.setEstatus("0");
				    		lnuErrores++;
			    		}
				    	
			    		
			    		//--Mes
			    		Cell cellMes = row.getCell(3);
				    	if(cellMes != null && cellMes.getCellType() != Cell.CELL_TYPE_BLANK)
				    	{
				    		if(cellMes.getCellType() == Cell.CELL_TYPE_NUMERIC)
				    		{
				    			cellMes.setCellType(Cell.CELL_TYPE_NUMERIC);
					    		datosXL.setMes( dateMgr.dateToString(cellMes.getDateCellValue(), "dd/MM/yyyy") );
				    		}
				    		else
				    		{
                                                        try {
                                                            String lstMes = df.formatCellValue(cellMes);
                                                            SimpleDateFormat  formatter = new SimpleDateFormat("dd/MM/yyyy");
                                                            Date d = formatter.parse(lstMes);
                                                            datosXL.setMes(lstMes);
                                                        } catch(Exception e){
                                                            datosXL.setComentarios("Campo Mes con datos invalidos");
                                                            datosXL.setEstatus("0");
                                                            lnuErrores++;
                                                        }
				    			
				    		}
				    		
				    	}
				    	else
				    	{
				    		datosXL.setMes("");
				    		datosXL.setComentarios("Campo Mes nulo");
				    		datosXL.setEstatus("0");
				    		lnuErrores++;
				    	}
			    		
				    	if(lnuErrores == 0)
			    		{
			    			datosXL.setComentarios("");
			    			datosXL.setEstatus("");
			    		}
				    	
				    	LOG.debug("leerArchivoExcelCargaVS["+this.getClass().getSimpleName()+"] Registro: "+datosXL.getFila()+": IdBroadview:["+datosXL.getIdBroadview()+"],Titulo:["+datosXL.getTitulo()+"],Visualizaciones:["+datosXL.getVisualizaciones()+"],Mes:["+datosXL.getMes()+"],Estatus:["+datosXL.getEstatus()+"],Comentarios:["+datosXL.getComentarios()+"]");
				    	this.lobDatosXL_VS.add(datosXL);
			    		
			    	}//Ends if(row != null)
			    }//Ends for(int xFila=1; xFila < lnuUltimaFila; xFila++)
			}// End verifica encabezado
		    else
		    {
		    	this.lstMensaje = "El encabezado del archivo no coincide con el especificado.";
		    	LOG.error("leerArchivoExcelCargaVS[HeaderException] El encabezado del archivo no coincide con el especificado.");
		    }
			
			file.close();
		    
		}
		catch (FileNotFoundException e) 
		{
		    LOG.error("leerArchivoExcelCargaVS[FileNotFoundException] No se encontro el archivo en la ruta especificada.");
		    this.lstMensaje = "No se encontro el archivo en la ruta especificada.";
			//e.printStackTrace();
		    
		} 
		catch (IOException e) 
		{
			LOG.error("leerArchivoExcelCargaVS[IOException] Ocurrio un error en la lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error en la lectura del archivo.";
		    //e.printStackTrace();
		}
		catch (Exception e)
		{
			LOG.error("leerArchivoExcelCargaVS[Exception] Ocurrio un error durante el proceso de lectura del archivo. Mensaje: " + e.getMessage());
			this.lstMensaje = "Ocurrio un error durante el proceso de la lectura del archivo.";
		}
	}
			
}
