package mx.com.amx.mx.dda.ws.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;


import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import mx.com.amx.mx.dda.ws.dto.AmortizacionDTO;
import mx.com.amx.mx.dda.ws.dto.CargaIdBVDetalleDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosPNExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosTRExcelDTO;
import mx.com.amx.mx.dda.ws.dto.CargaTitulosVSExcelDTO;
import mx.com.amx.mx.dda.ws.dto.ItDetalleAmortizaDTO;
import mx.com.amx.mx.dda.ws.dto.ItTituloDTO;
import mx.com.amx.mx.dda.ws.dto.ParamArchivoSqlLdrDTO;


public class FileManager 
{
	Properties env 	= 	new Properties();
	private final String ARCHIVO_PROPIEDADES 	= "/general.properties";
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	
	private String SEPARADOR_COLUMNAS;
	
	public FileManager()
	{
		super();

		try
		{
			env.load( this.getClass().getResourceAsStream( ARCHIVO_PROPIEDADES ) );
			SEPARADOR_COLUMNAS = env.getProperty("separador.columnas");
		}
		catch(Exception e)
		{
			LOG.error(">Constructor["+this.getClass().getSimpleName()+"] Ocurrio un error : " + e.getMessage() );	
		}
	}
	

	public boolean existeArchivo(File archivo) throws Exception
	{
		LOG.debug("    Inicia_existeArchivo");
		boolean retorno = false;
		
		try
		{

		    if (archivo.exists())
		    	retorno = true;
		}
		catch(Exception e)
		{
			LOG.error("Error_existeArchivoBO");
			throw new Exception(e);
		}
		
		return retorno;
	}
	
	public boolean escribeArchivoDataTitulos(ParamArchivoSqlLdrDTO dto) 
	{
		LOG.debug("    Inicia_escribeArchivoDataTitulos");
		boolean lboResultado = true;
		List<CargaTitulosExcelDTO> lobDatosXL = dto.getLobDatosXL();
		String lstRutaArchivoData = (dto.getRutaArchivo() != null && dto.getRutaArchivo().trim().length() > 0) ? dto.getRutaArchivo() : "";
		String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
		String lstRutaFinal = lstRutaArchivoData + lstNombreArchivo;
		
		try
		{
			FileWriter fw = new FileWriter(lstRutaFinal);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter pw = new PrintWriter(bw);
			
			int lnuTotalRegistros = lobDatosXL.size();
			for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			{
				CargaTitulosExcelDTO filaExcel = (CargaTitulosExcelDTO) lobDatosXL.get(xRegistro);
				
				StringBuffer sb = new StringBuffer();
				sb.append(filaExcel.getNombreUnico());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombreEstandar());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getTemporada());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getEpisodio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getFechaInicio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getFechaFin());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getCategoriaEstudio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getCategoria());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getPrecio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getAnual());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getBriefcase());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getIdBroadView());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getMesesExclusivo());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getPorcentajeExclusivo());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getAnnioContrato());
				
				String lstLinea = sb.toString();
				pw.println(lstLinea);
				LOG.debug("Linea "+xRegistro+":["+lstLinea+"]");
				
			}//Ends for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			
			pw.close();
			return lboResultado;
		}
		catch(IOException ioe)
		{
			lboResultado = false;
			LOG.error("Exception["+this.getClass().getSimpleName()+"::escribeArchivoDataTitulos]: "+ioe.getMessage() );
			StringWriter stack = new StringWriter();
			ioe.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			return lboResultado;
		}
	}
	
	public boolean escribeArchivoDataAmortizacion(ParamArchivoSqlLdrDTO dto)
	{
		LOG.debug("    Inicia_escribeArchivoDataAmortizacion");
		boolean lboResultado = true;
		
		List<ItTituloDTO> lobItTitulos = dto.getLobDatosTituloAmort();
		String lstIdContrato = (dto.getIdContrato() != null && dto.getIdContrato().trim().length() > 0) ? dto.getIdContrato() : "";
		String lstRutaArchivoData = (dto.getRutaArchivo() != null && dto.getRutaArchivo().trim().length() > 0) ? dto.getRutaArchivo() : "";
		String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
		String lstRutaFinal = lstRutaArchivoData + lstNombreArchivo;
		
		try
		{
			FileWriter fw = new FileWriter(lstRutaFinal);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter pw = new PrintWriter(bw);
			int lnuRegArchivo = 0;
			
			int lnuTotalRegistros = lobItTitulos.size();
			for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			{
				ItTituloDTO itTitulo = (ItTituloDTO)lobItTitulos.get(xRegistro);
				
				String lstIdTituloOriginal  = (itTitulo.getID_TITULO_CNTORIG() != null && itTitulo.getID_TITULO_CNTORIG().trim().length() > 0) ? itTitulo.getID_TITULO_CNTORIG() : ""; 
				List<ItDetalleAmortizaDTO> lobItDetalles = itTitulo.getLobDetalle();
				int lnuTotalDetalles = lobItDetalles.size();
				LOG.info("            TITULO: <Registro:["+xRegistro+"],IdTituloOriginal:["+lstIdTituloOriginal+"],RegistrosDetalle:["+lnuTotalDetalles+"]>");
				
				if(lnuTotalDetalles > 0)
				{
					//-- Recorrer el detalle
					for(int xDetalle = 0; xDetalle < lnuTotalDetalles; xDetalle++)
					{
						ItDetalleAmortizaDTO lobItDetalleAmortizacion = (ItDetalleAmortizaDTO)lobItDetalles.get(xDetalle);
						
						String lstMes = (lobItDetalleAmortizacion.getFechaMes() != null && lobItDetalleAmortizacion.getFechaMes().trim().length() > 0) ? lobItDetalleAmortizacion.getFechaMes() : "";
						String lstMonto = (lobItDetalleAmortizacion.getMonto() != null && lobItDetalleAmortizacion.getMonto().trim().length() > 0) ? lobItDetalleAmortizacion.getMonto() : "";
						
						StringBuffer sb = new StringBuffer();
						sb.append(lstIdTituloOriginal);
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(lstMes);
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(lstMonto);
						sb.append(SEPARADOR_COLUMNAS);
						sb.append(lstIdContrato);
						sb.append(SEPARADOR_COLUMNAS);
						
						String lstLinea = sb.toString();
						pw.println(lstLinea);
						lnuRegArchivo++;
						LOG.debug("Linea "+lnuRegArchivo+":["+lstLinea+"]");
						
					}//Ends for(int xDetalle = 0; xDetalle < lnuTotalDetalles; xDetalle++)
					
				}//Ends if(lnuTotalDetalles > 0)
				
			}//Ends for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			
			pw.close();
			return lboResultado;
		}
		catch(IOException ioe)
		{
			lboResultado = false;
			LOG.error("Exception["+this.getClass().getSimpleName()+"::escribeArchivoDataAmortizacion]: "+ioe.getMessage() );
			StringWriter stack = new StringWriter();
			ioe.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			return lboResultado;
		}	
	}
	
	public boolean escribeArchivoDataActIdBroadView(ParamArchivoSqlLdrDTO dto)
	{
		LOG.debug("    Inicia_escribeArchivoDataActIdBroadView");
		boolean lboResultado = true;
		
		List<CargaIdBVDetalleDTO> lobDatosXL = dto.getLobDatos_AIBV();
		String lstRutaArchivoData = (dto.getRutaArchivo() != null && dto.getRutaArchivo().trim().length() > 0) ? dto.getRutaArchivo() : "";
		String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
		String lstRutaFinal = lstRutaArchivoData + lstNombreArchivo;
		
		try
		{
			/*
			FileWriter fw = new FileWriter(lstRutaFinal);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter pw = new PrintWriter(bw);
			*/
			
			File file = new File(lstRutaFinal);
			PrintWriter pw = new PrintWriter(file,"UTF-8");
			
			int lnuTotalRegistros = lobDatosXL.size();
			for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			{
				CargaIdBVDetalleDTO filaExcel = (CargaIdBVDetalleDTO) lobDatosXL.get(xRegistro);
				
				StringBuffer sb = new StringBuffer();
				sb.append(filaExcel.getIdDDA());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getIdBroadView());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombreEstandar());
				sb.append(SEPARADOR_COLUMNAS);
				
				
				String lstLinea = sb.toString();
				pw.println(lstLinea);
				LOG.debug("Linea "+xRegistro+":["+lstLinea+"]");
				
			}//Ends for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			
			pw.close();
			return lboResultado;
		}
		catch(IOException ioe)
		{
			lboResultado = false;
			LOG.error("Exception["+this.getClass().getSimpleName()+"::escribeArchivoDataActIdBroadView]: "+ioe.getMessage() );
			StringWriter stack = new StringWriter();
			ioe.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			return lboResultado;
		}
 
	}
	
	public boolean escribeArchivoDataTitulosLF(ParamArchivoSqlLdrDTO dto) 
	{
		LOG.debug("    Inicia_escribeArchivoDataTitulosLF");
		boolean lboResultado = true;
		List<CargaTitulosExcelDTO> lobDatosXL = dto.getLobDatosXL_LF();
		String lstRutaArchivoData = (dto.getRutaArchivo() != null && dto.getRutaArchivo().trim().length() > 0) ? dto.getRutaArchivo() : "";
		String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
		String lstRutaFinal = lstRutaArchivoData + lstNombreArchivo;
		
		try
		{
			FileWriter fw = new FileWriter(lstRutaFinal);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter pw = new PrintWriter(bw);
			
			int lnuTotalRegistros = lobDatosXL.size();
			for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			{
				CargaTitulosExcelDTO filaExcel = (CargaTitulosExcelDTO) lobDatosXL.get(xRegistro);
				
				StringBuffer sb = new StringBuffer();
				sb.append(filaExcel.getNombreUnico());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombreEstandar());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getTemporada());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getEpisodio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getFechaInicio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getFechaFin());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getCategoria());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getBriefcase());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getIdBroadView());
				
				String lstLinea = sb.toString();
				pw.println(lstLinea);
				LOG.debug("Linea "+xRegistro+":["+lstLinea+"]");
				
			}//Ends for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			
			pw.close();
			return lboResultado;
		}
		catch(IOException ioe)
		{
			lboResultado = false;
			LOG.error("Exception["+this.getClass().getSimpleName()+"::escribeArchivoDataTitulosLF]: "+ioe.getMessage() );
			StringWriter stack = new StringWriter();
			ioe.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			return lboResultado;
		}
	}
	
	public boolean escribeArchivoDataTitulosTR(ParamArchivoSqlLdrDTO dto) 
	{
		LOG.debug("    escribeArchivoDataTitulosTR");
		boolean lboResultado = true;
		List<CargaTitulosTRExcelDTO> lobDatosXL = dto.getLobDatosXL_TR();
		String lstRutaArchivoData = (dto.getRutaArchivo() != null && dto.getRutaArchivo().trim().length() > 0) ? dto.getRutaArchivo() : "";
		String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
		String lstRutaFinal = lstRutaArchivoData + lstNombreArchivo;
		
		try
		{
			FileWriter fw = new FileWriter(lstRutaFinal);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter pw = new PrintWriter(bw);
			
			int lnuTotalRegistros = lobDatosXL.size();
			for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			{
				CargaTitulosTRExcelDTO filaExcel = (CargaTitulosTRExcelDTO) lobDatosXL.get(xRegistro);
				
				StringBuffer sb = new StringBuffer();
				
				sb.append(filaExcel.getFilial());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getIdBroadView());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombreUnico());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombreEstandar());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getCategoria());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getTemporada());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getEpisodio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getHvrd());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getFechaInicio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getFechaFin());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getBoxOffice());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getCategoriaDtr());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getCategoriaDto());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getBriefcase());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getDtr());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getDto());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getSd());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getHd());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getTresD());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getDuracion());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getAnnio());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getGeneroA());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getGeneroB());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombreEspanol());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombreIngles());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getNombrePortugues());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getEstatus());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getComentarios());
				
				
				String lstLinea = sb.toString();
				pw.println(lstLinea);
				LOG.debug("Linea "+xRegistro+":["+lstLinea+"]");
				
			}//Ends for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			
			pw.close();
			return lboResultado;
		}
		catch(IOException ioe)
		{
			lboResultado = false;
			LOG.error("Exception["+this.getClass().getSimpleName()+"::escribeArchivoDataTitulosTR]: "+ioe.getMessage() );
			StringWriter stack = new StringWriter();
			ioe.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			return lboResultado;
		}
	}
	
	public boolean escribeArchivoDataTitulosPN(ParamArchivoSqlLdrDTO dto) 
	{
		List<CargaTitulosPNExcelDTO> lobDatosXL = dto.getLobDatosXL_PN();
		String lstRutaArchivoData = (dto.getRutaArchivo() != null && dto.getRutaArchivo().trim().length() > 0) ? dto.getRutaArchivo() : "";
		String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
		String lstRutaFinal = lstRutaArchivoData + lstNombreArchivo;
		
		try
		{
			FileWriter fw = new FileWriter(lstRutaFinal);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter pw = new PrintWriter(bw);
			
			int lnuTotalRegistros = lobDatosXL.size();
			for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			{
				CargaTitulosPNExcelDTO filaExcel = (CargaTitulosPNExcelDTO) lobDatosXL.get(xRegistro);
				
				StringBuffer sb = new StringBuffer();
				if(filaExcel.getFilial().length() > 0) {
					sb.append(filaExcel.getFilial());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getIdProgram());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getTitulo());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getMedioPago());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getAbono());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getPrecio());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getCantidad());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getFormato());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getTypeAbono());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getGrupoType());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getEstatus());
					sb.append(SEPARADOR_COLUMNAS);
					sb.append(filaExcel.getComentarios());
					
					String lstLinea = sb.toString();
					pw.println(lstLinea);
				}else {
					break;
				}
				
			}//Ends for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			
			pw.close();
			return true;
		}
		catch(IOException ioe){
			LOG.error("Exception["+this.getClass().getSimpleName()+"::escribeArchivoDataTitulosPN]: "+ioe.getMessage() );
			StringWriter stack = new StringWriter();
			ioe.printStackTrace(new PrintWriter(stack));
			return false;
		}
	}
	
	public boolean escribeArchivoDataTitulosVS(ParamArchivoSqlLdrDTO dto) 
	{
		LOG.debug("    Inicia_escribeArchivoDataTitulosVS");
		boolean lboResultado = true;
		List<CargaTitulosVSExcelDTO> lobDatosXL = dto.getLobDatosXL_VS();
		String lstRutaArchivoData = (dto.getRutaArchivo() != null && dto.getRutaArchivo().trim().length() > 0) ? dto.getRutaArchivo() : "";
		String lstNombreArchivo = (dto.getNombreArchivo() != null && dto.getNombreArchivo().trim().length() > 0) ? dto.getNombreArchivo() : "";
		String lstRutaFinal = lstRutaArchivoData + lstNombreArchivo;
		
		try
		{
			FileWriter fw = new FileWriter(lstRutaFinal);
			BufferedWriter bw = new BufferedWriter(fw);
			PrintWriter pw = new PrintWriter(bw);
			
			int lnuTotalRegistros = lobDatosXL.size();
			
			for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			{
				CargaTitulosVSExcelDTO filaExcel = (CargaTitulosVSExcelDTO) lobDatosXL.get(xRegistro);
				
				StringBuffer sb = new StringBuffer();
				sb.append(filaExcel.getIdBroadview());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getTitulo());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getVisualizaciones());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getMes());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getEstatus());
				sb.append(SEPARADOR_COLUMNAS);
				sb.append(filaExcel.getComentarios());
				
				String lstLinea = sb.toString();
				pw.println(lstLinea);
				LOG.debug("Linea "+xRegistro+":["+lstLinea+"]");
				
			}//Ends for(int xRegistro=0; xRegistro < lnuTotalRegistros; xRegistro++)
			
			pw.close();
			return lboResultado;
			
		}
		catch(IOException ioe)
		{
			lboResultado = false;
			LOG.error("Exception["+this.getClass().getSimpleName()+"::escribeArchivoDataTitulosVS]: "+ioe.getMessage() );
			StringWriter stack = new StringWriter();
			ioe.printStackTrace(new PrintWriter(stack));
			LOG.debug("Stack : " + stack.toString());
			return lboResultado;
		}
	}
}
