package mx.com.amx.mx.dda.ws.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;


public class ValidationManager 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	private static final Pattern emailPattern = Pattern.compile("^[\\w-]+(\\.[\\w-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
	private static final Pattern noNumerosPattern = Pattern.compile("\\D+");
	private static final Pattern numPositivosMax2Dec = Pattern.compile("^[\\d]+([.][\\d]{1,2})?$");
	private static final Pattern numPositivosMax4Dec = Pattern.compile("^[\\d]+([.][\\d]{1,4})?$");
	//private static final Pattern valoresAbono = Pattern.compile("\\b(renta|rentas|compra|compras|top movies|ventana anticipada|estndar|estandar|serie)\\b",Pattern.CASE_INSENSITIVE|Pattern.UNICODE_CASE);
	private Pattern valoresAbono;
	
	public ValidationManager()
	{
		super();
	}
	
	public void setValoresAbono(List<String> valoresValidos)
	{
		String lstCadPattern = "";
		int lnuTotalValoresValidos = valoresValidos.size();
		StringBuffer sb = new StringBuffer();
		sb.append("\\b(");
		for(int xVal = 0; xVal < lnuTotalValoresValidos; xVal++)
		{
			String lstValor = valoresValidos.get(xVal);
			sb.append(lstValor);
			if(xVal < (lnuTotalValoresValidos - 1) )
				sb.append("|");
		}
		
		sb.append(")\\b");
		lstCadPattern = sb.toString();
		
		valoresAbono = Pattern.compile(lstCadPattern,Pattern.CASE_INSENSITIVE|Pattern.UNICODE_CASE);
	}
	
	public boolean soloNumeros(String pstCadena)
	{
		//--El patron busca todo aquello que no es numero, en caso de coincidencia, entonces el valor no es SOLO NUMEROS
		return !noNumerosPattern.matcher(pstCadena).find();
	}

	public boolean numPositivosMax2Dec(String pstCadena)
	{
		//--Busca que sean solo numeros positivos con un maximo de 2 decimales
		return numPositivosMax2Dec.matcher(pstCadena).matches();
	}
	
	public boolean numPositivosMax4Dec(String pstCadena)
	{
		//--Busca que sean solo numeros positivos con un maximo de 4 decimales
		return numPositivosMax4Dec.matcher(pstCadena).matches();
	}
	
	public List<String> valoresAbonoValidos(String pstCadena)
	{
		List<String> resultado = new ArrayList<String>();
		
		//Pattern p = Pattern.compile("\\b(renta|rentas|compra|compras|top movies|ventana anticipada|estndar|estandar|serie)\\b",Pattern.CASE_INSENSITIVE);
		Matcher m = valoresAbono.matcher(pstCadena);
		String lstCoincidencia;
		
		while(m.find()) 
	    {
			lstCoincidencia = m.group();
			lstCoincidencia = lstCoincidencia.replaceAll("(A)S$", "A");
			lstCoincidencia = lstCoincidencia.replaceAll("", "A");
			resultado.add(lstCoincidencia);
	    }

	    return resultado;
		
	}
}
