/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.util.Assert;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;

public class MarshallingMessageConverter
implements MessageConverter,
InitializingBean {
    public static final int MARSHAL_TO_BYTES_MESSAGE = 1;
    public static final int MARSHAL_TO_TEXT_MESSAGE = 2;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private int marshalTo = 1;

    public MarshallingMessageConverter() {
    }

    public MarshallingMessageConverter(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        if (!(marshaller instanceof Unmarshaller)) {
            throw new IllegalArgumentException("Marshaller [" + marshaller + "] does not implement the Unmarshaller " + "interface. Please set an Unmarshaller explicitely by using the " + "AbstractMarshallingPayloadEndpoint(Marshaller, Unmarshaller) constructor.");
        }
        this.marshaller = marshaller;
        this.unmarshaller = (Unmarshaller)((Object)marshaller);
    }

    public MarshallingMessageConverter(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public void setMarshalTo(int marshalTo) {
        this.marshalTo = marshalTo;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.marshaller, (String)"Property 'marshaller' is required");
        Assert.notNull((Object)this.unmarshaller, (String)"Property 'unmarshaller' is required");
    }

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        try {
            switch (this.marshalTo) {
                case 2: {
                    return this.marshalToTextMessage(object, session, this.marshaller);
                }
                case 1: {
                    return this.marshalToBytesMessage(object, session, this.marshaller);
                }
            }
            return this.marshalToMessage(object, session, this.marshaller);
        }
        catch (MarshallingFailureException ex) {
            throw new MessageConversionException("Could not marshal [" + object + "]", (Throwable)((Object)ex));
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not marshal  [" + object + "]", (Throwable)ex);
        }
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        try {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return this.unmarshalFromTextMessage(textMessage, this.unmarshaller);
            }
            if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                return this.unmarshalFromBytesMessage(bytesMessage, this.unmarshaller);
            }
            return this.unmarshalFromMessage(message, this.unmarshaller);
        }
        catch (UnmarshallingFailureException ex) {
            throw new MessageConversionException("Could not unmarshal message [" + message + "]", (Throwable)((Object)ex));
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not unmarshal message [" + message + "]", (Throwable)ex);
        }
    }

    protected TextMessage marshalToTextMessage(Object object, Session session, Marshaller marshaller) throws JMSException, IOException {
        StringResult result = new StringResult();
        marshaller.marshal(object, result);
        return session.createTextMessage(result.toString());
    }

    protected BytesMessage marshalToBytesMessage(Object object, Session session, Marshaller marshaller) throws JMSException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(bos);
        marshaller.marshal(object, streamResult);
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(bos.toByteArray());
        return message;
    }

    protected Message marshalToMessage(Object object, Session session, Marshaller marshaller) throws JMSException, IOException {
        throw new MessageConversionException("Unknown 'marshalTo' value [" + this.marshalTo + "]. Cannot convert object to Message");
    }

    protected Object unmarshalFromTextMessage(TextMessage message, Unmarshaller unmarshaller) throws JMSException, IOException {
        StringSource source = new StringSource(message.getText());
        return unmarshaller.unmarshal(source);
    }

    protected Object unmarshalFromBytesMessage(BytesMessage message, Unmarshaller unmarshaller) throws JMSException, IOException {
        byte[] bytes = new byte[(int)message.getBodyLength()];
        message.readBytes(bytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        StreamSource source = new StreamSource(bis);
        return unmarshaller.unmarshal(source);
    }

    protected Object unmarshalFromMessage(Message message, Unmarshaller unmarshaller) throws JMSException, IOException {
        throw new MessageConversionException("MarshallingMessageConverter only supports TextMessages and BytesMessages");
    }
}

