/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j.callback;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.SecretKey;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ws.soap.security.support.KeyStoreUtils;
import org.springframework.ws.soap.security.wss4j.callback.AbstractWsPasswordCallbackHandler;

public class KeyStoreCallbackHandler
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    private String privateKeyPassword;
    private char[] symmetricKeyPassword;
    private KeyStore keyStore;

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        if (privateKeyPassword != null) {
            this.privateKeyPassword = privateKeyPassword;
        }
    }

    public void setSymmetricKeyPassword(String symmetricKeyPassword) {
        if (symmetricKeyPassword != null) {
            this.symmetricKeyPassword = symmetricKeyPassword.toCharArray();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.keyStore == null) {
            this.loadDefaultKeyStore();
        }
        if (this.symmetricKeyPassword == null) {
            this.symmetricKeyPassword = this.privateKeyPassword.toCharArray();
        }
    }

    protected void handleDecrypt(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        callback.setPassword(this.privateKeyPassword);
    }

    protected void handleKeyName(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        try {
            String identifier = callback.getIdentifer();
            Key key = this.keyStore.getKey(identifier, this.symmetricKeyPassword);
            if (!(key instanceof SecretKey)) {
                throw new WSSecurityException("Key [" + key + "] is not a javax.crypto.SecretKey");
            }
            callback.setKey(key.getEncoded());
        }
        catch (GeneralSecurityException ex) {
            throw new WSSecurityException("Could not obtain symmetric key", (Throwable)ex);
        }
    }

    protected void loadDefaultKeyStore() {
        try {
            this.keyStore = KeyStoreUtils.loadDefaultKeyStore();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Loaded default key store");
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Could not open default key store", (Throwable)ex);
        }
    }
}

