/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.POIDocument;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.SlideMaster;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.TextShape;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PowerPointExtractor
extends POIOLE2TextExtractor {
    private HSLFSlideShow _hslfshow;
    private SlideShow _show;
    private Slide[] _slides;
    private boolean _slidesByDefault = true;
    private boolean _notesByDefault = false;
    private boolean _commentsByDefault = false;
    private boolean _masterByDefault = false;

    public static void main(String[] args) throws IOException {
        String file;
        if (args.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tPowerPointExtractor [-notes] <file>");
            System.exit(1);
        }
        boolean notes = false;
        boolean comments = false;
        boolean master = true;
        if (args.length > 1) {
            notes = true;
            file = args[1];
            if (args.length > 2) {
                comments = true;
            }
        } else {
            file = args[0];
        }
        PowerPointExtractor ppe = new PowerPointExtractor(file);
        System.out.println(ppe.getText(true, notes, comments, master));
    }

    public PowerPointExtractor(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public PowerPointExtractor(InputStream iStream) throws IOException {
        this(new POIFSFileSystem(iStream));
    }

    public PowerPointExtractor(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public PowerPointExtractor(NPOIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public PowerPointExtractor(DirectoryNode dir) throws IOException {
        this(new HSLFSlideShow(dir));
    }

    @Deprecated
    public PowerPointExtractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(new HSLFSlideShow(dir, fs));
    }

    public PowerPointExtractor(HSLFSlideShow ss) {
        super((POIDocument)ss);
        this._hslfshow = ss;
        this._show = new SlideShow(this._hslfshow);
        this._slides = this._show.getSlides();
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this._slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this._notesByDefault = notesByDefault;
    }

    public void setCommentsByDefault(boolean commentsByDefault) {
        this._commentsByDefault = commentsByDefault;
    }

    public void setMasterByDefault(boolean masterByDefault) {
        this._masterByDefault = masterByDefault;
    }

    public String getText() {
        return this.getText(this._slidesByDefault, this._notesByDefault, this._commentsByDefault, this._masterByDefault);
    }

    public String getNotes() {
        return this.getText(false, true);
    }

    public List<OLEShape> getOLEShapes() {
        ArrayList<OLEShape> list = new ArrayList<OLEShape>();
        for (int i = 0; i < this._slides.length; ++i) {
            Slide slide = this._slides[i];
            Shape[] shapes = slide.getShapes();
            for (int j = 0; j < shapes.length; ++j) {
                if (!(shapes[j] instanceof OLEShape)) continue;
                list.add((OLEShape)shapes[j]);
            }
        }
        return list;
    }

    public String getText(boolean getSlideText, boolean getNoteText) {
        return this.getText(getSlideText, getNoteText, this._commentsByDefault, this._masterByDefault);
    }

    public String getText(boolean getSlideText, boolean getNoteText, boolean getCommentText, boolean getMasterText) {
        StringBuffer ret = new StringBuffer();
        if (getSlideText) {
            if (getMasterText) {
                for (SlideMaster master : this._show.getSlidesMasters()) {
                    for (Shape sh : master.getShapes()) {
                        if (!(sh instanceof TextShape) || MasterSheet.isPlaceholder(sh)) continue;
                        TextShape tsh = (TextShape)sh;
                        String text = tsh.getText();
                        ret.append(text);
                        if (text.endsWith("\n")) continue;
                        ret.append("\n");
                    }
                }
            }
            for (int i = 0; i < this._slides.length; ++i) {
                Slide slide = this._slides[i];
                HeadersFooters hf = slide.getHeadersFooters();
                if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                    ret.append(hf.getHeaderText() + "\n");
                }
                this.textRunsToText(ret, slide.getTextRuns());
                if (hf != null && hf.isFooterVisible() && hf.getFooterText() != null) {
                    ret.append(hf.getFooterText() + "\n");
                }
                if (!getCommentText) continue;
                Comment[] comments = slide.getComments();
                for (int j = 0; j < comments.length; ++j) {
                    ret.append(comments[j].getAuthor() + " - " + comments[j].getText() + "\n");
                }
            }
            if (getNoteText) {
                ret.append("\n");
            }
        }
        if (getNoteText) {
            HashSet<Integer> seenNotes = new HashSet<Integer>();
            HeadersFooters hf = this._show.getNotesHeadersFooters();
            for (int i = 0; i < this._slides.length; ++i) {
                Integer id;
                Notes notes = this._slides[i].getNotesSheet();
                if (notes == null || seenNotes.contains(id = Integer.valueOf(notes._getSheetNumber()))) continue;
                seenNotes.add(id);
                if (hf != null && hf.isHeaderVisible() && hf.getHeaderText() != null) {
                    ret.append(hf.getHeaderText() + "\n");
                }
                this.textRunsToText(ret, notes.getTextRuns());
                if (hf == null || !hf.isFooterVisible() || hf.getFooterText() == null) continue;
                ret.append(hf.getFooterText() + "\n");
            }
        }
        return ret.toString();
    }

    private void textRunsToText(StringBuffer ret, TextRun[] runs) {
        if (runs == null) {
            return;
        }
        for (int j = 0; j < runs.length; ++j) {
            TextRun run = runs[j];
            if (run == null) continue;
            String text = run.getText();
            ret.append(text);
            if (text.endsWith("\n")) continue;
            ret.append("\n");
        }
    }
}

